/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jgit.lib.ObjectLoader;

public abstract class ObjectStream
extends InputStream {
    public abstract int getType();

    public abstract long getSize();

    public static class Filter
    extends ObjectStream {
        private final int type;
        private final long size;
        private final InputStream in;

        public Filter(int type, long size2, InputStream in) {
            this.type = type;
            this.size = size2;
            this.in = in;
        }

        public int getType() {
            return this.type;
        }

        public long getSize() {
            return this.size;
        }

        public int available() throws IOException {
            return this.in.available();
        }

        public long skip(long n) throws IOException {
            return this.in.skip(n);
        }

        public int read() throws IOException {
            return this.in.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.in.read(b, off, len);
        }

        public boolean markSupported() {
            return this.in.markSupported();
        }

        public void mark(int readlimit) {
            this.in.mark(readlimit);
        }

        public void reset() throws IOException {
            this.in.reset();
        }

        public void close() throws IOException {
            this.in.close();
        }
    }

    public static class SmallStream
    extends ObjectStream {
        private final int type;
        private final byte[] data;
        private int ptr;
        private int mark;

        public SmallStream(ObjectLoader loader) {
            this(loader.getType(), loader.getCachedBytes());
        }

        public SmallStream(int type, byte[] data) {
            this.type = type;
            this.data = data;
        }

        public int getType() {
            return this.type;
        }

        public long getSize() {
            return this.data.length;
        }

        public int available() {
            return this.data.length - this.ptr;
        }

        public long skip(long n) {
            int s2 = (int)Math.min((long)this.available(), Math.max(0L, n));
            this.ptr += s2;
            return s2;
        }

        public int read() {
            if (this.ptr == this.data.length) {
                return -1;
            }
            return this.data[this.ptr++] & 0xFF;
        }

        public int read(byte[] b, int off, int len) {
            if (this.ptr == this.data.length) {
                return -1;
            }
            int n = Math.min(this.available(), len);
            System.arraycopy(this.data, this.ptr, b, off, n);
            this.ptr += n;
            return n;
        }

        public boolean markSupported() {
            return true;
        }

        public void mark(int readlimit) {
            this.mark = this.ptr;
        }

        public void reset() {
            this.ptr = this.mark;
        }
    }
}

