/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.internal.storage.file.ObjectDirectory;
import org.eclipse.jgit.internal.storage.file.PackFile;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.file.RefDirectory;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.ReflogEntry;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.GitDateParser;
import org.eclipse.jgit.util.SystemReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GC {
    private static final String PRUNE_EXPIRE_DEFAULT = "2.weeks.ago";
    private final FileRepository repo;
    private ProgressMonitor pm;
    private long expireAgeMillis = -1L;
    private Date expire;
    private PackConfig pconfig = null;
    private Map<String, Ref> lastPackedRefs;
    private long lastRepackTime;

    public GC(FileRepository repo) {
        this.repo = repo;
        this.pm = NullProgressMonitor.INSTANCE;
    }

    public Collection<PackFile> gc() throws IOException, ParseException {
        this.pm.start(6);
        this.packRefs();
        Collection<PackFile> newPacks = this.repack();
        this.prune(Collections.<ObjectId>emptySet());
        return newPacks;
    }

    private void deleteOldPacks(Collection<PackFile> oldPacks, Collection<PackFile> newPacks) {
        block0: for (PackFile oldPack : oldPacks) {
            String oldName = oldPack.getPackName();
            for (PackFile newPack : newPacks) {
                if (!oldName.equals(newPack.getPackName())) continue;
                continue block0;
            }
            if (oldPack.shouldBeKept()) continue;
            oldPack.close();
            this.prunePack(oldName);
        }
        this.repo.getObjectDatabase().close();
    }

    private void prunePack(String packName) {
        PackExt[] extensions = PackExt.values();
        try {
            File f2;
            int deleteOptions = 6;
            for (PackExt ext : extensions) {
                if (!PackExt.PACK.equals(ext)) continue;
                f2 = this.nameFor(packName, "." + ext.getExtension());
                FileUtils.delete(f2, deleteOptions);
                break;
            }
            deleteOptions |= 8;
            for (PackExt ext : extensions) {
                if (PackExt.PACK.equals(ext)) continue;
                f2 = this.nameFor(packName, "." + ext.getExtension());
                FileUtils.delete(f2, deleteOptions);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prunePacked() throws IOException {
        ObjectDirectory objdb = this.repo.getObjectDatabase();
        Collection<PackFile> packs = objdb.getPacks();
        File objects = this.repo.getObjectsDirectory();
        String[] fanout = objects.list();
        if (fanout != null && fanout.length > 0) {
            this.pm.beginTask(JGitText.get().pruneLoosePackedObjects, fanout.length);
            try {
                for (String d : fanout) {
                    String[] entries;
                    this.pm.update(1);
                    if (d.length() != 2 || (entries = new File(objects, d).list()) == null) continue;
                    for (String e : entries) {
                        ObjectId id2;
                        if (e.length() != 38) continue;
                        try {
                            id2 = ObjectId.fromString(d + e);
                        }
                        catch (IllegalArgumentException notAnObject) {
                            continue;
                        }
                        boolean found = false;
                        for (PackFile p : packs) {
                            if (!p.hasObject(id2)) continue;
                            found = true;
                            break;
                        }
                        if (!found) continue;
                        FileUtils.delete(objdb.fileFor(id2), 14);
                    }
                }
                Object var19_19 = null;
                this.pm.endTask();
            }
            catch (Throwable throwable2) {
                Object var19_20 = null;
                this.pm.endTask();
                throw throwable2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prune(Set<ObjectId> objectsToKeep) throws IOException, ParseException {
        Map<String, Ref> newRefs;
        long expireDate = Long.MAX_VALUE;
        if (this.expire == null && this.expireAgeMillis == -1L) {
            String pruneExpireStr = this.repo.getConfig().getString("gc", null, "pruneexpire");
            if (pruneExpireStr == null) {
                pruneExpireStr = PRUNE_EXPIRE_DEFAULT;
            }
            this.expire = GitDateParser.parse(pruneExpireStr, null, SystemReader.getInstance().getLocale());
            this.expireAgeMillis = -1L;
        }
        if (this.expire != null) {
            expireDate = this.expire.getTime();
        }
        if (this.expireAgeMillis != -1L) {
            expireDate = System.currentTimeMillis() - this.expireAgeMillis;
        }
        HashMap<ObjectId, File> deletionCandidates = new HashMap<ObjectId, File>();
        Set<ObjectId> indexObjects = null;
        File objects = this.repo.getObjectsDirectory();
        String[] fanout = objects.list();
        if (fanout != null && fanout.length > 0) {
            this.pm.beginTask(JGitText.get().pruneLooseUnreferencedObjects, fanout.length);
            try {
                for (String d : fanout) {
                    File[] entries;
                    this.pm.update(1);
                    if (d.length() != 2 || (entries = new File(objects, d).listFiles()) == null) continue;
                    for (File f2 : entries) {
                        String fName = f2.getName();
                        if (fName.length() != 38 || f2.lastModified() >= expireDate) continue;
                        try {
                            ObjectId id2 = ObjectId.fromString(d + fName);
                            if (objectsToKeep.contains(id2)) continue;
                            if (indexObjects == null) {
                                indexObjects = this.listNonHEADIndexObjects();
                            }
                            if (indexObjects.contains(id2)) continue;
                            deletionCandidates.put(id2, f2);
                        }
                        catch (IllegalArgumentException notAnObject) {
                            // empty catch block
                        }
                    }
                }
                Object var20_25 = null;
                this.pm.endTask();
            }
            catch (Throwable throwable2) {
                Object var20_26 = null;
                this.pm.endTask();
                throw throwable2;
            }
        }
        if (deletionCandidates.isEmpty()) {
            return;
        }
        if (this.lastPackedRefs == null || this.lastPackedRefs.isEmpty()) {
            newRefs = this.getAllRefs();
        } else {
            newRefs = new HashMap<String, Ref>();
            for (Map.Entry<String, Ref> newEntry : this.getAllRefs().entrySet()) {
                Ref old = this.lastPackedRefs.get(newEntry.getKey());
                if (GC.equals(newEntry.getValue(), old)) continue;
                newRefs.put(newEntry.getKey(), newEntry.getValue());
            }
        }
        if (!newRefs.isEmpty()) {
            ObjectWalk w = new ObjectWalk(this.repo);
            try {
                for (Ref cr : newRefs.values()) {
                    w.markStart(w.parseAny(cr.getObjectId()));
                }
                if (this.lastPackedRefs != null) {
                    for (Ref lpr : this.lastPackedRefs.values()) {
                        w.markUninteresting(w.parseAny(lpr.getObjectId()));
                    }
                }
                this.removeReferenced(deletionCandidates, w);
                Object var22_28 = null;
                w.dispose();
            }
            catch (Throwable throwable3) {
                Object var22_29 = null;
                w.dispose();
                throw throwable3;
            }
        }
        if (deletionCandidates.isEmpty()) {
            return;
        }
        ObjectWalk w = new ObjectWalk(this.repo);
        try {
            for (Ref ar : this.getAllRefs().values()) {
                for (ObjectId id3 : this.listRefLogObjects(ar, this.lastRepackTime)) {
                    w.markStart(w.parseAny(id3));
                }
            }
            if (this.lastPackedRefs != null) {
                for (Ref lpr : this.lastPackedRefs.values()) {
                    w.markUninteresting(w.parseAny(lpr.getObjectId()));
                }
            }
            this.removeReferenced(deletionCandidates, w);
            Object var24_31 = null;
            w.dispose();
        }
        catch (Throwable throwable4) {
            Object var24_32 = null;
            w.dispose();
            throw throwable4;
        }
        if (deletionCandidates.isEmpty()) {
            return;
        }
        for (File f3 : deletionCandidates.values()) {
            f3.delete();
        }
        this.repo.getObjectDatabase().close();
    }

    private void removeReferenced(Map<ObjectId, File> id2File, ObjectWalk w) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevObject ro = w.next();
        while (ro != null) {
            if (id2File.remove(ro.getId()) != null && id2File.isEmpty()) {
                return;
            }
            ro = w.next();
        }
        ro = w.nextObject();
        while (ro != null) {
            if (id2File.remove(ro.getId()) != null && id2File.isEmpty()) {
                return;
            }
            ro = w.nextObject();
        }
    }

    private static boolean equals(Ref r1, Ref r2) {
        if (r1 == null || r2 == null) {
            return false;
        }
        if (r1.isSymbolic()) {
            if (!r2.isSymbolic()) {
                return false;
            }
            return r1.getTarget().getName().equals(r2.getTarget().getName());
        }
        if (r2.isSymbolic()) {
            return false;
        }
        return r1.getObjectId().equals(r2.getObjectId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void packRefs() throws IOException {
        Collection<Ref> refs = this.repo.getRefDatabase().getRefs("refs/").values();
        ArrayList<String> refsToBePacked = new ArrayList<String>(refs.size());
        this.pm.beginTask(JGitText.get().packRefs, refs.size());
        try {
            for (Ref ref2 : refs) {
                if (!ref2.isSymbolic() && ref2.getStorage().isLoose()) {
                    refsToBePacked.add(ref2.getName());
                }
                this.pm.update(1);
            }
            ((RefDirectory)this.repo.getRefDatabase()).pack(refsToBePacked);
            Object var6_5 = null;
            this.pm.endTask();
        }
        catch (Throwable throwable2) {
            Object var6_6 = null;
            this.pm.endTask();
            throw throwable2;
        }
    }

    public Collection<PackFile> repack() throws IOException {
        PackFile rest2;
        Collection<PackFile> toBeDeleted = this.repo.getObjectDatabase().getPacks();
        long time = System.currentTimeMillis();
        Map<String, Ref> refsBefore = this.getAllRefs();
        HashSet<ObjectId> allHeads = new HashSet<ObjectId>();
        HashSet<ObjectId> nonHeads = new HashSet<ObjectId>();
        HashSet<ObjectId> tagTargets = new HashSet<ObjectId>();
        Set<ObjectId> indexObjects = this.listNonHEADIndexObjects();
        for (Ref ref2 : refsBefore.values()) {
            nonHeads.addAll(this.listRefLogObjects(ref2, 0L));
            if (ref2.isSymbolic() || ref2.getObjectId() == null) continue;
            if (ref2.getName().startsWith("refs/heads/")) {
                allHeads.add(ref2.getObjectId());
            } else {
                nonHeads.add(ref2.getObjectId());
            }
            if (ref2.getPeeledObjectId() == null) continue;
            tagTargets.add(ref2.getPeeledObjectId());
        }
        LinkedList<PackWriter.ObjectIdSet> excluded = new LinkedList<PackWriter.ObjectIdSet>();
        for (PackFile f2 : this.repo.getObjectDatabase().getPacks()) {
            if (!f2.shouldBeKept()) continue;
            excluded.add(GC.objectIdSet(f2.getIndex()));
        }
        tagTargets.addAll(allHeads);
        nonHeads.addAll(indexObjects);
        ArrayList<PackFile> ret = new ArrayList<PackFile>(2);
        PackFile heads = null;
        if (!allHeads.isEmpty() && (heads = this.writePack(allHeads, Collections.emptySet(), tagTargets, excluded)) != null) {
            ret.add(heads);
            excluded.add(0, GC.objectIdSet(heads.getIndex()));
        }
        if (!nonHeads.isEmpty() && (rest2 = this.writePack(nonHeads, allHeads, tagTargets, excluded)) != null) {
            ret.add(rest2);
        }
        this.deleteOldPacks(toBeDeleted, ret);
        this.prunePacked();
        this.lastPackedRefs = refsBefore;
        this.lastRepackTime = time;
        return ret;
    }

    private Set<ObjectId> listRefLogObjects(Ref ref2, long minTime) throws IOException {
        List<ReflogEntry> rlEntries = this.repo.getReflogReader(ref2.getName()).getReverseEntries();
        if (rlEntries == null || rlEntries.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<ObjectId> ret = new HashSet<ObjectId>();
        for (ReflogEntry e : rlEntries) {
            ObjectId oldId;
            if (e.getWho().getWhen().getTime() < minTime) break;
            ObjectId newId = e.getNewId();
            if (newId != null && !ObjectId.zeroId().equals(newId)) {
                ret.add(newId);
            }
            if ((oldId = e.getOldId()) == null || ObjectId.zeroId().equals(oldId)) continue;
            ret.add(oldId);
        }
        return ret;
    }

    private Map<String, Ref> getAllRefs() throws IOException {
        Map<String, Ref> ret = this.repo.getRefDatabase().getRefs("");
        for (Ref ref2 : this.repo.getRefDatabase().getAdditionalRefs()) {
            ret.put(ref2.getName(), ref2);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ObjectId> listNonHEADIndexObjects() throws CorruptObjectException, IOException {
        RevWalk revWalk = null;
        try {
            if (this.repo.getIndexFile() == null) {
                return Collections.emptySet();
            }
        }
        catch (NoWorkTreeException e) {
            return Collections.emptySet();
        }
        TreeWalk treeWalk = new TreeWalk(this.repo);
        try {
            treeWalk.addTree(new DirCacheIterator(this.repo.readDirCache()));
            ObjectId headID = this.repo.resolve("HEAD");
            if (headID != null) {
                revWalk = new RevWalk(this.repo);
                treeWalk.addTree(revWalk.parseTree(headID));
                revWalk.dispose();
                revWalk = null;
            }
            treeWalk.setFilter(TreeFilter.ANY_DIFF);
            treeWalk.setRecursive(true);
            HashSet<ObjectId> ret = new HashSet<ObjectId>();
            block8: while (treeWalk.next()) {
                ObjectId objectId = treeWalk.getObjectId(0);
                switch (treeWalk.getRawMode(0) & 0xF000) {
                    case 0: 
                    case 57344: {
                        continue block8;
                    }
                    case 16384: 
                    case 32768: 
                    case 40960: {
                        ret.add(objectId);
                        continue block8;
                    }
                }
                throw new IOException(MessageFormat.format(JGitText.get().corruptObjectInvalidMode3, String.format("%o", treeWalk.getRawMode(0)), objectId == null ? "null" : objectId.name(), treeWalk.getPathString(), this.repo.getIndexFile()));
            }
            HashSet<ObjectId> hashSet = ret;
            Object var7_7 = null;
            if (revWalk != null) {
                revWalk.dispose();
            }
            treeWalk.release();
            return hashSet;
        }
        catch (Throwable throwable2) {
            Object var7_8 = null;
            if (revWalk != null) {
                revWalk.dispose();
            }
            treeWalk.release();
            throw throwable2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackFile writePack(Set<? extends ObjectId> want, Set<? extends ObjectId> have, Set<ObjectId> tagTargets, List<PackWriter.ObjectIdSet> excludeObjects) throws IOException {
        PackFile packFile;
        TreeMap<PackExt, File> tmpExts;
        block35: {
            PackWriter pw;
            File tmpPack;
            block31: {
                Iterator<PackWriter.ObjectIdSet> i$;
                block32: {
                    tmpPack = null;
                    tmpExts = new TreeMap<PackExt, File>(new Comparator<PackExt>(){

                        @Override
                        public int compare(PackExt o1, PackExt o2) {
                            if (o1 == o2) {
                                return 0;
                            }
                            if (o1 == PackExt.INDEX) {
                                return 1;
                            }
                            if (o2 == PackExt.INDEX) {
                                return -1;
                            }
                            return Integer.signum(o1.hashCode() - o2.hashCode());
                        }
                    });
                    pw = new PackWriter(this.pconfig == null ? new PackConfig(this.repo) : this.pconfig, this.repo.newObjectReader());
                    pw.setDeltaBaseAsOffset(true);
                    pw.setReuseDeltaCommits(false);
                    if (tagTargets != null) {
                        pw.setTagTargets(tagTargets);
                    }
                    if (excludeObjects != null) {
                        for (PackWriter.ObjectIdSet idx : excludeObjects) {
                            pw.excludeObjects(idx);
                        }
                    }
                    pw.preparePack(this.pm, want, have);
                    if (pw.getObjectCount() != 0L) break block31;
                    i$ = null;
                    Object var30_10 = null;
                    pw.release();
                    if (tmpPack == null || !tmpPack.exists()) break block32;
                    tmpPack.delete();
                }
                for (File tmpExt : tmpExts.values()) {
                    if (!tmpExt.exists()) continue;
                    tmpExt.delete();
                }
                return i$;
            }
            try {
                File realPack;
                block33: {
                    block34: {
                        String id2 = pw.computeName().getName();
                        File packdir = new File(this.repo.getObjectsDirectory(), "pack");
                        tmpPack = File.createTempFile("gc_", ".pack_tmp", packdir);
                        String tmpBase = tmpPack.getName().substring(0, tmpPack.getName().lastIndexOf(46));
                        File tmpIdx = new File(packdir, tmpBase + ".idx_tmp");
                        tmpExts.put(PackExt.INDEX, tmpIdx);
                        if (!tmpIdx.createNewFile()) {
                            throw new IOException(MessageFormat.format(JGitText.get().cannotCreateIndexfile, tmpIdx.getPath()));
                        }
                        FileOutputStream fos = new FileOutputStream(tmpPack);
                        FileChannel channel = fos.getChannel();
                        OutputStream channelStream = Channels.newOutputStream(channel);
                        try {
                            pw.writePack(this.pm, this.pm, channelStream);
                            Object var16_24 = null;
                        }
                        catch (Throwable throwable2) {
                            Object var16_25 = null;
                            channel.force(true);
                            channelStream.close();
                            fos.close();
                            throw throwable2;
                        }
                        channel.force(true);
                        channelStream.close();
                        fos.close();
                        fos = new FileOutputStream(tmpIdx);
                        FileChannel idxChannel = fos.getChannel();
                        OutputStream idxStream = Channels.newOutputStream(idxChannel);
                        try {
                            pw.writeIndex(idxStream);
                            Object var18_28 = null;
                        }
                        catch (Throwable throwable3) {
                            Object var18_29 = null;
                            idxChannel.force(true);
                            idxStream.close();
                            fos.close();
                            throw throwable3;
                        }
                        idxChannel.force(true);
                        idxStream.close();
                        fos.close();
                        if (pw.prepareBitmapIndex(this.pm)) {
                            File tmpBitmapIdx = new File(packdir, tmpBase + ".bitmap_tmp");
                            tmpExts.put(PackExt.BITMAP_INDEX, tmpBitmapIdx);
                            if (!tmpBitmapIdx.createNewFile()) {
                                throw new IOException(MessageFormat.format(JGitText.get().cannotCreateIndexfile, tmpBitmapIdx.getPath()));
                            }
                            fos = new FileOutputStream(tmpBitmapIdx);
                            idxChannel = fos.getChannel();
                            idxStream = Channels.newOutputStream(idxChannel);
                            try {
                                pw.writeBitmapIndex(idxStream);
                                Object var20_33 = null;
                            }
                            catch (Throwable throwable4) {
                                Object var20_34 = null;
                                idxChannel.force(true);
                                idxStream.close();
                                fos.close();
                                throw throwable4;
                            }
                            idxChannel.force(true);
                            idxStream.close();
                            fos.close();
                            {
                            }
                        }
                        if ((realPack = this.nameFor(id2, ".pack")).exists()) {
                            for (PackFile p : this.repo.getObjectDatabase().getPacks()) {
                                if (!realPack.getPath().equals(p.getPackFile().getPath())) continue;
                                p.close();
                                break;
                            }
                        }
                        tmpPack.setReadOnly();
                        boolean delete2 = true;
                        try {
                            FileUtils.rename(tmpPack, realPack);
                            delete2 = false;
                            for (Map.Entry tmpEntry : tmpExts.entrySet()) {
                                File tmpExt = (File)tmpEntry.getValue();
                                tmpExt.setReadOnly();
                                File realExt = this.nameFor(id2, "." + ((PackExt)tmpEntry.getKey()).getExtension());
                                try {
                                    FileUtils.rename(tmpExt, realExt);
                                }
                                catch (IOException e) {
                                    File newExt = new File(realExt.getParentFile(), realExt.getName() + ".new");
                                    if (!tmpExt.renameTo(newExt)) {
                                        newExt = tmpExt;
                                    }
                                    throw new IOException(MessageFormat.format(JGitText.get().panicCantRenameIndexFile, newExt, realExt));
                                }
                            }
                            Object var26_41 = null;
                            if (!delete2) break block33;
                            if (!tmpPack.exists()) break block34;
                            tmpPack.delete();
                        }
                        catch (Throwable throwable5) {
                            Object var26_42 = null;
                            if (delete2) {
                                if (tmpPack.exists()) {
                                    tmpPack.delete();
                                }
                                for (File tmpExt : tmpExts.values()) {
                                    if (!tmpExt.exists()) continue;
                                    tmpExt.delete();
                                }
                            }
                            throw throwable5;
                        }
                    }
                    for (File tmpExt : tmpExts.values()) {
                        if (!tmpExt.exists()) continue;
                        tmpExt.delete();
                    }
                }
                packFile = this.repo.getObjectDatabase().openPack(realPack);
                Object var30_11 = null;
                pw.release();
                if (tmpPack == null || !tmpPack.exists()) break block35;
                tmpPack.delete();
            }
            catch (Throwable throwable6) {
                Object var30_12 = null;
                pw.release();
                if (tmpPack != null && tmpPack.exists()) {
                    tmpPack.delete();
                }
                for (File tmpExt : tmpExts.values()) {
                    if (!tmpExt.exists()) continue;
                    tmpExt.delete();
                }
                throw throwable6;
            }
        }
        for (File tmpExt : tmpExts.values()) {
            if (!tmpExt.exists()) continue;
            tmpExt.delete();
        }
        return packFile;
    }

    private File nameFor(String name2, String ext) {
        File packdir = new File(this.repo.getObjectsDirectory(), "pack");
        return new File(packdir, "pack-" + name2 + ext);
    }

    public RepoStatistics getStatistics() throws IOException {
        RepoStatistics ret = new RepoStatistics();
        Collection<PackFile> packs = this.repo.getObjectDatabase().getPacks();
        for (PackFile f2 : packs) {
            ret.numberOfPackedObjects += f2.getIndex().getObjectCount();
            ++ret.numberOfPackFiles;
            ret.sizeOfPackedObjects += f2.getPackFile().length();
        }
        File objDir = this.repo.getObjectsDirectory();
        String[] fanout = objDir.list();
        if (fanout != null && fanout.length > 0) {
            for (String d : fanout) {
                File[] entries;
                if (d.length() != 2 || (entries = new File(objDir, d).listFiles()) == null) continue;
                for (File f3 : entries) {
                    if (f3.getName().length() != 38) continue;
                    ++ret.numberOfLooseObjects;
                    ret.sizeOfLooseObjects += f3.length();
                }
            }
        }
        RefDatabase refDb = this.repo.getRefDatabase();
        for (Ref r : refDb.getRefs("").values()) {
            Ref.Storage storage = r.getStorage();
            if (storage == Ref.Storage.LOOSE || storage == Ref.Storage.LOOSE_PACKED) {
                ++ret.numberOfLooseRefs;
            }
            if (storage != Ref.Storage.PACKED && storage != Ref.Storage.LOOSE_PACKED) continue;
            ++ret.numberOfPackedRefs;
        }
        return ret;
    }

    public GC setProgressMonitor(ProgressMonitor pm) {
        this.pm = pm == null ? NullProgressMonitor.INSTANCE : pm;
        return this;
    }

    public void setExpireAgeMillis(long expireAgeMillis) {
        this.expireAgeMillis = expireAgeMillis;
        this.expire = null;
    }

    public void setPackConfig(PackConfig pconfig) {
        this.pconfig = pconfig;
    }

    public void setExpire(Date expire) {
        this.expire = expire;
        this.expireAgeMillis = -1L;
    }

    private static PackWriter.ObjectIdSet objectIdSet(final PackIndex idx) {
        return new PackWriter.ObjectIdSet(){

            public boolean contains(AnyObjectId objectId) {
                return idx.hasObject(objectId);
            }
        };
    }

    public class RepoStatistics {
        public long numberOfPackedObjects;
        public long numberOfPackFiles;
        public long numberOfLooseObjects;
        public long sizeOfLooseObjects;
        public long sizeOfPackedObjects;
        public long numberOfLooseRefs;
        public long numberOfPackedRefs;

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("numberOfPackedObjects=").append(this.numberOfPackedObjects);
            b.append(", numberOfPackFiles=").append(this.numberOfPackFiles);
            b.append(", numberOfLooseObjects=").append(this.numberOfLooseObjects);
            b.append(", numberOfLooseRefs=").append(this.numberOfLooseRefs);
            b.append(", numberOfPackedRefs=").append(this.numberOfPackedRefs);
            b.append(", sizeOfLooseObjects=").append(this.sizeOfLooseObjects);
            b.append(", sizeOfPackedObjects=").append(this.sizeOfPackedObjects);
            return b.toString();
        }
    }
}

