/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsRepositoryDescription;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.internal.storage.pack.PackWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfsPackDescription
implements Comparable<DfsPackDescription> {
    private final DfsRepositoryDescription repoDesc;
    private final String packName;
    private DfsObjDatabase.PackSource packSource;
    private long lastModified;
    private final Map<PackExt, Long> sizeMap;
    private long objectCount;
    private long deltaCount;
    private PackWriter.Statistics stats;
    private int extensions;
    private int indexVersion;

    public DfsPackDescription(DfsRepositoryDescription repoDesc, String name2) {
        this.repoDesc = repoDesc;
        int dot = name2.lastIndexOf(46);
        this.packName = dot < 0 ? name2 : name2.substring(0, dot);
        this.sizeMap = new HashMap<PackExt, Long>(PackExt.values().length * 2);
    }

    public DfsRepositoryDescription getRepositoryDescription() {
        return this.repoDesc;
    }

    public void addFileExt(PackExt ext) {
        this.extensions |= ext.getBit();
    }

    public boolean hasFileExt(PackExt ext) {
        return (this.extensions & ext.getBit()) != 0;
    }

    public String getFileName(PackExt ext) {
        return this.packName + '.' + ext.getExtension();
    }

    public DfsObjDatabase.PackSource getPackSource() {
        return this.packSource;
    }

    public DfsPackDescription setPackSource(DfsObjDatabase.PackSource source) {
        this.packSource = source;
        return this;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public DfsPackDescription setLastModified(long timeMillis) {
        this.lastModified = timeMillis;
        return this;
    }

    public DfsPackDescription setFileSize(PackExt ext, long bytes2) {
        this.sizeMap.put(ext, Math.max(0L, bytes2));
        return this;
    }

    public long getFileSize(PackExt ext) {
        Long size2 = this.sizeMap.get(ext);
        return size2 == null ? 0L : size2;
    }

    public long getObjectCount() {
        return this.objectCount;
    }

    public DfsPackDescription setObjectCount(long cnt) {
        this.objectCount = Math.max(0L, cnt);
        return this;
    }

    public long getDeltaCount() {
        return this.deltaCount;
    }

    public DfsPackDescription setDeltaCount(long cnt) {
        this.deltaCount = Math.max(0L, cnt);
        return this;
    }

    public PackWriter.Statistics getPackStats() {
        return this.stats;
    }

    DfsPackDescription setPackStats(PackWriter.Statistics stats) {
        this.stats = stats;
        this.setFileSize(PackExt.PACK, stats.getTotalBytes());
        this.setObjectCount(stats.getTotalObjects());
        this.setDeltaCount(stats.getTotalDeltas());
        return this;
    }

    public DfsPackDescription clearPackStats() {
        this.stats = null;
        return this;
    }

    public int getIndexVersion() {
        return this.indexVersion;
    }

    public DfsPackDescription setIndexVersion(int version) {
        this.indexVersion = version;
        return this;
    }

    public int hashCode() {
        return this.packName.hashCode();
    }

    public boolean equals(Object b) {
        if (b instanceof DfsPackDescription) {
            DfsPackDescription desc = (DfsPackDescription)b;
            return this.packName.equals(desc.packName) && this.getRepositoryDescription().equals(desc.getRepositoryDescription());
        }
        return false;
    }

    @Override
    public int compareTo(DfsPackDescription b) {
        int cmp;
        DfsObjDatabase.PackSource as2 = this.getPackSource();
        DfsObjDatabase.PackSource bs = b.getPackSource();
        if (as2 != null && bs != null && (cmp = as2.category - bs.category) != 0) {
            return cmp;
        }
        cmp = Long.signum(b.getLastModified() - this.getLastModified());
        if (cmp != 0) {
            return cmp;
        }
        return Long.signum(this.getObjectCount() - b.getObjectCount());
    }

    public String toString() {
        return this.getFileName(PackExt.PACK);
    }
}

