/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.dircache;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.text.MessageFormat;
import java.util.Arrays;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.InvalidPathException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.MutableInteger;
import org.eclipse.jgit.util.NB;

public class DirCacheEntry {
    private static final byte[] nullpad = new byte[8];
    public static final int STAGE_0 = 0;
    public static final int STAGE_1 = 1;
    public static final int STAGE_2 = 2;
    public static final int STAGE_3 = 3;
    private static final int P_CTIME = 0;
    private static final int P_MTIME = 8;
    private static final int P_MODE = 24;
    private static final int P_SIZE = 36;
    private static final int P_OBJECTID = 40;
    private static final int P_FLAGS = 60;
    private static final int P_FLAGS2 = 62;
    private static final int NAME_MASK = 4095;
    private static final int INTENT_TO_ADD = 0x20000000;
    private static final int SKIP_WORKTREE = 0x40000000;
    private static final int EXTENDED_FLAGS = 0x60000000;
    private static final int INFO_LEN = 62;
    private static final int INFO_LEN_EXTENDED = 64;
    private static final int EXTENDED = 64;
    private static final int ASSUME_VALID = 128;
    private static final int UPDATE_NEEDED = 1;
    private final byte[] info;
    private final int infoOffset;
    final byte[] path;
    private byte inCoreFlags;

    DirCacheEntry(byte[] sharedInfo, MutableInteger infoAt, InputStream in, MessageDigest md, int smudge_s, int smudge_ns) throws IOException {
        int len;
        this.info = sharedInfo;
        this.infoOffset = infoAt.value;
        IO.readFully(in, this.info, this.infoOffset, 62);
        if (this.isExtended()) {
            len = 64;
            IO.readFully(in, this.info, this.infoOffset + 62, 2);
            if ((this.getExtendedFlags() & 0x9FFFFFFF) != 0) {
                throw new IOException(MessageFormat.format(JGitText.get().DIRCUnrecognizedExtendedFlags, String.valueOf(this.getExtendedFlags())));
            }
        } else {
            len = 62;
        }
        infoAt.value += len;
        md.update(this.info, this.infoOffset, len);
        int pathLen = NB.decodeUInt16(this.info, this.infoOffset + 60) & 0xFFF;
        int skipped = 0;
        if (pathLen < 4095) {
            this.path = new byte[pathLen];
            IO.readFully(in, this.path, 0, pathLen);
            md.update(this.path, 0, pathLen);
        } else {
            ByteArrayOutputStream tmp = new ByteArrayOutputStream();
            byte[] buf = new byte[4095];
            IO.readFully(in, buf, 0, 4095);
            tmp.write(buf);
            while (true) {
                int c;
                if ((c = in.read()) < 0) {
                    throw new EOFException(JGitText.get().shortReadOfBlock);
                }
                if (c == 0) break;
                tmp.write(c);
            }
            this.path = tmp.toByteArray();
            pathLen = this.path.length;
            skipped = 1;
            md.update(this.path, 0, pathLen);
            md.update((byte)0);
        }
        try {
            DirCacheCheckout.checkValidPath(DirCacheEntry.toString(this.path));
        }
        catch (InvalidPathException e) {
            CorruptObjectException p = new CorruptObjectException(e.getMessage());
            if (e.getCause() != null) {
                p.initCause(e.getCause());
            }
            throw p;
        }
        int actLen = len + pathLen;
        int expLen = actLen + 8 & 0xFFFFFFF8;
        int padLen = expLen - actLen - skipped;
        if (padLen > 0) {
            IO.skipFully(in, padLen);
            md.update(nullpad, 0, padLen);
        }
        if (this.mightBeRacilyClean(smudge_s, smudge_ns)) {
            this.smudgeRacilyClean();
        }
    }

    public DirCacheEntry(String newPath) {
        this(Constants.encode(newPath), 0);
    }

    public DirCacheEntry(String newPath, int stage) {
        this(Constants.encode(newPath), stage);
    }

    public DirCacheEntry(byte[] newPath) {
        this(newPath, 0);
    }

    public DirCacheEntry(byte[] newPath, int stage) {
        DirCacheCheckout.checkValidPath(DirCacheEntry.toString(newPath));
        if (stage < 0 || 3 < stage) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidStageForPath, stage, DirCacheEntry.toString(newPath)));
        }
        this.info = new byte[62];
        this.infoOffset = 0;
        this.path = newPath;
        int flags = (stage & 3) << 12;
        flags = this.path.length < 4095 ? (flags |= this.path.length) : (flags |= 0xFFF);
        NB.encodeInt16(this.info, this.infoOffset + 60, flags);
    }

    void write(OutputStream os) throws IOException {
        int len = this.isExtended() ? 64 : 62;
        int pathLen = this.path.length;
        os.write(this.info, this.infoOffset, len);
        os.write(this.path, 0, pathLen);
        int actLen = len + pathLen;
        int expLen = actLen + 8 & 0xFFFFFFF8;
        if (actLen != expLen) {
            os.write(nullpad, 0, expLen - actLen);
        }
    }

    public final boolean mightBeRacilyClean(int smudge_s, int smudge_ns) {
        int base = this.infoOffset + 8;
        int mtime = NB.decodeInt32(this.info, base);
        if (smudge_s == mtime) {
            return smudge_ns <= NB.decodeInt32(this.info, base + 4);
        }
        return false;
    }

    public final void smudgeRacilyClean() {
        int base = this.infoOffset + 36;
        Arrays.fill(this.info, base, base + 4, (byte)0);
    }

    public final boolean isSmudged() {
        int base = this.infoOffset + 40;
        return this.getLength() == 0 && Constants.EMPTY_BLOB_ID.compareTo(this.info, base) != 0;
    }

    final byte[] idBuffer() {
        return this.info;
    }

    final int idOffset() {
        return this.infoOffset + 40;
    }

    public boolean isAssumeValid() {
        return (this.info[this.infoOffset + 60] & 0x80) != 0;
    }

    public void setAssumeValid(boolean assume) {
        if (assume) {
            int n = this.infoOffset + 60;
            this.info[n] = (byte)(this.info[n] | 0x80);
        } else {
            int n = this.infoOffset + 60;
            this.info[n] = (byte)(this.info[n] & 0xFFFFFF7F);
        }
    }

    public boolean isUpdateNeeded() {
        return (this.inCoreFlags & 1) != 0;
    }

    public void setUpdateNeeded(boolean updateNeeded) {
        this.inCoreFlags = updateNeeded ? (byte)(this.inCoreFlags | 1) : (byte)(this.inCoreFlags & 0xFFFFFFFE);
    }

    public int getStage() {
        return this.info[this.infoOffset + 60] >>> 4 & 3;
    }

    public boolean isSkipWorkTree() {
        return (this.getExtendedFlags() & 0x40000000) != 0;
    }

    public boolean isIntentToAdd() {
        return (this.getExtendedFlags() & 0x20000000) != 0;
    }

    public boolean isMerged() {
        return this.getStage() == 0;
    }

    public int getRawMode() {
        return NB.decodeInt32(this.info, this.infoOffset + 24);
    }

    public FileMode getFileMode() {
        return FileMode.fromBits(this.getRawMode());
    }

    public void setFileMode(FileMode mode) {
        switch (mode.getBits() & 0xF000) {
            case 0: 
            case 16384: {
                throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidModeForPath, mode, this.getPathString()));
            }
        }
        NB.encodeInt32(this.info, this.infoOffset + 24, mode.getBits());
    }

    public long getCreationTime() {
        return this.decodeTS(0);
    }

    public void setCreationTime(long when) {
        this.encodeTS(0, when);
    }

    public long getLastModified() {
        return this.decodeTS(8);
    }

    public void setLastModified(long when) {
        this.encodeTS(8, when);
    }

    public int getLength() {
        return NB.decodeInt32(this.info, this.infoOffset + 36);
    }

    public void setLength(int sz) {
        NB.encodeInt32(this.info, this.infoOffset + 36, sz);
    }

    public void setLength(long sz) {
        this.setLength((int)sz);
    }

    public ObjectId getObjectId() {
        return ObjectId.fromRaw(this.idBuffer(), this.idOffset());
    }

    public void setObjectId(AnyObjectId id2) {
        id2.copyRawTo(this.idBuffer(), this.idOffset());
    }

    public void setObjectIdFromRaw(byte[] bs, int p) {
        int n = 20;
        System.arraycopy(bs, p, this.idBuffer(), this.idOffset(), 20);
    }

    public String getPathString() {
        return DirCacheEntry.toString(this.path);
    }

    public byte[] getRawPath() {
        return (byte[])this.path.clone();
    }

    public String toString() {
        return this.getFileMode() + " " + this.getLength() + " " + this.getLastModified() + " " + this.getObjectId() + " " + this.getStage() + " " + this.getPathString() + "\n";
    }

    public void copyMetaData(DirCacheEntry src) {
        this.copyMetaData(src, false);
    }

    void copyMetaData(DirCacheEntry src, boolean keepStage) {
        int origflags = NB.decodeUInt16(this.info, this.infoOffset + 60);
        int newflags = NB.decodeUInt16(src.info, src.infoOffset + 60);
        System.arraycopy(src.info, src.infoOffset, this.info, this.infoOffset, 62);
        int pLen = origflags & 0xFFF;
        int SHIFTED_STAGE_MASK = 12288;
        int pStageShifted = keepStage ? origflags & 0x3000 : newflags & 0x3000;
        NB.encodeInt16(this.info, this.infoOffset + 60, pStageShifted | pLen | newflags & 0xFFFFF000 & 0xFFFFCFFF);
    }

    boolean isExtended() {
        return (this.info[this.infoOffset + 60] & 0x40) != 0;
    }

    private long decodeTS(int pIdx) {
        int base = this.infoOffset + pIdx;
        int sec = NB.decodeInt32(this.info, base);
        int ms = NB.decodeInt32(this.info, base + 4) / 1000000;
        return 1000L * (long)sec + (long)ms;
    }

    private void encodeTS(int pIdx, long when) {
        int base = this.infoOffset + pIdx;
        NB.encodeInt32(this.info, base, (int)(when / 1000L));
        NB.encodeInt32(this.info, base + 4, (int)(when % 1000L) * 1000000);
    }

    private int getExtendedFlags() {
        if (this.isExtended()) {
            return NB.decodeUInt16(this.info, this.infoOffset + 62) << 16;
        }
        return 0;
    }

    private static String toString(byte[] path2) {
        return Constants.CHARSET.decode(ByteBuffer.wrap(path2)).toString();
    }

    static int getMaximumInfoLength(boolean extended) {
        return extended ? 64 : 62;
    }
}

