/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.diff;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.PathFilter;

public abstract class ContentSource {
    public static ContentSource create(ObjectReader reader) {
        return new ObjectReaderSource(reader);
    }

    public static ContentSource create(WorkingTreeIterator iterator2) {
        return new WorkingTreeSource(iterator2);
    }

    public abstract long size(String var1, ObjectId var2) throws IOException;

    public abstract ObjectLoader open(String var1, ObjectId var2) throws IOException;

    private static class ObjectReaderSource
    extends ContentSource {
        private final ObjectReader reader;

        ObjectReaderSource(ObjectReader reader) {
            this.reader = reader;
        }

        public long size(String path2, ObjectId id2) throws IOException {
            return this.reader.getObjectSize(id2, 3);
        }

        public ObjectLoader open(String path2, ObjectId id2) throws IOException {
            return this.reader.open(id2, 3);
        }
    }

    public static final class Pair {
        private final ContentSource oldSource;
        private final ContentSource newSource;

        public Pair(ContentSource oldSource, ContentSource newSource) {
            this.oldSource = oldSource;
            this.newSource = newSource;
        }

        public long size(DiffEntry.Side side, DiffEntry ent) throws IOException {
            switch (side) {
                case OLD: {
                    return this.oldSource.size(ent.oldPath, ent.oldId.toObjectId());
                }
                case NEW: {
                    return this.newSource.size(ent.newPath, ent.newId.toObjectId());
                }
            }
            throw new IllegalArgumentException();
        }

        public ObjectLoader open(DiffEntry.Side side, DiffEntry ent) throws IOException {
            switch (side) {
                case OLD: {
                    return this.oldSource.open(ent.oldPath, ent.oldId.toObjectId());
                }
                case NEW: {
                    return this.newSource.open(ent.newPath, ent.newId.toObjectId());
                }
            }
            throw new IllegalArgumentException();
        }
    }

    private static class WorkingTreeSource
    extends ContentSource {
        private final TreeWalk tw = new TreeWalk((ObjectReader)null);
        private final WorkingTreeIterator iterator;
        private String current;
        private WorkingTreeIterator ptr;

        WorkingTreeSource(WorkingTreeIterator iterator2) {
            this.tw.setRecursive(true);
            this.iterator = iterator2;
        }

        public long size(String path2, ObjectId id2) throws IOException {
            this.seek(path2);
            return this.ptr.getEntryLength();
        }

        public ObjectLoader open(String path2, ObjectId id2) throws IOException {
            this.seek(path2);
            return new ObjectLoader(){

                public long getSize() {
                    return WorkingTreeSource.this.ptr.getEntryLength();
                }

                public int getType() {
                    return WorkingTreeSource.this.ptr.getEntryFileMode().getObjectType();
                }

                public ObjectStream openStream() throws MissingObjectException, IOException {
                    long contentLength = WorkingTreeSource.this.ptr.getEntryContentLength();
                    InputStream in = WorkingTreeSource.this.ptr.openEntryStream();
                    in = new BufferedInputStream(in);
                    return new ObjectStream.Filter(this.getType(), contentLength, in);
                }

                public boolean isLarge() {
                    return true;
                }

                public byte[] getCachedBytes() throws LargeObjectException {
                    throw new LargeObjectException();
                }
            };
        }

        private void seek(String path2) throws IOException {
            if (!path2.equals(this.current)) {
                this.iterator.reset();
                this.tw.reset();
                this.tw.addTree(this.iterator);
                this.tw.setFilter(PathFilter.create(path2));
                this.current = path2;
                if (!this.tw.next()) {
                    throw new FileNotFoundException(path2);
                }
                this.ptr = this.tw.getTree(0, WorkingTreeIterator.class);
                if (this.ptr == null) {
                    throw new FileNotFoundException(path2);
                }
            }
        }
    }
}

