/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidTagNameException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.RefAlreadyExistsException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.lib.TagBuilder;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagCommand
extends GitCommand<Ref> {
    private RevObject id;
    private String name;
    private String message;
    private PersonIdent tagger;
    private boolean signed;
    private boolean forceUpdate;
    private boolean annotated = true;

    protected TagCommand(Repository repo) {
        super(repo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Ref call() throws GitAPIException, ConcurrentRefUpdateException, InvalidTagNameException, NoHeadException {
        this.checkCallable();
        RepositoryState state = this.repo.getRepositoryState();
        this.processOptions(state);
        RevWalk revWalk = new RevWalk(this.repo);
        try {
            Object objectId;
            if (this.id == null) {
                objectId = this.repo.resolve("HEAD^{commit}");
                if (objectId == null) {
                    throw new NoHeadException(JGitText.get().tagOnRepoWithoutHEADCurrentlyNotSupported);
                }
                this.id = revWalk.parseCommit((AnyObjectId)objectId);
            }
            if (!this.annotated) {
                if (this.message != null || this.tagger != null) {
                    throw new JGitInternalException(JGitText.get().messageAndTaggerNotAllowedInUnannotatedTags);
                }
                objectId = this.updateTagRef(this.id, revWalk, this.name, "SimpleTag[" + this.name + " : " + this.id + "]");
                return objectId;
            }
            TagBuilder newTag = new TagBuilder();
            newTag.setTag(this.name);
            newTag.setMessage(this.message);
            newTag.setTagger(this.tagger);
            newTag.setObjectId(this.id);
            ObjectInserter inserter = this.repo.newObjectInserter();
            try {
                ObjectId tagId = inserter.insert(newTag);
                inserter.flush();
                String tag2 = newTag.getTag();
                Ref ref2 = this.updateTagRef(tagId, revWalk, tag2, newTag.toString());
                inserter.release();
                return ref2;
            }
            catch (Throwable throwable2) {
                try {
                    inserter.release();
                    throw throwable2;
                }
                catch (IOException e) {
                    throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfTagCommand, e);
                }
            }
        }
        finally {
            revWalk.release();
        }
    }

    private Ref updateTagRef(ObjectId tagId, RevWalk revWalk, String tagName, String newTagToString) throws IOException, ConcurrentRefUpdateException, RefAlreadyExistsException {
        String refName = "refs/tags/" + tagName;
        RefUpdate tagRef = this.repo.updateRef(refName);
        tagRef.setNewObjectId(tagId);
        tagRef.setForceUpdate(this.forceUpdate);
        tagRef.setRefLogMessage("tagged " + this.name, false);
        RefUpdate.Result updateResult = tagRef.update(revWalk);
        switch (updateResult) {
            case NEW: 
            case FORCED: {
                return this.repo.getRef(refName);
            }
            case LOCK_FAILURE: {
                throw new ConcurrentRefUpdateException(JGitText.get().couldNotLockHEAD, tagRef.getRef(), updateResult);
            }
            case REJECTED: {
                throw new RefAlreadyExistsException(MessageFormat.format(JGitText.get().tagAlreadyExists, newTagToString));
            }
        }
        throw new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, new Object[]{refName, newTagToString, updateResult}));
    }

    private void processOptions(RepositoryState state) throws InvalidTagNameException {
        if (this.tagger == null && this.annotated) {
            this.tagger = new PersonIdent(this.repo);
        }
        if (this.name == null || !Repository.isValidRefName("refs/tags/" + this.name)) {
            throw new InvalidTagNameException(MessageFormat.format(JGitText.get().tagNameInvalid, this.name == null ? "<null>" : this.name));
        }
        if (this.signed) {
            throw new UnsupportedOperationException(JGitText.get().signingNotSupportedOnTag);
        }
    }

    public TagCommand setName(String name2) {
        this.checkCallable();
        this.name = name2;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getMessage() {
        return this.message;
    }

    public TagCommand setMessage(String message) {
        this.checkCallable();
        this.message = message;
        return this;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public TagCommand setSigned(boolean signed) {
        this.signed = signed;
        return this;
    }

    public TagCommand setTagger(PersonIdent tagger) {
        this.tagger = tagger;
        return this;
    }

    public PersonIdent getTagger() {
        return this.tagger;
    }

    public RevObject getObjectId() {
        return this.id;
    }

    public TagCommand setObjectId(RevObject id2) {
        this.id = id2;
        return this;
    }

    public boolean isForceUpdate() {
        return this.forceUpdate;
    }

    public TagCommand setForceUpdate(boolean forceUpdate) {
        this.forceUpdate = forceUpdate;
        return this;
    }

    public TagCommand setAnnotated(boolean annotated) {
        this.annotated = annotated;
        return this;
    }

    public boolean isAnnotated() {
        return this.annotated;
    }
}

