/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteTagCommand
extends GitCommand<List<String>> {
    private final Set<String> tags = new HashSet<String>();

    protected DeleteTagCommand(Repository repo) {
        super(repo);
    }

    @Override
    public List<String> call() throws GitAPIException {
        this.checkCallable();
        ArrayList<String> result2 = new ArrayList<String>();
        if (this.tags.isEmpty()) {
            return result2;
        }
        try {
            this.setCallable(false);
            for (String tagName : this.tags) {
                Ref currentRef;
                if (tagName == null || (currentRef = this.repo.getRef(tagName)) == null) continue;
                String fullName = currentRef.getName();
                RefUpdate update2 = this.repo.updateRef(fullName);
                update2.setForceUpdate(true);
                RefUpdate.Result deleteResult = update2.delete();
                boolean ok = true;
                switch (deleteResult) {
                    case IO_FAILURE: 
                    case LOCK_FAILURE: 
                    case REJECTED: {
                        ok = false;
                        break;
                    }
                }
                if (ok) {
                    result2.add(fullName);
                    continue;
                }
                throw new JGitInternalException(MessageFormat.format(JGitText.get().deleteTagUnexpectedResult, deleteResult.name()));
            }
            return result2;
        }
        catch (IOException ioe) {
            throw new JGitInternalException(ioe.getMessage(), ioe);
        }
    }

    public DeleteTagCommand setTags(String ... tags) {
        this.checkCallable();
        this.tags.clear();
        for (String tagName : tags) {
            this.tags.add(tagName);
        }
        return this;
    }
}

