/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.util.ByteArrayBuffer;
import org.apache.http.util.CharArrayBuffer;

public final class EntityUtils {
    private EntityUtils() {
    }

    public static void consume(HttpEntity entity) throws IOException {
        InputStream instream;
        if (entity == null) {
            return;
        }
        if (entity.isStreaming() && (instream = entity.getContent()) != null) {
            instream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(HttpEntity entity) throws IOException {
        if (entity == null) {
            throw new IllegalArgumentException("HTTP entity may not be null");
        }
        InputStream instream = entity.getContent();
        if (instream == null) {
            return null;
        }
        try {
            int l;
            if (entity.getContentLength() > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("HTTP entity too large to be buffered in memory");
            }
            int i = (int)entity.getContentLength();
            if (i < 0) {
                i = 4096;
            }
            ByteArrayBuffer buffer2 = new ByteArrayBuffer(i);
            byte[] tmp = new byte[4096];
            while ((l = instream.read(tmp)) != -1) {
                buffer2.append(tmp, 0, l);
            }
            byte[] byArray = buffer2.toByteArray();
            return byArray;
        }
        finally {
            instream.close();
        }
    }

    public static String getContentCharSet(HttpEntity entity) throws ParseException {
        NameValuePair param2;
        HeaderElement[] values2;
        if (entity == null) {
            throw new IllegalArgumentException("HTTP entity may not be null");
        }
        String charset = null;
        if (entity.getContentType() != null && (values2 = entity.getContentType().getElements()).length > 0 && (param2 = values2[0].getParameterByName("charset")) != null) {
            charset = param2.getValue();
        }
        return charset;
    }

    public static String getContentMimeType(HttpEntity entity) throws ParseException {
        HeaderElement[] values2;
        if (entity == null) {
            throw new IllegalArgumentException("HTTP entity may not be null");
        }
        String mimeType = null;
        if (entity.getContentType() != null && (values2 = entity.getContentType().getElements()).length > 0) {
            mimeType = values2[0].getName();
        }
        return mimeType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(HttpEntity entity, String defaultCharset) throws IOException, ParseException {
        if (entity == null) {
            throw new IllegalArgumentException("HTTP entity may not be null");
        }
        InputStream instream = entity.getContent();
        if (instream == null) {
            return null;
        }
        try {
            int l;
            String charset;
            if (entity.getContentLength() > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("HTTP entity too large to be buffered in memory");
            }
            int i = (int)entity.getContentLength();
            if (i < 0) {
                i = 4096;
            }
            if ((charset = EntityUtils.getContentCharSet(entity)) == null) {
                charset = defaultCharset;
            }
            if (charset == null) {
                charset = "ISO-8859-1";
            }
            InputStreamReader reader = new InputStreamReader(instream, charset);
            CharArrayBuffer buffer2 = new CharArrayBuffer(i);
            char[] tmp = new char[1024];
            while ((l = reader.read(tmp)) != -1) {
                buffer2.append(tmp, 0, l);
            }
            String string2 = buffer2.toString();
            return string2;
        }
        finally {
            instream.close();
        }
    }

    public static String toString(HttpEntity entity) throws IOException, ParseException {
        return EntityUtils.toString(entity, null);
    }
}

