/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.cookie.ClientCookie;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieAttributeHandler;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.impl.cookie.BasicClientCookie2;
import org.apache.http.impl.cookie.RFC2109Spec;
import org.apache.http.impl.cookie.RFC2965CommentUrlAttributeHandler;
import org.apache.http.impl.cookie.RFC2965DiscardAttributeHandler;
import org.apache.http.impl.cookie.RFC2965DomainAttributeHandler;
import org.apache.http.impl.cookie.RFC2965PortAttributeHandler;
import org.apache.http.impl.cookie.RFC2965VersionAttributeHandler;
import org.apache.http.message.BufferedHeader;
import org.apache.http.util.CharArrayBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class RFC2965Spec
extends RFC2109Spec {
    public RFC2965Spec() {
        this(null, false);
    }

    public RFC2965Spec(String[] datepatterns, boolean oneHeader) {
        super(datepatterns, oneHeader);
        this.registerAttribHandler("domain", new RFC2965DomainAttributeHandler());
        this.registerAttribHandler("port", new RFC2965PortAttributeHandler());
        this.registerAttribHandler("commenturl", new RFC2965CommentUrlAttributeHandler());
        this.registerAttribHandler("discard", new RFC2965DiscardAttributeHandler());
        this.registerAttribHandler("version", new RFC2965VersionAttributeHandler());
    }

    @Override
    public List<Cookie> parse(Header header, CookieOrigin origin2) throws MalformedCookieException {
        if (header == null) {
            throw new IllegalArgumentException("Header may not be null");
        }
        if (origin2 == null) {
            throw new IllegalArgumentException("Cookie origin may not be null");
        }
        if (!header.getName().equalsIgnoreCase("Set-Cookie2")) {
            throw new MalformedCookieException("Unrecognized cookie header '" + header.toString() + "'");
        }
        origin2 = RFC2965Spec.adjustEffectiveHost(origin2);
        HeaderElement[] elems = header.getElements();
        return this.createCookies(elems, origin2);
    }

    @Override
    protected List<Cookie> parse(HeaderElement[] elems, CookieOrigin origin2) throws MalformedCookieException {
        origin2 = RFC2965Spec.adjustEffectiveHost(origin2);
        return this.createCookies(elems, origin2);
    }

    private List<Cookie> createCookies(HeaderElement[] elems, CookieOrigin origin2) throws MalformedCookieException {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>(elems.length);
        for (HeaderElement headerelement : elems) {
            String name2 = headerelement.getName();
            String value2 = headerelement.getValue();
            if (name2 == null || name2.length() == 0) {
                throw new MalformedCookieException("Cookie name may not be empty");
            }
            BasicClientCookie2 cookie = new BasicClientCookie2(name2, value2);
            cookie.setPath(RFC2965Spec.getDefaultPath(origin2));
            cookie.setDomain(RFC2965Spec.getDefaultDomain(origin2));
            cookie.setPorts(new int[]{origin2.getPort()});
            NameValuePair[] attribs = headerelement.getParameters();
            HashMap<String, NameValuePair> attribmap = new HashMap<String, NameValuePair>(attribs.length);
            for (int j = attribs.length - 1; j >= 0; --j) {
                NameValuePair param2 = attribs[j];
                attribmap.put(param2.getName().toLowerCase(Locale.ENGLISH), param2);
            }
            for (Map.Entry entry2 : attribmap.entrySet()) {
                NameValuePair attrib = (NameValuePair)entry2.getValue();
                String s2 = attrib.getName().toLowerCase(Locale.ENGLISH);
                cookie.setAttribute(s2, attrib.getValue());
                CookieAttributeHandler handler = this.findAttribHandler(s2);
                if (handler == null) continue;
                handler.parse(cookie, attrib.getValue());
            }
            cookies.add(cookie);
        }
        return cookies;
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin2) throws MalformedCookieException {
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (origin2 == null) {
            throw new IllegalArgumentException("Cookie origin may not be null");
        }
        origin2 = RFC2965Spec.adjustEffectiveHost(origin2);
        super.validate(cookie, origin2);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin2) {
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (origin2 == null) {
            throw new IllegalArgumentException("Cookie origin may not be null");
        }
        origin2 = RFC2965Spec.adjustEffectiveHost(origin2);
        return super.match(cookie, origin2);
    }

    @Override
    protected void formatCookieAsVer(CharArrayBuffer buffer2, Cookie cookie, int version) {
        String s2;
        super.formatCookieAsVer(buffer2, cookie, version);
        if (cookie instanceof ClientCookie && (s2 = ((ClientCookie)cookie).getAttribute("port")) != null) {
            int[] ports;
            buffer2.append("; $Port");
            buffer2.append("=\"");
            if (s2.trim().length() > 0 && (ports = cookie.getPorts()) != null) {
                int len = ports.length;
                for (int i = 0; i < len; ++i) {
                    if (i > 0) {
                        buffer2.append(",");
                    }
                    buffer2.append(Integer.toString(ports[i]));
                }
            }
            buffer2.append("\"");
        }
    }

    private static CookieOrigin adjustEffectiveHost(CookieOrigin origin2) {
        String host = origin2.getHost();
        boolean isLocalHost = true;
        for (int i = 0; i < host.length(); ++i) {
            char ch = host.charAt(i);
            if (ch != '.' && ch != ':') continue;
            isLocalHost = false;
            break;
        }
        if (isLocalHost) {
            host = host + ".local";
            return new CookieOrigin(host, origin2.getPort(), origin2.getPath(), origin2.isSecure());
        }
        return origin2;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public Header getVersionHeader() {
        CharArrayBuffer buffer2 = new CharArrayBuffer(40);
        buffer2.append("Cookie2");
        buffer2.append(": ");
        buffer2.append("$Version=");
        buffer2.append(Integer.toString(this.getVersion()));
        return new BufferedHeader(buffer2);
    }

    @Override
    public String toString() {
        return "rfc2965";
    }
}

