/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth;

import org.apache.http.FormattedHeader;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.ContextAwareAuthScheme;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.protocol.HTTP;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.CharArrayBuffer;

@NotThreadSafe
public abstract class AuthSchemeBase
implements ContextAwareAuthScheme {
    private boolean proxy;

    public void processChallenge(Header header) throws MalformedChallengeException {
        int pos;
        CharArrayBuffer buffer2;
        if (header == null) {
            throw new IllegalArgumentException("Header may not be null");
        }
        String authheader = header.getName();
        if (authheader.equalsIgnoreCase("WWW-Authenticate")) {
            this.proxy = false;
        } else if (authheader.equalsIgnoreCase("Proxy-Authenticate")) {
            this.proxy = true;
        } else {
            throw new MalformedChallengeException("Unexpected header name: " + authheader);
        }
        if (header instanceof FormattedHeader) {
            buffer2 = ((FormattedHeader)header).getBuffer();
            pos = ((FormattedHeader)header).getValuePos();
        } else {
            String s2 = header.getValue();
            if (s2 == null) {
                throw new MalformedChallengeException("Header value is null");
            }
            buffer2 = new CharArrayBuffer(s2.length());
            buffer2.append(s2);
            pos = 0;
        }
        while (pos < buffer2.length() && HTTP.isWhitespace(buffer2.charAt(pos))) {
            ++pos;
        }
        int beginIndex = pos;
        while (pos < buffer2.length() && !HTTP.isWhitespace(buffer2.charAt(pos))) {
            ++pos;
        }
        int endIndex = pos;
        String s3 = buffer2.substring(beginIndex, endIndex);
        if (!s3.equalsIgnoreCase(this.getSchemeName())) {
            throw new MalformedChallengeException("Invalid scheme identifier: " + s3);
        }
        this.parseChallenge(buffer2, pos, buffer2.length());
    }

    public Header authenticate(Credentials credentials, HttpRequest request, HttpContext context) throws AuthenticationException {
        return this.authenticate(credentials, request);
    }

    protected abstract void parseChallenge(CharArrayBuffer var1, int var2, int var3) throws MalformedChallengeException;

    public boolean isProxy() {
        return this.proxy;
    }

    public String toString() {
        return this.getSchemeName();
    }
}

