/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.cookie;

import java.util.Locale;
import org.apache.http.annotation.Immutable;

@Immutable
public final class CookieOrigin {
    private final String host;
    private final int port;
    private final String path;
    private final boolean secure;

    public CookieOrigin(String host, int port, String path2, boolean secure2) {
        if (host == null) {
            throw new IllegalArgumentException("Host of origin may not be null");
        }
        if (host.trim().length() == 0) {
            throw new IllegalArgumentException("Host of origin may not be blank");
        }
        if (port < 0) {
            throw new IllegalArgumentException("Invalid port: " + port);
        }
        if (path2 == null) {
            throw new IllegalArgumentException("Path of origin may not be null.");
        }
        this.host = host.toLowerCase(Locale.ENGLISH);
        this.port = port;
        this.path = path2.trim().length() != 0 ? path2 : "/";
        this.secure = secure2;
    }

    public String getHost() {
        return this.host;
    }

    public String getPath() {
        return this.path;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String toString() {
        StringBuilder buffer2 = new StringBuilder();
        buffer2.append('[');
        if (this.secure) {
            buffer2.append("(secure)");
        }
        buffer2.append(this.host);
        buffer2.append(':');
        buffer2.append(Integer.toString(this.port));
        buffer2.append(this.path);
        buffer2.append(']');
        return buffer2.toString();
    }
}

