/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.StringTokenizer;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPListParseEngine;
import org.apache.commons.net.ftp.parser.ConfigurableFTPFileEntryParserImpl;

public class VMSFTPEntryParser
extends ConfigurableFTPFileEntryParserImpl {
    private static final String DEFAULT_DATE_FORMAT = "d-MMM-yyyy HH:mm:ss";
    private static final String REGEX = "(.*;[0-9]+)\\s*(\\d+)/\\d+\\s*(\\S+)\\s+(\\S+)\\s+\\[(([0-9$A-Za-z_]+)|([0-9$A-Za-z_]+),([0-9$a-zA-Z_]+))\\]?\\s*\\([a-zA-Z]*,([a-zA-Z]*),([a-zA-Z]*),([a-zA-Z]*)\\)";

    public VMSFTPEntryParser() {
        this((FTPClientConfig)null);
    }

    public VMSFTPEntryParser(FTPClientConfig config) {
        super(REGEX);
        this.configure(config);
    }

    public FTPFile[] parseFileList(InputStream listStream) throws IOException {
        FTPListParseEngine engine = new FTPListParseEngine(this);
        engine.readServerList(listStream);
        return engine.getFiles();
    }

    public FTPFile parseFTPEntry(String entry2) {
        long longBlock = 512L;
        if (this.matches(entry2)) {
            String user;
            String grp;
            FTPFile f2 = new FTPFile();
            f2.setRawListing(entry2);
            String name2 = this.group(1);
            String size2 = this.group(2);
            String datestr = this.group(3) + " " + this.group(4);
            String owner2 = this.group(5);
            String[] permissions = new String[]{this.group(9), this.group(10), this.group(11)};
            try {
                f2.setTimestamp(super.parseTimestamp(datestr));
            }
            catch (ParseException e) {
                // empty catch block
            }
            StringTokenizer t = new StringTokenizer(owner2, ",");
            switch (t.countTokens()) {
                case 1: {
                    grp = null;
                    user = t.nextToken();
                    break;
                }
                case 2: {
                    grp = t.nextToken();
                    user = t.nextToken();
                    break;
                }
                default: {
                    grp = null;
                    user = null;
                }
            }
            if (name2.lastIndexOf(".DIR") != -1) {
                f2.setType(1);
            } else {
                f2.setType(0);
            }
            if (this.isVersioning()) {
                f2.setName(name2);
            } else {
                name2 = name2.substring(0, name2.lastIndexOf(";"));
                f2.setName(name2);
            }
            long sizeInBytes = Long.parseLong(size2) * longBlock;
            f2.setSize(sizeInBytes);
            f2.setGroup(grp);
            f2.setUser(user);
            for (int access2 = 0; access2 < 3; ++access2) {
                String permission = permissions[access2];
                f2.setPermission(access2, 0, permission.indexOf(82) >= 0);
                f2.setPermission(access2, 1, permission.indexOf(87) >= 0);
                f2.setPermission(access2, 2, permission.indexOf(69) >= 0);
            }
            return f2;
        }
        return null;
    }

    public String readNextEntry(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        StringBuffer entry2 = new StringBuffer();
        while (line != null) {
            if (line.startsWith("Directory") || line.startsWith("Total")) {
                line = reader.readLine();
                continue;
            }
            entry2.append(line);
            if (line.trim().endsWith(")")) break;
            line = reader.readLine();
        }
        return entry2.length() == 0 ? null : entry2.toString();
    }

    protected boolean isVersioning() {
        return false;
    }

    protected FTPClientConfig getDefaultConfiguration() {
        return new FTPClientConfig("VMS", DEFAULT_DATE_FORMAT, null, null, null, null);
    }
}

