/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp.parser;

import java.text.ParseException;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.parser.ConfigurableFTPFileEntryParserImpl;

public class NTFTPEntryParser
extends ConfigurableFTPFileEntryParserImpl {
    private static final String DEFAULT_DATE_FORMAT = "MM-dd-yy hh:mma";
    private static final String REGEX = "(\\S+)\\s+(\\S+)\\s+(?:(<DIR>)|([0-9]+))\\s+(\\S.*)";

    public NTFTPEntryParser() {
        this((FTPClientConfig)null);
    }

    public NTFTPEntryParser(FTPClientConfig config) {
        super(REGEX);
        this.configure(config);
    }

    public FTPFile parseFTPEntry(String entry2) {
        FTPFile f2 = new FTPFile();
        f2.setRawListing(entry2);
        if (this.matches(entry2)) {
            String datestr = this.group(1) + " " + this.group(2);
            String dirString = this.group(3);
            String size2 = this.group(4);
            String name2 = this.group(5);
            try {
                f2.setTimestamp(super.parseTimestamp(datestr));
            }
            catch (ParseException e) {
                // empty catch block
            }
            if (null == name2 || name2.equals(".") || name2.equals("..")) {
                return null;
            }
            f2.setName(name2);
            if ("<DIR>".equals(dirString)) {
                f2.setType(1);
                f2.setSize(0L);
            } else {
                f2.setType(0);
                if (null != size2) {
                    f2.setSize(Long.parseLong(size2));
                }
            }
            return f2;
        }
        return null;
    }

    public FTPClientConfig getDefaultConfiguration() {
        return new FTPClientConfig("WINDOWS", DEFAULT_DATE_FORMAT, null, null, null, null);
    }
}

