/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigValueType;
import com.typesafe.config.impl.ConfigNumber;
import com.typesafe.config.impl.SerializedConfigValue;
import java.io.ObjectStreamException;
import java.io.Serializable;

final class ConfigDouble
extends ConfigNumber
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final double value;

    ConfigDouble(ConfigOrigin origin2, double value2, String originalText) {
        super(origin2, originalText);
        this.value = value2;
    }

    @Override
    public ConfigValueType valueType() {
        return ConfigValueType.NUMBER;
    }

    @Override
    public Double unwrapped() {
        return this.value;
    }

    @Override
    String transformToString() {
        String s2 = super.transformToString();
        if (s2 == null) {
            return Double.toString(this.value);
        }
        return s2;
    }

    @Override
    protected long longValue() {
        return (long)this.value;
    }

    @Override
    protected double doubleValue() {
        return this.value;
    }

    @Override
    protected ConfigDouble newCopy(ConfigOrigin origin2) {
        return new ConfigDouble(origin2, this.value, this.originalText);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializedConfigValue(this);
    }
}

