/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah32;

import com.googlecode.javaewah32.AndIt;
import com.googlecode.javaewah32.BitmapStorage32;
import com.googlecode.javaewah32.BufferedIterator32;
import com.googlecode.javaewah32.IteratingRLW32;
import com.googlecode.javaewah32.ORIt;
import com.googlecode.javaewah32.XORIt;
import java.util.Arrays;
import java.util.LinkedList;

public class IteratorAggregation32 {
    public static final int DEFAULTMAXBUFSIZE = 65536;

    public static IteratingRLW32 not(final IteratingRLW32 x) {
        return new IteratingRLW32(){

            @Override
            public boolean next() {
                return x.next();
            }

            @Override
            public int getLiteralWordAt(int index2) {
                return ~x.getLiteralWordAt(index2);
            }

            @Override
            public int getNumberOfLiteralWords() {
                return x.getNumberOfLiteralWords();
            }

            @Override
            public boolean getRunningBit() {
                return !x.getRunningBit();
            }

            @Override
            public int size() {
                return x.size();
            }

            @Override
            public int getRunningLength() {
                return x.getRunningLength();
            }

            @Override
            public void discardFirstWords(int y) {
                x.discardFirstWords(y);
            }
        };
    }

    public static IteratingRLW32 bufferedand(IteratingRLW32 ... al) {
        return IteratorAggregation32.bufferedand(65536, al);
    }

    public static IteratingRLW32 bufferedand(int bufsize, IteratingRLW32 ... al) {
        if (al.length == 0) {
            throw new IllegalArgumentException("Need at least one iterator");
        }
        if (al.length == 1) {
            return al[0];
        }
        LinkedList<IteratingRLW32> basell = new LinkedList<IteratingRLW32>();
        for (IteratingRLW32 i : al) {
            basell.add(i);
        }
        return new BufferedIterator32(new AndIt(basell, bufsize));
    }

    public static IteratingRLW32 bufferedor(IteratingRLW32 ... al) {
        return IteratorAggregation32.bufferedor(65536, al);
    }

    public static IteratingRLW32 bufferedor(int bufsize, IteratingRLW32 ... al) {
        if (al.length == 0) {
            throw new IllegalArgumentException("Need at least one iterator");
        }
        if (al.length == 1) {
            return al[0];
        }
        LinkedList<IteratingRLW32> basell = new LinkedList<IteratingRLW32>();
        for (IteratingRLW32 i : al) {
            basell.add(i);
        }
        return new BufferedIterator32(new ORIt(basell, bufsize));
    }

    public static IteratingRLW32 bufferedxor(IteratingRLW32 ... al) {
        return IteratorAggregation32.bufferedxor(65536, al);
    }

    public static IteratingRLW32 bufferedxor(int bufsize, IteratingRLW32 ... al) {
        if (al.length == 0) {
            throw new IllegalArgumentException("Need at least one iterator");
        }
        if (al.length == 1) {
            return al[0];
        }
        LinkedList<IteratingRLW32> basell = new LinkedList<IteratingRLW32>();
        for (IteratingRLW32 i : al) {
            basell.add(i);
        }
        return new BufferedIterator32(new XORIt(basell, bufsize));
    }

    protected static void dischargeAsEmpty(BitmapStorage32 container, IteratingRLW32 i) {
        while (i.size() > 0) {
            container.addStreamOfEmptyWords(false, i.size());
            i.next();
        }
    }

    protected static int discharge(BitmapStorage32 container, IteratingRLW32 i, int max2) {
        int counter2;
        int L;
        for (counter2 = 0; i.size() > 0 && counter2 < max2; counter2 += L) {
            int L1 = i.getRunningLength();
            if (L1 > 0) {
                if (L1 + counter2 > max2) {
                    L1 = max2 - counter2;
                }
                container.addStreamOfEmptyWords(i.getRunningBit(), L1);
                counter2 += L1;
            }
            if ((L = i.getNumberOfLiteralWords()) + counter2 > max2) {
                L = max2 - counter2;
            }
            for (int k = 0; k < L; ++k) {
                container.add(i.getLiteralWordAt(k));
            }
            i.discardFirstWords(L + L1);
        }
        return counter2;
    }

    protected static int dischargeNegated(BitmapStorage32 container, IteratingRLW32 i, int max2) {
        int counter2;
        int L;
        for (counter2 = 0; i.size() > 0 && counter2 < max2; counter2 += L) {
            int L1 = i.getRunningLength();
            if (L1 > 0) {
                if (L1 + counter2 > max2) {
                    L1 = max2 - counter2;
                }
                container.addStreamOfEmptyWords(i.getRunningBit(), L1);
                counter2 += L1;
            }
            if ((L = i.getNumberOfLiteralWords()) + counter2 > max2) {
                L = max2 - counter2;
            }
            for (int k = 0; k < L; ++k) {
                container.add(i.getLiteralWordAt(k));
            }
            i.discardFirstWords(L + L1);
        }
        return counter2;
    }

    static void andToContainer(BitmapStorage32 container, int desiredrlwcount, IteratingRLW32 rlwi, IteratingRLW32 rlwj) {
        while (rlwi.size() > 0 && rlwj.size() > 0 && desiredrlwcount-- > 0) {
            while (rlwi.getRunningLength() > 0 || rlwj.getRunningLength() > 0) {
                IteratingRLW32 predator;
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingRLW32 prey = i_is_prey ? rlwi : rlwj;
                IteratingRLW32 iteratingRLW32 = predator = i_is_prey ? rlwj : rlwi;
                if (!predator.getRunningBit()) {
                    container.addStreamOfEmptyWords(false, predator.getRunningLength());
                    prey.discardFirstWords(predator.getRunningLength());
                    predator.discardFirstWords(predator.getRunningLength());
                    continue;
                }
                int index2 = IteratorAggregation32.discharge(container, prey, predator.getRunningLength());
                container.addStreamOfEmptyWords(false, predator.getRunningLength() - index2);
                predator.discardFirstWords(predator.getRunningLength());
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            desiredrlwcount -= nbre_literal;
            for (int k = 0; k < nbre_literal; ++k) {
                container.add(rlwi.getLiteralWordAt(k) & rlwj.getLiteralWordAt(k));
            }
            rlwi.discardFirstWords(nbre_literal);
            rlwj.discardFirstWords(nbre_literal);
        }
    }

    static void andToContainer(BitmapStorage32 container, IteratingRLW32 rlwi, IteratingRLW32 rlwj) {
        while (rlwi.size() > 0 && rlwj.size() > 0) {
            while (rlwi.getRunningLength() > 0 || rlwj.getRunningLength() > 0) {
                IteratingRLW32 predator;
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingRLW32 prey = i_is_prey ? rlwi : rlwj;
                IteratingRLW32 iteratingRLW32 = predator = i_is_prey ? rlwj : rlwi;
                if (!predator.getRunningBit()) {
                    container.addStreamOfEmptyWords(false, predator.getRunningLength());
                    prey.discardFirstWords(predator.getRunningLength());
                    predator.discardFirstWords(predator.getRunningLength());
                    continue;
                }
                int index2 = IteratorAggregation32.discharge(container, prey, predator.getRunningLength());
                container.addStreamOfEmptyWords(false, predator.getRunningLength() - index2);
                predator.discardFirstWords(predator.getRunningLength());
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            for (int k = 0; k < nbre_literal; ++k) {
                container.add(rlwi.getLiteralWordAt(k) & rlwj.getLiteralWordAt(k));
            }
            rlwi.discardFirstWords(nbre_literal);
            rlwj.discardFirstWords(nbre_literal);
        }
    }

    public static void xorToContainer(BitmapStorage32 container, int desiredrlwcount, IteratingRLW32 rlwi, IteratingRLW32 rlwj) {
        while (rlwi.size() > 0 && rlwj.size() > 0 && desiredrlwcount-- > 0) {
            while (rlwi.getRunningLength() > 0 || rlwj.getRunningLength() > 0) {
                int index2;
                IteratingRLW32 predator;
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingRLW32 prey = i_is_prey ? rlwi : rlwj;
                IteratingRLW32 iteratingRLW32 = predator = i_is_prey ? rlwj : rlwi;
                if (!predator.getRunningBit()) {
                    index2 = IteratorAggregation32.discharge(container, prey, predator.getRunningLength());
                    container.addStreamOfEmptyWords(false, predator.getRunningLength() - index2);
                    predator.discardFirstWords(predator.getRunningLength());
                    continue;
                }
                index2 = IteratorAggregation32.dischargeNegated(container, prey, predator.getRunningLength());
                container.addStreamOfEmptyWords(true, predator.getRunningLength() - index2);
                predator.discardFirstWords(predator.getRunningLength());
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            desiredrlwcount -= nbre_literal;
            for (int k = 0; k < nbre_literal; ++k) {
                container.add(rlwi.getLiteralWordAt(k) ^ rlwj.getLiteralWordAt(k));
            }
            rlwi.discardFirstWords(nbre_literal);
            rlwj.discardFirstWords(nbre_literal);
        }
    }

    protected static int inplaceor(int[] bitmap, IteratingRLW32 i) {
        int s2;
        int pos = 0;
        while ((s2 = i.size()) > 0) {
            int k;
            if (pos + s2 < bitmap.length) {
                int L = i.getRunningLength();
                if (i.getRunningBit()) {
                    Arrays.fill(bitmap, pos, pos + L, -1);
                }
                pos += L;
                int LR2 = i.getNumberOfLiteralWords();
                for (k = 0; k < LR2; ++k) {
                    int n = pos++;
                    bitmap[n] = bitmap[n] | i.getLiteralWordAt(k);
                }
                if (i.next()) continue;
                return pos;
            }
            int howmany = bitmap.length - pos;
            int L = i.getRunningLength();
            if (pos + L > bitmap.length) {
                if (i.getRunningBit()) {
                    Arrays.fill(bitmap, pos, bitmap.length, -1);
                }
                i.discardFirstWords(howmany);
                return bitmap.length;
            }
            if (i.getRunningBit()) {
                Arrays.fill(bitmap, pos, pos + L, -1);
            }
            pos += L;
            k = 0;
            while (pos < bitmap.length) {
                int n = pos++;
                bitmap[n] = bitmap[n] | i.getLiteralWordAt(k);
                ++k;
            }
            i.discardFirstWords(howmany);
            return pos;
        }
        return pos;
    }

    protected static int inplacexor(int[] bitmap, IteratingRLW32 i) {
        int s2;
        int pos = 0;
        while ((s2 = i.size()) > 0) {
            int k;
            if (pos + s2 < bitmap.length) {
                int L = i.getRunningLength();
                if (i.getRunningBit()) {
                    for (int k2 = pos; k2 < pos + L; ++k2) {
                        bitmap[k2] = ~bitmap[k2];
                    }
                }
                pos += L;
                int LR2 = i.getNumberOfLiteralWords();
                for (k = 0; k < LR2; ++k) {
                    int n = pos++;
                    bitmap[n] = bitmap[n] ^ i.getLiteralWordAt(k);
                }
                if (i.next()) continue;
                return pos;
            }
            int howmany = bitmap.length - pos;
            int L = i.getRunningLength();
            if (pos + L > bitmap.length) {
                if (i.getRunningBit()) {
                    for (k = pos; k < bitmap.length; ++k) {
                        bitmap[k] = ~bitmap[k];
                    }
                }
                i.discardFirstWords(howmany);
                return bitmap.length;
            }
            if (i.getRunningBit()) {
                for (k = pos; k < pos + L; ++k) {
                    bitmap[k] = ~bitmap[k];
                }
            }
            pos += L;
            k = 0;
            while (pos < bitmap.length) {
                int n = pos++;
                bitmap[n] = bitmap[n] ^ i.getLiteralWordAt(k);
                ++k;
            }
            i.discardFirstWords(howmany);
            return pos;
        }
        return pos;
    }

    protected static int inplaceand(int[] bitmap, IteratingRLW32 i) {
        int s2;
        int pos = 0;
        while ((s2 = i.size()) > 0) {
            int k;
            if (pos + s2 < bitmap.length) {
                int L = i.getRunningLength();
                if (!i.getRunningBit()) {
                    for (int k2 = pos; k2 < pos + L; ++k2) {
                        bitmap[k2] = 0;
                    }
                }
                pos += L;
                int LR2 = i.getNumberOfLiteralWords();
                for (k = 0; k < LR2; ++k) {
                    int n = pos++;
                    bitmap[n] = bitmap[n] & i.getLiteralWordAt(k);
                }
                if (i.next()) continue;
                return pos;
            }
            int howmany = bitmap.length - pos;
            int L = i.getRunningLength();
            if (pos + L > bitmap.length) {
                if (!i.getRunningBit()) {
                    for (k = pos; k < bitmap.length; ++k) {
                        bitmap[k] = 0;
                    }
                }
                i.discardFirstWords(howmany);
                return bitmap.length;
            }
            if (!i.getRunningBit()) {
                for (k = pos; k < pos + L; ++k) {
                    bitmap[k] = 0;
                }
            }
            pos += L;
            k = 0;
            while (pos < bitmap.length) {
                int n = pos++;
                bitmap[n] = bitmap[n] & i.getLiteralWordAt(k);
                ++k;
            }
            i.discardFirstWords(howmany);
            return pos;
        }
        return pos;
    }
}

