/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah.benchmark;

import com.googlecode.javaewah.EWAHCompressedBitmap;
import com.googlecode.javaewah.FastAggregation;
import com.googlecode.javaewah.IteratingBufferedRunningLengthWord;
import com.googlecode.javaewah.IteratingRLW;
import com.googlecode.javaewah.IteratorAggregation;
import com.googlecode.javaewah.IteratorUtil;
import com.googlecode.javaewah.benchmark.Benchmark;
import com.googlecode.javaewah.benchmark.ClusteredDataGenerator;
import java.text.DecimalFormat;

public class BenchmarkIntersection {
    public static void main(String[] args2) {
        BenchmarkIntersection.test(10, 18, 1);
    }

    public static void test(int N, int nbr, int repeat2) {
        long bogus = 0L;
        DecimalFormat df = new DecimalFormat("0.###");
        ClusteredDataGenerator cdg = new ClusteredDataGenerator();
        for (int sparsity = 1; sparsity < 30 - nbr; ++sparsity) {
            for (int times2 = 0; times2 < 2; ++times2) {
                Object[] ewahcp;
                int r;
                String line = "";
                line = line + sparsity;
                int[][] data = new int[N][];
                int Max2 = 1 << nbr + sparsity;
                int[] inter = cdg.generateClustered(1 << nbr / 2, Max2);
                for (int k = 0; k < N; ++k) {
                    data[k] = Benchmark.unite2by2(cdg.generateClustered(1 << nbr, Max2), inter);
                }
                EWAHCompressedBitmap[] ewah = new EWAHCompressedBitmap[N];
                for (int k = 0; k < N; ++k) {
                    ewah[k] = new EWAHCompressedBitmap();
                    for (int x = 0; x < data[k].length; ++x) {
                        ewah[k].set(data[k][x]);
                    }
                    data[k] = null;
                }
                EWAHCompressedBitmap answer = ewah[0].and(ewah[1]);
                for (int k = 2; k < ewah.length; ++k) {
                    answer = answer.and(ewah[k]);
                }
                EWAHCompressedBitmap ewahand = EWAHCompressedBitmap.and(ewah);
                if (!answer.equals(ewahand)) {
                    throw new RuntimeException("bug EWAHCompressedBitmap.and");
                }
                EWAHCompressedBitmap ewahand2 = FastAggregation.bufferedand(65536, ewah);
                if (!ewahand.equals(ewahand2)) {
                    throw new RuntimeException("bug FastAggregation.bufferedand ");
                }
                long bef = System.currentTimeMillis();
                for (r = 0; r < repeat2; ++r) {
                    for (int k = 0; k < N; ++k) {
                        EWAHCompressedBitmap ewahor = ewah[0];
                        for (int j = 1; j < k + 1; ++j) {
                            ewahor = ewahor.and(ewah[j]);
                        }
                    }
                }
                long aft = System.currentTimeMillis();
                line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
                bef = System.currentTimeMillis();
                for (r = 0; r < repeat2; ++r) {
                    for (int k = 0; k < N; ++k) {
                        ewahcp = new EWAHCompressedBitmap[k + 1];
                        for (int j = 0; j < k + 1; ++j) {
                            ewahcp[j] = ewah[j];
                        }
                        EWAHCompressedBitmap ewahor = EWAHCompressedBitmap.and((EWAHCompressedBitmap[])ewahcp);
                        bogus += (long)ewahor.sizeInBits();
                    }
                }
                aft = System.currentTimeMillis();
                line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
                bef = System.currentTimeMillis();
                for (r = 0; r < repeat2; ++r) {
                    for (int k = 0; k < N; ++k) {
                        ewahcp = new EWAHCompressedBitmap[k + 1];
                        for (int j = 0; j < k + 1; ++j) {
                            ewahcp[j] = ewah[j];
                        }
                        EWAHCompressedBitmap ewahor = FastAggregation.bufferedand(65536, (EWAHCompressedBitmap[])ewahcp);
                        bogus += (long)ewahor.sizeInBits();
                    }
                }
                aft = System.currentTimeMillis();
                line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
                bef = System.currentTimeMillis();
                for (r = 0; r < repeat2; ++r) {
                    for (int k = 0; k < N; ++k) {
                        ewahcp = new IteratingRLW[k + 1];
                        for (int j = 0; j < k + 1; ++j) {
                            ewahcp[j] = new IteratingBufferedRunningLengthWord(ewah[j]);
                        }
                        IteratingRLW ewahor = IteratorAggregation.bufferedand((IteratingRLW[])ewahcp);
                        int wordcounter = IteratorUtil.cardinality(ewahor);
                        bogus += (long)wordcounter;
                    }
                }
                aft = System.currentTimeMillis();
                line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
                System.out.println("# times for: 2by2 EWAHCompressedBitmap.and bufferedand iterator-bufferedand");
                System.out.println(line);
            }
            System.out.println("# bogus =" + bogus);
        }
    }
}

