/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jdk8;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.ReferenceType;
import com.fasterxml.jackson.databind.type.TypeBindings;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.type.TypeModifier;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

public class Jdk8TypeModifier
extends TypeModifier {
    @Override
    public JavaType modifyType(JavaType type, Type jdkType, TypeBindings bindings, TypeFactory typeFactory) {
        JavaType refType;
        if (type.isReferenceType() || type.isContainerType()) {
            return type;
        }
        Class<?> raw2 = type.getRawClass();
        if (raw2 == Optional.class) {
            refType = bindings.isEmpty() ? TypeFactory.unknownType() : bindings.getBoundType(0);
        } else if (raw2 == OptionalInt.class) {
            refType = typeFactory.constructType(Integer.TYPE);
        } else if (raw2 == OptionalLong.class) {
            refType = typeFactory.constructType(Long.TYPE);
        } else if (raw2 == OptionalDouble.class) {
            refType = typeFactory.constructType(Double.TYPE);
        } else {
            return type;
        }
        return ReferenceType.upgradeFrom(type, refType);
    }
}

