/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.util.CompactStringObjectMap;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class EnumResolver
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Class<Enum<?>> _enumClass;
    protected final Enum<?>[] _enums;
    protected final HashMap<String, Enum<?>> _enumsById;

    protected EnumResolver(Class<Enum<?>> enumClass, Enum<?>[] enums, HashMap<String, Enum<?>> map23) {
        this._enumClass = enumClass;
        this._enums = enums;
        this._enumsById = map23;
    }

    public static EnumResolver constructFor(Class<Enum<?>> enumCls, AnnotationIntrospector ai) {
        Enum<?>[] enumValues = enumCls.getEnumConstants();
        if (enumValues == null) {
            throw new IllegalArgumentException("No enum constants for class " + enumCls.getName());
        }
        String[] names = ai.findEnumValues(enumCls, enumValues, new String[enumValues.length]);
        HashMap map23 = new HashMap();
        int len = enumValues.length;
        for (int i = 0; i < len; ++i) {
            String name2 = names[i];
            if (name2 == null) {
                name2 = enumValues[i].name();
            }
            map23.put(name2, enumValues[i]);
        }
        return new EnumResolver(enumCls, enumValues, map23);
    }

    public static EnumResolver constructUsingToString(Class<Enum<?>> enumCls) {
        Enum<?>[] enumValues = enumCls.getEnumConstants();
        HashMap map23 = new HashMap();
        int i = enumValues.length;
        while (--i >= 0) {
            Enum<?> e = enumValues[i];
            map23.put(e.toString(), e);
        }
        return new EnumResolver(enumCls, enumValues, map23);
    }

    public static EnumResolver constructUsingMethod(Class<Enum<?>> enumCls, Method accessor) {
        Enum<?>[] enumValues = enumCls.getEnumConstants();
        HashMap map23 = new HashMap();
        int i = enumValues.length;
        while (--i >= 0) {
            Enum<?> en = enumValues[i];
            try {
                Object o = accessor.invoke(en, new Object[0]);
                if (o == null) continue;
                map23.put(o.toString(), en);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to access @JsonValue of Enum value " + en + ": " + e.getMessage());
            }
        }
        return new EnumResolver(enumCls, enumValues, map23);
    }

    public static EnumResolver constructUnsafe(Class<?> rawEnumCls, AnnotationIntrospector ai) {
        Class<Enum<?>> enumCls = rawEnumCls;
        return EnumResolver.constructFor(enumCls, ai);
    }

    public static EnumResolver constructUnsafeUsingToString(Class<?> rawEnumCls) {
        Class<Enum<?>> enumCls = rawEnumCls;
        return EnumResolver.constructUsingToString(enumCls);
    }

    public static EnumResolver constructUnsafeUsingMethod(Class<?> rawEnumCls, Method accessor) {
        Class<Enum<?>> enumCls = rawEnumCls;
        return EnumResolver.constructUsingMethod(enumCls, accessor);
    }

    public CompactStringObjectMap constructLookup() {
        return CompactStringObjectMap.construct(this._enumsById);
    }

    public Enum<?> findEnum(String key) {
        return this._enumsById.get(key);
    }

    public Enum<?> getEnum(int index2) {
        if (index2 < 0 || index2 >= this._enums.length) {
            return null;
        }
        return this._enums[index2];
    }

    public Enum<?>[] getRawEnums() {
        return this._enums;
    }

    public List<Enum<?>> getEnums() {
        ArrayList enums = new ArrayList(this._enums.length);
        for (Enum<?> e : this._enums) {
            enums.add(e);
        }
        return enums;
    }

    public Class<Enum<?>> getEnumClass() {
        return this._enumClass;
    }

    public int lastValidIndex() {
        return this._enums.length - 1;
    }
}

