/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.util.EnumMap;
import java.util.EnumSet;

public class ClassNameIdResolver
extends TypeIdResolverBase {
    public ClassNameIdResolver(JavaType baseType, TypeFactory typeFactory) {
        super(baseType, typeFactory);
    }

    @Override
    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CLASS;
    }

    public void registerSubtype(Class<?> type, String name2) {
    }

    @Override
    public String idFromValue(Object value2) {
        return this._idFrom(value2, value2.getClass());
    }

    @Override
    public String idFromValueAndType(Object value2, Class<?> type) {
        return this._idFrom(value2, type);
    }

    @Override
    @Deprecated
    public JavaType typeFromId(String id2) {
        return this._typeFromId(id2, this._typeFactory);
    }

    @Override
    public JavaType typeFromId(DatabindContext context, String id2) {
        return this._typeFromId(id2, context.getTypeFactory());
    }

    protected JavaType _typeFromId(String id2, TypeFactory typeFactory) {
        if (id2.indexOf(60) > 0) {
            JavaType t = typeFactory.constructFromCanonical(id2);
            return t;
        }
        try {
            Class<?> cls = typeFactory.findClass(id2);
            return typeFactory.constructSpecializedType(this._baseType, cls);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Invalid type id '" + id2 + "' (for id type 'Id.class'): no such class found");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid type id '" + id2 + "' (for id type 'Id.class'): " + e.getMessage(), e);
        }
    }

    protected final String _idFrom(Object value2, Class<?> cls) {
        Class<?> staticType;
        Class<?> outer;
        String str;
        if (Enum.class.isAssignableFrom(cls) && !cls.isEnum()) {
            cls = cls.getSuperclass();
        }
        if ((str = cls.getName()).startsWith("java.util")) {
            if (value2 instanceof EnumSet) {
                Class<? extends Enum<?>> enumClass = ClassUtil.findEnumType((EnumSet)value2);
                str = TypeFactory.defaultInstance().constructCollectionType(EnumSet.class, enumClass).toCanonical();
            } else if (value2 instanceof EnumMap) {
                Class<? extends Enum<?>> enumClass = ClassUtil.findEnumType((EnumMap)value2);
                Class<Object> valueClass = Object.class;
                str = TypeFactory.defaultInstance().constructMapType(EnumMap.class, enumClass, valueClass).toCanonical();
            } else {
                String end2 = str.substring(9);
                if ((end2.startsWith(".Arrays$") || end2.startsWith(".Collections$")) && str.indexOf("List") >= 0) {
                    str = "java.util.ArrayList";
                }
            }
        } else if (str.indexOf(36) >= 0 && (outer = ClassUtil.getOuterClass(cls)) != null && ClassUtil.getOuterClass(staticType = this._baseType.getRawClass()) == null) {
            cls = this._baseType.getRawClass();
            str = cls.getName();
        }
        return str;
    }

    @Override
    public String getDescForKnownTypeIds() {
        return "class name used as type id";
    }
}

