/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.TypeSerializerBase;
import java.io.IOException;

public class AsWrapperTypeSerializer
extends TypeSerializerBase {
    public AsWrapperTypeSerializer(TypeIdResolver idRes, BeanProperty property) {
        super(idRes, property);
    }

    @Override
    public AsWrapperTypeSerializer forProperty(BeanProperty prop) {
        return this._property == prop ? this : new AsWrapperTypeSerializer(this._idResolver, prop);
    }

    @Override
    public JsonTypeInfo.As getTypeInclusion() {
        return JsonTypeInfo.As.WRAPPER_OBJECT;
    }

    @Override
    public void writeTypePrefixForObject(Object value2, JsonGenerator g2) throws IOException {
        String typeId = this.idFromValue(value2);
        if (g2.canWriteTypeId()) {
            if (typeId != null) {
                g2.writeTypeId(typeId);
            }
            g2.writeStartObject();
        } else {
            g2.writeStartObject();
            g2.writeObjectFieldStart(this._validTypeId(typeId));
        }
    }

    @Override
    public void writeTypePrefixForObject(Object value2, JsonGenerator g2, Class<?> type) throws IOException {
        String typeId = this.idFromValueAndType(value2, type);
        if (g2.canWriteTypeId()) {
            if (typeId != null) {
                g2.writeTypeId(typeId);
            }
            g2.writeStartObject();
        } else {
            g2.writeStartObject();
            g2.writeObjectFieldStart(this._validTypeId(typeId));
        }
    }

    @Override
    public void writeTypePrefixForArray(Object value2, JsonGenerator g2) throws IOException {
        String typeId = this.idFromValue(value2);
        if (g2.canWriteTypeId()) {
            if (typeId != null) {
                g2.writeTypeId(typeId);
            }
            g2.writeStartArray();
        } else {
            g2.writeStartObject();
            g2.writeArrayFieldStart(this._validTypeId(typeId));
        }
    }

    @Override
    public void writeTypePrefixForArray(Object value2, JsonGenerator g2, Class<?> type) throws IOException {
        String typeId = this.idFromValueAndType(value2, type);
        if (g2.canWriteTypeId()) {
            if (typeId != null) {
                g2.writeTypeId(typeId);
            }
            g2.writeStartArray();
        } else {
            g2.writeStartObject();
            g2.writeArrayFieldStart(this._validTypeId(typeId));
        }
    }

    @Override
    public void writeTypePrefixForScalar(Object value2, JsonGenerator g2) throws IOException {
        String typeId = this.idFromValue(value2);
        if (g2.canWriteTypeId()) {
            if (typeId != null) {
                g2.writeTypeId(typeId);
            }
        } else {
            g2.writeStartObject();
            g2.writeFieldName(this._validTypeId(typeId));
        }
    }

    @Override
    public void writeTypePrefixForScalar(Object value2, JsonGenerator g2, Class<?> type) throws IOException {
        String typeId = this.idFromValueAndType(value2, type);
        if (g2.canWriteTypeId()) {
            if (typeId != null) {
                g2.writeTypeId(typeId);
            }
        } else {
            g2.writeStartObject();
            g2.writeFieldName(this._validTypeId(typeId));
        }
    }

    @Override
    public void writeTypeSuffixForObject(Object value2, JsonGenerator g2) throws IOException {
        g2.writeEndObject();
        if (!g2.canWriteTypeId()) {
            g2.writeEndObject();
        }
    }

    @Override
    public void writeTypeSuffixForArray(Object value2, JsonGenerator g2) throws IOException {
        g2.writeEndArray();
        if (!g2.canWriteTypeId()) {
            g2.writeEndObject();
        }
    }

    @Override
    public void writeTypeSuffixForScalar(Object value2, JsonGenerator g2) throws IOException {
        if (!g2.canWriteTypeId()) {
            g2.writeEndObject();
        }
    }

    @Override
    public void writeCustomTypePrefixForObject(Object value2, JsonGenerator g2, String typeId) throws IOException {
        if (g2.canWriteTypeId()) {
            if (typeId != null) {
                g2.writeTypeId(typeId);
            }
            g2.writeStartObject();
        } else {
            g2.writeStartObject();
            g2.writeObjectFieldStart(this._validTypeId(typeId));
        }
    }

    @Override
    public void writeCustomTypePrefixForArray(Object value2, JsonGenerator g2, String typeId) throws IOException {
        if (g2.canWriteTypeId()) {
            if (typeId != null) {
                g2.writeTypeId(typeId);
            }
            g2.writeStartArray();
        } else {
            g2.writeStartObject();
            g2.writeArrayFieldStart(this._validTypeId(typeId));
        }
    }

    @Override
    public void writeCustomTypePrefixForScalar(Object value2, JsonGenerator g2, String typeId) throws IOException {
        if (g2.canWriteTypeId()) {
            if (typeId != null) {
                g2.writeTypeId(typeId);
            }
        } else {
            g2.writeStartObject();
            g2.writeFieldName(this._validTypeId(typeId));
        }
    }

    @Override
    public void writeCustomTypeSuffixForObject(Object value2, JsonGenerator g2, String typeId) throws IOException {
        if (!g2.canWriteTypeId()) {
            this.writeTypeSuffixForObject(value2, g2);
        }
    }

    @Override
    public void writeCustomTypeSuffixForArray(Object value2, JsonGenerator g2, String typeId) throws IOException {
        if (!g2.canWriteTypeId()) {
            this.writeTypeSuffixForArray(value2, g2);
        }
    }

    @Override
    public void writeCustomTypeSuffixForScalar(Object value2, JsonGenerator g2, String typeId) throws IOException {
        if (!g2.canWriteTypeId()) {
            this.writeTypeSuffixForScalar(value2, g2);
        }
    }

    protected String _validTypeId(String typeId) {
        return typeId == null ? "" : typeId;
    }
}

