/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.UnresolvedForwardReference;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.impl.ReadableObjectId;
import com.fasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

@JacksonStdImpl
public class CollectionDeserializer
extends ContainerDeserializerBase<Collection<Object>>
implements ContextualDeserializer {
    private static final long serialVersionUID = -1L;
    protected final JavaType _collectionType;
    protected final JsonDeserializer<Object> _valueDeserializer;
    protected final TypeDeserializer _valueTypeDeserializer;
    protected final ValueInstantiator _valueInstantiator;
    protected final JsonDeserializer<Object> _delegateDeserializer;
    protected final Boolean _unwrapSingle;

    public CollectionDeserializer(JavaType collectionType, JsonDeserializer<Object> valueDeser, TypeDeserializer valueTypeDeser, ValueInstantiator valueInstantiator) {
        this(collectionType, valueDeser, valueTypeDeser, valueInstantiator, null, null);
    }

    protected CollectionDeserializer(JavaType collectionType, JsonDeserializer<Object> valueDeser, TypeDeserializer valueTypeDeser, ValueInstantiator valueInstantiator, JsonDeserializer<Object> delegateDeser, Boolean unwrapSingle) {
        super(collectionType);
        this._collectionType = collectionType;
        this._valueDeserializer = valueDeser;
        this._valueTypeDeserializer = valueTypeDeser;
        this._valueInstantiator = valueInstantiator;
        this._delegateDeserializer = delegateDeser;
        this._unwrapSingle = unwrapSingle;
    }

    protected CollectionDeserializer(CollectionDeserializer src) {
        super(src._collectionType);
        this._collectionType = src._collectionType;
        this._valueDeserializer = src._valueDeserializer;
        this._valueTypeDeserializer = src._valueTypeDeserializer;
        this._valueInstantiator = src._valueInstantiator;
        this._delegateDeserializer = src._delegateDeserializer;
        this._unwrapSingle = src._unwrapSingle;
    }

    protected CollectionDeserializer withResolved(JsonDeserializer<?> dd2, JsonDeserializer<?> vd, TypeDeserializer vtd, Boolean unwrapSingle) {
        if (dd2 == this._delegateDeserializer && vd == this._valueDeserializer && vtd == this._valueTypeDeserializer && this._unwrapSingle == unwrapSingle) {
            return this;
        }
        return new CollectionDeserializer(this._collectionType, vd, vtd, this._valueInstantiator, dd2, unwrapSingle);
    }

    @Deprecated
    protected CollectionDeserializer withResolved(JsonDeserializer<?> dd2, JsonDeserializer<?> vd, TypeDeserializer vtd) {
        return this.withResolved(dd2, vd, vtd, this._unwrapSingle);
    }

    @Override
    public boolean isCachable() {
        return this._valueDeserializer == null && this._valueTypeDeserializer == null && this._delegateDeserializer == null;
    }

    public CollectionDeserializer createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JsonDeserializer<Object> delegateDeser = null;
        if (this._valueInstantiator != null && this._valueInstantiator.canCreateUsingDelegate()) {
            JavaType delegateType = this._valueInstantiator.getDelegateType(ctxt.getConfig());
            if (delegateType == null) {
                throw new IllegalArgumentException("Invalid delegate-creator definition for " + this._collectionType + ": value instantiator (" + this._valueInstantiator.getClass().getName() + ") returned true for 'canCreateUsingDelegate()', but null for 'getDelegateType()'");
            }
            delegateDeser = this.findDeserializer(ctxt, delegateType, property);
        }
        Boolean unwrapSingle = this.findFormatFeature(ctxt, property, Collection.class, JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        JsonDeserializer<Object> valueDeser = this._valueDeserializer;
        valueDeser = this.findConvertingContentDeserializer(ctxt, property, valueDeser);
        JavaType vt = this._collectionType.getContentType();
        valueDeser = valueDeser == null ? ctxt.findContextualValueDeserializer(vt, property) : ctxt.handleSecondaryContextualization(valueDeser, property, vt);
        TypeDeserializer valueTypeDeser = this._valueTypeDeserializer;
        if (valueTypeDeser != null) {
            valueTypeDeser = valueTypeDeser.forProperty(property);
        }
        return this.withResolved(delegateDeser, valueDeser, valueTypeDeser, unwrapSingle);
    }

    @Override
    public JavaType getContentType() {
        return this._collectionType.getContentType();
    }

    @Override
    public JsonDeserializer<Object> getContentDeserializer() {
        return this._valueDeserializer;
    }

    @Override
    public Collection<Object> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        String str;
        if (this._delegateDeserializer != null) {
            return (Collection)this._valueInstantiator.createUsingDelegate(ctxt, this._delegateDeserializer.deserialize(p, ctxt));
        }
        if (p.hasToken(JsonToken.VALUE_STRING) && (str = p.getText()).length() == 0) {
            return (Collection)this._valueInstantiator.createFromString(ctxt, str);
        }
        return this.deserialize(p, ctxt, (Collection)this._valueInstantiator.createUsingDefault(ctxt));
    }

    @Override
    public Collection<Object> deserialize(JsonParser p, DeserializationContext ctxt, Collection<Object> result2) throws IOException {
        JsonToken t;
        CollectionReferringAccumulator referringAccumulator;
        if (!p.isExpectedStartArrayToken()) {
            return this.handleNonArray(p, ctxt, result2);
        }
        p.setCurrentValue(result2);
        JsonDeserializer<Object> valueDes = this._valueDeserializer;
        TypeDeserializer typeDeser = this._valueTypeDeserializer;
        CollectionReferringAccumulator collectionReferringAccumulator = referringAccumulator = valueDes.getObjectIdReader() == null ? null : new CollectionReferringAccumulator(this._collectionType.getContentType().getRawClass(), result2);
        while ((t = p.nextToken()) != JsonToken.END_ARRAY) {
            try {
                Object value2 = t == JsonToken.VALUE_NULL ? valueDes.getNullValue(ctxt) : (typeDeser == null ? valueDes.deserialize(p, ctxt) : valueDes.deserializeWithType(p, ctxt, typeDeser));
                if (referringAccumulator != null) {
                    referringAccumulator.add(value2);
                    continue;
                }
                result2.add(value2);
            }
            catch (UnresolvedForwardReference reference) {
                if (referringAccumulator == null) {
                    throw JsonMappingException.from(p, "Unresolved forward reference but no identity info", (Throwable)reference);
                }
                ReadableObjectId.Referring ref2 = referringAccumulator.handleUnresolvedReference(reference);
                reference.getRoid().appendReferring(ref2);
            }
            catch (Exception e) {
                boolean wrap2;
                boolean bl = wrap2 = ctxt == null || ctxt.isEnabled(DeserializationFeature.WRAP_EXCEPTIONS);
                if (!wrap2 && e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw JsonMappingException.wrapWithPath((Throwable)e, result2, result2.size());
            }
        }
        return result2;
    }

    @Override
    public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromArray(jp, ctxt);
    }

    protected final Collection<Object> handleNonArray(JsonParser p, DeserializationContext ctxt, Collection<Object> result2) throws IOException {
        Object value2;
        boolean canWrap;
        boolean bl = canWrap = this._unwrapSingle == Boolean.TRUE || this._unwrapSingle == null && ctxt.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        if (!canWrap) {
            throw ctxt.mappingException(this._collectionType.getRawClass());
        }
        JsonDeserializer<Object> valueDes = this._valueDeserializer;
        TypeDeserializer typeDeser = this._valueTypeDeserializer;
        JsonToken t = p.getCurrentToken();
        try {
            value2 = t == JsonToken.VALUE_NULL ? valueDes.getNullValue(ctxt) : (typeDeser == null ? valueDes.deserialize(p, ctxt) : valueDes.deserializeWithType(p, ctxt, typeDeser));
        }
        catch (Exception e) {
            throw JsonMappingException.wrapWithPath((Throwable)e, Object.class, result2.size());
        }
        result2.add(value2);
        return result2;
    }

    private static final class CollectionReferring
    extends ReadableObjectId.Referring {
        private final CollectionReferringAccumulator _parent;
        public final List<Object> next = new ArrayList<Object>();

        CollectionReferring(CollectionReferringAccumulator parent, UnresolvedForwardReference reference, Class<?> contentType2) {
            super(reference, contentType2);
            this._parent = parent;
        }

        @Override
        public void handleResolvedForwardReference(Object id2, Object value2) throws IOException {
            this._parent.resolveForwardReference(id2, value2);
        }
    }

    public static final class CollectionReferringAccumulator {
        private final Class<?> _elementType;
        private final Collection<Object> _result;
        private List<CollectionReferring> _accumulator = new ArrayList<CollectionReferring>();

        public CollectionReferringAccumulator(Class<?> elementType2, Collection<Object> result2) {
            this._elementType = elementType2;
            this._result = result2;
        }

        public void add(Object value2) {
            if (this._accumulator.isEmpty()) {
                this._result.add(value2);
            } else {
                CollectionReferring ref2 = this._accumulator.get(this._accumulator.size() - 1);
                ref2.next.add(value2);
            }
        }

        public ReadableObjectId.Referring handleUnresolvedReference(UnresolvedForwardReference reference) {
            CollectionReferring id2 = new CollectionReferring(this, reference, this._elementType);
            this._accumulator.add(id2);
            return id2;
        }

        public void resolveForwardReference(Object id2, Object value2) throws IOException {
            Iterator<CollectionReferring> iterator2 = this._accumulator.iterator();
            Collection<Object> previous = this._result;
            while (iterator2.hasNext()) {
                CollectionReferring ref2 = iterator2.next();
                if (ref2.hasId(id2)) {
                    iterator2.remove();
                    previous.add(value2);
                    previous.addAll(ref2.next);
                    return;
                }
                previous = ref2.next;
            }
            throw new IllegalArgumentException("Trying to resolve a forward reference with id [" + id2 + "] that wasn't previously seen as unresolved.");
        }
    }
}

