CREATE FOREIGN PROCEDURE "doubleclicksearch.conversion.get"(IN adGroupId string OPTIONS (ANNOTATION 'Numeric ID of the ad group.', "teiid_rest:PARAMETER_TYPE" 'query'), IN adId string OPTIONS (ANNOTATION 'Numeric ID of the ad.', "teiid_rest:PARAMETER_TYPE" 'query'), IN advertiserId string NOT NULL OPTIONS (ANNOTATION 'Numeric ID of the advertiser.', "teiid_rest:PARAMETER_TYPE" 'path'), IN agencyId string NOT NULL OPTIONS (ANNOTATION 'Numeric ID of the agency.', "teiid_rest:PARAMETER_TYPE" 'path'), IN campaignId string OPTIONS (ANNOTATION 'Numeric ID of the campaign.', "teiid_rest:PARAMETER_TYPE" 'query'), IN criterionId string OPTIONS (ANNOTATION 'Numeric ID of the criterion.', "teiid_rest:PARAMETER_TYPE" 'query'), IN endDate string NOT NULL OPTIONS (ANNOTATION 'Last date (inclusive) on which to retrieve conversions. Format is yyyymmdd.', "teiid_rest:PARAMETER_TYPE" 'query'), IN engineAccountId string NOT NULL OPTIONS (ANNOTATION 'Numeric ID of the engine account.', "teiid_rest:PARAMETER_TYPE" 'path'), IN rowCount string NOT NULL OPTIONS (ANNOTATION 'The number of conversions to return per call.', "teiid_rest:PARAMETER_TYPE" 'query'), IN startDate string NOT NULL OPTIONS (ANNOTATION 'First date (inclusive) on which to retrieve conversions. Format is yyyymmdd.', "teiid_rest:PARAMETER_TYPE" 'query'), IN startRow string NOT NULL OPTIONS (ANNOTATION 'The 0-based starting index for retrieving conversions results.', "teiid_rest:PARAMETER_TYPE" 'query')) RETURNS TABLE (conversion_Conversion_adGroupId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/adGroupId'), conversion_Conversion_adId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/adId'), conversion_Conversion_advertiserId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/advertiserId'), conversion_Conversion_agencyId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/agencyId'), conversion_Conversion_attributionModel string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/attributionModel'), conversion_Conversion_campaignId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/campaignId'), conversion_Conversion_channel string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/channel'), conversion_Conversion_clickId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/clickId'), conversion_Conversion_conversionId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/conversionId'), conversion_Conversion_conversionModifiedTimestamp string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/conversionModifiedTimestamp'), conversion_Conversion_conversionTimestamp string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/conversionTimestamp'), conversion_Conversion_countMillis string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/countMillis'), conversion_Conversion_criterionId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/criterionId'), conversion_Conversion_currencyCode string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/currencyCode'), conversion_Conversion_customDimension_CustomDimension_name string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/customDimension[]/CustomDimension/name'), conversion_Conversion_customDimension_CustomDimension_value string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/customDimension[]/CustomDimension/value'), conversion_Conversion_customMetric_CustomMetric_name string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/customMetric[]/CustomMetric/name'), conversion_Conversion_customMetric_CustomMetric_value double OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/customMetric[]/CustomMetric/value'), conversion_Conversion_deviceType string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/deviceType'), conversion_Conversion_dsConversionId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/dsConversionId'), conversion_Conversion_engineAccountId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/engineAccountId'), conversion_Conversion_floodlightOrderId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/floodlightOrderId'), conversion_Conversion_inventoryAccountId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/inventoryAccountId'), conversion_Conversion_productCountry string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/productCountry'), conversion_Conversion_productGroupId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/productGroupId'), conversion_Conversion_productId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/productId'), conversion_Conversion_productLanguage string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/productLanguage'), conversion_Conversion_quantityMillis string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/quantityMillis'), conversion_Conversion_revenueMicros string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/revenueMicros'), conversion_Conversion_segmentationId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/segmentationId'), conversion_Conversion_segmentationName string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/segmentationName'), conversion_Conversion_segmentationType string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/segmentationType'), conversion_Conversion_state string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/state'), conversion_Conversion_storeId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/storeId'), conversion_Conversion_type string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/type'), kind string)
OPTIONS (ANNOTATION 'Retrieves a list of conversions from a DoubleClick Search engine account.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'https://www.googleapis.com/doubleclicksearch/v2/agency/{agencyId}/advertiser/{advertiserId}/engine/{engineAccountId}/conversion');

CREATE FOREIGN PROCEDURE "doubleclicksearch.savedColumns.list"(IN advertiserId string NOT NULL OPTIONS (ANNOTATION 'DS ID of the advertiser.', "teiid_rest:PARAMETER_TYPE" 'path'), IN agencyId string NOT NULL OPTIONS (ANNOTATION 'DS ID of the agency.', "teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (items_SavedColumn_kind string OPTIONS (NAMEINSOURCE 'items[]/SavedColumn/kind'), items_SavedColumn_savedColumnName string OPTIONS (NAMEINSOURCE 'items[]/SavedColumn/savedColumnName'), items_SavedColumn_type string OPTIONS (NAMEINSOURCE 'items[]/SavedColumn/type'), kind string)
OPTIONS (ANNOTATION 'Retrieve the list of saved columns for a specified advertiser.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'https://www.googleapis.com/doubleclicksearch/v2/agency/{agencyId}/advertiser/{advertiserId}/savedcolumns');

CREATE FOREIGN PROCEDURE "doubleclicksearch.conversion.update"(IN conversion_Conversion_adGroupId string OPTIONS (ANNOTATION 'DS ad group ID.', NAMEINSOURCE 'conversion[]/Conversion/adGroupId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_adId string OPTIONS (ANNOTATION 'DS ad ID.', NAMEINSOURCE 'conversion[]/Conversion/adId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_advertiserId string OPTIONS (ANNOTATION 'DS advertiser ID.', NAMEINSOURCE 'conversion[]/Conversion/advertiserId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_agencyId string OPTIONS (ANNOTATION 'DS agency ID.', NAMEINSOURCE 'conversion[]/Conversion/agencyId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_attributionModel string OPTIONS (ANNOTATION 'Available to advertisers only after contacting DoubleClick Search customer support.', NAMEINSOURCE 'conversion[]/Conversion/attributionModel', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_campaignId string OPTIONS (ANNOTATION 'DS campaign ID.', NAMEINSOURCE 'conversion[]/Conversion/campaignId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_channel string OPTIONS (ANNOTATION 'Sales channel for the product. Acceptable values are:  \u000A- "local": a physical store \u000A- "online": an online store', NAMEINSOURCE 'conversion[]/Conversion/channel', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_clickId string OPTIONS (ANNOTATION 'DS click ID for the conversion.', NAMEINSOURCE 'conversion[]/Conversion/clickId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_conversionId string OPTIONS (ANNOTATION 'For offline conversions, advertisers provide this ID. Advertisers can specify any ID that is meaningful to them. Each conversion in a request must specify a unique ID, and the combination of ID and timestamp must be unique amongst all conversions within the advertiser.\u000AFor online conversions, DS copies the dsConversionId or floodlightOrderId into this property depending on the advertiser''s Floodlight instructions.', NAMEINSOURCE 'conversion[]/Conversion/conversionId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_conversionModifiedTimestamp string OPTIONS (ANNOTATION 'The time at which the conversion was last modified, in epoch millis UTC.', NAMEINSOURCE 'conversion[]/Conversion/conversionModifiedTimestamp', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_conversionTimestamp string OPTIONS (ANNOTATION 'The time at which the conversion took place, in epoch millis UTC.', NAMEINSOURCE 'conversion[]/Conversion/conversionTimestamp', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_countMillis string OPTIONS (ANNOTATION 'Available to advertisers only after contacting DoubleClick Search customer support.', NAMEINSOURCE 'conversion[]/Conversion/countMillis', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_criterionId string OPTIONS (ANNOTATION 'DS criterion (keyword) ID.', NAMEINSOURCE 'conversion[]/Conversion/criterionId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_currencyCode string OPTIONS (ANNOTATION 'The currency code for the conversion''s revenue. Should be in ISO 4217 alphabetic (3-char) format.', NAMEINSOURCE 'conversion[]/Conversion/currencyCode', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_customDimension_CustomDimension_name string OPTIONS (ANNOTATION 'Custom dimension name.', NAMEINSOURCE 'conversion[]/Conversion/customDimension[]/CustomDimension/name', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_customDimension_CustomDimension_value string OPTIONS (ANNOTATION 'Custom dimension value.', NAMEINSOURCE 'conversion[]/Conversion/customDimension[]/CustomDimension/value', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_customMetric_CustomMetric_name string OPTIONS (ANNOTATION 'Custom metric name.', NAMEINSOURCE 'conversion[]/Conversion/customMetric[]/CustomMetric/name', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_customMetric_CustomMetric_value double OPTIONS (ANNOTATION 'Custom metric numeric value.', NAMEINSOURCE 'conversion[]/Conversion/customMetric[]/CustomMetric/value', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_deviceType string OPTIONS (ANNOTATION 'The type of device on which the conversion occurred.', NAMEINSOURCE 'conversion[]/Conversion/deviceType', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_dsConversionId string OPTIONS (ANNOTATION 'ID that DoubleClick Search generates for each conversion.', NAMEINSOURCE 'conversion[]/Conversion/dsConversionId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_engineAccountId string OPTIONS (ANNOTATION 'DS engine account ID.', NAMEINSOURCE 'conversion[]/Conversion/engineAccountId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_floodlightOrderId string OPTIONS (ANNOTATION 'The Floodlight order ID provided by the advertiser for the conversion.', NAMEINSOURCE 'conversion[]/Conversion/floodlightOrderId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_inventoryAccountId string OPTIONS (ANNOTATION 'ID that DS generates and uses to uniquely identify the inventory account that contains the product.', NAMEINSOURCE 'conversion[]/Conversion/inventoryAccountId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_productCountry string OPTIONS (ANNOTATION 'The country registered for the Merchant Center feed that contains the product. Use an ISO 3166 code to specify a country.', NAMEINSOURCE 'conversion[]/Conversion/productCountry', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_productGroupId string OPTIONS (ANNOTATION 'DS product group ID.', NAMEINSOURCE 'conversion[]/Conversion/productGroupId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_productId string OPTIONS (ANNOTATION 'The product ID (SKU).', NAMEINSOURCE 'conversion[]/Conversion/productId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_productLanguage string OPTIONS (ANNOTATION 'The language registered for the Merchant Center feed that contains the product. Use an ISO 639 code to specify a language.', NAMEINSOURCE 'conversion[]/Conversion/productLanguage', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_quantityMillis string OPTIONS (ANNOTATION 'The quantity of this conversion, in millis.', NAMEINSOURCE 'conversion[]/Conversion/quantityMillis', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_revenueMicros string OPTIONS (ANNOTATION 'The revenue amount of this TRANSACTION conversion, in micros (value multiplied by 1000000, no decimal). For example, to specify a revenue value of "10" enter "10000000" (10 million) in your request.', NAMEINSOURCE 'conversion[]/Conversion/revenueMicros', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_segmentationId string OPTIONS (ANNOTATION 'The numeric segmentation identifier (for example, DoubleClick Search Floodlight activity ID).', NAMEINSOURCE 'conversion[]/Conversion/segmentationId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_segmentationName string OPTIONS (ANNOTATION 'The friendly segmentation identifier (for example, DoubleClick Search Floodlight activity name).', NAMEINSOURCE 'conversion[]/Conversion/segmentationName', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_segmentationType string OPTIONS (ANNOTATION 'The segmentation type of this conversion (for example, FLOODLIGHT).', NAMEINSOURCE 'conversion[]/Conversion/segmentationType', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_state string OPTIONS (ANNOTATION 'The state of the conversion, that is, either ACTIVE or REMOVED. Note: state DELETED is deprecated.', NAMEINSOURCE 'conversion[]/Conversion/state', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_storeId string OPTIONS (ANNOTATION 'The ID of the local store for which the product was advertised. Applicable only when the channel is "local".', NAMEINSOURCE 'conversion[]/Conversion/storeId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_type string OPTIONS (ANNOTATION 'The type of the conversion, that is, either ACTION or TRANSACTION. An ACTION conversion is an action by the user that has no monetarily quantifiable value, while a TRANSACTION conversion is an action that does have a monetarily quantifiable value. Examples are email list signups (ACTION) versus ecommerce purchases (TRANSACTION).', NAMEINSOURCE 'conversion[]/Conversion/type', "teiid_rest:PARAMETER_TYPE" 'body'), IN kind string OPTIONS (ANNOTATION 'Identifies this as a ConversionList resource. Value: the fixed string doubleclicksearch#conversionList.', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (conversion_Conversion_adGroupId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/adGroupId'), conversion_Conversion_adId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/adId'), conversion_Conversion_advertiserId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/advertiserId'), conversion_Conversion_agencyId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/agencyId'), conversion_Conversion_attributionModel string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/attributionModel'), conversion_Conversion_campaignId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/campaignId'), conversion_Conversion_channel string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/channel'), conversion_Conversion_clickId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/clickId'), conversion_Conversion_conversionId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/conversionId'), conversion_Conversion_conversionModifiedTimestamp string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/conversionModifiedTimestamp'), conversion_Conversion_conversionTimestamp string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/conversionTimestamp'), conversion_Conversion_countMillis string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/countMillis'), conversion_Conversion_criterionId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/criterionId'), conversion_Conversion_currencyCode string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/currencyCode'), conversion_Conversion_customDimension_CustomDimension_name string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/customDimension[]/CustomDimension/name'), conversion_Conversion_customDimension_CustomDimension_value string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/customDimension[]/CustomDimension/value'), conversion_Conversion_customMetric_CustomMetric_name string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/customMetric[]/CustomMetric/name'), conversion_Conversion_customMetric_CustomMetric_value double OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/customMetric[]/CustomMetric/value'), conversion_Conversion_deviceType string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/deviceType'), conversion_Conversion_dsConversionId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/dsConversionId'), conversion_Conversion_engineAccountId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/engineAccountId'), conversion_Conversion_floodlightOrderId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/floodlightOrderId'), conversion_Conversion_inventoryAccountId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/inventoryAccountId'), conversion_Conversion_productCountry string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/productCountry'), conversion_Conversion_productGroupId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/productGroupId'), conversion_Conversion_productId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/productId'), conversion_Conversion_productLanguage string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/productLanguage'), conversion_Conversion_quantityMillis string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/quantityMillis'), conversion_Conversion_revenueMicros string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/revenueMicros'), conversion_Conversion_segmentationId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/segmentationId'), conversion_Conversion_segmentationName string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/segmentationName'), conversion_Conversion_segmentationType string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/segmentationType'), conversion_Conversion_state string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/state'), conversion_Conversion_storeId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/storeId'), conversion_Conversion_type string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/type'), kind string)
OPTIONS (ANNOTATION 'Updates a batch of conversions in DoubleClick Search.', "teiid_rest:METHOD" 'PUT', "teiid_rest:URI" 'https://www.googleapis.com/doubleclicksearch/v2/conversion');

CREATE FOREIGN PROCEDURE "doubleclicksearch.conversion.insert"(IN conversion_Conversion_adGroupId string OPTIONS (ANNOTATION 'DS ad group ID.', NAMEINSOURCE 'conversion[]/Conversion/adGroupId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_adId string OPTIONS (ANNOTATION 'DS ad ID.', NAMEINSOURCE 'conversion[]/Conversion/adId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_advertiserId string OPTIONS (ANNOTATION 'DS advertiser ID.', NAMEINSOURCE 'conversion[]/Conversion/advertiserId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_agencyId string OPTIONS (ANNOTATION 'DS agency ID.', NAMEINSOURCE 'conversion[]/Conversion/agencyId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_attributionModel string OPTIONS (ANNOTATION 'Available to advertisers only after contacting DoubleClick Search customer support.', NAMEINSOURCE 'conversion[]/Conversion/attributionModel', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_campaignId string OPTIONS (ANNOTATION 'DS campaign ID.', NAMEINSOURCE 'conversion[]/Conversion/campaignId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_channel string OPTIONS (ANNOTATION 'Sales channel for the product. Acceptable values are:  \u000A- "local": a physical store \u000A- "online": an online store', NAMEINSOURCE 'conversion[]/Conversion/channel', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_clickId string OPTIONS (ANNOTATION 'DS click ID for the conversion.', NAMEINSOURCE 'conversion[]/Conversion/clickId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_conversionId string OPTIONS (ANNOTATION 'For offline conversions, advertisers provide this ID. Advertisers can specify any ID that is meaningful to them. Each conversion in a request must specify a unique ID, and the combination of ID and timestamp must be unique amongst all conversions within the advertiser.\u000AFor online conversions, DS copies the dsConversionId or floodlightOrderId into this property depending on the advertiser''s Floodlight instructions.', NAMEINSOURCE 'conversion[]/Conversion/conversionId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_conversionModifiedTimestamp string OPTIONS (ANNOTATION 'The time at which the conversion was last modified, in epoch millis UTC.', NAMEINSOURCE 'conversion[]/Conversion/conversionModifiedTimestamp', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_conversionTimestamp string OPTIONS (ANNOTATION 'The time at which the conversion took place, in epoch millis UTC.', NAMEINSOURCE 'conversion[]/Conversion/conversionTimestamp', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_countMillis string OPTIONS (ANNOTATION 'Available to advertisers only after contacting DoubleClick Search customer support.', NAMEINSOURCE 'conversion[]/Conversion/countMillis', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_criterionId string OPTIONS (ANNOTATION 'DS criterion (keyword) ID.', NAMEINSOURCE 'conversion[]/Conversion/criterionId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_currencyCode string OPTIONS (ANNOTATION 'The currency code for the conversion''s revenue. Should be in ISO 4217 alphabetic (3-char) format.', NAMEINSOURCE 'conversion[]/Conversion/currencyCode', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_customDimension_CustomDimension_name string OPTIONS (ANNOTATION 'Custom dimension name.', NAMEINSOURCE 'conversion[]/Conversion/customDimension[]/CustomDimension/name', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_customDimension_CustomDimension_value string OPTIONS (ANNOTATION 'Custom dimension value.', NAMEINSOURCE 'conversion[]/Conversion/customDimension[]/CustomDimension/value', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_customMetric_CustomMetric_name string OPTIONS (ANNOTATION 'Custom metric name.', NAMEINSOURCE 'conversion[]/Conversion/customMetric[]/CustomMetric/name', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_customMetric_CustomMetric_value double OPTIONS (ANNOTATION 'Custom metric numeric value.', NAMEINSOURCE 'conversion[]/Conversion/customMetric[]/CustomMetric/value', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_deviceType string OPTIONS (ANNOTATION 'The type of device on which the conversion occurred.', NAMEINSOURCE 'conversion[]/Conversion/deviceType', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_dsConversionId string OPTIONS (ANNOTATION 'ID that DoubleClick Search generates for each conversion.', NAMEINSOURCE 'conversion[]/Conversion/dsConversionId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_engineAccountId string OPTIONS (ANNOTATION 'DS engine account ID.', NAMEINSOURCE 'conversion[]/Conversion/engineAccountId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_floodlightOrderId string OPTIONS (ANNOTATION 'The Floodlight order ID provided by the advertiser for the conversion.', NAMEINSOURCE 'conversion[]/Conversion/floodlightOrderId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_inventoryAccountId string OPTIONS (ANNOTATION 'ID that DS generates and uses to uniquely identify the inventory account that contains the product.', NAMEINSOURCE 'conversion[]/Conversion/inventoryAccountId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_productCountry string OPTIONS (ANNOTATION 'The country registered for the Merchant Center feed that contains the product. Use an ISO 3166 code to specify a country.', NAMEINSOURCE 'conversion[]/Conversion/productCountry', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_productGroupId string OPTIONS (ANNOTATION 'DS product group ID.', NAMEINSOURCE 'conversion[]/Conversion/productGroupId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_productId string OPTIONS (ANNOTATION 'The product ID (SKU).', NAMEINSOURCE 'conversion[]/Conversion/productId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_productLanguage string OPTIONS (ANNOTATION 'The language registered for the Merchant Center feed that contains the product. Use an ISO 639 code to specify a language.', NAMEINSOURCE 'conversion[]/Conversion/productLanguage', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_quantityMillis string OPTIONS (ANNOTATION 'The quantity of this conversion, in millis.', NAMEINSOURCE 'conversion[]/Conversion/quantityMillis', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_revenueMicros string OPTIONS (ANNOTATION 'The revenue amount of this TRANSACTION conversion, in micros (value multiplied by 1000000, no decimal). For example, to specify a revenue value of "10" enter "10000000" (10 million) in your request.', NAMEINSOURCE 'conversion[]/Conversion/revenueMicros', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_segmentationId string OPTIONS (ANNOTATION 'The numeric segmentation identifier (for example, DoubleClick Search Floodlight activity ID).', NAMEINSOURCE 'conversion[]/Conversion/segmentationId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_segmentationName string OPTIONS (ANNOTATION 'The friendly segmentation identifier (for example, DoubleClick Search Floodlight activity name).', NAMEINSOURCE 'conversion[]/Conversion/segmentationName', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_segmentationType string OPTIONS (ANNOTATION 'The segmentation type of this conversion (for example, FLOODLIGHT).', NAMEINSOURCE 'conversion[]/Conversion/segmentationType', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_state string OPTIONS (ANNOTATION 'The state of the conversion, that is, either ACTIVE or REMOVED. Note: state DELETED is deprecated.', NAMEINSOURCE 'conversion[]/Conversion/state', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_storeId string OPTIONS (ANNOTATION 'The ID of the local store for which the product was advertised. Applicable only when the channel is "local".', NAMEINSOURCE 'conversion[]/Conversion/storeId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_type string OPTIONS (ANNOTATION 'The type of the conversion, that is, either ACTION or TRANSACTION. An ACTION conversion is an action by the user that has no monetarily quantifiable value, while a TRANSACTION conversion is an action that does have a monetarily quantifiable value. Examples are email list signups (ACTION) versus ecommerce purchases (TRANSACTION).', NAMEINSOURCE 'conversion[]/Conversion/type', "teiid_rest:PARAMETER_TYPE" 'body'), IN kind string OPTIONS (ANNOTATION 'Identifies this as a ConversionList resource. Value: the fixed string doubleclicksearch#conversionList.', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (conversion_Conversion_adGroupId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/adGroupId'), conversion_Conversion_adId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/adId'), conversion_Conversion_advertiserId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/advertiserId'), conversion_Conversion_agencyId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/agencyId'), conversion_Conversion_attributionModel string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/attributionModel'), conversion_Conversion_campaignId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/campaignId'), conversion_Conversion_channel string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/channel'), conversion_Conversion_clickId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/clickId'), conversion_Conversion_conversionId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/conversionId'), conversion_Conversion_conversionModifiedTimestamp string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/conversionModifiedTimestamp'), conversion_Conversion_conversionTimestamp string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/conversionTimestamp'), conversion_Conversion_countMillis string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/countMillis'), conversion_Conversion_criterionId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/criterionId'), conversion_Conversion_currencyCode string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/currencyCode'), conversion_Conversion_customDimension_CustomDimension_name string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/customDimension[]/CustomDimension/name'), conversion_Conversion_customDimension_CustomDimension_value string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/customDimension[]/CustomDimension/value'), conversion_Conversion_customMetric_CustomMetric_name string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/customMetric[]/CustomMetric/name'), conversion_Conversion_customMetric_CustomMetric_value double OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/customMetric[]/CustomMetric/value'), conversion_Conversion_deviceType string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/deviceType'), conversion_Conversion_dsConversionId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/dsConversionId'), conversion_Conversion_engineAccountId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/engineAccountId'), conversion_Conversion_floodlightOrderId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/floodlightOrderId'), conversion_Conversion_inventoryAccountId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/inventoryAccountId'), conversion_Conversion_productCountry string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/productCountry'), conversion_Conversion_productGroupId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/productGroupId'), conversion_Conversion_productId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/productId'), conversion_Conversion_productLanguage string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/productLanguage'), conversion_Conversion_quantityMillis string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/quantityMillis'), conversion_Conversion_revenueMicros string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/revenueMicros'), conversion_Conversion_segmentationId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/segmentationId'), conversion_Conversion_segmentationName string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/segmentationName'), conversion_Conversion_segmentationType string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/segmentationType'), conversion_Conversion_state string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/state'), conversion_Conversion_storeId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/storeId'), conversion_Conversion_type string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/type'), kind string)
OPTIONS (ANNOTATION 'Inserts a batch of new conversions into DoubleClick Search.', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'https://www.googleapis.com/doubleclicksearch/v2/conversion');

CREATE FOREIGN PROCEDURE "doubleclicksearch.conversion.patch"(IN advertiserId string NOT NULL OPTIONS (ANNOTATION 'Numeric ID of the advertiser.', "teiid_rest:PARAMETER_TYPE" 'query'), IN agencyId string NOT NULL OPTIONS (ANNOTATION 'Numeric ID of the agency.', "teiid_rest:PARAMETER_TYPE" 'query'), IN conversion_Conversion_adGroupId string OPTIONS (ANNOTATION 'DS ad group ID.', NAMEINSOURCE 'conversion[]/Conversion/adGroupId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_adId string OPTIONS (ANNOTATION 'DS ad ID.', NAMEINSOURCE 'conversion[]/Conversion/adId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_advertiserId string OPTIONS (ANNOTATION 'DS advertiser ID.', NAMEINSOURCE 'conversion[]/Conversion/advertiserId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_agencyId string OPTIONS (ANNOTATION 'DS agency ID.', NAMEINSOURCE 'conversion[]/Conversion/agencyId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_attributionModel string OPTIONS (ANNOTATION 'Available to advertisers only after contacting DoubleClick Search customer support.', NAMEINSOURCE 'conversion[]/Conversion/attributionModel', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_campaignId string OPTIONS (ANNOTATION 'DS campaign ID.', NAMEINSOURCE 'conversion[]/Conversion/campaignId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_channel string OPTIONS (ANNOTATION 'Sales channel for the product. Acceptable values are:  \u000A- "local": a physical store \u000A- "online": an online store', NAMEINSOURCE 'conversion[]/Conversion/channel', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_clickId string OPTIONS (ANNOTATION 'DS click ID for the conversion.', NAMEINSOURCE 'conversion[]/Conversion/clickId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_conversionId string OPTIONS (ANNOTATION 'For offline conversions, advertisers provide this ID. Advertisers can specify any ID that is meaningful to them. Each conversion in a request must specify a unique ID, and the combination of ID and timestamp must be unique amongst all conversions within the advertiser.\u000AFor online conversions, DS copies the dsConversionId or floodlightOrderId into this property depending on the advertiser''s Floodlight instructions.', NAMEINSOURCE 'conversion[]/Conversion/conversionId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_conversionModifiedTimestamp string OPTIONS (ANNOTATION 'The time at which the conversion was last modified, in epoch millis UTC.', NAMEINSOURCE 'conversion[]/Conversion/conversionModifiedTimestamp', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_conversionTimestamp string OPTIONS (ANNOTATION 'The time at which the conversion took place, in epoch millis UTC.', NAMEINSOURCE 'conversion[]/Conversion/conversionTimestamp', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_countMillis string OPTIONS (ANNOTATION 'Available to advertisers only after contacting DoubleClick Search customer support.', NAMEINSOURCE 'conversion[]/Conversion/countMillis', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_criterionId string OPTIONS (ANNOTATION 'DS criterion (keyword) ID.', NAMEINSOURCE 'conversion[]/Conversion/criterionId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_currencyCode string OPTIONS (ANNOTATION 'The currency code for the conversion''s revenue. Should be in ISO 4217 alphabetic (3-char) format.', NAMEINSOURCE 'conversion[]/Conversion/currencyCode', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_customDimension_CustomDimension_name string OPTIONS (ANNOTATION 'Custom dimension name.', NAMEINSOURCE 'conversion[]/Conversion/customDimension[]/CustomDimension/name', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_customDimension_CustomDimension_value string OPTIONS (ANNOTATION 'Custom dimension value.', NAMEINSOURCE 'conversion[]/Conversion/customDimension[]/CustomDimension/value', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_customMetric_CustomMetric_name string OPTIONS (ANNOTATION 'Custom metric name.', NAMEINSOURCE 'conversion[]/Conversion/customMetric[]/CustomMetric/name', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_customMetric_CustomMetric_value double OPTIONS (ANNOTATION 'Custom metric numeric value.', NAMEINSOURCE 'conversion[]/Conversion/customMetric[]/CustomMetric/value', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_deviceType string OPTIONS (ANNOTATION 'The type of device on which the conversion occurred.', NAMEINSOURCE 'conversion[]/Conversion/deviceType', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_dsConversionId string OPTIONS (ANNOTATION 'ID that DoubleClick Search generates for each conversion.', NAMEINSOURCE 'conversion[]/Conversion/dsConversionId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_engineAccountId string OPTIONS (ANNOTATION 'DS engine account ID.', NAMEINSOURCE 'conversion[]/Conversion/engineAccountId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_floodlightOrderId string OPTIONS (ANNOTATION 'The Floodlight order ID provided by the advertiser for the conversion.', NAMEINSOURCE 'conversion[]/Conversion/floodlightOrderId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_inventoryAccountId string OPTIONS (ANNOTATION 'ID that DS generates and uses to uniquely identify the inventory account that contains the product.', NAMEINSOURCE 'conversion[]/Conversion/inventoryAccountId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_productCountry string OPTIONS (ANNOTATION 'The country registered for the Merchant Center feed that contains the product. Use an ISO 3166 code to specify a country.', NAMEINSOURCE 'conversion[]/Conversion/productCountry', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_productGroupId string OPTIONS (ANNOTATION 'DS product group ID.', NAMEINSOURCE 'conversion[]/Conversion/productGroupId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_productId string OPTIONS (ANNOTATION 'The product ID (SKU).', NAMEINSOURCE 'conversion[]/Conversion/productId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_productLanguage string OPTIONS (ANNOTATION 'The language registered for the Merchant Center feed that contains the product. Use an ISO 639 code to specify a language.', NAMEINSOURCE 'conversion[]/Conversion/productLanguage', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_quantityMillis string OPTIONS (ANNOTATION 'The quantity of this conversion, in millis.', NAMEINSOURCE 'conversion[]/Conversion/quantityMillis', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_revenueMicros string OPTIONS (ANNOTATION 'The revenue amount of this TRANSACTION conversion, in micros (value multiplied by 1000000, no decimal). For example, to specify a revenue value of "10" enter "10000000" (10 million) in your request.', NAMEINSOURCE 'conversion[]/Conversion/revenueMicros', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_segmentationId string OPTIONS (ANNOTATION 'The numeric segmentation identifier (for example, DoubleClick Search Floodlight activity ID).', NAMEINSOURCE 'conversion[]/Conversion/segmentationId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_segmentationName string OPTIONS (ANNOTATION 'The friendly segmentation identifier (for example, DoubleClick Search Floodlight activity name).', NAMEINSOURCE 'conversion[]/Conversion/segmentationName', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_segmentationType string OPTIONS (ANNOTATION 'The segmentation type of this conversion (for example, FLOODLIGHT).', NAMEINSOURCE 'conversion[]/Conversion/segmentationType', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_state string OPTIONS (ANNOTATION 'The state of the conversion, that is, either ACTIVE or REMOVED. Note: state DELETED is deprecated.', NAMEINSOURCE 'conversion[]/Conversion/state', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_storeId string OPTIONS (ANNOTATION 'The ID of the local store for which the product was advertised. Applicable only when the channel is "local".', NAMEINSOURCE 'conversion[]/Conversion/storeId', "teiid_rest:PARAMETER_TYPE" 'body'), IN conversion_Conversion_type string OPTIONS (ANNOTATION 'The type of the conversion, that is, either ACTION or TRANSACTION. An ACTION conversion is an action by the user that has no monetarily quantifiable value, while a TRANSACTION conversion is an action that does have a monetarily quantifiable value. Examples are email list signups (ACTION) versus ecommerce purchases (TRANSACTION).', NAMEINSOURCE 'conversion[]/Conversion/type', "teiid_rest:PARAMETER_TYPE" 'body'), IN kind string OPTIONS (ANNOTATION 'Identifies this as a ConversionList resource. Value: the fixed string doubleclicksearch#conversionList.', "teiid_rest:PARAMETER_TYPE" 'body'), IN endDate string NOT NULL OPTIONS (ANNOTATION 'Last date (inclusive) on which to retrieve conversions. Format is yyyymmdd.', "teiid_rest:PARAMETER_TYPE" 'query'), IN engineAccountId string NOT NULL OPTIONS (ANNOTATION 'Numeric ID of the engine account.', "teiid_rest:PARAMETER_TYPE" 'query'), IN rowCount string NOT NULL OPTIONS (ANNOTATION 'The number of conversions to return per call.', "teiid_rest:PARAMETER_TYPE" 'query'), IN startDate string NOT NULL OPTIONS (ANNOTATION 'First date (inclusive) on which to retrieve conversions. Format is yyyymmdd.', "teiid_rest:PARAMETER_TYPE" 'query'), IN startRow string NOT NULL OPTIONS (ANNOTATION 'The 0-based starting index for retrieving conversions results.', "teiid_rest:PARAMETER_TYPE" 'query')) RETURNS TABLE (conversion_Conversion_adGroupId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/adGroupId'), conversion_Conversion_adId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/adId'), conversion_Conversion_advertiserId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/advertiserId'), conversion_Conversion_agencyId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/agencyId'), conversion_Conversion_attributionModel string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/attributionModel'), conversion_Conversion_campaignId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/campaignId'), conversion_Conversion_channel string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/channel'), conversion_Conversion_clickId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/clickId'), conversion_Conversion_conversionId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/conversionId'), conversion_Conversion_conversionModifiedTimestamp string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/conversionModifiedTimestamp'), conversion_Conversion_conversionTimestamp string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/conversionTimestamp'), conversion_Conversion_countMillis string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/countMillis'), conversion_Conversion_criterionId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/criterionId'), conversion_Conversion_currencyCode string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/currencyCode'), conversion_Conversion_customDimension_CustomDimension_name string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/customDimension[]/CustomDimension/name'), conversion_Conversion_customDimension_CustomDimension_value string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/customDimension[]/CustomDimension/value'), conversion_Conversion_customMetric_CustomMetric_name string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/customMetric[]/CustomMetric/name'), conversion_Conversion_customMetric_CustomMetric_value double OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/customMetric[]/CustomMetric/value'), conversion_Conversion_deviceType string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/deviceType'), conversion_Conversion_dsConversionId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/dsConversionId'), conversion_Conversion_engineAccountId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/engineAccountId'), conversion_Conversion_floodlightOrderId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/floodlightOrderId'), conversion_Conversion_inventoryAccountId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/inventoryAccountId'), conversion_Conversion_productCountry string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/productCountry'), conversion_Conversion_productGroupId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/productGroupId'), conversion_Conversion_productId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/productId'), conversion_Conversion_productLanguage string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/productLanguage'), conversion_Conversion_quantityMillis string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/quantityMillis'), conversion_Conversion_revenueMicros string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/revenueMicros'), conversion_Conversion_segmentationId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/segmentationId'), conversion_Conversion_segmentationName string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/segmentationName'), conversion_Conversion_segmentationType string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/segmentationType'), conversion_Conversion_state string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/state'), conversion_Conversion_storeId string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/storeId'), conversion_Conversion_type string OPTIONS (NAMEINSOURCE 'conversion[]/Conversion/type'), kind string)
OPTIONS (ANNOTATION 'Updates a batch of conversions in DoubleClick Search. This method supports patch semantics.', "teiid_rest:METHOD" 'PATCH', "teiid_rest:URI" 'https://www.googleapis.com/doubleclicksearch/v2/conversion');

CREATE FOREIGN PROCEDURE "doubleclicksearch.conversion.updateAvailability"(IN availabilities_Availability_advertiserId string OPTIONS (ANNOTATION 'DS advertiser ID.', NAMEINSOURCE 'availabilities[]/Availability/advertiserId', "teiid_rest:PARAMETER_TYPE" 'body'), IN availabilities_Availability_agencyId string OPTIONS (ANNOTATION 'DS agency ID.', NAMEINSOURCE 'availabilities[]/Availability/agencyId', "teiid_rest:PARAMETER_TYPE" 'body'), IN availabilities_Availability_availabilityTimestamp string OPTIONS (ANNOTATION 'The time by which all conversions have been uploaded, in epoch millis UTC.', NAMEINSOURCE 'availabilities[]/Availability/availabilityTimestamp', "teiid_rest:PARAMETER_TYPE" 'body'), IN availabilities_Availability_segmentationId string OPTIONS (ANNOTATION 'The numeric segmentation identifier (for example, DoubleClick Search Floodlight activity ID).', NAMEINSOURCE 'availabilities[]/Availability/segmentationId', "teiid_rest:PARAMETER_TYPE" 'body'), IN availabilities_Availability_segmentationName string OPTIONS (ANNOTATION 'The friendly segmentation identifier (for example, DoubleClick Search Floodlight activity name).', NAMEINSOURCE 'availabilities[]/Availability/segmentationName', "teiid_rest:PARAMETER_TYPE" 'body'), IN availabilities_Availability_segmentationType string OPTIONS (ANNOTATION 'The segmentation type that this availability is for (its default value is FLOODLIGHT).', NAMEINSOURCE 'availabilities[]/Availability/segmentationType', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (availabilities_Availability_advertiserId string OPTIONS (NAMEINSOURCE 'availabilities[]/Availability/advertiserId'), availabilities_Availability_agencyId string OPTIONS (NAMEINSOURCE 'availabilities[]/Availability/agencyId'), availabilities_Availability_availabilityTimestamp string OPTIONS (NAMEINSOURCE 'availabilities[]/Availability/availabilityTimestamp'), availabilities_Availability_segmentationId string OPTIONS (NAMEINSOURCE 'availabilities[]/Availability/segmentationId'), availabilities_Availability_segmentationName string OPTIONS (NAMEINSOURCE 'availabilities[]/Availability/segmentationName'), availabilities_Availability_segmentationType string OPTIONS (NAMEINSOURCE 'availabilities[]/Availability/segmentationType'))
OPTIONS (ANNOTATION 'Updates the availabilities of a batch of floodlight activities in DoubleClick Search.', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'https://www.googleapis.com/doubleclicksearch/v2/conversion/updateAvailability');

CREATE FOREIGN PROCEDURE "doubleclicksearch.reports.request"(IN columns_ReportApiColumnSpec_columnName string OPTIONS (ANNOTATION 'Name of a DoubleClick Search column to include in the report.', NAMEINSOURCE 'columns[]/ReportApiColumnSpec/columnName', "teiid_rest:PARAMETER_TYPE" 'body'), IN columns_ReportApiColumnSpec_customDimensionName string OPTIONS (ANNOTATION 'Segments a report by a custom dimension. The report must be scoped to an advertiser or lower, and the custom dimension must already be set up in DoubleClick Search. The custom dimension name, which appears in DoubleClick Search, is case sensitive.\u000AIf used in a conversion report, returns the value of the specified custom dimension for the given conversion, if set. This column does not segment the conversion report.', NAMEINSOURCE 'columns[]/ReportApiColumnSpec/customDimensionName', "teiid_rest:PARAMETER_TYPE" 'body'), IN columns_ReportApiColumnSpec_customMetricName string OPTIONS (ANNOTATION 'Name of a custom metric to include in the report. The report must be scoped to an advertiser or lower, and the custom metric must already be set up in DoubleClick Search. The custom metric name, which appears in DoubleClick Search, is case sensitive.', NAMEINSOURCE 'columns[]/ReportApiColumnSpec/customMetricName', "teiid_rest:PARAMETER_TYPE" 'body'), IN columns_ReportApiColumnSpec_endDate string OPTIONS (ANNOTATION 'Inclusive day in YYYY-MM-DD format. When provided, this overrides the overall time range of the report for this column only. Must be provided together with startDate.', NAMEINSOURCE 'columns[]/ReportApiColumnSpec/endDate', "teiid_rest:PARAMETER_TYPE" 'body'), IN columns_ReportApiColumnSpec_groupByColumn boolean OPTIONS (ANNOTATION 'Synchronous report only. Set to true to group by this column. Defaults to false.', NAMEINSOURCE 'columns[]/ReportApiColumnSpec/groupByColumn', "teiid_rest:PARAMETER_TYPE" 'body'), IN columns_ReportApiColumnSpec_headerText string OPTIONS (ANNOTATION 'Text used to identify this column in the report output; defaults to columnName or savedColumnName when not specified. This can be used to prevent collisions between DoubleClick Search columns and saved columns with the same name.', NAMEINSOURCE 'columns[]/ReportApiColumnSpec/headerText', "teiid_rest:PARAMETER_TYPE" 'body'), IN columns_ReportApiColumnSpec_platformSource string OPTIONS (ANNOTATION 'The platform that is used to provide data for the custom dimension. Acceptable values are "floodlight".', NAMEINSOURCE 'columns[]/ReportApiColumnSpec/platformSource', "teiid_rest:PARAMETER_TYPE" 'body'), IN columns_ReportApiColumnSpec_productReportPerspective string OPTIONS (ANNOTATION 'Returns metrics only for a specific type of product activity. Accepted values are:  \u000A- "sold": returns metrics only for products that were sold \u000A- "advertised": returns metrics only for products that were advertised in a Shopping campaign, and that might or might not have been sold', NAMEINSOURCE 'columns[]/ReportApiColumnSpec/productReportPerspective', "teiid_rest:PARAMETER_TYPE" 'body'), IN columns_ReportApiColumnSpec_savedColumnName string OPTIONS (ANNOTATION 'Name of a saved column to include in the report. The report must be scoped at advertiser or lower, and this saved column must already be created in the DoubleClick Search UI.', NAMEINSOURCE 'columns[]/ReportApiColumnSpec/savedColumnName', "teiid_rest:PARAMETER_TYPE" 'body'), IN columns_ReportApiColumnSpec_startDate string OPTIONS (ANNOTATION 'Inclusive date in YYYY-MM-DD format. When provided, this overrides the overall time range of the report for this column only. Must be provided together with endDate.', NAMEINSOURCE 'columns[]/ReportApiColumnSpec/startDate', "teiid_rest:PARAMETER_TYPE" 'body'), IN downloadFormat string OPTIONS (ANNOTATION 'Format that the report should be returned in. Currently csv or tsv is supported.', "teiid_rest:PARAMETER_TYPE" 'body'), IN filters_values string[] OPTIONS (NAMEINSOURCE 'filters[]/values', "teiid_rest:PARAMETER_TYPE" 'body'), IN filters_column_columnName string OPTIONS (ANNOTATION 'Name of a DoubleClick Search column to include in the report.', NAMEINSOURCE 'filters[]/column/columnName', "teiid_rest:PARAMETER_TYPE" 'body'), IN filters_column_customDimensionName string OPTIONS (ANNOTATION 'Segments a report by a custom dimension. The report must be scoped to an advertiser or lower, and the custom dimension must already be set up in DoubleClick Search. The custom dimension name, which appears in DoubleClick Search, is case sensitive.\u000AIf used in a conversion report, returns the value of the specified custom dimension for the given conversion, if set. This column does not segment the conversion report.', NAMEINSOURCE 'filters[]/column/customDimensionName', "teiid_rest:PARAMETER_TYPE" 'body'), IN filters_column_customMetricName string OPTIONS (ANNOTATION 'Name of a custom metric to include in the report. The report must be scoped to an advertiser or lower, and the custom metric must already be set up in DoubleClick Search. The custom metric name, which appears in DoubleClick Search, is case sensitive.', NAMEINSOURCE 'filters[]/column/customMetricName', "teiid_rest:PARAMETER_TYPE" 'body'), IN filters_column_endDate string OPTIONS (ANNOTATION 'Inclusive day in YYYY-MM-DD format. When provided, this overrides the overall time range of the report for this column only. Must be provided together with startDate.', NAMEINSOURCE 'filters[]/column/endDate', "teiid_rest:PARAMETER_TYPE" 'body'), IN filters_column_groupByColumn boolean OPTIONS (ANNOTATION 'Synchronous report only. Set to true to group by this column. Defaults to false.', NAMEINSOURCE 'filters[]/column/groupByColumn', "teiid_rest:PARAMETER_TYPE" 'body'), IN filters_column_headerText string OPTIONS (ANNOTATION 'Text used to identify this column in the report output; defaults to columnName or savedColumnName when not specified. This can be used to prevent collisions between DoubleClick Search columns and saved columns with the same name.', NAMEINSOURCE 'filters[]/column/headerText', "teiid_rest:PARAMETER_TYPE" 'body'), IN filters_column_platformSource string OPTIONS (ANNOTATION 'The platform that is used to provide data for the custom dimension. Acceptable values are "floodlight".', NAMEINSOURCE 'filters[]/column/platformSource', "teiid_rest:PARAMETER_TYPE" 'body'), IN filters_column_productReportPerspective string OPTIONS (ANNOTATION 'Returns metrics only for a specific type of product activity. Accepted values are:  \u000A- "sold": returns metrics only for products that were sold \u000A- "advertised": returns metrics only for products that were advertised in a Shopping campaign, and that might or might not have been sold', NAMEINSOURCE 'filters[]/column/productReportPerspective', "teiid_rest:PARAMETER_TYPE" 'body'), IN filters_column_savedColumnName string OPTIONS (ANNOTATION 'Name of a saved column to include in the report. The report must be scoped at advertiser or lower, and this saved column must already be created in the DoubleClick Search UI.', NAMEINSOURCE 'filters[]/column/savedColumnName', "teiid_rest:PARAMETER_TYPE" 'body'), IN filters_column_startDate string OPTIONS (ANNOTATION 'Inclusive date in YYYY-MM-DD format. When provided, this overrides the overall time range of the report for this column only. Must be provided together with endDate.', NAMEINSOURCE 'filters[]/column/startDate', "teiid_rest:PARAMETER_TYPE" 'body'), IN filters_operator string OPTIONS (ANNOTATION 'Operator to use in the filter. See the filter reference for a list of available operators.', NAMEINSOURCE 'filters[]/operator', "teiid_rest:PARAMETER_TYPE" 'body'), IN includeDeletedEntities boolean OPTIONS (ANNOTATION 'Determines if removed entities should be included in the report. Defaults to false. Deprecated, please use includeRemovedEntities instead.', "teiid_rest:PARAMETER_TYPE" 'body'), IN includeRemovedEntities boolean OPTIONS (ANNOTATION 'Determines if removed entities should be included in the report. Defaults to false.', "teiid_rest:PARAMETER_TYPE" 'body'), IN maxRowsPerFile integer OPTIONS (ANNOTATION 'Asynchronous report only. The maximum number of rows per report file. A large report is split into many files based on this field. Acceptable values are 1000000 to 100000000, inclusive.', "teiid_rest:PARAMETER_TYPE" 'body'), IN orderBy_sortOrder string OPTIONS (ANNOTATION 'The sort direction, which is either ascending or descending.', NAMEINSOURCE 'orderBy[]/sortOrder', "teiid_rest:PARAMETER_TYPE" 'body'), IN orderBy_column_columnName string OPTIONS (ANNOTATION 'Name of a DoubleClick Search column to include in the report.', NAMEINSOURCE 'orderBy[]/column/columnName', "teiid_rest:PARAMETER_TYPE" 'body'), IN orderBy_column_customDimensionName string OPTIONS (ANNOTATION 'Segments a report by a custom dimension. The report must be scoped to an advertiser or lower, and the custom dimension must already be set up in DoubleClick Search. The custom dimension name, which appears in DoubleClick Search, is case sensitive.\u000AIf used in a conversion report, returns the value of the specified custom dimension for the given conversion, if set. This column does not segment the conversion report.', NAMEINSOURCE 'orderBy[]/column/customDimensionName', "teiid_rest:PARAMETER_TYPE" 'body'), IN orderBy_column_customMetricName string OPTIONS (ANNOTATION 'Name of a custom metric to include in the report. The report must be scoped to an advertiser or lower, and the custom metric must already be set up in DoubleClick Search. The custom metric name, which appears in DoubleClick Search, is case sensitive.', NAMEINSOURCE 'orderBy[]/column/customMetricName', "teiid_rest:PARAMETER_TYPE" 'body'), IN orderBy_column_endDate string OPTIONS (ANNOTATION 'Inclusive day in YYYY-MM-DD format. When provided, this overrides the overall time range of the report for this column only. Must be provided together with startDate.', NAMEINSOURCE 'orderBy[]/column/endDate', "teiid_rest:PARAMETER_TYPE" 'body'), IN orderBy_column_groupByColumn boolean OPTIONS (ANNOTATION 'Synchronous report only. Set to true to group by this column. Defaults to false.', NAMEINSOURCE 'orderBy[]/column/groupByColumn', "teiid_rest:PARAMETER_TYPE" 'body'), IN orderBy_column_headerText string OPTIONS (ANNOTATION 'Text used to identify this column in the report output; defaults to columnName or savedColumnName when not specified. This can be used to prevent collisions between DoubleClick Search columns and saved columns with the same name.', NAMEINSOURCE 'orderBy[]/column/headerText', "teiid_rest:PARAMETER_TYPE" 'body'), IN orderBy_column_platformSource string OPTIONS (ANNOTATION 'The platform that is used to provide data for the custom dimension. Acceptable values are "floodlight".', NAMEINSOURCE 'orderBy[]/column/platformSource', "teiid_rest:PARAMETER_TYPE" 'body'), IN orderBy_column_productReportPerspective string OPTIONS (ANNOTATION 'Returns metrics only for a specific type of product activity. Accepted values are:  \u000A- "sold": returns metrics only for products that were sold \u000A- "advertised": returns metrics only for products that were advertised in a Shopping campaign, and that might or might not have been sold', NAMEINSOURCE 'orderBy[]/column/productReportPerspective', "teiid_rest:PARAMETER_TYPE" 'body'), IN orderBy_column_savedColumnName string OPTIONS (ANNOTATION 'Name of a saved column to include in the report. The report must be scoped at advertiser or lower, and this saved column must already be created in the DoubleClick Search UI.', NAMEINSOURCE 'orderBy[]/column/savedColumnName', "teiid_rest:PARAMETER_TYPE" 'body'), IN orderBy_column_startDate string OPTIONS (ANNOTATION 'Inclusive date in YYYY-MM-DD format. When provided, this overrides the overall time range of the report for this column only. Must be provided together with endDate.', NAMEINSOURCE 'orderBy[]/column/startDate', "teiid_rest:PARAMETER_TYPE" 'body'), IN reportScope_keywordId string OPTIONS (ANNOTATION 'DS keyword ID.', NAMEINSOURCE 'reportScope/keywordId', "teiid_rest:PARAMETER_TYPE" 'body'), IN reportScope_adId string OPTIONS (ANNOTATION 'DS ad ID.', NAMEINSOURCE 'reportScope/adId', "teiid_rest:PARAMETER_TYPE" 'body'), IN reportScope_campaignId string OPTIONS (ANNOTATION 'DS campaign ID.', NAMEINSOURCE 'reportScope/campaignId', "teiid_rest:PARAMETER_TYPE" 'body'), IN reportScope_agencyId string OPTIONS (ANNOTATION 'DS agency ID.', NAMEINSOURCE 'reportScope/agencyId', "teiid_rest:PARAMETER_TYPE" 'body'), IN reportScope_engineAccountId string OPTIONS (ANNOTATION 'DS engine account ID.', NAMEINSOURCE 'reportScope/engineAccountId', "teiid_rest:PARAMETER_TYPE" 'body'), IN reportScope_adGroupId string OPTIONS (ANNOTATION 'DS ad group ID.', NAMEINSOURCE 'reportScope/adGroupId', "teiid_rest:PARAMETER_TYPE" 'body'), IN reportScope_advertiserId string OPTIONS (ANNOTATION 'DS advertiser ID.', NAMEINSOURCE 'reportScope/advertiserId', "teiid_rest:PARAMETER_TYPE" 'body'), IN reportType string OPTIONS (ANNOTATION 'Determines the type of rows that are returned in the report. For example, if you specify reportType: keyword, each row in the report will contain data about a keyword. See the Types of Reports reference for the columns that are available for each type.', "teiid_rest:PARAMETER_TYPE" 'body'), IN rowCount integer OPTIONS (ANNOTATION 'Synchronous report only. The maxinum number of rows to return; additional rows are dropped. Acceptable values are 0 to 10000, inclusive. Defaults to 10000.', "teiid_rest:PARAMETER_TYPE" 'body'), IN startRow integer OPTIONS (ANNOTATION 'Synchronous report only. Zero-based index of the first row to return. Acceptable values are 0 to 50000, inclusive. Defaults to 0.', "teiid_rest:PARAMETER_TYPE" 'body'), IN statisticsCurrency string OPTIONS (ANNOTATION 'Specifies the currency in which monetary will be returned. Possible values are: usd, agency (valid if the report is scoped to agency or lower), advertiser (valid if the report is scoped to * advertiser or lower), or account (valid if the report is scoped to engine account or lower).', "teiid_rest:PARAMETER_TYPE" 'body'), IN timeRange_changedMetricsSinceTimestamp timestamp OPTIONS (ANNOTATION 'Inclusive UTC timestamp in RFC format, e.g., 2013-07-16T10:16:23.555Z. See additional references on how changed metrics reports work.', NAMEINSOURCE 'timeRange/changedMetricsSinceTimestamp', "teiid_rest:PARAMETER_TYPE" 'body'), IN timeRange_endDate string OPTIONS (ANNOTATION 'Inclusive date in YYYY-MM-DD format.', NAMEINSOURCE 'timeRange/endDate', "teiid_rest:PARAMETER_TYPE" 'body'), IN timeRange_changedAttributesSinceTimestamp timestamp OPTIONS (ANNOTATION 'Inclusive UTC timestamp in RFC format, e.g., 2013-07-16T10:16:23.555Z. See additional references on how changed attribute reports work.', NAMEINSOURCE 'timeRange/changedAttributesSinceTimestamp', "teiid_rest:PARAMETER_TYPE" 'body'), IN timeRange_startDate string OPTIONS (ANNOTATION 'Inclusive date in YYYY-MM-DD format.', NAMEINSOURCE 'timeRange/startDate', "teiid_rest:PARAMETER_TYPE" 'body'), IN verifySingleTimeZone boolean OPTIONS (ANNOTATION 'If true, the report would only be created if all the requested stat data are sourced from a single timezone. Defaults to false.', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (files_byteCount string OPTIONS (NAMEINSOURCE 'files[]/byteCount'), files_url string OPTIONS (NAMEINSOURCE 'files[]/url'), id string, isReportReady boolean, kind string, request_columns_ReportApiColumnSpec_columnName string OPTIONS (NAMEINSOURCE 'request/columns[]/ReportApiColumnSpec/columnName'), request_columns_ReportApiColumnSpec_customDimensionName string OPTIONS (NAMEINSOURCE 'request/columns[]/ReportApiColumnSpec/customDimensionName'), request_columns_ReportApiColumnSpec_customMetricName string OPTIONS (NAMEINSOURCE 'request/columns[]/ReportApiColumnSpec/customMetricName'), request_columns_ReportApiColumnSpec_endDate string OPTIONS (NAMEINSOURCE 'request/columns[]/ReportApiColumnSpec/endDate'), request_columns_ReportApiColumnSpec_groupByColumn boolean OPTIONS (NAMEINSOURCE 'request/columns[]/ReportApiColumnSpec/groupByColumn'), request_columns_ReportApiColumnSpec_headerText string OPTIONS (NAMEINSOURCE 'request/columns[]/ReportApiColumnSpec/headerText'), request_columns_ReportApiColumnSpec_platformSource string OPTIONS (NAMEINSOURCE 'request/columns[]/ReportApiColumnSpec/platformSource'), request_columns_ReportApiColumnSpec_productReportPerspective string OPTIONS (NAMEINSOURCE 'request/columns[]/ReportApiColumnSpec/productReportPerspective'), request_columns_ReportApiColumnSpec_savedColumnName string OPTIONS (NAMEINSOURCE 'request/columns[]/ReportApiColumnSpec/savedColumnName'), request_columns_ReportApiColumnSpec_startDate string OPTIONS (NAMEINSOURCE 'request/columns[]/ReportApiColumnSpec/startDate'), request_downloadFormat string OPTIONS (NAMEINSOURCE 'request/downloadFormat'), request_filters_values string[] OPTIONS (NAMEINSOURCE 'request/filters[]/values'), request_filters_column_columnName string OPTIONS (NAMEINSOURCE 'request/filters[]/column/columnName'), request_filters_column_customDimensionName string OPTIONS (NAMEINSOURCE 'request/filters[]/column/customDimensionName'), request_filters_column_customMetricName string OPTIONS (NAMEINSOURCE 'request/filters[]/column/customMetricName'), request_filters_column_endDate string OPTIONS (NAMEINSOURCE 'request/filters[]/column/endDate'), request_filters_column_groupByColumn boolean OPTIONS (NAMEINSOURCE 'request/filters[]/column/groupByColumn'), request_filters_column_headerText string OPTIONS (NAMEINSOURCE 'request/filters[]/column/headerText'), request_filters_column_platformSource string OPTIONS (NAMEINSOURCE 'request/filters[]/column/platformSource'), request_filters_column_productReportPerspective string OPTIONS (NAMEINSOURCE 'request/filters[]/column/productReportPerspective'), request_filters_column_savedColumnName string OPTIONS (NAMEINSOURCE 'request/filters[]/column/savedColumnName'), request_filters_column_startDate string OPTIONS (NAMEINSOURCE 'request/filters[]/column/startDate'), request_filters_operator string OPTIONS (NAMEINSOURCE 'request/filters[]/operator'), request_includeDeletedEntities boolean OPTIONS (NAMEINSOURCE 'request/includeDeletedEntities'), request_includeRemovedEntities boolean OPTIONS (NAMEINSOURCE 'request/includeRemovedEntities'), request_maxRowsPerFile integer OPTIONS (NAMEINSOURCE 'request/maxRowsPerFile'), request_orderBy_sortOrder string OPTIONS (NAMEINSOURCE 'request/orderBy[]/sortOrder'), request_orderBy_column_columnName string OPTIONS (NAMEINSOURCE 'request/orderBy[]/column/columnName'), request_orderBy_column_customDimensionName string OPTIONS (NAMEINSOURCE 'request/orderBy[]/column/customDimensionName'), request_orderBy_column_customMetricName string OPTIONS (NAMEINSOURCE 'request/orderBy[]/column/customMetricName'), request_orderBy_column_endDate string OPTIONS (NAMEINSOURCE 'request/orderBy[]/column/endDate'), request_orderBy_column_groupByColumn boolean OPTIONS (NAMEINSOURCE 'request/orderBy[]/column/groupByColumn'), request_orderBy_column_headerText string OPTIONS (NAMEINSOURCE 'request/orderBy[]/column/headerText'), request_orderBy_column_platformSource string OPTIONS (NAMEINSOURCE 'request/orderBy[]/column/platformSource'), request_orderBy_column_productReportPerspective string OPTIONS (NAMEINSOURCE 'request/orderBy[]/column/productReportPerspective'), request_orderBy_column_savedColumnName string OPTIONS (NAMEINSOURCE 'request/orderBy[]/column/savedColumnName'), request_orderBy_column_startDate string OPTIONS (NAMEINSOURCE 'request/orderBy[]/column/startDate'), request_reportScope_keywordId string OPTIONS (NAMEINSOURCE 'request/reportScope/keywordId'), request_reportScope_adId string OPTIONS (NAMEINSOURCE 'request/reportScope/adId'), request_reportScope_campaignId string OPTIONS (NAMEINSOURCE 'request/reportScope/campaignId'), request_reportScope_agencyId string OPTIONS (NAMEINSOURCE 'request/reportScope/agencyId'), request_reportScope_engineAccountId string OPTIONS (NAMEINSOURCE 'request/reportScope/engineAccountId'), request_reportScope_adGroupId string OPTIONS (NAMEINSOURCE 'request/reportScope/adGroupId'), request_reportScope_advertiserId string OPTIONS (NAMEINSOURCE 'request/reportScope/advertiserId'), request_reportType string OPTIONS (NAMEINSOURCE 'request/reportType'), request_rowCount integer OPTIONS (NAMEINSOURCE 'request/rowCount'), request_startRow integer OPTIONS (NAMEINSOURCE 'request/startRow'), request_statisticsCurrency string OPTIONS (NAMEINSOURCE 'request/statisticsCurrency'), request_timeRange_changedMetricsSinceTimestamp timestamp OPTIONS (NAMEINSOURCE 'request/timeRange/changedMetricsSinceTimestamp'), request_timeRange_endDate string OPTIONS (NAMEINSOURCE 'request/timeRange/endDate'), request_timeRange_changedAttributesSinceTimestamp timestamp OPTIONS (NAMEINSOURCE 'request/timeRange/changedAttributesSinceTimestamp'), request_timeRange_startDate string OPTIONS (NAMEINSOURCE 'request/timeRange/startDate'), request_verifySingleTimeZone boolean OPTIONS (NAMEINSOURCE 'request/verifySingleTimeZone'), rowCount integer, statisticsCurrencyCode string, statisticsTimeZone string)
OPTIONS (ANNOTATION 'Inserts a report request into the reporting system.', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'https://www.googleapis.com/doubleclicksearch/v2/reports');

CREATE FOREIGN PROCEDURE "doubleclicksearch.reports.generate"(IN columns_ReportApiColumnSpec_columnName string OPTIONS (ANNOTATION 'Name of a DoubleClick Search column to include in the report.', NAMEINSOURCE 'columns[]/ReportApiColumnSpec/columnName', "teiid_rest:PARAMETER_TYPE" 'body'), IN columns_ReportApiColumnSpec_customDimensionName string OPTIONS (ANNOTATION 'Segments a report by a custom dimension. The report must be scoped to an advertiser or lower, and the custom dimension must already be set up in DoubleClick Search. The custom dimension name, which appears in DoubleClick Search, is case sensitive.\u000AIf used in a conversion report, returns the value of the specified custom dimension for the given conversion, if set. This column does not segment the conversion report.', NAMEINSOURCE 'columns[]/ReportApiColumnSpec/customDimensionName', "teiid_rest:PARAMETER_TYPE" 'body'), IN columns_ReportApiColumnSpec_customMetricName string OPTIONS (ANNOTATION 'Name of a custom metric to include in the report. The report must be scoped to an advertiser or lower, and the custom metric must already be set up in DoubleClick Search. The custom metric name, which appears in DoubleClick Search, is case sensitive.', NAMEINSOURCE 'columns[]/ReportApiColumnSpec/customMetricName', "teiid_rest:PARAMETER_TYPE" 'body'), IN columns_ReportApiColumnSpec_endDate string OPTIONS (ANNOTATION 'Inclusive day in YYYY-MM-DD format. When provided, this overrides the overall time range of the report for this column only. Must be provided together with startDate.', NAMEINSOURCE 'columns[]/ReportApiColumnSpec/endDate', "teiid_rest:PARAMETER_TYPE" 'body'), IN columns_ReportApiColumnSpec_groupByColumn boolean OPTIONS (ANNOTATION 'Synchronous report only. Set to true to group by this column. Defaults to false.', NAMEINSOURCE 'columns[]/ReportApiColumnSpec/groupByColumn', "teiid_rest:PARAMETER_TYPE" 'body'), IN columns_ReportApiColumnSpec_headerText string OPTIONS (ANNOTATION 'Text used to identify this column in the report output; defaults to columnName or savedColumnName when not specified. This can be used to prevent collisions between DoubleClick Search columns and saved columns with the same name.', NAMEINSOURCE 'columns[]/ReportApiColumnSpec/headerText', "teiid_rest:PARAMETER_TYPE" 'body'), IN columns_ReportApiColumnSpec_platformSource string OPTIONS (ANNOTATION 'The platform that is used to provide data for the custom dimension. Acceptable values are "floodlight".', NAMEINSOURCE 'columns[]/ReportApiColumnSpec/platformSource', "teiid_rest:PARAMETER_TYPE" 'body'), IN columns_ReportApiColumnSpec_productReportPerspective string OPTIONS (ANNOTATION 'Returns metrics only for a specific type of product activity. Accepted values are:  \u000A- "sold": returns metrics only for products that were sold \u000A- "advertised": returns metrics only for products that were advertised in a Shopping campaign, and that might or might not have been sold', NAMEINSOURCE 'columns[]/ReportApiColumnSpec/productReportPerspective', "teiid_rest:PARAMETER_TYPE" 'body'), IN columns_ReportApiColumnSpec_savedColumnName string OPTIONS (ANNOTATION 'Name of a saved column to include in the report. The report must be scoped at advertiser or lower, and this saved column must already be created in the DoubleClick Search UI.', NAMEINSOURCE 'columns[]/ReportApiColumnSpec/savedColumnName', "teiid_rest:PARAMETER_TYPE" 'body'), IN columns_ReportApiColumnSpec_startDate string OPTIONS (ANNOTATION 'Inclusive date in YYYY-MM-DD format. When provided, this overrides the overall time range of the report for this column only. Must be provided together with endDate.', NAMEINSOURCE 'columns[]/ReportApiColumnSpec/startDate', "teiid_rest:PARAMETER_TYPE" 'body'), IN downloadFormat string OPTIONS (ANNOTATION 'Format that the report should be returned in. Currently csv or tsv is supported.', "teiid_rest:PARAMETER_TYPE" 'body'), IN filters_values string[] OPTIONS (NAMEINSOURCE 'filters[]/values', "teiid_rest:PARAMETER_TYPE" 'body'), IN filters_column_columnName string OPTIONS (ANNOTATION 'Name of a DoubleClick Search column to include in the report.', NAMEINSOURCE 'filters[]/column/columnName', "teiid_rest:PARAMETER_TYPE" 'body'), IN filters_column_customDimensionName string OPTIONS (ANNOTATION 'Segments a report by a custom dimension. The report must be scoped to an advertiser or lower, and the custom dimension must already be set up in DoubleClick Search. The custom dimension name, which appears in DoubleClick Search, is case sensitive.\u000AIf used in a conversion report, returns the value of the specified custom dimension for the given conversion, if set. This column does not segment the conversion report.', NAMEINSOURCE 'filters[]/column/customDimensionName', "teiid_rest:PARAMETER_TYPE" 'body'), IN filters_column_customMetricName string OPTIONS (ANNOTATION 'Name of a custom metric to include in the report. The report must be scoped to an advertiser or lower, and the custom metric must already be set up in DoubleClick Search. The custom metric name, which appears in DoubleClick Search, is case sensitive.', NAMEINSOURCE 'filters[]/column/customMetricName', "teiid_rest:PARAMETER_TYPE" 'body'), IN filters_column_endDate string OPTIONS (ANNOTATION 'Inclusive day in YYYY-MM-DD format. When provided, this overrides the overall time range of the report for this column only. Must be provided together with startDate.', NAMEINSOURCE 'filters[]/column/endDate', "teiid_rest:PARAMETER_TYPE" 'body'), IN filters_column_groupByColumn boolean OPTIONS (ANNOTATION 'Synchronous report only. Set to true to group by this column. Defaults to false.', NAMEINSOURCE 'filters[]/column/groupByColumn', "teiid_rest:PARAMETER_TYPE" 'body'), IN filters_column_headerText string OPTIONS (ANNOTATION 'Text used to identify this column in the report output; defaults to columnName or savedColumnName when not specified. This can be used to prevent collisions between DoubleClick Search columns and saved columns with the same name.', NAMEINSOURCE 'filters[]/column/headerText', "teiid_rest:PARAMETER_TYPE" 'body'), IN filters_column_platformSource string OPTIONS (ANNOTATION 'The platform that is used to provide data for the custom dimension. Acceptable values are "floodlight".', NAMEINSOURCE 'filters[]/column/platformSource', "teiid_rest:PARAMETER_TYPE" 'body'), IN filters_column_productReportPerspective string OPTIONS (ANNOTATION 'Returns metrics only for a specific type of product activity. Accepted values are:  \u000A- "sold": returns metrics only for products that were sold \u000A- "advertised": returns metrics only for products that were advertised in a Shopping campaign, and that might or might not have been sold', NAMEINSOURCE 'filters[]/column/productReportPerspective', "teiid_rest:PARAMETER_TYPE" 'body'), IN filters_column_savedColumnName string OPTIONS (ANNOTATION 'Name of a saved column to include in the report. The report must be scoped at advertiser or lower, and this saved column must already be created in the DoubleClick Search UI.', NAMEINSOURCE 'filters[]/column/savedColumnName', "teiid_rest:PARAMETER_TYPE" 'body'), IN filters_column_startDate string OPTIONS (ANNOTATION 'Inclusive date in YYYY-MM-DD format. When provided, this overrides the overall time range of the report for this column only. Must be provided together with endDate.', NAMEINSOURCE 'filters[]/column/startDate', "teiid_rest:PARAMETER_TYPE" 'body'), IN filters_operator string OPTIONS (ANNOTATION 'Operator to use in the filter. See the filter reference for a list of available operators.', NAMEINSOURCE 'filters[]/operator', "teiid_rest:PARAMETER_TYPE" 'body'), IN includeDeletedEntities boolean OPTIONS (ANNOTATION 'Determines if removed entities should be included in the report. Defaults to false. Deprecated, please use includeRemovedEntities instead.', "teiid_rest:PARAMETER_TYPE" 'body'), IN includeRemovedEntities boolean OPTIONS (ANNOTATION 'Determines if removed entities should be included in the report. Defaults to false.', "teiid_rest:PARAMETER_TYPE" 'body'), IN maxRowsPerFile integer OPTIONS (ANNOTATION 'Asynchronous report only. The maximum number of rows per report file. A large report is split into many files based on this field. Acceptable values are 1000000 to 100000000, inclusive.', "teiid_rest:PARAMETER_TYPE" 'body'), IN orderBy_sortOrder string OPTIONS (ANNOTATION 'The sort direction, which is either ascending or descending.', NAMEINSOURCE 'orderBy[]/sortOrder', "teiid_rest:PARAMETER_TYPE" 'body'), IN orderBy_column_columnName string OPTIONS (ANNOTATION 'Name of a DoubleClick Search column to include in the report.', NAMEINSOURCE 'orderBy[]/column/columnName', "teiid_rest:PARAMETER_TYPE" 'body'), IN orderBy_column_customDimensionName string OPTIONS (ANNOTATION 'Segments a report by a custom dimension. The report must be scoped to an advertiser or lower, and the custom dimension must already be set up in DoubleClick Search. The custom dimension name, which appears in DoubleClick Search, is case sensitive.\u000AIf used in a conversion report, returns the value of the specified custom dimension for the given conversion, if set. This column does not segment the conversion report.', NAMEINSOURCE 'orderBy[]/column/customDimensionName', "teiid_rest:PARAMETER_TYPE" 'body'), IN orderBy_column_customMetricName string OPTIONS (ANNOTATION 'Name of a custom metric to include in the report. The report must be scoped to an advertiser or lower, and the custom metric must already be set up in DoubleClick Search. The custom metric name, which appears in DoubleClick Search, is case sensitive.', NAMEINSOURCE 'orderBy[]/column/customMetricName', "teiid_rest:PARAMETER_TYPE" 'body'), IN orderBy_column_endDate string OPTIONS (ANNOTATION 'Inclusive day in YYYY-MM-DD format. When provided, this overrides the overall time range of the report for this column only. Must be provided together with startDate.', NAMEINSOURCE 'orderBy[]/column/endDate', "teiid_rest:PARAMETER_TYPE" 'body'), IN orderBy_column_groupByColumn boolean OPTIONS (ANNOTATION 'Synchronous report only. Set to true to group by this column. Defaults to false.', NAMEINSOURCE 'orderBy[]/column/groupByColumn', "teiid_rest:PARAMETER_TYPE" 'body'), IN orderBy_column_headerText string OPTIONS (ANNOTATION 'Text used to identify this column in the report output; defaults to columnName or savedColumnName when not specified. This can be used to prevent collisions between DoubleClick Search columns and saved columns with the same name.', NAMEINSOURCE 'orderBy[]/column/headerText', "teiid_rest:PARAMETER_TYPE" 'body'), IN orderBy_column_platformSource string OPTIONS (ANNOTATION 'The platform that is used to provide data for the custom dimension. Acceptable values are "floodlight".', NAMEINSOURCE 'orderBy[]/column/platformSource', "teiid_rest:PARAMETER_TYPE" 'body'), IN orderBy_column_productReportPerspective string OPTIONS (ANNOTATION 'Returns metrics only for a specific type of product activity. Accepted values are:  \u000A- "sold": returns metrics only for products that were sold \u000A- "advertised": returns metrics only for products that were advertised in a Shopping campaign, and that might or might not have been sold', NAMEINSOURCE 'orderBy[]/column/productReportPerspective', "teiid_rest:PARAMETER_TYPE" 'body'), IN orderBy_column_savedColumnName string OPTIONS (ANNOTATION 'Name of a saved column to include in the report. The report must be scoped at advertiser or lower, and this saved column must already be created in the DoubleClick Search UI.', NAMEINSOURCE 'orderBy[]/column/savedColumnName', "teiid_rest:PARAMETER_TYPE" 'body'), IN orderBy_column_startDate string OPTIONS (ANNOTATION 'Inclusive date in YYYY-MM-DD format. When provided, this overrides the overall time range of the report for this column only. Must be provided together with endDate.', NAMEINSOURCE 'orderBy[]/column/startDate', "teiid_rest:PARAMETER_TYPE" 'body'), IN reportScope_keywordId string OPTIONS (ANNOTATION 'DS keyword ID.', NAMEINSOURCE 'reportScope/keywordId', "teiid_rest:PARAMETER_TYPE" 'body'), IN reportScope_adId string OPTIONS (ANNOTATION 'DS ad ID.', NAMEINSOURCE 'reportScope/adId', "teiid_rest:PARAMETER_TYPE" 'body'), IN reportScope_campaignId string OPTIONS (ANNOTATION 'DS campaign ID.', NAMEINSOURCE 'reportScope/campaignId', "teiid_rest:PARAMETER_TYPE" 'body'), IN reportScope_agencyId string OPTIONS (ANNOTATION 'DS agency ID.', NAMEINSOURCE 'reportScope/agencyId', "teiid_rest:PARAMETER_TYPE" 'body'), IN reportScope_engineAccountId string OPTIONS (ANNOTATION 'DS engine account ID.', NAMEINSOURCE 'reportScope/engineAccountId', "teiid_rest:PARAMETER_TYPE" 'body'), IN reportScope_adGroupId string OPTIONS (ANNOTATION 'DS ad group ID.', NAMEINSOURCE 'reportScope/adGroupId', "teiid_rest:PARAMETER_TYPE" 'body'), IN reportScope_advertiserId string OPTIONS (ANNOTATION 'DS advertiser ID.', NAMEINSOURCE 'reportScope/advertiserId', "teiid_rest:PARAMETER_TYPE" 'body'), IN reportType string OPTIONS (ANNOTATION 'Determines the type of rows that are returned in the report. For example, if you specify reportType: keyword, each row in the report will contain data about a keyword. See the Types of Reports reference for the columns that are available for each type.', "teiid_rest:PARAMETER_TYPE" 'body'), IN rowCount integer OPTIONS (ANNOTATION 'Synchronous report only. The maxinum number of rows to return; additional rows are dropped. Acceptable values are 0 to 10000, inclusive. Defaults to 10000.', "teiid_rest:PARAMETER_TYPE" 'body'), IN startRow integer OPTIONS (ANNOTATION 'Synchronous report only. Zero-based index of the first row to return. Acceptable values are 0 to 50000, inclusive. Defaults to 0.', "teiid_rest:PARAMETER_TYPE" 'body'), IN statisticsCurrency string OPTIONS (ANNOTATION 'Specifies the currency in which monetary will be returned. Possible values are: usd, agency (valid if the report is scoped to agency or lower), advertiser (valid if the report is scoped to * advertiser or lower), or account (valid if the report is scoped to engine account or lower).', "teiid_rest:PARAMETER_TYPE" 'body'), IN timeRange_changedMetricsSinceTimestamp timestamp OPTIONS (ANNOTATION 'Inclusive UTC timestamp in RFC format, e.g., 2013-07-16T10:16:23.555Z. See additional references on how changed metrics reports work.', NAMEINSOURCE 'timeRange/changedMetricsSinceTimestamp', "teiid_rest:PARAMETER_TYPE" 'body'), IN timeRange_endDate string OPTIONS (ANNOTATION 'Inclusive date in YYYY-MM-DD format.', NAMEINSOURCE 'timeRange/endDate', "teiid_rest:PARAMETER_TYPE" 'body'), IN timeRange_changedAttributesSinceTimestamp timestamp OPTIONS (ANNOTATION 'Inclusive UTC timestamp in RFC format, e.g., 2013-07-16T10:16:23.555Z. See additional references on how changed attribute reports work.', NAMEINSOURCE 'timeRange/changedAttributesSinceTimestamp', "teiid_rest:PARAMETER_TYPE" 'body'), IN timeRange_startDate string OPTIONS (ANNOTATION 'Inclusive date in YYYY-MM-DD format.', NAMEINSOURCE 'timeRange/startDate', "teiid_rest:PARAMETER_TYPE" 'body'), IN verifySingleTimeZone boolean OPTIONS (ANNOTATION 'If true, the report would only be created if all the requested stat data are sourced from a single timezone. Defaults to false.', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (files_byteCount string OPTIONS (NAMEINSOURCE 'files[]/byteCount'), files_url string OPTIONS (NAMEINSOURCE 'files[]/url'), id string, isReportReady boolean, kind string, request_columns_ReportApiColumnSpec_columnName string OPTIONS (NAMEINSOURCE 'request/columns[]/ReportApiColumnSpec/columnName'), request_columns_ReportApiColumnSpec_customDimensionName string OPTIONS (NAMEINSOURCE 'request/columns[]/ReportApiColumnSpec/customDimensionName'), request_columns_ReportApiColumnSpec_customMetricName string OPTIONS (NAMEINSOURCE 'request/columns[]/ReportApiColumnSpec/customMetricName'), request_columns_ReportApiColumnSpec_endDate string OPTIONS (NAMEINSOURCE 'request/columns[]/ReportApiColumnSpec/endDate'), request_columns_ReportApiColumnSpec_groupByColumn boolean OPTIONS (NAMEINSOURCE 'request/columns[]/ReportApiColumnSpec/groupByColumn'), request_columns_ReportApiColumnSpec_headerText string OPTIONS (NAMEINSOURCE 'request/columns[]/ReportApiColumnSpec/headerText'), request_columns_ReportApiColumnSpec_platformSource string OPTIONS (NAMEINSOURCE 'request/columns[]/ReportApiColumnSpec/platformSource'), request_columns_ReportApiColumnSpec_productReportPerspective string OPTIONS (NAMEINSOURCE 'request/columns[]/ReportApiColumnSpec/productReportPerspective'), request_columns_ReportApiColumnSpec_savedColumnName string OPTIONS (NAMEINSOURCE 'request/columns[]/ReportApiColumnSpec/savedColumnName'), request_columns_ReportApiColumnSpec_startDate string OPTIONS (NAMEINSOURCE 'request/columns[]/ReportApiColumnSpec/startDate'), request_downloadFormat string OPTIONS (NAMEINSOURCE 'request/downloadFormat'), request_filters_values string[] OPTIONS (NAMEINSOURCE 'request/filters[]/values'), request_filters_column_columnName string OPTIONS (NAMEINSOURCE 'request/filters[]/column/columnName'), request_filters_column_customDimensionName string OPTIONS (NAMEINSOURCE 'request/filters[]/column/customDimensionName'), request_filters_column_customMetricName string OPTIONS (NAMEINSOURCE 'request/filters[]/column/customMetricName'), request_filters_column_endDate string OPTIONS (NAMEINSOURCE 'request/filters[]/column/endDate'), request_filters_column_groupByColumn boolean OPTIONS (NAMEINSOURCE 'request/filters[]/column/groupByColumn'), request_filters_column_headerText string OPTIONS (NAMEINSOURCE 'request/filters[]/column/headerText'), request_filters_column_platformSource string OPTIONS (NAMEINSOURCE 'request/filters[]/column/platformSource'), request_filters_column_productReportPerspective string OPTIONS (NAMEINSOURCE 'request/filters[]/column/productReportPerspective'), request_filters_column_savedColumnName string OPTIONS (NAMEINSOURCE 'request/filters[]/column/savedColumnName'), request_filters_column_startDate string OPTIONS (NAMEINSOURCE 'request/filters[]/column/startDate'), request_filters_operator string OPTIONS (NAMEINSOURCE 'request/filters[]/operator'), request_includeDeletedEntities boolean OPTIONS (NAMEINSOURCE 'request/includeDeletedEntities'), request_includeRemovedEntities boolean OPTIONS (NAMEINSOURCE 'request/includeRemovedEntities'), request_maxRowsPerFile integer OPTIONS (NAMEINSOURCE 'request/maxRowsPerFile'), request_orderBy_sortOrder string OPTIONS (NAMEINSOURCE 'request/orderBy[]/sortOrder'), request_orderBy_column_columnName string OPTIONS (NAMEINSOURCE 'request/orderBy[]/column/columnName'), request_orderBy_column_customDimensionName string OPTIONS (NAMEINSOURCE 'request/orderBy[]/column/customDimensionName'), request_orderBy_column_customMetricName string OPTIONS (NAMEINSOURCE 'request/orderBy[]/column/customMetricName'), request_orderBy_column_endDate string OPTIONS (NAMEINSOURCE 'request/orderBy[]/column/endDate'), request_orderBy_column_groupByColumn boolean OPTIONS (NAMEINSOURCE 'request/orderBy[]/column/groupByColumn'), request_orderBy_column_headerText string OPTIONS (NAMEINSOURCE 'request/orderBy[]/column/headerText'), request_orderBy_column_platformSource string OPTIONS (NAMEINSOURCE 'request/orderBy[]/column/platformSource'), request_orderBy_column_productReportPerspective string OPTIONS (NAMEINSOURCE 'request/orderBy[]/column/productReportPerspective'), request_orderBy_column_savedColumnName string OPTIONS (NAMEINSOURCE 'request/orderBy[]/column/savedColumnName'), request_orderBy_column_startDate string OPTIONS (NAMEINSOURCE 'request/orderBy[]/column/startDate'), request_reportScope_keywordId string OPTIONS (NAMEINSOURCE 'request/reportScope/keywordId'), request_reportScope_adId string OPTIONS (NAMEINSOURCE 'request/reportScope/adId'), request_reportScope_campaignId string OPTIONS (NAMEINSOURCE 'request/reportScope/campaignId'), request_reportScope_agencyId string OPTIONS (NAMEINSOURCE 'request/reportScope/agencyId'), request_reportScope_engineAccountId string OPTIONS (NAMEINSOURCE 'request/reportScope/engineAccountId'), request_reportScope_adGroupId string OPTIONS (NAMEINSOURCE 'request/reportScope/adGroupId'), request_reportScope_advertiserId string OPTIONS (NAMEINSOURCE 'request/reportScope/advertiserId'), request_reportType string OPTIONS (NAMEINSOURCE 'request/reportType'), request_rowCount integer OPTIONS (NAMEINSOURCE 'request/rowCount'), request_startRow integer OPTIONS (NAMEINSOURCE 'request/startRow'), request_statisticsCurrency string OPTIONS (NAMEINSOURCE 'request/statisticsCurrency'), request_timeRange_changedMetricsSinceTimestamp timestamp OPTIONS (NAMEINSOURCE 'request/timeRange/changedMetricsSinceTimestamp'), request_timeRange_endDate string OPTIONS (NAMEINSOURCE 'request/timeRange/endDate'), request_timeRange_changedAttributesSinceTimestamp timestamp OPTIONS (NAMEINSOURCE 'request/timeRange/changedAttributesSinceTimestamp'), request_timeRange_startDate string OPTIONS (NAMEINSOURCE 'request/timeRange/startDate'), request_verifySingleTimeZone boolean OPTIONS (NAMEINSOURCE 'request/verifySingleTimeZone'), rowCount integer, statisticsCurrencyCode string, statisticsTimeZone string)
OPTIONS (ANNOTATION 'Generates and returns a report immediately.', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'https://www.googleapis.com/doubleclicksearch/v2/reports/generate');

CREATE FOREIGN PROCEDURE "doubleclicksearch.reports.get"(IN reportId string NOT NULL OPTIONS (ANNOTATION 'ID of the report request being polled.', "teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (files_byteCount string OPTIONS (NAMEINSOURCE 'files[]/byteCount'), files_url string OPTIONS (NAMEINSOURCE 'files[]/url'), id string, isReportReady boolean, kind string, request_columns_ReportApiColumnSpec_columnName string OPTIONS (NAMEINSOURCE 'request/columns[]/ReportApiColumnSpec/columnName'), request_columns_ReportApiColumnSpec_customDimensionName string OPTIONS (NAMEINSOURCE 'request/columns[]/ReportApiColumnSpec/customDimensionName'), request_columns_ReportApiColumnSpec_customMetricName string OPTIONS (NAMEINSOURCE 'request/columns[]/ReportApiColumnSpec/customMetricName'), request_columns_ReportApiColumnSpec_endDate string OPTIONS (NAMEINSOURCE 'request/columns[]/ReportApiColumnSpec/endDate'), request_columns_ReportApiColumnSpec_groupByColumn boolean OPTIONS (NAMEINSOURCE 'request/columns[]/ReportApiColumnSpec/groupByColumn'), request_columns_ReportApiColumnSpec_headerText string OPTIONS (NAMEINSOURCE 'request/columns[]/ReportApiColumnSpec/headerText'), request_columns_ReportApiColumnSpec_platformSource string OPTIONS (NAMEINSOURCE 'request/columns[]/ReportApiColumnSpec/platformSource'), request_columns_ReportApiColumnSpec_productReportPerspective string OPTIONS (NAMEINSOURCE 'request/columns[]/ReportApiColumnSpec/productReportPerspective'), request_columns_ReportApiColumnSpec_savedColumnName string OPTIONS (NAMEINSOURCE 'request/columns[]/ReportApiColumnSpec/savedColumnName'), request_columns_ReportApiColumnSpec_startDate string OPTIONS (NAMEINSOURCE 'request/columns[]/ReportApiColumnSpec/startDate'), request_downloadFormat string OPTIONS (NAMEINSOURCE 'request/downloadFormat'), request_filters_values string[] OPTIONS (NAMEINSOURCE 'request/filters[]/values'), request_filters_column_columnName string OPTIONS (NAMEINSOURCE 'request/filters[]/column/columnName'), request_filters_column_customDimensionName string OPTIONS (NAMEINSOURCE 'request/filters[]/column/customDimensionName'), request_filters_column_customMetricName string OPTIONS (NAMEINSOURCE 'request/filters[]/column/customMetricName'), request_filters_column_endDate string OPTIONS (NAMEINSOURCE 'request/filters[]/column/endDate'), request_filters_column_groupByColumn boolean OPTIONS (NAMEINSOURCE 'request/filters[]/column/groupByColumn'), request_filters_column_headerText string OPTIONS (NAMEINSOURCE 'request/filters[]/column/headerText'), request_filters_column_platformSource string OPTIONS (NAMEINSOURCE 'request/filters[]/column/platformSource'), request_filters_column_productReportPerspective string OPTIONS (NAMEINSOURCE 'request/filters[]/column/productReportPerspective'), request_filters_column_savedColumnName string OPTIONS (NAMEINSOURCE 'request/filters[]/column/savedColumnName'), request_filters_column_startDate string OPTIONS (NAMEINSOURCE 'request/filters[]/column/startDate'), request_filters_operator string OPTIONS (NAMEINSOURCE 'request/filters[]/operator'), request_includeDeletedEntities boolean OPTIONS (NAMEINSOURCE 'request/includeDeletedEntities'), request_includeRemovedEntities boolean OPTIONS (NAMEINSOURCE 'request/includeRemovedEntities'), request_maxRowsPerFile integer OPTIONS (NAMEINSOURCE 'request/maxRowsPerFile'), request_orderBy_sortOrder string OPTIONS (NAMEINSOURCE 'request/orderBy[]/sortOrder'), request_orderBy_column_columnName string OPTIONS (NAMEINSOURCE 'request/orderBy[]/column/columnName'), request_orderBy_column_customDimensionName string OPTIONS (NAMEINSOURCE 'request/orderBy[]/column/customDimensionName'), request_orderBy_column_customMetricName string OPTIONS (NAMEINSOURCE 'request/orderBy[]/column/customMetricName'), request_orderBy_column_endDate string OPTIONS (NAMEINSOURCE 'request/orderBy[]/column/endDate'), request_orderBy_column_groupByColumn boolean OPTIONS (NAMEINSOURCE 'request/orderBy[]/column/groupByColumn'), request_orderBy_column_headerText string OPTIONS (NAMEINSOURCE 'request/orderBy[]/column/headerText'), request_orderBy_column_platformSource string OPTIONS (NAMEINSOURCE 'request/orderBy[]/column/platformSource'), request_orderBy_column_productReportPerspective string OPTIONS (NAMEINSOURCE 'request/orderBy[]/column/productReportPerspective'), request_orderBy_column_savedColumnName string OPTIONS (NAMEINSOURCE 'request/orderBy[]/column/savedColumnName'), request_orderBy_column_startDate string OPTIONS (NAMEINSOURCE 'request/orderBy[]/column/startDate'), request_reportScope_keywordId string OPTIONS (NAMEINSOURCE 'request/reportScope/keywordId'), request_reportScope_adId string OPTIONS (NAMEINSOURCE 'request/reportScope/adId'), request_reportScope_campaignId string OPTIONS (NAMEINSOURCE 'request/reportScope/campaignId'), request_reportScope_agencyId string OPTIONS (NAMEINSOURCE 'request/reportScope/agencyId'), request_reportScope_engineAccountId string OPTIONS (NAMEINSOURCE 'request/reportScope/engineAccountId'), request_reportScope_adGroupId string OPTIONS (NAMEINSOURCE 'request/reportScope/adGroupId'), request_reportScope_advertiserId string OPTIONS (NAMEINSOURCE 'request/reportScope/advertiserId'), request_reportType string OPTIONS (NAMEINSOURCE 'request/reportType'), request_rowCount integer OPTIONS (NAMEINSOURCE 'request/rowCount'), request_startRow integer OPTIONS (NAMEINSOURCE 'request/startRow'), request_statisticsCurrency string OPTIONS (NAMEINSOURCE 'request/statisticsCurrency'), request_timeRange_changedMetricsSinceTimestamp timestamp OPTIONS (NAMEINSOURCE 'request/timeRange/changedMetricsSinceTimestamp'), request_timeRange_endDate string OPTIONS (NAMEINSOURCE 'request/timeRange/endDate'), request_timeRange_changedAttributesSinceTimestamp timestamp OPTIONS (NAMEINSOURCE 'request/timeRange/changedAttributesSinceTimestamp'), request_timeRange_startDate string OPTIONS (NAMEINSOURCE 'request/timeRange/startDate'), request_verifySingleTimeZone boolean OPTIONS (NAMEINSOURCE 'request/verifySingleTimeZone'), rowCount integer, statisticsCurrencyCode string, statisticsTimeZone string)
OPTIONS (ANNOTATION 'Polls for the status of a report request.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'https://www.googleapis.com/doubleclicksearch/v2/reports/{reportId}');

CREATE FOREIGN PROCEDURE "doubleclicksearch.reports.getFile"(IN reportFragment string NOT NULL OPTIONS (ANNOTATION 'The index of the report fragment to download.', "teiid_rest:PARAMETER_TYPE" 'path'), IN reportId string NOT NULL OPTIONS (ANNOTATION 'ID of the report.', "teiid_rest:PARAMETER_TYPE" 'path'))
OPTIONS (ANNOTATION 'Downloads a report file encoded in UTF-8.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'https://www.googleapis.com/doubleclicksearch/v2/reports/{reportId}/files/{reportFragment}');