// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/datacatalog/v1beta1/datacatalog.proto

package datacatalog

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	v1 "google.golang.org/genproto/googleapis/iam/v1"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Entry resources in Data Catalog can be of different types e.g. BigQuery
// Table entry is of type 'TABLE'. This enum describes all the possible types
// Data Catalog contains.
type EntryType int32

const (
	// Default unknown type
	EntryType_ENTRY_TYPE_UNSPECIFIED EntryType = 0
	// The type of entry that has a GoogleSQL schema, including logical views.
	EntryType_TABLE EntryType = 2
	// An entry type which is used for streaming entries. Example - Pub/Sub.
	EntryType_DATA_STREAM EntryType = 3
)

var EntryType_name = map[int32]string{
	0: "ENTRY_TYPE_UNSPECIFIED",
	2: "TABLE",
	3: "DATA_STREAM",
}

var EntryType_value = map[string]int32{
	"ENTRY_TYPE_UNSPECIFIED": 0,
	"TABLE":                  2,
	"DATA_STREAM":            3,
}

func (x EntryType) String() string {
	return proto.EnumName(EntryType_name, int32(x))
}

func (EntryType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{0}
}

// Request message for
// [SearchCatalog][google.cloud.datacatalog.v1beta1.DataCatalog.SearchCatalog].
type SearchCatalogRequest struct {
	// Required. The scope of this search request.
	Scope *SearchCatalogRequest_Scope `protobuf:"bytes,6,opt,name=scope,proto3" json:"scope,omitempty"`
	// Required. The query string in search query syntax. The query must be
	// non-empty.
	//
	// Query strings can be simple as "x" or more qualified as:
	//
	// * name:x
	// * column:x
	// * description:y
	//
	// Note: Query tokens need to have a minimum of 3 characters for substring
	// matching to work correctly. See [Data Catalog Search
	// Syntax](/data-catalog/docs/how-to/search-reference) for more information.
	Query string `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	// Number of results in the search page. If <=0 then defaults to 10. Max limit
	// for page_size is 1000. Throws an invalid argument for page_size > 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional pagination token returned in an earlier
	// [SearchCatalogResponse.next_page_token][google.cloud.datacatalog.v1beta1.DataCatalog.SearchCatalogResponse.next_page_token];
	// indicates that this is a continuation of a prior
	// [SearchCatalog][google.cloud.datacatalog.v1beta1.DataCatalog.SearchCatalog]
	// call, and that the system should return the next page of data. If empty
	// then the first page is returned.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Specifies the ordering of results, currently supported case-sensitive
	// choices are:
	// <ul>
	//   <li> relevance </li>
	//   <li> last_access_timestamp [asc|desc], defaults to descending if not
	//   specified, </li>
	//   <li> last_modified_timestamp [asc|desc], defaults to descending if not
	//   specified, </li>
	//   <li> title [asc|desc], defaults to ascending if not specified. </li>
	// </ul>
	OrderBy              string   `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchCatalogRequest) Reset()         { *m = SearchCatalogRequest{} }
func (m *SearchCatalogRequest) String() string { return proto.CompactTextString(m) }
func (*SearchCatalogRequest) ProtoMessage()    {}
func (*SearchCatalogRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{0}
}

func (m *SearchCatalogRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchCatalogRequest.Unmarshal(m, b)
}
func (m *SearchCatalogRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchCatalogRequest.Marshal(b, m, deterministic)
}
func (m *SearchCatalogRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchCatalogRequest.Merge(m, src)
}
func (m *SearchCatalogRequest) XXX_Size() int {
	return xxx_messageInfo_SearchCatalogRequest.Size(m)
}
func (m *SearchCatalogRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchCatalogRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SearchCatalogRequest proto.InternalMessageInfo

func (m *SearchCatalogRequest) GetScope() *SearchCatalogRequest_Scope {
	if m != nil {
		return m.Scope
	}
	return nil
}

func (m *SearchCatalogRequest) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

func (m *SearchCatalogRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *SearchCatalogRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *SearchCatalogRequest) GetOrderBy() string {
	if m != nil {
		return m.OrderBy
	}
	return ""
}

type SearchCatalogRequest_Scope struct {
	// Data Catalog tries to automatically choose the right corpus of data to
	// search through. You can ensure an organization is included by adding it
	// to "include_org_ids". You can ensure a project's org is included with
	// "include_project_ids". You must specify at least one organization
	// using "include_org_ids" or "include_project_ids" in all search requests.
	//
	// List of organization IDs to search within. To find your organization ID,
	// follow instructions in
	// https://cloud.google.com/resource-manager/docs/creating-managing-organization
	IncludeOrgIds []string `protobuf:"bytes,2,rep,name=include_org_ids,json=includeOrgIds,proto3" json:"include_org_ids,omitempty"`
	// List of project IDs to search within. To learn more about the
	// distinction between project names/IDs/numbers, go to
	// https://cloud.google.com/docs/overview/#projects
	IncludeProjectIds []string `protobuf:"bytes,3,rep,name=include_project_ids,json=includeProjectIds,proto3" json:"include_project_ids,omitempty"`
	// If true, include Google Cloud Platform (GCP) public datasets in the
	// search results. Info on GCP public datasets is available at
	// https://cloud.google.com/public-datasets/. By default, GCP public
	// datasets are excluded.
	IncludeGcpPublicDatasets bool     `protobuf:"varint,7,opt,name=include_gcp_public_datasets,json=includeGcpPublicDatasets,proto3" json:"include_gcp_public_datasets,omitempty"`
	XXX_NoUnkeyedLiteral     struct{} `json:"-"`
	XXX_unrecognized         []byte   `json:"-"`
	XXX_sizecache            int32    `json:"-"`
}

func (m *SearchCatalogRequest_Scope) Reset()         { *m = SearchCatalogRequest_Scope{} }
func (m *SearchCatalogRequest_Scope) String() string { return proto.CompactTextString(m) }
func (*SearchCatalogRequest_Scope) ProtoMessage()    {}
func (*SearchCatalogRequest_Scope) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{0, 0}
}

func (m *SearchCatalogRequest_Scope) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchCatalogRequest_Scope.Unmarshal(m, b)
}
func (m *SearchCatalogRequest_Scope) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchCatalogRequest_Scope.Marshal(b, m, deterministic)
}
func (m *SearchCatalogRequest_Scope) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchCatalogRequest_Scope.Merge(m, src)
}
func (m *SearchCatalogRequest_Scope) XXX_Size() int {
	return xxx_messageInfo_SearchCatalogRequest_Scope.Size(m)
}
func (m *SearchCatalogRequest_Scope) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchCatalogRequest_Scope.DiscardUnknown(m)
}

var xxx_messageInfo_SearchCatalogRequest_Scope proto.InternalMessageInfo

func (m *SearchCatalogRequest_Scope) GetIncludeOrgIds() []string {
	if m != nil {
		return m.IncludeOrgIds
	}
	return nil
}

func (m *SearchCatalogRequest_Scope) GetIncludeProjectIds() []string {
	if m != nil {
		return m.IncludeProjectIds
	}
	return nil
}

func (m *SearchCatalogRequest_Scope) GetIncludeGcpPublicDatasets() bool {
	if m != nil {
		return m.IncludeGcpPublicDatasets
	}
	return false
}

// Response message for
// [SearchCatalog][google.cloud.datacatalog.v1beta1.DataCatalog.SearchCatalog].
type SearchCatalogResponse struct {
	// Search results in descending order of relevance.
	Results []*SearchCatalogResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// The token that can be used to retrieve the next page of results.
	NextPageToken        string   `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchCatalogResponse) Reset()         { *m = SearchCatalogResponse{} }
func (m *SearchCatalogResponse) String() string { return proto.CompactTextString(m) }
func (*SearchCatalogResponse) ProtoMessage()    {}
func (*SearchCatalogResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{1}
}

func (m *SearchCatalogResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchCatalogResponse.Unmarshal(m, b)
}
func (m *SearchCatalogResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchCatalogResponse.Marshal(b, m, deterministic)
}
func (m *SearchCatalogResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchCatalogResponse.Merge(m, src)
}
func (m *SearchCatalogResponse) XXX_Size() int {
	return xxx_messageInfo_SearchCatalogResponse.Size(m)
}
func (m *SearchCatalogResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchCatalogResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SearchCatalogResponse proto.InternalMessageInfo

func (m *SearchCatalogResponse) GetResults() []*SearchCatalogResult {
	if m != nil {
		return m.Results
	}
	return nil
}

func (m *SearchCatalogResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for
// [UpdateEntry][google.cloud.datacatalog.v1beta1.DataCatalog.UpdateEntry].
type UpdateEntryRequest struct {
	// Required. The updated Entry.
	Entry *Entry `protobuf:"bytes,1,opt,name=entry,proto3" json:"entry,omitempty"`
	// Optional. The fields to update on the entry.  If absent or empty, all
	// modifiable fields are updated.
	//
	// Modifiable fields in synced entries:
	//
	// 1. schema (Pub/Sub topics only)
	//
	// Modifiable fields in native entries:
	//
	// 1. display_name
	// 2. description
	// 3. schema
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateEntryRequest) Reset()         { *m = UpdateEntryRequest{} }
func (m *UpdateEntryRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateEntryRequest) ProtoMessage()    {}
func (*UpdateEntryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{2}
}

func (m *UpdateEntryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateEntryRequest.Unmarshal(m, b)
}
func (m *UpdateEntryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateEntryRequest.Marshal(b, m, deterministic)
}
func (m *UpdateEntryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateEntryRequest.Merge(m, src)
}
func (m *UpdateEntryRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateEntryRequest.Size(m)
}
func (m *UpdateEntryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateEntryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateEntryRequest proto.InternalMessageInfo

func (m *UpdateEntryRequest) GetEntry() *Entry {
	if m != nil {
		return m.Entry
	}
	return nil
}

func (m *UpdateEntryRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for
// [GetEntry][google.cloud.datacatalog.v1beta1.DataCatalog.GetEntry].
type GetEntryRequest struct {
	// Required. The name of the entry. For example,
	// "projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}/entries/{entry_id}".
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetEntryRequest) Reset()         { *m = GetEntryRequest{} }
func (m *GetEntryRequest) String() string { return proto.CompactTextString(m) }
func (*GetEntryRequest) ProtoMessage()    {}
func (*GetEntryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{3}
}

func (m *GetEntryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetEntryRequest.Unmarshal(m, b)
}
func (m *GetEntryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetEntryRequest.Marshal(b, m, deterministic)
}
func (m *GetEntryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetEntryRequest.Merge(m, src)
}
func (m *GetEntryRequest) XXX_Size() int {
	return xxx_messageInfo_GetEntryRequest.Size(m)
}
func (m *GetEntryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetEntryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetEntryRequest proto.InternalMessageInfo

func (m *GetEntryRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for
// [LookupEntry][google.cloud.datacatalog.v1beta1.DataCatalog.LookupEntry].
type LookupEntryRequest struct {
	// Required. Represents either the Google Cloud Platform resource or SQL name
	// for a Google Cloud Platform resource.
	//
	// Types that are valid to be assigned to TargetName:
	//	*LookupEntryRequest_LinkedResource
	//	*LookupEntryRequest_SqlResource
	TargetName           isLookupEntryRequest_TargetName `protobuf_oneof:"target_name"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *LookupEntryRequest) Reset()         { *m = LookupEntryRequest{} }
func (m *LookupEntryRequest) String() string { return proto.CompactTextString(m) }
func (*LookupEntryRequest) ProtoMessage()    {}
func (*LookupEntryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{4}
}

func (m *LookupEntryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LookupEntryRequest.Unmarshal(m, b)
}
func (m *LookupEntryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LookupEntryRequest.Marshal(b, m, deterministic)
}
func (m *LookupEntryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LookupEntryRequest.Merge(m, src)
}
func (m *LookupEntryRequest) XXX_Size() int {
	return xxx_messageInfo_LookupEntryRequest.Size(m)
}
func (m *LookupEntryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_LookupEntryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_LookupEntryRequest proto.InternalMessageInfo

type isLookupEntryRequest_TargetName interface {
	isLookupEntryRequest_TargetName()
}

type LookupEntryRequest_LinkedResource struct {
	LinkedResource string `protobuf:"bytes,1,opt,name=linked_resource,json=linkedResource,proto3,oneof"`
}

type LookupEntryRequest_SqlResource struct {
	SqlResource string `protobuf:"bytes,3,opt,name=sql_resource,json=sqlResource,proto3,oneof"`
}

func (*LookupEntryRequest_LinkedResource) isLookupEntryRequest_TargetName() {}

func (*LookupEntryRequest_SqlResource) isLookupEntryRequest_TargetName() {}

func (m *LookupEntryRequest) GetTargetName() isLookupEntryRequest_TargetName {
	if m != nil {
		return m.TargetName
	}
	return nil
}

func (m *LookupEntryRequest) GetLinkedResource() string {
	if x, ok := m.GetTargetName().(*LookupEntryRequest_LinkedResource); ok {
		return x.LinkedResource
	}
	return ""
}

func (m *LookupEntryRequest) GetSqlResource() string {
	if x, ok := m.GetTargetName().(*LookupEntryRequest_SqlResource); ok {
		return x.SqlResource
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*LookupEntryRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*LookupEntryRequest_LinkedResource)(nil),
		(*LookupEntryRequest_SqlResource)(nil),
	}
}

// Entry Metadata.
// A Data Catalog Entry resource represents another resource in Google
// Cloud Platform, such as a BigQuery Dataset or a Pub/Sub Topic. Clients can
// use the `linked_resource` field in the Entry resource to refer to the
// original resource id of the source system.
//
// An Entry resource contains resource details, such as its schema. An Entry can
// also be used to attach flexible metadata, such as a
// [Tag][google.cloud.datacatalog.v1beta1.Tag].
type Entry struct {
	// Required when used in
	// [UpdateEntryRequest][google.cloud.datacatalog.v1beta1.UpdateEntryRequest].
	// The Data Catalog resource name of the entry in URL format. For example,
	// "projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}/entries/{entry_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The full name of the cloud resource the entry belongs to. See:
	// https://cloud.google.com/apis/design/resource_names#full_resource_name
	//
	// Data Catalog supports resources from select Google Cloud Platform systems.
	// `linked_resource` is the full name of the Google Cloud Platform resource.
	// For example, the `linked_resource` for a table resource from BigQuery is:
	//
	// "//bigquery.googleapis.com/projects/projectId/datasets/datasetId/tables/tableId".
	LinkedResource string `protobuf:"bytes,9,opt,name=linked_resource,json=linkedResource,proto3" json:"linked_resource,omitempty"`
	// Required. Type of entry.
	Type EntryType `protobuf:"varint,2,opt,name=type,proto3,enum=google.cloud.datacatalog.v1beta1.EntryType" json:"type,omitempty"`
	// Optional. Type specification information.
	//
	// Types that are valid to be assigned to TypeSpec:
	//	*Entry_BigqueryTableSpec
	//	*Entry_BigqueryDateShardedSpec
	TypeSpec isEntry_TypeSpec `protobuf_oneof:"type_spec"`
	// Optional. Display information such as title and description. A short name
	// to identify the entry, for example, "Analytics Data - Jan 2011". Default
	// value is an empty string.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. Entry description, which can consist of several sentences or
	// paragraphs that describe entry contents. Default value is an empty string.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. Schema of the entry. An entry might not have any schema attached
	// to it.
	Schema *Schema `protobuf:"bytes,5,opt,name=schema,proto3" json:"schema,omitempty"`
	// Output only. Timestamps about the underlying Google Cloud Platform resource
	// -- not about this Data Catalog Entry.
	SourceSystemTimestamps *SystemTimestamps `protobuf:"bytes,7,opt,name=source_system_timestamps,json=sourceSystemTimestamps,proto3" json:"source_system_timestamps,omitempty"`
	XXX_NoUnkeyedLiteral   struct{}          `json:"-"`
	XXX_unrecognized       []byte            `json:"-"`
	XXX_sizecache          int32             `json:"-"`
}

func (m *Entry) Reset()         { *m = Entry{} }
func (m *Entry) String() string { return proto.CompactTextString(m) }
func (*Entry) ProtoMessage()    {}
func (*Entry) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{5}
}

func (m *Entry) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Entry.Unmarshal(m, b)
}
func (m *Entry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Entry.Marshal(b, m, deterministic)
}
func (m *Entry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Entry.Merge(m, src)
}
func (m *Entry) XXX_Size() int {
	return xxx_messageInfo_Entry.Size(m)
}
func (m *Entry) XXX_DiscardUnknown() {
	xxx_messageInfo_Entry.DiscardUnknown(m)
}

var xxx_messageInfo_Entry proto.InternalMessageInfo

func (m *Entry) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Entry) GetLinkedResource() string {
	if m != nil {
		return m.LinkedResource
	}
	return ""
}

func (m *Entry) GetType() EntryType {
	if m != nil {
		return m.Type
	}
	return EntryType_ENTRY_TYPE_UNSPECIFIED
}

type isEntry_TypeSpec interface {
	isEntry_TypeSpec()
}

type Entry_BigqueryTableSpec struct {
	BigqueryTableSpec *BigQueryTableSpec `protobuf:"bytes,12,opt,name=bigquery_table_spec,json=bigqueryTableSpec,proto3,oneof"`
}

type Entry_BigqueryDateShardedSpec struct {
	BigqueryDateShardedSpec *BigQueryDateShardedSpec `protobuf:"bytes,15,opt,name=bigquery_date_sharded_spec,json=bigqueryDateShardedSpec,proto3,oneof"`
}

func (*Entry_BigqueryTableSpec) isEntry_TypeSpec() {}

func (*Entry_BigqueryDateShardedSpec) isEntry_TypeSpec() {}

func (m *Entry) GetTypeSpec() isEntry_TypeSpec {
	if m != nil {
		return m.TypeSpec
	}
	return nil
}

func (m *Entry) GetBigqueryTableSpec() *BigQueryTableSpec {
	if x, ok := m.GetTypeSpec().(*Entry_BigqueryTableSpec); ok {
		return x.BigqueryTableSpec
	}
	return nil
}

func (m *Entry) GetBigqueryDateShardedSpec() *BigQueryDateShardedSpec {
	if x, ok := m.GetTypeSpec().(*Entry_BigqueryDateShardedSpec); ok {
		return x.BigqueryDateShardedSpec
	}
	return nil
}

func (m *Entry) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Entry) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Entry) GetSchema() *Schema {
	if m != nil {
		return m.Schema
	}
	return nil
}

func (m *Entry) GetSourceSystemTimestamps() *SystemTimestamps {
	if m != nil {
		return m.SourceSystemTimestamps
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Entry) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Entry_BigqueryTableSpec)(nil),
		(*Entry_BigqueryDateShardedSpec)(nil),
	}
}

// Request message for
// [CreateTagTemplate][google.cloud.datacatalog.v1beta1.DataCatalog.CreateTagTemplate].
type CreateTagTemplateRequest struct {
	// Required. The name of the project and the location this template is in.
	// Example: "projects/{project_id}/locations/{location}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The id of the tag template to create.
	TagTemplateId string `protobuf:"bytes,3,opt,name=tag_template_id,json=tagTemplateId,proto3" json:"tag_template_id,omitempty"`
	// Required. The tag template to create.
	TagTemplate          *TagTemplate `protobuf:"bytes,2,opt,name=tag_template,json=tagTemplate,proto3" json:"tag_template,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *CreateTagTemplateRequest) Reset()         { *m = CreateTagTemplateRequest{} }
func (m *CreateTagTemplateRequest) String() string { return proto.CompactTextString(m) }
func (*CreateTagTemplateRequest) ProtoMessage()    {}
func (*CreateTagTemplateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{6}
}

func (m *CreateTagTemplateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateTagTemplateRequest.Unmarshal(m, b)
}
func (m *CreateTagTemplateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateTagTemplateRequest.Marshal(b, m, deterministic)
}
func (m *CreateTagTemplateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateTagTemplateRequest.Merge(m, src)
}
func (m *CreateTagTemplateRequest) XXX_Size() int {
	return xxx_messageInfo_CreateTagTemplateRequest.Size(m)
}
func (m *CreateTagTemplateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateTagTemplateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateTagTemplateRequest proto.InternalMessageInfo

func (m *CreateTagTemplateRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateTagTemplateRequest) GetTagTemplateId() string {
	if m != nil {
		return m.TagTemplateId
	}
	return ""
}

func (m *CreateTagTemplateRequest) GetTagTemplate() *TagTemplate {
	if m != nil {
		return m.TagTemplate
	}
	return nil
}

// Request message for
// [GetTagTemplate][google.cloud.datacatalog.v1beta1.DataCatalog.GetTagTemplate].
type GetTagTemplateRequest struct {
	// Required. The name of the tag template. For example,
	// "projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}".
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetTagTemplateRequest) Reset()         { *m = GetTagTemplateRequest{} }
func (m *GetTagTemplateRequest) String() string { return proto.CompactTextString(m) }
func (*GetTagTemplateRequest) ProtoMessage()    {}
func (*GetTagTemplateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{7}
}

func (m *GetTagTemplateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetTagTemplateRequest.Unmarshal(m, b)
}
func (m *GetTagTemplateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetTagTemplateRequest.Marshal(b, m, deterministic)
}
func (m *GetTagTemplateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetTagTemplateRequest.Merge(m, src)
}
func (m *GetTagTemplateRequest) XXX_Size() int {
	return xxx_messageInfo_GetTagTemplateRequest.Size(m)
}
func (m *GetTagTemplateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetTagTemplateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetTagTemplateRequest proto.InternalMessageInfo

func (m *GetTagTemplateRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for
// [UpdateTagTemplate][google.cloud.datacatalog.v1beta1.DataCatalog.UpdateTagTemplate].
type UpdateTagTemplateRequest struct {
	// Required. The template to update.
	TagTemplate *TagTemplate `protobuf:"bytes,1,opt,name=tag_template,json=tagTemplate,proto3" json:"tag_template,omitempty"`
	// Optional. The field mask specifies the parts of the template to overwrite.
	//
	// Allowed fields:
	//
	//   * display_name
	//
	// If update_mask is omitted, all of the allowed fields above will be updated.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateTagTemplateRequest) Reset()         { *m = UpdateTagTemplateRequest{} }
func (m *UpdateTagTemplateRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateTagTemplateRequest) ProtoMessage()    {}
func (*UpdateTagTemplateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{8}
}

func (m *UpdateTagTemplateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateTagTemplateRequest.Unmarshal(m, b)
}
func (m *UpdateTagTemplateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateTagTemplateRequest.Marshal(b, m, deterministic)
}
func (m *UpdateTagTemplateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateTagTemplateRequest.Merge(m, src)
}
func (m *UpdateTagTemplateRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateTagTemplateRequest.Size(m)
}
func (m *UpdateTagTemplateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateTagTemplateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateTagTemplateRequest proto.InternalMessageInfo

func (m *UpdateTagTemplateRequest) GetTagTemplate() *TagTemplate {
	if m != nil {
		return m.TagTemplate
	}
	return nil
}

func (m *UpdateTagTemplateRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for
// [DeleteTagTemplate][google.cloud.datacatalog.v1beta1.DataCatalog.DeleteTagTemplate].
type DeleteTagTemplateRequest struct {
	// Required. The name of the tag template to delete. For example,
	// "projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Currently, this field must always be set to <code>true</code>.
	// This confirms the deletion of any possible tags using this template.
	// <code>force = false</code> will be supported in the future.
	Force                bool     `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteTagTemplateRequest) Reset()         { *m = DeleteTagTemplateRequest{} }
func (m *DeleteTagTemplateRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteTagTemplateRequest) ProtoMessage()    {}
func (*DeleteTagTemplateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{9}
}

func (m *DeleteTagTemplateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteTagTemplateRequest.Unmarshal(m, b)
}
func (m *DeleteTagTemplateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteTagTemplateRequest.Marshal(b, m, deterministic)
}
func (m *DeleteTagTemplateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteTagTemplateRequest.Merge(m, src)
}
func (m *DeleteTagTemplateRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteTagTemplateRequest.Size(m)
}
func (m *DeleteTagTemplateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteTagTemplateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteTagTemplateRequest proto.InternalMessageInfo

func (m *DeleteTagTemplateRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DeleteTagTemplateRequest) GetForce() bool {
	if m != nil {
		return m.Force
	}
	return false
}

// Request message for
// [CreateTag][google.cloud.datacatalog.v1beta1.DataCatalog.CreateTag].
type CreateTagRequest struct {
	// Required.
	// The name of the resource to attach this tag to. Tags can be attached to
	// Entries. (example:
	// "projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}/entries/{entry_id}").
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The tag to create.
	Tag                  *Tag     `protobuf:"bytes,2,opt,name=tag,proto3" json:"tag,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateTagRequest) Reset()         { *m = CreateTagRequest{} }
func (m *CreateTagRequest) String() string { return proto.CompactTextString(m) }
func (*CreateTagRequest) ProtoMessage()    {}
func (*CreateTagRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{10}
}

func (m *CreateTagRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateTagRequest.Unmarshal(m, b)
}
func (m *CreateTagRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateTagRequest.Marshal(b, m, deterministic)
}
func (m *CreateTagRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateTagRequest.Merge(m, src)
}
func (m *CreateTagRequest) XXX_Size() int {
	return xxx_messageInfo_CreateTagRequest.Size(m)
}
func (m *CreateTagRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateTagRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateTagRequest proto.InternalMessageInfo

func (m *CreateTagRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateTagRequest) GetTag() *Tag {
	if m != nil {
		return m.Tag
	}
	return nil
}

// Request message for
// [UpdateTag][google.cloud.datacatalog.v1beta1.DataCatalog.UpdateTag].
type UpdateTagRequest struct {
	// Required. The updated tag.
	Tag *Tag `protobuf:"bytes,1,opt,name=tag,proto3" json:"tag,omitempty"`
	// Optional. The fields to update on the Tag.  If absent or empty, all
	// modifiable fields are updated. Currently the only modifiable field is the
	// field `fields`.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateTagRequest) Reset()         { *m = UpdateTagRequest{} }
func (m *UpdateTagRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateTagRequest) ProtoMessage()    {}
func (*UpdateTagRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{11}
}

func (m *UpdateTagRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateTagRequest.Unmarshal(m, b)
}
func (m *UpdateTagRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateTagRequest.Marshal(b, m, deterministic)
}
func (m *UpdateTagRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateTagRequest.Merge(m, src)
}
func (m *UpdateTagRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateTagRequest.Size(m)
}
func (m *UpdateTagRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateTagRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateTagRequest proto.InternalMessageInfo

func (m *UpdateTagRequest) GetTag() *Tag {
	if m != nil {
		return m.Tag
	}
	return nil
}

func (m *UpdateTagRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for
// [DeleteTag][google.cloud.datacatalog.v1beta1.DataCatalog.DeleteTag].
type DeleteTagRequest struct {
	// Required. The name of the tag to delete. For example,
	// "projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}/entries/{entry_id}/tags/{tag_id}".
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteTagRequest) Reset()         { *m = DeleteTagRequest{} }
func (m *DeleteTagRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteTagRequest) ProtoMessage()    {}
func (*DeleteTagRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{12}
}

func (m *DeleteTagRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteTagRequest.Unmarshal(m, b)
}
func (m *DeleteTagRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteTagRequest.Marshal(b, m, deterministic)
}
func (m *DeleteTagRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteTagRequest.Merge(m, src)
}
func (m *DeleteTagRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteTagRequest.Size(m)
}
func (m *DeleteTagRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteTagRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteTagRequest proto.InternalMessageInfo

func (m *DeleteTagRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for
// [CreateTagTemplateField][google.cloud.datacatalog.v1beta1.DataCatalog.CreateTagTemplateField].
type CreateTagTemplateFieldRequest struct {
	// Required. The name of the project this template is in. Example:
	// "projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The id of the tag template field to create.
	// Field ids can contain letters (both uppercase and lowercase), numbers
	// (0-9), underscores (_) and dashes (-). Field ids must be at least 1
	// character long and at most 128 characters long. Field ids must also be
	// unique to their template.
	TagTemplateFieldId string `protobuf:"bytes,2,opt,name=tag_template_field_id,json=tagTemplateFieldId,proto3" json:"tag_template_field_id,omitempty"`
	// Required. The tag template field to create.
	TagTemplateField     *TagTemplateField `protobuf:"bytes,3,opt,name=tag_template_field,json=tagTemplateField,proto3" json:"tag_template_field,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *CreateTagTemplateFieldRequest) Reset()         { *m = CreateTagTemplateFieldRequest{} }
func (m *CreateTagTemplateFieldRequest) String() string { return proto.CompactTextString(m) }
func (*CreateTagTemplateFieldRequest) ProtoMessage()    {}
func (*CreateTagTemplateFieldRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{13}
}

func (m *CreateTagTemplateFieldRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateTagTemplateFieldRequest.Unmarshal(m, b)
}
func (m *CreateTagTemplateFieldRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateTagTemplateFieldRequest.Marshal(b, m, deterministic)
}
func (m *CreateTagTemplateFieldRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateTagTemplateFieldRequest.Merge(m, src)
}
func (m *CreateTagTemplateFieldRequest) XXX_Size() int {
	return xxx_messageInfo_CreateTagTemplateFieldRequest.Size(m)
}
func (m *CreateTagTemplateFieldRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateTagTemplateFieldRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateTagTemplateFieldRequest proto.InternalMessageInfo

func (m *CreateTagTemplateFieldRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateTagTemplateFieldRequest) GetTagTemplateFieldId() string {
	if m != nil {
		return m.TagTemplateFieldId
	}
	return ""
}

func (m *CreateTagTemplateFieldRequest) GetTagTemplateField() *TagTemplateField {
	if m != nil {
		return m.TagTemplateField
	}
	return nil
}

// Request message for
// [UpdateTagTemplateField][google.cloud.datacatalog.v1beta1.DataCatalog.UpdateTagTemplateField].
type UpdateTagTemplateFieldRequest struct {
	// Required. The name of the tag template field. For example,
	// "projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}/fields/{tag_template_field_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The template to update.
	TagTemplateField *TagTemplateField `protobuf:"bytes,2,opt,name=tag_template_field,json=tagTemplateField,proto3" json:"tag_template_field,omitempty"`
	// Optional. The field mask specifies the parts of the template to overwrite.
	// Allowed fields:
	//
	//   * display_name
	//   * type.enum_type
	//
	// If update_mask is omitted, all of the allowed fields above will be updated.
	//
	// When updating an enum type, the provided values will be merged with the
	// existing values. Therefore, enum values can only be added, existing enum
	// values cannot be deleted nor renamed.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateTagTemplateFieldRequest) Reset()         { *m = UpdateTagTemplateFieldRequest{} }
func (m *UpdateTagTemplateFieldRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateTagTemplateFieldRequest) ProtoMessage()    {}
func (*UpdateTagTemplateFieldRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{14}
}

func (m *UpdateTagTemplateFieldRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateTagTemplateFieldRequest.Unmarshal(m, b)
}
func (m *UpdateTagTemplateFieldRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateTagTemplateFieldRequest.Marshal(b, m, deterministic)
}
func (m *UpdateTagTemplateFieldRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateTagTemplateFieldRequest.Merge(m, src)
}
func (m *UpdateTagTemplateFieldRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateTagTemplateFieldRequest.Size(m)
}
func (m *UpdateTagTemplateFieldRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateTagTemplateFieldRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateTagTemplateFieldRequest proto.InternalMessageInfo

func (m *UpdateTagTemplateFieldRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateTagTemplateFieldRequest) GetTagTemplateField() *TagTemplateField {
	if m != nil {
		return m.TagTemplateField
	}
	return nil
}

func (m *UpdateTagTemplateFieldRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for
// [RenameTagTemplateField][google.cloud.datacatalog.v1beta1.DataCatalog.RenameTagTemplateField].
type RenameTagTemplateFieldRequest struct {
	// Required. The name of the tag template. For example,
	// "projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}/fields/{tag_template_field_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The new ID of this tag template field. For example,
	// "my_new_field".
	NewTagTemplateFieldId string   `protobuf:"bytes,2,opt,name=new_tag_template_field_id,json=newTagTemplateFieldId,proto3" json:"new_tag_template_field_id,omitempty"`
	XXX_NoUnkeyedLiteral  struct{} `json:"-"`
	XXX_unrecognized      []byte   `json:"-"`
	XXX_sizecache         int32    `json:"-"`
}

func (m *RenameTagTemplateFieldRequest) Reset()         { *m = RenameTagTemplateFieldRequest{} }
func (m *RenameTagTemplateFieldRequest) String() string { return proto.CompactTextString(m) }
func (*RenameTagTemplateFieldRequest) ProtoMessage()    {}
func (*RenameTagTemplateFieldRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{15}
}

func (m *RenameTagTemplateFieldRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RenameTagTemplateFieldRequest.Unmarshal(m, b)
}
func (m *RenameTagTemplateFieldRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RenameTagTemplateFieldRequest.Marshal(b, m, deterministic)
}
func (m *RenameTagTemplateFieldRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RenameTagTemplateFieldRequest.Merge(m, src)
}
func (m *RenameTagTemplateFieldRequest) XXX_Size() int {
	return xxx_messageInfo_RenameTagTemplateFieldRequest.Size(m)
}
func (m *RenameTagTemplateFieldRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RenameTagTemplateFieldRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RenameTagTemplateFieldRequest proto.InternalMessageInfo

func (m *RenameTagTemplateFieldRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *RenameTagTemplateFieldRequest) GetNewTagTemplateFieldId() string {
	if m != nil {
		return m.NewTagTemplateFieldId
	}
	return ""
}

// Request message for
// [DeleteTagTemplateField][google.cloud.datacatalog.v1beta1.DataCatalog.DeleteTagTemplateField].
type DeleteTagTemplateFieldRequest struct {
	// Required. The name of the tag template field to delete. For example,
	// "projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}/fields/{tag_template_field_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Currently, this field must always be set to <code>true</code>.
	// This confirms the deletion of this field from any tags using this field.
	// <code>force = false</code> will be supported in the future.
	Force                bool     `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteTagTemplateFieldRequest) Reset()         { *m = DeleteTagTemplateFieldRequest{} }
func (m *DeleteTagTemplateFieldRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteTagTemplateFieldRequest) ProtoMessage()    {}
func (*DeleteTagTemplateFieldRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{16}
}

func (m *DeleteTagTemplateFieldRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteTagTemplateFieldRequest.Unmarshal(m, b)
}
func (m *DeleteTagTemplateFieldRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteTagTemplateFieldRequest.Marshal(b, m, deterministic)
}
func (m *DeleteTagTemplateFieldRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteTagTemplateFieldRequest.Merge(m, src)
}
func (m *DeleteTagTemplateFieldRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteTagTemplateFieldRequest.Size(m)
}
func (m *DeleteTagTemplateFieldRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteTagTemplateFieldRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteTagTemplateFieldRequest proto.InternalMessageInfo

func (m *DeleteTagTemplateFieldRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DeleteTagTemplateFieldRequest) GetForce() bool {
	if m != nil {
		return m.Force
	}
	return false
}

// Request message for
// [ListTags][google.cloud.datacatalog.v1beta1.DataCatalog.ListTags].
type ListTagsRequest struct {
	// Required. The name of the Data Catalog resource to list the tags of. The
	// resource could be an [Entry][google.cloud.datacatalog.v1beta1.Entry].
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of tags to return. Default is 10. Max limit is
	// 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Token that specifies which page is requested. If empty, the first
	// page is returned.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTagsRequest) Reset()         { *m = ListTagsRequest{} }
func (m *ListTagsRequest) String() string { return proto.CompactTextString(m) }
func (*ListTagsRequest) ProtoMessage()    {}
func (*ListTagsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{17}
}

func (m *ListTagsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTagsRequest.Unmarshal(m, b)
}
func (m *ListTagsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTagsRequest.Marshal(b, m, deterministic)
}
func (m *ListTagsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTagsRequest.Merge(m, src)
}
func (m *ListTagsRequest) XXX_Size() int {
	return xxx_messageInfo_ListTagsRequest.Size(m)
}
func (m *ListTagsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTagsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListTagsRequest proto.InternalMessageInfo

func (m *ListTagsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListTagsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListTagsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for
// [ListTags][google.cloud.datacatalog.v1beta1.DataCatalog.ListTags].
type ListTagsResponse struct {
	// [Tag][google.cloud.datacatalog.v1beta1.Tag] details.
	Tags []*Tag `protobuf:"bytes,1,rep,name=tags,proto3" json:"tags,omitempty"`
	// Token to retrieve the next page of results. It is set to empty if no items
	// remain in results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTagsResponse) Reset()         { *m = ListTagsResponse{} }
func (m *ListTagsResponse) String() string { return proto.CompactTextString(m) }
func (*ListTagsResponse) ProtoMessage()    {}
func (*ListTagsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_2054d97e7b16f897, []int{18}
}

func (m *ListTagsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTagsResponse.Unmarshal(m, b)
}
func (m *ListTagsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTagsResponse.Marshal(b, m, deterministic)
}
func (m *ListTagsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTagsResponse.Merge(m, src)
}
func (m *ListTagsResponse) XXX_Size() int {
	return xxx_messageInfo_ListTagsResponse.Size(m)
}
func (m *ListTagsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTagsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListTagsResponse proto.InternalMessageInfo

func (m *ListTagsResponse) GetTags() []*Tag {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *ListTagsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterEnum("google.cloud.datacatalog.v1beta1.EntryType", EntryType_name, EntryType_value)
	proto.RegisterType((*SearchCatalogRequest)(nil), "google.cloud.datacatalog.v1beta1.SearchCatalogRequest")
	proto.RegisterType((*SearchCatalogRequest_Scope)(nil), "google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope")
	proto.RegisterType((*SearchCatalogResponse)(nil), "google.cloud.datacatalog.v1beta1.SearchCatalogResponse")
	proto.RegisterType((*UpdateEntryRequest)(nil), "google.cloud.datacatalog.v1beta1.UpdateEntryRequest")
	proto.RegisterType((*GetEntryRequest)(nil), "google.cloud.datacatalog.v1beta1.GetEntryRequest")
	proto.RegisterType((*LookupEntryRequest)(nil), "google.cloud.datacatalog.v1beta1.LookupEntryRequest")
	proto.RegisterType((*Entry)(nil), "google.cloud.datacatalog.v1beta1.Entry")
	proto.RegisterType((*CreateTagTemplateRequest)(nil), "google.cloud.datacatalog.v1beta1.CreateTagTemplateRequest")
	proto.RegisterType((*GetTagTemplateRequest)(nil), "google.cloud.datacatalog.v1beta1.GetTagTemplateRequest")
	proto.RegisterType((*UpdateTagTemplateRequest)(nil), "google.cloud.datacatalog.v1beta1.UpdateTagTemplateRequest")
	proto.RegisterType((*DeleteTagTemplateRequest)(nil), "google.cloud.datacatalog.v1beta1.DeleteTagTemplateRequest")
	proto.RegisterType((*CreateTagRequest)(nil), "google.cloud.datacatalog.v1beta1.CreateTagRequest")
	proto.RegisterType((*UpdateTagRequest)(nil), "google.cloud.datacatalog.v1beta1.UpdateTagRequest")
	proto.RegisterType((*DeleteTagRequest)(nil), "google.cloud.datacatalog.v1beta1.DeleteTagRequest")
	proto.RegisterType((*CreateTagTemplateFieldRequest)(nil), "google.cloud.datacatalog.v1beta1.CreateTagTemplateFieldRequest")
	proto.RegisterType((*UpdateTagTemplateFieldRequest)(nil), "google.cloud.datacatalog.v1beta1.UpdateTagTemplateFieldRequest")
	proto.RegisterType((*RenameTagTemplateFieldRequest)(nil), "google.cloud.datacatalog.v1beta1.RenameTagTemplateFieldRequest")
	proto.RegisterType((*DeleteTagTemplateFieldRequest)(nil), "google.cloud.datacatalog.v1beta1.DeleteTagTemplateFieldRequest")
	proto.RegisterType((*ListTagsRequest)(nil), "google.cloud.datacatalog.v1beta1.ListTagsRequest")
	proto.RegisterType((*ListTagsResponse)(nil), "google.cloud.datacatalog.v1beta1.ListTagsResponse")
}

func init() {
	proto.RegisterFile("google/cloud/datacatalog/v1beta1/datacatalog.proto", fileDescriptor_2054d97e7b16f897)
}

var fileDescriptor_2054d97e7b16f897 = []byte{
	// 1904 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x59, 0xcb, 0x73, 0x1b, 0x49,
	0x19, 0x4f, 0xdb, 0x56, 0x62, 0x7d, 0x72, 0x62, 0xbb, 0x37, 0x76, 0x14, 0x25, 0x06, 0x31, 0xd4,
	0xee, 0x7a, 0x95, 0x8a, 0x54, 0xd6, 0x12, 0xc2, 0x6a, 0x49, 0x76, 0xed, 0x58, 0xf1, 0x9a, 0x38,
	0x59, 0x65, 0xa4, 0x05, 0x76, 0x2f, 0xc3, 0x78, 0xa6, 0x33, 0x1e, 0x3c, 0xa3, 0x99, 0x4c, 0xb7,
	0xe2, 0xd5, 0x52, 0x7b, 0xe1, 0xc4, 0x85, 0x2a, 0xaa, 0xb8, 0x52, 0x9c, 0xa8, 0xad, 0xa2, 0x8a,
	0xe2, 0x4a, 0xc1, 0x81, 0x02, 0x8e, 0xc0, 0x69, 0xb9, 0x70, 0xe3, 0xc2, 0x01, 0xfe, 0x83, 0x1c,
	0xa9, 0xee, 0xe9, 0xd1, 0x63, 0x34, 0xb2, 0x46, 0x52, 0x8a, 0x53, 0x32, 0xfd, 0x3d, 0xfa, 0xf7,
	0xbd, 0xba, 0x7f, 0x6d, 0x41, 0xd5, 0xf2, 0x3c, 0xcb, 0x21, 0x15, 0xc3, 0xf1, 0x3a, 0x66, 0xc5,
	0xd4, 0x99, 0x6e, 0xe8, 0x4c, 0x77, 0x3c, 0xab, 0xf2, 0x62, 0xe7, 0x98, 0x30, 0x7d, 0x67, 0x70,
	0xad, 0xec, 0x07, 0x1e, 0xf3, 0x70, 0x31, 0xb4, 0x29, 0x0b, 0x9b, 0xf2, 0xa0, 0x5c, 0xda, 0x14,
	0x6e, 0x4a, 0xaf, 0xba, 0x6f, 0x57, 0xf4, 0x76, 0xdb, 0x63, 0x3a, 0xb3, 0xbd, 0x36, 0x0d, 0xed,
	0x0b, 0xb7, 0x27, 0xee, 0x49, 0x8d, 0x13, 0xe2, 0xea, 0xe9, 0xd5, 0x89, 0x1e, 0x18, 0x27, 0x52,
	0x7d, 0x67, 0xa2, 0x3a, 0xd3, 0x8f, 0x1d, 0xa2, 0x51, 0x9f, 0x18, 0xd2, 0xe4, 0x56, 0x0a, 0x13,
	0x8b, 0xa6, 0xf7, 0x6f, 0xbb, 0x84, 0x32, 0xdd, 0xf5, 0x23, 0x93, 0xaf, 0x48, 0x13, 0x5b, 0x77,
	0x2b, 0x2f, 0x76, 0xf8, 0x3f, 0x9a, 0xef, 0x39, 0xb6, 0xd1, 0x95, 0xf2, 0xc2, 0xb0, 0x7c, 0x48,
	0x76, 0x43, 0xca, 0xc4, 0xd7, 0x71, 0xe7, 0x59, 0x85, 0xb8, 0x3e, 0x8b, 0x84, 0xc5, 0xb8, 0xf0,
	0x99, 0x4d, 0x1c, 0x53, 0x73, 0x75, 0x7a, 0x2a, 0x35, 0xae, 0x0d, 0x54, 0xc2, 0x70, 0x6c, 0xd2,
	0x66, 0xa1, 0x40, 0x79, 0xb9, 0x00, 0x57, 0x9b, 0x22, 0x6f, 0x0f, 0x42, 0xf8, 0x2a, 0x79, 0xde,
	0x21, 0x94, 0x61, 0x15, 0x32, 0xd4, 0xf0, 0x7c, 0x92, 0xbf, 0x58, 0x44, 0xdb, 0xb9, 0xea, 0xb7,
	0xcb, 0x93, 0xaa, 0x5d, 0x4e, 0x72, 0x53, 0x6e, 0x72, 0x1f, 0x6a, 0xe8, 0x0a, 0x5f, 0x85, 0xcc,
	0xf3, 0x0e, 0x09, 0xba, 0x79, 0x54, 0x44, 0xdb, 0x59, 0x35, 0xfc, 0xc0, 0x37, 0x20, 0xeb, 0xeb,
	0x16, 0xd1, 0xa8, 0xfd, 0x19, 0xc9, 0x2f, 0x14, 0xd1, 0x76, 0x46, 0x5d, 0xe6, 0x0b, 0x4d, 0xfb,
	0x33, 0x82, 0xb7, 0x00, 0x84, 0x90, 0x79, 0xa7, 0xa4, 0x9d, 0x5f, 0x14, 0x76, 0x42, 0xbd, 0xc5,
	0x17, 0xf0, 0x75, 0x58, 0xf6, 0x02, 0x93, 0x04, 0xda, 0x71, 0x37, 0x9f, 0x11, 0xc2, 0x4b, 0xe2,
	0x7b, 0xaf, 0x5b, 0xf8, 0x25, 0x82, 0x8c, 0xd8, 0x1d, 0xbf, 0x01, 0xab, 0x76, 0xdb, 0x70, 0x3a,
	0x26, 0xd1, 0xbc, 0xc0, 0xd2, 0x6c, 0x93, 0xe6, 0x17, 0x8a, 0x8b, 0xdb, 0x59, 0xf5, 0xb2, 0x5c,
	0xfe, 0x30, 0xb0, 0x0e, 0x4d, 0x8a, 0xcb, 0xf0, 0x5a, 0xa4, 0xe7, 0x07, 0xde, 0x0f, 0x89, 0xc1,
	0x84, 0xee, 0xa2, 0xd0, 0x5d, 0x97, 0xa2, 0x46, 0x28, 0xe1, 0xfa, 0xf7, 0xe0, 0x46, 0xa4, 0x6f,
	0x19, 0xbe, 0xe6, 0x77, 0x8e, 0x1d, 0xdb, 0xd0, 0x78, 0x6a, 0x28, 0x61, 0x34, 0x7f, 0xa9, 0x88,
	0xb6, 0x97, 0xd5, 0xbc, 0x54, 0x39, 0x30, 0xfc, 0x86, 0x50, 0xd8, 0x97, 0x72, 0xe5, 0x67, 0x08,
	0x36, 0x62, 0x39, 0xa3, 0xbe, 0xd7, 0xa6, 0x04, 0x7f, 0x08, 0x97, 0x02, 0x42, 0x3b, 0x0e, 0xa3,
	0x79, 0x54, 0x5c, 0xdc, 0xce, 0x55, 0xef, 0x4c, 0x9d, 0x7d, 0x6e, 0xad, 0x46, 0x5e, 0x78, 0x06,
	0xda, 0xe4, 0x53, 0xa6, 0x8d, 0xa4, 0xf2, 0x32, 0x5f, 0x6e, 0x44, 0xe9, 0xe4, 0x90, 0xf0, 0x47,
	0xbe, 0xa9, 0x33, 0x52, 0x6f, 0xb3, 0xa0, 0x1b, 0xf5, 0xc2, 0x3d, 0xc8, 0x10, 0xfe, 0x2d, 0xea,
	0x96, 0xab, 0xbe, 0x39, 0x19, 0x4d, 0x68, 0x1e, 0x5a, 0xe1, 0x77, 0x21, 0xd7, 0x11, 0x4e, 0x45,
	0x47, 0x8a, 0x12, 0xe7, 0xaa, 0x85, 0xc8, 0x49, 0xd4, 0xb4, 0xe5, 0x87, 0xbc, 0x69, 0x1f, 0xeb,
	0xf4, 0x54, 0x85, 0x50, 0x9d, 0xff, 0x5f, 0x79, 0x1d, 0x56, 0x0f, 0x08, 0x1b, 0x82, 0x83, 0x61,
	0xa9, 0xad, 0xbb, 0x44, 0x76, 0x91, 0xf8, 0xbf, 0x42, 0x01, 0x1f, 0x79, 0xde, 0x69, 0xc7, 0x1f,
	0xd2, 0x7c, 0x0b, 0x56, 0x1d, 0xbb, 0x7d, 0x4a, 0x4c, 0x2d, 0x20, 0xd4, 0xeb, 0x04, 0x86, 0x34,
	0xfa, 0xe0, 0x82, 0x7a, 0x25, 0x14, 0xa8, 0x72, 0x1d, 0x7f, 0x1d, 0x56, 0xe8, 0x73, 0xa7, 0xaf,
	0xb7, 0x28, 0xf5, 0x72, 0xf4, 0xb9, 0x13, 0x29, 0xed, 0x5d, 0x86, 0x1c, 0xd3, 0x03, 0x8b, 0x30,
	0x4d, 0x6c, 0xfa, 0x9f, 0x25, 0xc8, 0x88, 0xfd, 0x92, 0x20, 0xe1, 0x37, 0x47, 0x37, 0xcf, 0x0a,
	0x71, 0x7c, 0xeb, 0xf7, 0x60, 0x89, 0x75, 0xfd, 0xb0, 0xf7, 0xaf, 0x54, 0x6f, 0xa5, 0xcc, 0x6e,
	0xab, 0xeb, 0x13, 0x55, 0x18, 0x62, 0x02, 0xaf, 0x1d, 0xdb, 0x96, 0x98, 0x26, 0xad, 0x7f, 0xaa,
	0xe5, 0x57, 0x44, 0xa2, 0xdf, 0x9e, 0xec, 0x6f, 0xcf, 0xb6, 0x9e, 0x72, 0xe3, 0x16, 0xb7, 0x6d,
	0xfa, 0xc4, 0xf8, 0xe0, 0x82, 0xba, 0x1e, 0x79, 0xec, 0x2d, 0xe2, 0x4f, 0xa1, 0xd0, 0xdb, 0x46,
	0x94, 0x93, 0x9e, 0xe8, 0x81, 0x49, 0xcc, 0x70, 0xb7, 0x55, 0xb1, 0xdb, 0x3b, 0xe9, 0x77, 0xdb,
	0xd7, 0x19, 0x69, 0x86, 0x1e, 0xe4, 0x9e, 0xd7, 0x22, 0xf7, 0x31, 0x11, 0xfe, 0x1a, 0xac, 0x98,
	0x36, 0xf5, 0x1d, 0xbd, 0x2b, 0x12, 0x2f, 0x9b, 0x37, 0x27, 0xd7, 0x9e, 0xf0, 0x6c, 0x17, 0x21,
	0x67, 0x12, 0x6a, 0x04, 0xb6, 0xcf, 0xef, 0x98, 0xfc, 0x92, 0xd4, 0xe8, 0x2f, 0xe1, 0xf7, 0xe1,
	0x62, 0x78, 0xa1, 0x88, 0x93, 0x22, 0x57, 0xdd, 0x4e, 0x31, 0x54, 0x42, 0x5f, 0x95, 0x76, 0xd8,
	0x81, 0x7c, 0x58, 0x32, 0x8d, 0x76, 0x29, 0x23, 0xae, 0xd6, 0x3f, 0xe2, 0xc5, 0xb4, 0xe7, 0xaa,
	0xd5, 0x14, 0x3e, 0x85, 0x69, 0xab, 0x67, 0xa9, 0x6e, 0x86, 0x3e, 0xe3, 0xeb, 0x7b, 0x39, 0xc8,
	0xf2, 0xea, 0x8a, 0xec, 0x2a, 0xbf, 0x41, 0x90, 0x7f, 0x10, 0x10, 0x9d, 0x91, 0x96, 0x6e, 0xb5,
	0x88, 0xeb, 0x3b, 0x3a, 0x23, 0x51, 0x9b, 0x6f, 0xc2, 0x45, 0x5f, 0x0f, 0x48, 0x9b, 0xc9, 0xfe,
	0x93, 0x5f, 0x7c, 0xec, 0x99, 0x6e, 0x69, 0x4c, 0xaa, 0x6b, 0xb6, 0x19, 0x8d, 0x3d, 0xeb, 0x3b,
	0x39, 0x34, 0x71, 0x03, 0x56, 0x06, 0xf5, 0xe4, 0x84, 0xde, 0x9e, 0x1c, 0xcb, 0x20, 0x96, 0xdc,
	0x80, 0x4f, 0xe5, 0x16, 0x6c, 0x1c, 0x10, 0x96, 0x00, 0x35, 0x69, 0x76, 0x7f, 0x8d, 0x20, 0x1f,
	0x9e, 0x3a, 0x09, 0x06, 0x71, 0x6c, 0x68, 0x5e, 0x6c, 0xf3, 0x1d, 0x47, 0xfb, 0x90, 0xdf, 0x27,
	0x0e, 0x49, 0x84, 0x9a, 0x74, 0x08, 0x5c, 0x85, 0xcc, 0x33, 0x8f, 0x8f, 0xfe, 0x82, 0xb8, 0x0d,
	0xc2, 0x0f, 0xc5, 0x80, 0xb5, 0x5e, 0x31, 0x27, 0x15, 0xf1, 0x2e, 0x2c, 0x32, 0xdd, 0x92, 0x30,
	0x5f, 0x4f, 0x15, 0xb7, 0xca, 0x2d, 0x94, 0x9f, 0x20, 0x58, 0xeb, 0xa5, 0x35, 0xda, 0x45, 0x7a,
	0x43, 0xd3, 0x7a, 0x9b, 0x2f, 0x6b, 0x6f, 0xc0, 0x5a, 0x2f, 0x6b, 0xe7, 0x75, 0xc2, 0xdf, 0x11,
	0x6c, 0x8d, 0x74, 0xb9, 0x70, 0x39, 0x29, 0x4b, 0x3b, 0xb0, 0x31, 0xd4, 0xea, 0x21, 0x03, 0xb2,
	0x4d, 0x01, 0x34, 0xab, 0x62, 0x16, 0xf3, 0x77, 0x68, 0xe2, 0x1f, 0x00, 0x1e, 0x35, 0x11, 0x03,
	0x92, 0x6a, 0x8e, 0x47, 0x10, 0xae, 0xc5, 0xf7, 0x50, 0xbe, 0x44, 0xb0, 0x35, 0xd2, 0xd8, 0x43,
	0xe1, 0x24, 0xb5, 0x4c, 0x32, 0xae, 0x85, 0x57, 0x87, 0x2b, 0x5e, 0xcb, 0xc5, 0xa9, 0x6a, 0xe9,
	0xc2, 0x96, 0x4a, 0x38, 0xd0, 0x69, 0x62, 0xfa, 0x16, 0x5c, 0x6f, 0x93, 0x33, 0xed, 0xbc, 0x12,
	0x6d, 0xb4, 0xc9, 0x59, 0x6b, 0xa4, 0x4a, 0xca, 0x21, 0x6c, 0x8d, 0x0c, 0xdc, 0xc4, 0xed, 0x92,
	0xa7, 0x8e, 0xc0, 0xea, 0x91, 0x4d, 0xf9, 0xa9, 0x44, 0x27, 0xb5, 0xd3, 0x1c, 0x9c, 0x54, 0xe9,
	0xc0, 0x5a, 0x7f, 0x1b, 0xc9, 0xe8, 0xde, 0x81, 0x25, 0xfe, 0x76, 0x90, 0x74, 0x2e, 0xe5, 0xdc,
	0x09, 0x93, 0x24, 0xee, 0xb6, 0x90, 0xc0, 0xdd, 0x4a, 0x0f, 0x20, 0xdb, 0xe3, 0x05, 0xb8, 0x00,
	0x9b, 0xf5, 0x27, 0x2d, 0xf5, 0x63, 0xad, 0xf5, 0x71, 0xa3, 0xae, 0x7d, 0xf4, 0xa4, 0xd9, 0xa8,
	0x3f, 0x38, 0x7c, 0x78, 0x58, 0xdf, 0x5f, 0xbb, 0x80, 0xb3, 0x90, 0x69, 0xed, 0xee, 0x1d, 0xd5,
	0xd7, 0x16, 0xf0, 0x2a, 0xe4, 0xf6, 0x77, 0x5b, 0xbb, 0x5a, 0xb3, 0xa5, 0xd6, 0x77, 0x1f, 0xaf,
	0x2d, 0x56, 0x5f, 0xde, 0x84, 0x1c, 0x27, 0xa8, 0x92, 0x47, 0xe2, 0x5f, 0x21, 0xb8, 0x3c, 0xc4,
	0x2c, 0xf1, 0x37, 0x67, 0x7b, 0x08, 0x14, 0xee, 0x4e, 0x4f, 0x61, 0x45, 0xea, 0x14, 0xe5, 0xc7,
	0xff, 0xf8, 0xf7, 0xcf, 0x17, 0x6e, 0x2a, 0xd7, 0x7a, 0x0f, 0x2b, 0x69, 0x57, 0x0b, 0xdf, 0x7b,
	0x35, 0x54, 0xc2, 0x7f, 0x46, 0x90, 0x1b, 0xe0, 0xad, 0xf8, 0x1b, 0x93, 0x37, 0x1b, 0xa5, 0xb9,
	0x85, 0xb4, 0xbc, 0x56, 0x69, 0x0a, 0x48, 0x8f, 0xab, 0xfb, 0x3d, 0x48, 0x3f, 0x12, 0x4c, 0xb7,
	0xcc, 0x9b, 0xef, 0x9e, 0x7c, 0x3b, 0xd0, 0x4a, 0xa9, 0xe2, 0x78, 0x46, 0xf8, 0xe4, 0xad, 0x94,
	0x2a, 0x42, 0xe3, 0x20, 0xf0, 0x3a, 0x7e, 0xf4, 0x65, 0x13, 0x5a, 0x29, 0x7d, 0x5e, 0x93, 0x2c,
	0xf9, 0xb7, 0x08, 0x96, 0x23, 0xa6, 0x8b, 0x77, 0x26, 0x43, 0x89, 0xb1, 0xe2, 0xf4, 0xe8, 0x1f,
	0x0a, 0xf4, 0xef, 0xe3, 0xfb, 0x7d, 0xf4, 0xb3, 0xe0, 0xc6, 0x3f, 0x45, 0x90, 0x1b, 0xe0, 0xdc,
	0x69, 0x92, 0x3e, 0x4a, 0xd1, 0xd3, 0xc3, 0xfe, 0xaa, 0x80, 0x7d, 0x1d, 0xf7, 0xfb, 0x40, 0x62,
	0xa9, 0x39, 0xc2, 0x2b, 0xfe, 0x1b, 0x82, 0xf5, 0x91, 0xcb, 0x03, 0xd7, 0x26, 0xfb, 0x1f, 0xc7,
	0xab, 0x0a, 0xd3, 0xb1, 0x0c, 0xe5, 0x91, 0x40, 0x58, 0x57, 0xee, 0xf4, 0x13, 0x1b, 0x1e, 0x27,
	0x63, 0x52, 0xfb, 0x79, 0x65, 0xe0, 0x64, 0xa6, 0xb5, 0x21, 0x9e, 0x83, 0x7f, 0x87, 0xe0, 0xca,
	0x30, 0x85, 0xc2, 0x77, 0x53, 0x35, 0xc5, 0xfc, 0x71, 0xdc, 0x13, 0x71, 0xdc, 0xc5, 0x77, 0xd2,
	0x35, 0xc8, 0x60, 0x10, 0xbc, 0x2f, 0xfe, 0x89, 0x60, 0x7d, 0xe4, 0xd6, 0x4b, 0x53, 0x87, 0x71,
	0x1c, 0x70, 0x5a, 0xfc, 0xdf, 0x17, 0xf8, 0xd5, 0xea, 0x5e, 0x1f, 0xff, 0x60, 0x6a, 0xcb, 0x53,
	0x04, 0x13, 0x2b, 0xca, 0x17, 0x08, 0xd6, 0x47, 0x6e, 0xa3, 0x34, 0xa1, 0x8d, 0xe3, 0x8c, 0x85,
	0xcd, 0x91, 0x5b, 0xb7, 0xee, 0xfa, 0xac, 0x1b, 0xd5, 0xa0, 0x34, 0x63, 0x0d, 0xfe, 0x8b, 0x60,
	0x33, 0x99, 0x48, 0xe1, 0xf7, 0x66, 0x18, 0x88, 0xc1, 0x0b, 0xb7, 0x30, 0x03, 0x07, 0x51, 0x3e,
	0x11, 0xe1, 0xb4, 0x94, 0xfb, 0x29, 0x47, 0x23, 0x1e, 0x50, 0xf8, 0x17, 0x2d, 0x5a, 0x4b, 0x60,
	0x46, 0x22, 0xd6, 0x64, 0x96, 0x95, 0x26, 0xd6, 0x73, 0xf9, 0xd9, 0x3c, 0xb1, 0x56, 0xef, 0xcf,
	0x52, 0x3a, 0x19, 0x28, 0x6f, 0xbd, 0xa4, 0x58, 0xff, 0x85, 0x60, 0x33, 0x99, 0x7d, 0xa5, 0x89,
	0xf5, 0x5c, 0xde, 0x36, 0x53, 0xac, 0x0d, 0x11, 0xeb, 0x77, 0x94, 0xfa, 0x9c, 0xb1, 0x06, 0x02,
	0x19, 0xbf, 0xca, 0x7f, 0x8f, 0x60, 0x33, 0x99, 0xf0, 0xa5, 0x89, 0xf0, 0x5c, 0xaa, 0x38, 0x76,
	0xd8, 0xe4, 0x8d, 0x58, 0x9a, 0xb3, 0x62, 0xf8, 0x0f, 0x08, 0xb2, 0xbd, 0xd9, 0xc1, 0xd5, 0x29,
	0x06, 0x2d, 0x42, 0x98, 0x8e, 0x19, 0x2a, 0xaa, 0x00, 0x7c, 0x34, 0x98, 0xf6, 0xf3, 0xc7, 0x69,
	0xdc, 0x25, 0x2e, 0xfe, 0xa2, 0x5d, 0x13, 0x0f, 0xbc, 0x3f, 0x22, 0xc8, 0xf6, 0x86, 0x21, 0x0d,
	0xf8, 0xf8, 0xdb, 0x32, 0x2d, 0xf8, 0xef, 0x0a, 0xf0, 0x8d, 0xea, 0xe1, 0xd0, 0xf1, 0x3c, 0x0b,
	0x77, 0x12, 0xe8, 0x79, 0xfb, 0x88, 0x00, 0xbe, 0x40, 0x90, 0xed, 0xd5, 0x3f, 0x4d, 0x00, 0xf1,
	0x27, 0xe9, 0xd8, 0xfe, 0x78, 0x2c, 0x10, 0x1f, 0x94, 0xea, 0x73, 0x31, 0xa6, 0x08, 0x2d, 0xfe,
	0x13, 0x82, 0xe5, 0xe8, 0x85, 0x90, 0x86, 0xe9, 0xc5, 0x1e, 0x2d, 0x69, 0x06, 0x35, 0xfe, 0x00,
	0x89, 0x42, 0xc0, 0xaf, 0xa6, 0x63, 0xf0, 0x2f, 0x10, 0xac, 0x34, 0x09, 0x3b, 0xd4, 0xdd, 0x86,
	0xf8, 0x95, 0x02, 0x2b, 0x11, 0x26, 0x5b, 0x77, 0xcb, 0x2f, 0x38, 0x97, 0xef, 0x0b, 0x23, 0xdc,
	0x1b, 0x31, 0x9d, 0x50, 0xaa, 0x3c, 0x15, 0xd0, 0x1e, 0x29, 0x0f, 0xfb, 0xd0, 0xa2, 0x3f, 0x98,
	0xa6, 0xbd, 0xa5, 0xe9, 0xc0, 0x6e, 0xfc, 0x10, 0xe1, 0xf0, 0x0e, 0xce, 0x83, 0x77, 0xf0, 0x7f,
	0x85, 0x67, 0xc5, 0xe0, 0xfd, 0x05, 0x01, 0x6e, 0x11, 0x2a, 0x16, 0x49, 0xe0, 0xda, 0x94, 0x72,
	0x43, 0xbc, 0x1d, 0x03, 0x30, 0xaa, 0x12, 0x41, 0x7d, 0x2b, 0x85, 0xa6, 0x2c, 0xfc, 0xf7, 0x04,
	0xfc, 0xa7, 0xca, 0xd1, 0xec, 0xf0, 0xd9, 0x88, 0xf7, 0x1a, 0x2a, 0x15, 0x9e, 0xfc, 0x75, 0xb7,
	0x30, 0xd8, 0x7a, 0x21, 0x22, 0xdd, 0xb7, 0x69, 0xd9, 0xf0, 0xdc, 0x2f, 0x77, 0xcb, 0x27, 0x8c,
	0xf9, 0xb4, 0x56, 0xa9, 0x9c, 0x9d, 0x9d, 0xc5, 0x84, 0x15, 0xbd, 0xc3, 0x4e, 0xc2, 0x5f, 0xce,
	0x6e, 0xf3, 0x6d, 0x9e, 0x79, 0x81, 0xbb, 0xe7, 0xc3, 0x4d, 0xc3, 0x73, 0xc7, 0xb6, 0x76, 0x03,
	0x7d, 0xf2, 0x48, 0xca, 0x2c, 0xcf, 0xd1, 0xdb, 0x56, 0xd9, 0x0b, 0xac, 0x8a, 0x45, 0xda, 0x62,
	0x56, 0x2b, 0xfd, 0x0d, 0xc6, 0xff, 0x22, 0xf7, 0xee, 0xc0, 0xda, 0x4b, 0x84, 0x8e, 0x2f, 0x0a,
	0xd3, 0xb7, 0xff, 0x17, 0x00, 0x00, 0xff, 0xff, 0x96, 0xae, 0x5d, 0x62, 0xfd, 0x1c, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// DataCatalogClient is the client API for DataCatalog service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DataCatalogClient interface {
	// Searches Data Catalog for multiple resources like entries, tags that
	// match a query.
	//
	// This is a custom method
	// (https://cloud.google.com/apis/design/custom_methods) and does not return
	// the complete resource, only the resource identifier and high level
	// fields. Clients can subsequentally call Get methods.
	//
	// See [Data Catalog Search
	// Syntax](/data-catalog/docs/how-to/search-reference)
	SearchCatalog(ctx context.Context, in *SearchCatalogRequest, opts ...grpc.CallOption) (*SearchCatalogResponse, error)
	// Updates an existing entry.
	UpdateEntry(ctx context.Context, in *UpdateEntryRequest, opts ...grpc.CallOption) (*Entry, error)
	// Gets an entry.
	GetEntry(ctx context.Context, in *GetEntryRequest, opts ...grpc.CallOption) (*Entry, error)
	// Get an entry by target resource name. This method allows clients to use
	// the resource name from the source Google Cloud Platform service to get the
	// Data Catalog Entry.
	LookupEntry(ctx context.Context, in *LookupEntryRequest, opts ...grpc.CallOption) (*Entry, error)
	// Creates a tag template.
	CreateTagTemplate(ctx context.Context, in *CreateTagTemplateRequest, opts ...grpc.CallOption) (*TagTemplate, error)
	// Gets a tag template.
	GetTagTemplate(ctx context.Context, in *GetTagTemplateRequest, opts ...grpc.CallOption) (*TagTemplate, error)
	// Updates a tag template. This method cannot be used to update the fields of
	// a template. The tag template fields are represented as separate resources
	// and should be updated using their own create/update/delete methods.
	UpdateTagTemplate(ctx context.Context, in *UpdateTagTemplateRequest, opts ...grpc.CallOption) (*TagTemplate, error)
	// Deletes a tag template and all tags using the template.
	DeleteTagTemplate(ctx context.Context, in *DeleteTagTemplateRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Creates a field in a tag template.
	CreateTagTemplateField(ctx context.Context, in *CreateTagTemplateFieldRequest, opts ...grpc.CallOption) (*TagTemplateField, error)
	// Updates a field in a tag template. This method cannot be used to update the
	// field type.
	UpdateTagTemplateField(ctx context.Context, in *UpdateTagTemplateFieldRequest, opts ...grpc.CallOption) (*TagTemplateField, error)
	// Renames a field in a tag template.
	RenameTagTemplateField(ctx context.Context, in *RenameTagTemplateFieldRequest, opts ...grpc.CallOption) (*TagTemplateField, error)
	// Deletes a field in a tag template and all uses of that field.
	DeleteTagTemplateField(ctx context.Context, in *DeleteTagTemplateFieldRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Creates a tag on an [Entry][google.cloud.datacatalog.v1beta1.Entry].
	CreateTag(ctx context.Context, in *CreateTagRequest, opts ...grpc.CallOption) (*Tag, error)
	// Updates an existing tag.
	UpdateTag(ctx context.Context, in *UpdateTagRequest, opts ...grpc.CallOption) (*Tag, error)
	// Deletes a tag.
	DeleteTag(ctx context.Context, in *DeleteTagRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Lists the tags on an [Entry][google.cloud.datacatalog.v1beta1.Entry].
	ListTags(ctx context.Context, in *ListTagsRequest, opts ...grpc.CallOption) (*ListTagsResponse, error)
	// Sets the access control policy for a resource. Replaces any existing
	// policy.
	// Supported resources are:
	//   - Tag templates.
	// Note, this method cannot be used to manage policies for BigQuery, Cloud
	// Pub/Sub and any external Google Cloud Platform resources synced to Cloud
	// Data Catalog.
	//
	// Callers must have following Google IAM permission
	// `datacatalog.tagTemplates.setIamPolicy` to set policies on tag templates.
	SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Gets the access control policy for a resource. A `NOT_FOUND` error
	// is returned if the resource does not exist. An empty policy is returned
	// if the resource exists but does not have a policy set on it.
	//
	// Supported resources are:
	//   - Tag templates.
	// Note, this method cannot be used to manage policies for BigQuery, Cloud
	// Pub/Sub and any external Google Cloud Platform resources synced to Cloud
	// Data Catalog.
	//
	// Callers must have following Google IAM permission
	// `datacatalog.tagTemplates.getIamPolicy` to get policies on tag templates.
	GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Returns the caller's permissions on a resource.
	// If the resource does not exist, an empty set of permissions is returned
	// (We don't return a `NOT_FOUND` error).
	//
	// Supported resource are:
	//   - tag templates.
	// Note, this method cannot be used to manage policies for BigQuery, Cloud
	// Pub/Sub and any external Google Cloud Platform resources synced to Cloud
	// Data Catalog.
	//
	// A caller is not required to have Google IAM permission to make this
	// request.
	TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error)
}

type dataCatalogClient struct {
	cc *grpc.ClientConn
}

func NewDataCatalogClient(cc *grpc.ClientConn) DataCatalogClient {
	return &dataCatalogClient{cc}
}

func (c *dataCatalogClient) SearchCatalog(ctx context.Context, in *SearchCatalogRequest, opts ...grpc.CallOption) (*SearchCatalogResponse, error) {
	out := new(SearchCatalogResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.DataCatalog/SearchCatalog", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) UpdateEntry(ctx context.Context, in *UpdateEntryRequest, opts ...grpc.CallOption) (*Entry, error) {
	out := new(Entry)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.DataCatalog/UpdateEntry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) GetEntry(ctx context.Context, in *GetEntryRequest, opts ...grpc.CallOption) (*Entry, error) {
	out := new(Entry)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.DataCatalog/GetEntry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) LookupEntry(ctx context.Context, in *LookupEntryRequest, opts ...grpc.CallOption) (*Entry, error) {
	out := new(Entry)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.DataCatalog/LookupEntry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) CreateTagTemplate(ctx context.Context, in *CreateTagTemplateRequest, opts ...grpc.CallOption) (*TagTemplate, error) {
	out := new(TagTemplate)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.DataCatalog/CreateTagTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) GetTagTemplate(ctx context.Context, in *GetTagTemplateRequest, opts ...grpc.CallOption) (*TagTemplate, error) {
	out := new(TagTemplate)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.DataCatalog/GetTagTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) UpdateTagTemplate(ctx context.Context, in *UpdateTagTemplateRequest, opts ...grpc.CallOption) (*TagTemplate, error) {
	out := new(TagTemplate)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.DataCatalog/UpdateTagTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) DeleteTagTemplate(ctx context.Context, in *DeleteTagTemplateRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.DataCatalog/DeleteTagTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) CreateTagTemplateField(ctx context.Context, in *CreateTagTemplateFieldRequest, opts ...grpc.CallOption) (*TagTemplateField, error) {
	out := new(TagTemplateField)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.DataCatalog/CreateTagTemplateField", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) UpdateTagTemplateField(ctx context.Context, in *UpdateTagTemplateFieldRequest, opts ...grpc.CallOption) (*TagTemplateField, error) {
	out := new(TagTemplateField)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.DataCatalog/UpdateTagTemplateField", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) RenameTagTemplateField(ctx context.Context, in *RenameTagTemplateFieldRequest, opts ...grpc.CallOption) (*TagTemplateField, error) {
	out := new(TagTemplateField)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.DataCatalog/RenameTagTemplateField", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) DeleteTagTemplateField(ctx context.Context, in *DeleteTagTemplateFieldRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.DataCatalog/DeleteTagTemplateField", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) CreateTag(ctx context.Context, in *CreateTagRequest, opts ...grpc.CallOption) (*Tag, error) {
	out := new(Tag)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.DataCatalog/CreateTag", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) UpdateTag(ctx context.Context, in *UpdateTagRequest, opts ...grpc.CallOption) (*Tag, error) {
	out := new(Tag)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.DataCatalog/UpdateTag", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) DeleteTag(ctx context.Context, in *DeleteTagRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.DataCatalog/DeleteTag", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) ListTags(ctx context.Context, in *ListTagsRequest, opts ...grpc.CallOption) (*ListTagsResponse, error) {
	out := new(ListTagsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.DataCatalog/ListTags", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.DataCatalog/SetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.DataCatalog/GetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error) {
	out := new(v1.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.DataCatalog/TestIamPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DataCatalogServer is the server API for DataCatalog service.
type DataCatalogServer interface {
	// Searches Data Catalog for multiple resources like entries, tags that
	// match a query.
	//
	// This is a custom method
	// (https://cloud.google.com/apis/design/custom_methods) and does not return
	// the complete resource, only the resource identifier and high level
	// fields. Clients can subsequentally call Get methods.
	//
	// See [Data Catalog Search
	// Syntax](/data-catalog/docs/how-to/search-reference)
	SearchCatalog(context.Context, *SearchCatalogRequest) (*SearchCatalogResponse, error)
	// Updates an existing entry.
	UpdateEntry(context.Context, *UpdateEntryRequest) (*Entry, error)
	// Gets an entry.
	GetEntry(context.Context, *GetEntryRequest) (*Entry, error)
	// Get an entry by target resource name. This method allows clients to use
	// the resource name from the source Google Cloud Platform service to get the
	// Data Catalog Entry.
	LookupEntry(context.Context, *LookupEntryRequest) (*Entry, error)
	// Creates a tag template.
	CreateTagTemplate(context.Context, *CreateTagTemplateRequest) (*TagTemplate, error)
	// Gets a tag template.
	GetTagTemplate(context.Context, *GetTagTemplateRequest) (*TagTemplate, error)
	// Updates a tag template. This method cannot be used to update the fields of
	// a template. The tag template fields are represented as separate resources
	// and should be updated using their own create/update/delete methods.
	UpdateTagTemplate(context.Context, *UpdateTagTemplateRequest) (*TagTemplate, error)
	// Deletes a tag template and all tags using the template.
	DeleteTagTemplate(context.Context, *DeleteTagTemplateRequest) (*empty.Empty, error)
	// Creates a field in a tag template.
	CreateTagTemplateField(context.Context, *CreateTagTemplateFieldRequest) (*TagTemplateField, error)
	// Updates a field in a tag template. This method cannot be used to update the
	// field type.
	UpdateTagTemplateField(context.Context, *UpdateTagTemplateFieldRequest) (*TagTemplateField, error)
	// Renames a field in a tag template.
	RenameTagTemplateField(context.Context, *RenameTagTemplateFieldRequest) (*TagTemplateField, error)
	// Deletes a field in a tag template and all uses of that field.
	DeleteTagTemplateField(context.Context, *DeleteTagTemplateFieldRequest) (*empty.Empty, error)
	// Creates a tag on an [Entry][google.cloud.datacatalog.v1beta1.Entry].
	CreateTag(context.Context, *CreateTagRequest) (*Tag, error)
	// Updates an existing tag.
	UpdateTag(context.Context, *UpdateTagRequest) (*Tag, error)
	// Deletes a tag.
	DeleteTag(context.Context, *DeleteTagRequest) (*empty.Empty, error)
	// Lists the tags on an [Entry][google.cloud.datacatalog.v1beta1.Entry].
	ListTags(context.Context, *ListTagsRequest) (*ListTagsResponse, error)
	// Sets the access control policy for a resource. Replaces any existing
	// policy.
	// Supported resources are:
	//   - Tag templates.
	// Note, this method cannot be used to manage policies for BigQuery, Cloud
	// Pub/Sub and any external Google Cloud Platform resources synced to Cloud
	// Data Catalog.
	//
	// Callers must have following Google IAM permission
	// `datacatalog.tagTemplates.setIamPolicy` to set policies on tag templates.
	SetIamPolicy(context.Context, *v1.SetIamPolicyRequest) (*v1.Policy, error)
	// Gets the access control policy for a resource. A `NOT_FOUND` error
	// is returned if the resource does not exist. An empty policy is returned
	// if the resource exists but does not have a policy set on it.
	//
	// Supported resources are:
	//   - Tag templates.
	// Note, this method cannot be used to manage policies for BigQuery, Cloud
	// Pub/Sub and any external Google Cloud Platform resources synced to Cloud
	// Data Catalog.
	//
	// Callers must have following Google IAM permission
	// `datacatalog.tagTemplates.getIamPolicy` to get policies on tag templates.
	GetIamPolicy(context.Context, *v1.GetIamPolicyRequest) (*v1.Policy, error)
	// Returns the caller's permissions on a resource.
	// If the resource does not exist, an empty set of permissions is returned
	// (We don't return a `NOT_FOUND` error).
	//
	// Supported resource are:
	//   - tag templates.
	// Note, this method cannot be used to manage policies for BigQuery, Cloud
	// Pub/Sub and any external Google Cloud Platform resources synced to Cloud
	// Data Catalog.
	//
	// A caller is not required to have Google IAM permission to make this
	// request.
	TestIamPermissions(context.Context, *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error)
}

func RegisterDataCatalogServer(s *grpc.Server, srv DataCatalogServer) {
	s.RegisterService(&_DataCatalog_serviceDesc, srv)
}

func _DataCatalog_SearchCatalog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchCatalogRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).SearchCatalog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.DataCatalog/SearchCatalog",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).SearchCatalog(ctx, req.(*SearchCatalogRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_UpdateEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).UpdateEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.DataCatalog/UpdateEntry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).UpdateEntry(ctx, req.(*UpdateEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_GetEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).GetEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.DataCatalog/GetEntry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).GetEntry(ctx, req.(*GetEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_LookupEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LookupEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).LookupEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.DataCatalog/LookupEntry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).LookupEntry(ctx, req.(*LookupEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_CreateTagTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTagTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).CreateTagTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.DataCatalog/CreateTagTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).CreateTagTemplate(ctx, req.(*CreateTagTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_GetTagTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTagTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).GetTagTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.DataCatalog/GetTagTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).GetTagTemplate(ctx, req.(*GetTagTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_UpdateTagTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTagTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).UpdateTagTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.DataCatalog/UpdateTagTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).UpdateTagTemplate(ctx, req.(*UpdateTagTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_DeleteTagTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTagTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).DeleteTagTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.DataCatalog/DeleteTagTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).DeleteTagTemplate(ctx, req.(*DeleteTagTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_CreateTagTemplateField_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTagTemplateFieldRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).CreateTagTemplateField(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.DataCatalog/CreateTagTemplateField",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).CreateTagTemplateField(ctx, req.(*CreateTagTemplateFieldRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_UpdateTagTemplateField_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTagTemplateFieldRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).UpdateTagTemplateField(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.DataCatalog/UpdateTagTemplateField",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).UpdateTagTemplateField(ctx, req.(*UpdateTagTemplateFieldRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_RenameTagTemplateField_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RenameTagTemplateFieldRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).RenameTagTemplateField(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.DataCatalog/RenameTagTemplateField",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).RenameTagTemplateField(ctx, req.(*RenameTagTemplateFieldRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_DeleteTagTemplateField_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTagTemplateFieldRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).DeleteTagTemplateField(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.DataCatalog/DeleteTagTemplateField",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).DeleteTagTemplateField(ctx, req.(*DeleteTagTemplateFieldRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_CreateTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).CreateTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.DataCatalog/CreateTag",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).CreateTag(ctx, req.(*CreateTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_UpdateTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).UpdateTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.DataCatalog/UpdateTag",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).UpdateTag(ctx, req.(*UpdateTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_DeleteTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).DeleteTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.DataCatalog/DeleteTag",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).DeleteTag(ctx, req.(*DeleteTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_ListTags_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTagsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).ListTags(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.DataCatalog/ListTags",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).ListTags(ctx, req.(*ListTagsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.DataCatalog/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).SetIamPolicy(ctx, req.(*v1.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.DataCatalog/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).GetIamPolicy(ctx, req.(*v1.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.DataCatalog/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).TestIamPermissions(ctx, req.(*v1.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DataCatalog_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.datacatalog.v1beta1.DataCatalog",
	HandlerType: (*DataCatalogServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SearchCatalog",
			Handler:    _DataCatalog_SearchCatalog_Handler,
		},
		{
			MethodName: "UpdateEntry",
			Handler:    _DataCatalog_UpdateEntry_Handler,
		},
		{
			MethodName: "GetEntry",
			Handler:    _DataCatalog_GetEntry_Handler,
		},
		{
			MethodName: "LookupEntry",
			Handler:    _DataCatalog_LookupEntry_Handler,
		},
		{
			MethodName: "CreateTagTemplate",
			Handler:    _DataCatalog_CreateTagTemplate_Handler,
		},
		{
			MethodName: "GetTagTemplate",
			Handler:    _DataCatalog_GetTagTemplate_Handler,
		},
		{
			MethodName: "UpdateTagTemplate",
			Handler:    _DataCatalog_UpdateTagTemplate_Handler,
		},
		{
			MethodName: "DeleteTagTemplate",
			Handler:    _DataCatalog_DeleteTagTemplate_Handler,
		},
		{
			MethodName: "CreateTagTemplateField",
			Handler:    _DataCatalog_CreateTagTemplateField_Handler,
		},
		{
			MethodName: "UpdateTagTemplateField",
			Handler:    _DataCatalog_UpdateTagTemplateField_Handler,
		},
		{
			MethodName: "RenameTagTemplateField",
			Handler:    _DataCatalog_RenameTagTemplateField_Handler,
		},
		{
			MethodName: "DeleteTagTemplateField",
			Handler:    _DataCatalog_DeleteTagTemplateField_Handler,
		},
		{
			MethodName: "CreateTag",
			Handler:    _DataCatalog_CreateTag_Handler,
		},
		{
			MethodName: "UpdateTag",
			Handler:    _DataCatalog_UpdateTag_Handler,
		},
		{
			MethodName: "DeleteTag",
			Handler:    _DataCatalog_DeleteTag_Handler,
		},
		{
			MethodName: "ListTags",
			Handler:    _DataCatalog_ListTags_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _DataCatalog_SetIamPolicy_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _DataCatalog_GetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _DataCatalog_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/datacatalog/v1beta1/datacatalog.proto",
}
