/*
 * #%L
 * Wildfly Camel :: Testsuite
 * %%
 * Copyright (C) 2013 - 2017 RedHat
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
package org.wildfly.camel.test.google.pubsub;

import java.util.HashMap;
import java.util.Map;

import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.google.pubsub.GooglePubsubComponent;
import org.apache.camel.component.google.pubsub.GooglePubsubConnectionFactory;
import org.apache.camel.component.google.pubsub.GooglePubsubConstants;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(Arquillian.class)
public class GooglePubSubIntegrationTest {

    @Deployment
    public static JavaArchive createDeployment() {
        JavaArchive archive = ShrinkWrap.create(JavaArchive.class, "camel-google-pubsub-tests.jar");
        return archive;
    }

    @Test
    public void testPubSub() throws Exception {

        String credentialsJson = System.getenv("GOOGLE_SERVICE_ACCOUNT_CREDENTIALS");
        Assume.assumeNotNull(credentialsJson);

        String projectId = "wfc-testsuite-10258";
        String subscriptionId = "test-topic-sub";
        String topicName = "test-topic";
        
        String serviceURL = "https://pubsub.googleapis.com";
        
        GooglePubsubConnectionFactory connectionFactory = new GooglePubsubConnectionFactory()
                .setCredentialsFileLocation(credentialsJson)
                .setServiceURL(serviceURL);

        CamelContext camelctx = new DefaultCamelContext();

        GooglePubsubComponent component = camelctx.getComponent("google-pubsub", GooglePubsubComponent.class);
        component.setConnectionFactory(connectionFactory);

        camelctx.addRoutes(new RouteBuilder() {
            @Override
            public void configure() throws Exception {
                from("direct:send")
                .toF("google-pubsub:%s:%s", projectId, topicName);

                fromF("google-pubsub:%s:%s", projectId, subscriptionId)
                .to("direct:receive");

                from("direct:receive")
                .to("mock:result");
            }
        });

        MockEndpoint mockEndpoint = camelctx.getEndpoint("mock:result", MockEndpoint.class);
        mockEndpoint.expectedBodiesReceivedInAnyOrder("Hello Kermit");

        camelctx.start();
        try {
            Map<String, String> attributes = new HashMap<>();
            attributes.put("ATTRIBUTE-TEST-KEY", "ATTRIBUTE-TEST-VALUE");

            ProducerTemplate template = camelctx.createProducerTemplate();
            template.sendBodyAndHeader("direct:send", "Hello Kermit", GooglePubsubConstants.ATTRIBUTES, attributes);

            mockEndpoint.assertIsSatisfied();
        } finally {
            camelctx.stop();
        }
    }
}
