#!/usr/bin/groovy

import java.io.File
import java.nio.file.Paths
import java.util.TreeSet

layoutDir = new File("${basedir}/target/layout")

outFile = new File("${basedir}/target/licenses/artifact-filters.txt")
outFile.getParentFile().mkdirs()

class GAV {
    
    def groupId
    def artifactId
    def version
    
    def key() {
        "${groupId}:${artifactId}"
    }
    
    def version() {
        "${version}"
    }
    
    GAV(groupId, artifactId, version) {
        this.groupId = groupId
        this.artifactId = artifactId
        this.version = version
    }

    @Override
    String toString() {
        "${groupId}:${artifactId}:${version}"
    }
}

result = new TreeSet<String>();

layoutDir.eachFileRecurse() { file ->
    
    if (file.getName() != "module.xml")
        return
    
    def parser = new XmlParser()
    def doc = parser.parse(file);
    
    doc.resources.artifact['@name'].each { val -> 
        assert val.startsWith("\${") && val.endsWith("}") : "Unexpected attribute value: ${val}"
        val = val.substring(0, val.length() - 1).substring(2)
        def toks = val.split(":")
        assert toks.length == 2 : "Unexpected number of tokens: ${val}"
        def gav = new GAV(toks[0], toks[1], null)
        result.add("include gaPattern ${gav.key()}")
    }
}

result.each { line -> outFile << "${line}\n" }

println "Generated ${outFile}"
