/*
 * #%L
 * Fuse EAP :: Config
 * %%
 * Copyright (C) 2015 RedHat
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
package org.wildfly.camel.test.config;

import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;

import org.junit.Assert;
import org.junit.Test;
import org.wildfly.extension.camel.config.WildFlyCamelConfigPlugin;

public class WildFlyVersionTest {

    @Test
    public void validTargetVersions() throws Exception {

        WildFlyCamelConfigPlugin plugin = new WildFlyCamelConfigPlugin();

        Path targetVersion = Paths.get("src/test/resources/versionA/version.txt");
        InputStream inputStream = getClass().getResourceAsStream("/expected-wildfly-version.txt");
        plugin.verifyTargetVersion(targetVersion, inputStream);

        targetVersion = Paths.get("src/test/resources/versionB/version.txt");
        inputStream = getClass().getResourceAsStream("/expected-wildfly-version.txt");
        plugin.verifyTargetVersion(targetVersion, inputStream);
    }

    @Test
    public void invalidTargetVersions() throws Exception {

        WildFlyCamelConfigPlugin plugin = new WildFlyCamelConfigPlugin();

        Path targetVersion = Paths.get("src/test/resources/versionC/version.txt");
        InputStream inputStream = getClass().getResourceAsStream("/expected-wildfly-version.txt");
        try {
            plugin.verifyTargetVersion(targetVersion, inputStream);
            Assert.fail("Incompatible target version expected");
        } catch (IllegalStateException ex) {
            // expected
            Assert.assertTrue(ex.getMessage().contains("Incompatible target version"));
        }
    }
}

