/*
 * Copyright (C) 2016 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.syndesis.integration.runtime.util;

public final class StringHelpers {
    private StringHelpers() {
    }

    public static Object sanitizeForURI(Object token){
        if (token == null) {
            return null;
        }
        if(!(token instanceof String)){
            return token;
        }
        String string = (String) token;

        // new_line is an illegal character in URIs. Camel does not sanitize them
        // at Framework level, so we do it explicitly here.
        return string.replace("\n", "%0A");
    }
}
