
[![Build Status](https://ci-builds.apache.org/job/CXF/job/CXF-JDK8/badge/icon?subject=Build)](https://ci-builds.apache.org/job/CXF/job/CXF-JDK8/)
[![Maven Central](https://maven-badges.herokuapp.com/maven-central/org.apache.cxf/cxf/badge.svg)](https://maven-badges.herokuapp.com/maven-central/org.apache.cxf/cxf)
[![Total alerts](https://img.shields.io/lgtm/alerts/g/apache/cxf)](https://lgtm.com/projects/g/apache/cxf/alerts/)

Welcome to Apache CXF!
======================
Apache CXF is an open source services framework. CXF helps you build and 
develop services using frontend programming APIs, like JAX-WS and JAX-RS. 
These services can speak a variety of protocols such as SOAP, XML/HTTP, 
RESTful HTTP, or CORBA and work over a variety of transports such as HTTP,
JMS or JBI.

CXF includes a broad feature set, but it is primarily focused on the following 
areas:

- Web Services Standards Support: CXF supports a variety of web service 
  standards including SOAP, the Basic Profile, WSDL, WS-Addressing, 
  WS-Policy, WS-ReliableMessaging, WS-Security, WS-SecurityPolicy,
  WS-SecureConversation, and WS-Trust.
- Frontends: CXF supports a variety of "frontend" programming models. CXF
  implements the JAX-WS APIs. It also includes a "simple frontend" which 
  allows creation of clients and endpoints without annotations. CXF supports 
  both contract first development with WSDL and code first development 
  starting from Java.  There is also a JAX-RS frontend for providing 
  REST support.
- Ease of use: CXF is designed to be intuitive and easy to use. There 
  are simple APIs to quickly build code-first services, Maven plug-ins to 
  make tooling integration easy, JAX-WS API support, Spring 2.x XML support 
  to make configuration a snap, and much more.
- Binary and Legacy Protocol Support: CXF has been designed to provide a 
  pluggable architecture that supports not only XML but also non-XML type 
  bindings, such as JSON and CORBA, in combination with any type of transport.


Export Notice
============================
This distribution includes cryptographic software.  The country in 
which you currently reside may have restrictions on the import, 
possession, use, and/or re-export to another country, of 
encryption software.  BEFORE using any encryption software, please 
check your country's laws, regulations and policies concerning the
import, possession, or use, and re-export of encryption software, to 
see if this is permitted.  See <http://www.wassenaar.org/> for more
information.

The U.S. Government Department of Commerce, Bureau of Industry and
Security (BIS), has classified this software as Export Commodity 
Control Number (ECCN) 5D002.C.1, which includes information security
software using or performing cryptographic functions with asymmetric
algorithms.  The form and manner of this Apache Software Foundation
distribution makes it eligible for export under the License Exception
ENC Technology Software Unrestricted (TSU) exception (see the BIS 
Export Administration Regulations, Section 740.13) for both object 
code and source code.

The following provides more details on the included cryptographic
software:
- http://santuario.apache.org/
- http://www.bouncycastle.org/
- http://ws.apache.org/wss4j/



Getting Started
===============

For an Apache CXF source distribution, please read BUILDING.txt for 
instructions on building Apache CXF. 

For an Apache CXF binary distribution, please read release_notes.txt
for installation instructions and list of supported and unsupported 
features.

Alternatively, you can also find out how to get started here:
http://cxf.apache.org/

If you need more help try talking to us on our mailing lists:
http://cxf.apache.org/mailing-lists.html
 
If you find any issues with CXF, please submit reports with JIRA here:
https://issues.apache.org/jira/browse/CXF

We welcome contributions, and encourage you to get involved in the CXF
community. If you'd like to learn more about how you can contribute, please
see:
http://cxf.apache.org/getting-involved.html

Thank you for using CXF!

The Apache CXF Team
http://cxf.apache.org/
