/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.model.springboot;

import javax.annotation.Generated;

/**
 * Hystrix Circuit Breaker EIP configuration
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.SpringBootAutoConfigurationMojo")
public class HystrixConfigurationDefinitionCommon {

    /**
     * Sets the group key to use. The default value is CamelHystrix.
     */
    private String groupKey = "CamelHystrix";
    /**
     * Sets the thread pool key to use. Will by default use the same value as
     * groupKey has been configured to use.
     */
    private String threadPoolKey = "CamelHystrix";
    /**
     * Whether to use a HystrixCircuitBreaker or not. If false no
     * circuit-breaker logic will be used and all requests permitted. This is
     * similar in effect to circuitBreakerForceClosed() except that continues
     * tracking metrics and knowing whether it should be open/closed, this
     * property results in not even instantiating a circuit-breaker.
     */
    private Boolean circuitBreakerEnabled = true;
    /**
     * Error percentage threshold (as whole number such as 50) at which point
     * the circuit breaker will trip open and reject requests. It will stay
     * tripped for the duration defined in
     * circuitBreakerSleepWindowInMilliseconds; The error percentage this is
     * compared against comes from HystrixCommandMetrics.getHealthCounts().
     */
    private String circuitBreakerErrorThresholdPercentage = "50";
    /**
     * If true the HystrixCircuitBreaker#allowRequest() will always return true
     * to allow requests regardless of the error percentage from
     * HystrixCommandMetrics.getHealthCounts(). The circuitBreakerForceOpen()
     * property takes precedence so if it set to true this property does
     * nothing.
     */
    private Boolean circuitBreakerForceClosed = false;
    /**
     * If true the HystrixCircuitBreaker.allowRequest() will always return
     * false, causing the circuit to be open (tripped) and reject all requests.
     * This property takes precedence over circuitBreakerForceClosed();
     */
    private Boolean circuitBreakerForceOpen = false;
    /**
     * Minimum number of requests in the
     * metricsRollingStatisticalWindowInMilliseconds() that must exist before
     * the HystrixCircuitBreaker will trip. If below this number the circuit
     * will not trip regardless of error percentage.
     */
    private String circuitBreakerRequestVolumeThreshold = "20";
    /**
     * The time in milliseconds after a HystrixCircuitBreaker trips open that it
     * should wait before trying requests again.
     */
    private String circuitBreakerSleepWindowInMilliseconds = "5000";
    /**
     * Number of concurrent requests permitted to HystrixCommand.run(). Requests
     * beyond the concurrent limit will be rejected. Applicable only when
     * executionIsolationStrategy == SEMAPHORE.
     */
    private String executionIsolationSemaphoreMaxConcurrentRequests = "20";
    /**
     * What isolation strategy HystrixCommand.run() will be executed with. If
     * THREAD then it will be executed on a separate thread and concurrent
     * requests limited by the number of threads in the thread-pool. If
     * SEMAPHORE then it will be executed on the calling thread and concurrent
     * requests limited by the semaphore count.
     */
    private String executionIsolationStrategy = "THREAD";
    /**
     * Whether the execution thread should attempt an interrupt (using
     * Future#cancel) when a thread times out. Applicable only when
     * executionIsolationStrategy() == THREAD.
     */
    private Boolean executionIsolationThreadInterruptOnTimeout = true;
    /**
     * Time in milliseconds at which point the command will timeout and halt
     * execution. If executionIsolationThreadInterruptOnTimeout == true and the
     * command is thread-isolated, the executing thread will be interrupted. If
     * the command is semaphore-isolated and a HystrixObservableCommand, that
     * command will get unsubscribed.
     */
    private String executionTimeoutInMilliseconds = "1000";
    /**
     * Whether the timeout mechanism is enabled for this command
     */
    private Boolean executionTimeoutEnabled = true;
    /**
     * Number of concurrent requests permitted to HystrixCommand.getFallback().
     * Requests beyond the concurrent limit will fail-fast and not attempt
     * retrieving a fallback.
     */
    private String fallbackIsolationSemaphoreMaxConcurrentRequests = "10";
    /**
     * Whether HystrixCommand.getFallback() should be attempted when failure
     * occurs.
     */
    private Boolean fallbackEnabled = true;
    /**
     * Time in milliseconds to wait between allowing health snapshots to be
     * taken that calculate success and error percentages and affect
     * HystrixCircuitBreaker.isOpen() status. On high-volume circuits the
     * continual calculation of error percentage can become CPU intensive thus
     * this controls how often it is calculated.
     */
    private String metricsHealthSnapshotIntervalInMilliseconds = "500";
    /**
     * Maximum number of values stored in each bucket of the rolling percentile.
     * This is passed into HystrixRollingPercentile inside
     * HystrixCommandMetrics.
     */
    private String metricsRollingPercentileBucketSize = "10";
    /**
     * Whether percentile metrics should be captured using
     * HystrixRollingPercentile inside HystrixCommandMetrics.
     */
    private Boolean metricsRollingPercentileEnabled = true;
    /**
     * Duration of percentile rolling window in milliseconds. This is passed
     * into HystrixRollingPercentile inside HystrixCommandMetrics.
     */
    private String metricsRollingPercentileWindowInMilliseconds = "10000";
    /**
     * Number of buckets the rolling percentile window is broken into. This is
     * passed into HystrixRollingPercentile inside HystrixCommandMetrics.
     */
    private String metricsRollingPercentileWindowBuckets = "6";
    /**
     * This property sets the duration of the statistical rolling window, in
     * milliseconds. This is how long metrics are kept for the thread pool. The
     * window is divided into buckets and rolls by those increments.
     */
    private String metricsRollingStatisticalWindowInMilliseconds = "10000";
    /**
     * Number of buckets the rolling statistical window is broken into. This is
     * passed into HystrixRollingNumber inside HystrixCommandMetrics.
     */
    private String metricsRollingStatisticalWindowBuckets = "10";
    /**
     * Whether HystrixCommand execution and events should be logged to
     * HystrixRequestLog.
     */
    private Boolean requestLogEnabled = true;
    /**
     * Core thread-pool size that gets passed to
     * java.util.concurrent.ThreadPoolExecutor#setCorePoolSize(int)
     */
    private String corePoolSize = "10";
    /**
     * Maximum thread-pool size that gets passed to
     * ThreadPoolExecutor#setMaximumPoolSize(int). This is the maximum amount of
     * concurrency that can be supported without starting to reject
     * HystrixCommands. Please note that this setting only takes effect if you
     * also set allowMaximumSizeToDivergeFromCoreSize
     */
    private String maximumSize = "10";
    /**
     * Keep-alive time in minutes that gets passed to link
     * ThreadPoolExecutor#setKeepAliveTime(long, TimeUnit)
     */
    private String keepAliveTime = "1";
    /**
     * Max queue size that gets passed to BlockingQueue in
     * HystrixConcurrencyStrategy.getBlockingQueue(int) This should only affect
     * the instantiation of a threadpool - it is not eliglible to change a queue
     * size on the fly. For that, use queueSizeRejectionThreshold().
     */
    private String maxQueueSize = "-1";
    /**
     * Queue size rejection threshold is an artificial max size at which
     * rejections will occur even if maxQueueSize has not been reached. This is
     * done because the maxQueueSize of a BlockingQueue can not be dynamically
     * changed and we want to support dynamically changing the queue size that
     * affects rejections. This is used by HystrixCommand when queuing a thread
     * for execution.
     */
    private String queueSizeRejectionThreshold = "5";
    /**
     * Duration of statistical rolling window in milliseconds. This is passed
     * into HystrixRollingNumber inside each HystrixThreadPoolMetrics instance.
     */
    private String threadPoolRollingNumberStatisticalWindowInMilliseconds = "10000";
    /**
     * Number of buckets the rolling statistical window is broken into. This is
     * passed into HystrixRollingNumber inside each HystrixThreadPoolMetrics
     * instance.
     */
    private String threadPoolRollingNumberStatisticalWindowBuckets = "10";
    /**
     * Allows the configuration for maximumSize to take effect. That value can
     * then be equal to, or higher, than coreSize
     */
    private Boolean allowMaximumSizeToDivergeFromCoreSize = false;

    public String getGroupKey() {
        return groupKey;
    }

    public void setGroupKey(String groupKey) {
        this.groupKey = groupKey;
    }

    public String getThreadPoolKey() {
        return threadPoolKey;
    }

    public void setThreadPoolKey(String threadPoolKey) {
        this.threadPoolKey = threadPoolKey;
    }

    public Boolean getCircuitBreakerEnabled() {
        return circuitBreakerEnabled;
    }

    public void setCircuitBreakerEnabled(Boolean circuitBreakerEnabled) {
        this.circuitBreakerEnabled = circuitBreakerEnabled;
    }

    public String getCircuitBreakerErrorThresholdPercentage() {
        return circuitBreakerErrorThresholdPercentage;
    }

    public void setCircuitBreakerErrorThresholdPercentage(
            String circuitBreakerErrorThresholdPercentage) {
        this.circuitBreakerErrorThresholdPercentage = circuitBreakerErrorThresholdPercentage;
    }

    public Boolean getCircuitBreakerForceClosed() {
        return circuitBreakerForceClosed;
    }

    public void setCircuitBreakerForceClosed(Boolean circuitBreakerForceClosed) {
        this.circuitBreakerForceClosed = circuitBreakerForceClosed;
    }

    public Boolean getCircuitBreakerForceOpen() {
        return circuitBreakerForceOpen;
    }

    public void setCircuitBreakerForceOpen(Boolean circuitBreakerForceOpen) {
        this.circuitBreakerForceOpen = circuitBreakerForceOpen;
    }

    public String getCircuitBreakerRequestVolumeThreshold() {
        return circuitBreakerRequestVolumeThreshold;
    }

    public void setCircuitBreakerRequestVolumeThreshold(
            String circuitBreakerRequestVolumeThreshold) {
        this.circuitBreakerRequestVolumeThreshold = circuitBreakerRequestVolumeThreshold;
    }

    public String getCircuitBreakerSleepWindowInMilliseconds() {
        return circuitBreakerSleepWindowInMilliseconds;
    }

    public void setCircuitBreakerSleepWindowInMilliseconds(
            String circuitBreakerSleepWindowInMilliseconds) {
        this.circuitBreakerSleepWindowInMilliseconds = circuitBreakerSleepWindowInMilliseconds;
    }

    public String getExecutionIsolationSemaphoreMaxConcurrentRequests() {
        return executionIsolationSemaphoreMaxConcurrentRequests;
    }

    public void setExecutionIsolationSemaphoreMaxConcurrentRequests(
            String executionIsolationSemaphoreMaxConcurrentRequests) {
        this.executionIsolationSemaphoreMaxConcurrentRequests = executionIsolationSemaphoreMaxConcurrentRequests;
    }

    public String getExecutionIsolationStrategy() {
        return executionIsolationStrategy;
    }

    public void setExecutionIsolationStrategy(String executionIsolationStrategy) {
        this.executionIsolationStrategy = executionIsolationStrategy;
    }

    public Boolean getExecutionIsolationThreadInterruptOnTimeout() {
        return executionIsolationThreadInterruptOnTimeout;
    }

    public void setExecutionIsolationThreadInterruptOnTimeout(
            Boolean executionIsolationThreadInterruptOnTimeout) {
        this.executionIsolationThreadInterruptOnTimeout = executionIsolationThreadInterruptOnTimeout;
    }

    public String getExecutionTimeoutInMilliseconds() {
        return executionTimeoutInMilliseconds;
    }

    public void setExecutionTimeoutInMilliseconds(
            String executionTimeoutInMilliseconds) {
        this.executionTimeoutInMilliseconds = executionTimeoutInMilliseconds;
    }

    public Boolean getExecutionTimeoutEnabled() {
        return executionTimeoutEnabled;
    }

    public void setExecutionTimeoutEnabled(Boolean executionTimeoutEnabled) {
        this.executionTimeoutEnabled = executionTimeoutEnabled;
    }

    public String getFallbackIsolationSemaphoreMaxConcurrentRequests() {
        return fallbackIsolationSemaphoreMaxConcurrentRequests;
    }

    public void setFallbackIsolationSemaphoreMaxConcurrentRequests(
            String fallbackIsolationSemaphoreMaxConcurrentRequests) {
        this.fallbackIsolationSemaphoreMaxConcurrentRequests = fallbackIsolationSemaphoreMaxConcurrentRequests;
    }

    public Boolean getFallbackEnabled() {
        return fallbackEnabled;
    }

    public void setFallbackEnabled(Boolean fallbackEnabled) {
        this.fallbackEnabled = fallbackEnabled;
    }

    public String getMetricsHealthSnapshotIntervalInMilliseconds() {
        return metricsHealthSnapshotIntervalInMilliseconds;
    }

    public void setMetricsHealthSnapshotIntervalInMilliseconds(
            String metricsHealthSnapshotIntervalInMilliseconds) {
        this.metricsHealthSnapshotIntervalInMilliseconds = metricsHealthSnapshotIntervalInMilliseconds;
    }

    public String getMetricsRollingPercentileBucketSize() {
        return metricsRollingPercentileBucketSize;
    }

    public void setMetricsRollingPercentileBucketSize(
            String metricsRollingPercentileBucketSize) {
        this.metricsRollingPercentileBucketSize = metricsRollingPercentileBucketSize;
    }

    public Boolean getMetricsRollingPercentileEnabled() {
        return metricsRollingPercentileEnabled;
    }

    public void setMetricsRollingPercentileEnabled(
            Boolean metricsRollingPercentileEnabled) {
        this.metricsRollingPercentileEnabled = metricsRollingPercentileEnabled;
    }

    public String getMetricsRollingPercentileWindowInMilliseconds() {
        return metricsRollingPercentileWindowInMilliseconds;
    }

    public void setMetricsRollingPercentileWindowInMilliseconds(
            String metricsRollingPercentileWindowInMilliseconds) {
        this.metricsRollingPercentileWindowInMilliseconds = metricsRollingPercentileWindowInMilliseconds;
    }

    public String getMetricsRollingPercentileWindowBuckets() {
        return metricsRollingPercentileWindowBuckets;
    }

    public void setMetricsRollingPercentileWindowBuckets(
            String metricsRollingPercentileWindowBuckets) {
        this.metricsRollingPercentileWindowBuckets = metricsRollingPercentileWindowBuckets;
    }

    public String getMetricsRollingStatisticalWindowInMilliseconds() {
        return metricsRollingStatisticalWindowInMilliseconds;
    }

    public void setMetricsRollingStatisticalWindowInMilliseconds(
            String metricsRollingStatisticalWindowInMilliseconds) {
        this.metricsRollingStatisticalWindowInMilliseconds = metricsRollingStatisticalWindowInMilliseconds;
    }

    public String getMetricsRollingStatisticalWindowBuckets() {
        return metricsRollingStatisticalWindowBuckets;
    }

    public void setMetricsRollingStatisticalWindowBuckets(
            String metricsRollingStatisticalWindowBuckets) {
        this.metricsRollingStatisticalWindowBuckets = metricsRollingStatisticalWindowBuckets;
    }

    public Boolean getRequestLogEnabled() {
        return requestLogEnabled;
    }

    public void setRequestLogEnabled(Boolean requestLogEnabled) {
        this.requestLogEnabled = requestLogEnabled;
    }

    public String getCorePoolSize() {
        return corePoolSize;
    }

    public void setCorePoolSize(String corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public String getMaximumSize() {
        return maximumSize;
    }

    public void setMaximumSize(String maximumSize) {
        this.maximumSize = maximumSize;
    }

    public String getKeepAliveTime() {
        return keepAliveTime;
    }

    public void setKeepAliveTime(String keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public String getMaxQueueSize() {
        return maxQueueSize;
    }

    public void setMaxQueueSize(String maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public String getQueueSizeRejectionThreshold() {
        return queueSizeRejectionThreshold;
    }

    public void setQueueSizeRejectionThreshold(
            String queueSizeRejectionThreshold) {
        this.queueSizeRejectionThreshold = queueSizeRejectionThreshold;
    }

    public String getThreadPoolRollingNumberStatisticalWindowInMilliseconds() {
        return threadPoolRollingNumberStatisticalWindowInMilliseconds;
    }

    public void setThreadPoolRollingNumberStatisticalWindowInMilliseconds(
            String threadPoolRollingNumberStatisticalWindowInMilliseconds) {
        this.threadPoolRollingNumberStatisticalWindowInMilliseconds = threadPoolRollingNumberStatisticalWindowInMilliseconds;
    }

    public String getThreadPoolRollingNumberStatisticalWindowBuckets() {
        return threadPoolRollingNumberStatisticalWindowBuckets;
    }

    public void setThreadPoolRollingNumberStatisticalWindowBuckets(
            String threadPoolRollingNumberStatisticalWindowBuckets) {
        this.threadPoolRollingNumberStatisticalWindowBuckets = threadPoolRollingNumberStatisticalWindowBuckets;
    }

    public Boolean getAllowMaximumSizeToDivergeFromCoreSize() {
        return allowMaximumSizeToDivergeFromCoreSize;
    }

    public void setAllowMaximumSizeToDivergeFromCoreSize(
            Boolean allowMaximumSizeToDivergeFromCoreSize) {
        this.allowMaximumSizeToDivergeFromCoreSize = allowMaximumSizeToDivergeFromCoreSize;
    }
}