/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.camel.component.yammer;

import java.io.InputStream;
import java.util.Collection;

import org.apache.camel.Endpoint;
import org.apache.camel.test.junit4.CamelTestSupport;
import org.junit.Before;

public abstract class YammerComponentTestSupport extends CamelTestSupport {

    protected YammerComponent yammerComponent;
    private String messages;
    
    public YammerComponentTestSupport() {
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        
        InputStream is = getClass().getResourceAsStream(jsonFile());        
        setMessages(context.getTypeConverter().convertTo(String.class, is));    
        
        yammerComponent = context.getComponent("yammer", YammerComponent.class);
        
        Collection<Endpoint> endpoints = context.getEndpoints();
        for (Endpoint endpoint : endpoints) {
            if (endpoint instanceof YammerEndpoint) {
                ((YammerEndpoint)endpoint).getConfig().setRequestor(new TestApiRequestor(getMessages()));
            }
        }
    }

    protected String jsonFile() {
        return "/messages.json";
    }

    protected String getMessages() {
        return messages;
    }

    protected void setMessages(String messages) {
        this.messages = messages;
    }

}