/*
    Copyright (C) 2017 Red Hat, Inc.

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

            http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
*/
import React, { SVGAttributes, forwardRef } from 'react';

export const AtlasmapLogo = forwardRef<
  SVGSVGElement,
  SVGAttributes<SVGSVGElement>
>(function atlasmapLogo(props, ref) {
  return (
    <svg
      viewBox="0, 0, 400,369.09090909090907"
      width={80}
      height={80}
      {...props}
      ref={ref}
    >
      <g id="svgg">
        <path
          id="path0"
          d="M289.650 33.143 C 288.782 33.220,288.169 33.441,288.287 33.632 C 288.560 34.075,295.106 34.092,295.106 33.650 C 295.106 32.909,293.702 32.778,289.650 33.143 M299.261 33.094 C 299.007 33.209,298.800 33.455,298.800 33.641 C 298.800 34.105,306.453 34.075,306.741 33.610 C 306.878 33.388,306.393 33.241,305.524 33.241 C 304.729 33.241,303.099 33.161,301.901 33.063 C 300.703 32.965,299.515 32.979,299.261 33.094 M283.657 34.534 C 283.657 34.841,283.985 35.088,284.395 35.088 C 284.806 35.088,285.134 34.841,285.134 34.534 C 285.134 34.226,284.806 33.980,284.395 33.980 C 283.985 33.980,283.657 34.226,283.657 34.534 M308.772 34.534 C 308.772 34.838,309.021 35.088,309.326 35.088 C 309.631 35.088,309.880 34.838,309.880 34.534 C 309.880 34.229,309.631 33.980,309.326 33.980 C 309.021 33.980,308.772 34.229,308.772 34.534 M279.963 35.457 C 279.963 35.660,280.295 35.826,280.702 35.826 C 281.108 35.826,281.440 35.660,281.440 35.457 C 281.440 35.254,281.108 35.088,280.702 35.088 C 280.295 35.088,279.963 35.254,279.963 35.457 M277.747 36.380 C 277.747 36.725,278.096 36.934,278.670 36.934 C 279.245 36.934,279.594 36.725,279.594 36.380 C 279.594 36.036,279.245 35.826,278.670 35.826 C 278.096 35.826,277.747 36.036,277.747 36.380 M314.312 36.380 C 314.312 36.725,314.661 36.934,315.235 36.934 C 315.810 36.934,316.159 36.725,316.159 36.380 C 316.159 36.036,315.810 35.826,315.235 35.826 C 314.661 35.826,314.312 36.036,314.312 36.380 M274.054 38.227 C 274.054 38.572,274.402 38.781,274.977 38.781 C 275.551 38.781,275.900 38.572,275.900 38.227 C 275.900 37.882,275.551 37.673,274.977 37.673 C 274.402 37.673,274.054 37.882,274.054 38.227 M317.636 38.227 C 317.636 38.572,317.985 38.781,318.560 38.781 C 319.134 38.781,319.483 38.572,319.483 38.227 C 319.483 37.882,319.134 37.673,318.560 37.673 C 317.985 37.673,317.636 37.882,317.636 38.227 M270.360 40.074 C 270.360 40.419,270.709 40.628,271.283 40.628 C 271.858 40.628,272.207 40.419,272.207 40.074 C 272.207 39.729,271.858 39.520,271.283 39.520 C 270.709 39.520,270.360 39.729,270.360 40.074 M322.438 40.074 C 322.438 40.773,322.839 40.777,323.752 40.086 C 324.439 39.566,324.426 39.543,323.453 39.532 C 322.792 39.524,322.438 39.713,322.438 40.074 M266.667 42.629 C 266.667 42.950,266.930 43.213,267.251 43.213 C 267.573 43.213,267.770 43.016,267.690 42.775 C 267.462 42.090,266.667 41.976,266.667 42.629 M326.131 42.659 C 326.131 42.967,326.459 43.213,326.870 43.213 C 327.750 43.213,327.850 42.646,327.024 42.329 C 326.199 42.013,326.131 42.038,326.131 42.659 M328.717 44.506 C 328.717 44.811,328.966 45.060,329.271 45.060 C 329.575 45.060,329.825 44.811,329.825 44.506 C 329.825 44.201,329.575 43.952,329.271 43.952 C 328.966 43.952,328.717 44.201,328.717 44.506 M333.149 48.938 C 333.149 49.243,333.398 49.492,333.703 49.492 C 334.007 49.492,334.257 49.243,334.257 48.938 C 334.257 48.633,334.007 48.384,333.703 48.384 C 333.398 48.384,333.149 48.633,333.149 48.938 M254.848 54.109 C 254.848 54.683,255.057 55.032,255.402 55.032 C 255.746 55.032,255.956 54.683,255.956 54.109 C 255.956 53.534,255.746 53.186,255.402 53.186 C 255.057 53.186,254.848 53.534,254.848 54.109 M339.428 55.956 C 339.428 56.530,339.637 56.879,339.982 56.879 C 340.326 56.879,340.536 56.530,340.536 55.956 C 340.536 55.381,340.326 55.032,339.982 55.032 C 339.637 55.032,339.428 55.381,339.428 55.956 M341.274 58.910 C 341.274 59.215,341.524 59.464,341.828 59.464 C 342.133 59.464,342.382 59.714,342.382 60.018 C 342.382 60.323,342.548 60.572,342.752 60.572 C 342.955 60.572,343.121 60.323,343.121 60.018 C 343.121 59.714,342.955 59.464,342.752 59.464 C 342.548 59.464,342.382 59.215,342.382 58.910 C 342.382 58.606,342.133 58.356,341.828 58.356 C 341.524 58.356,341.274 58.606,341.274 58.910 M248.569 65.005 C 248.569 65.743,248.753 66.113,249.123 66.113 C 249.492 66.113,249.677 65.743,249.677 65.005 C 249.677 64.266,249.492 63.897,249.123 63.897 C 248.753 63.897,248.569 64.266,248.569 65.005 M247.368 67.365 C 246.664 67.900,246.478 69.437,247.118 69.437 C 247.770 69.437,248.569 68.434,248.569 67.616 C 248.569 66.735,248.278 66.675,247.368 67.365 M346.076 69.437 C 346.076 70.046,346.242 70.545,346.445 70.545 C 346.648 70.545,346.814 70.046,346.814 69.437 C 346.814 68.827,346.648 68.329,346.445 68.329 C 346.242 68.329,346.076 68.827,346.076 69.437 M346.814 73.315 C 346.814 74.546,346.958 74.977,347.368 74.977 C 347.713 74.977,347.922 75.326,347.922 75.900 C 347.922 76.408,348.089 76.824,348.292 76.824 C 348.495 76.824,348.661 75.993,348.661 74.977 C 348.661 73.961,348.495 73.130,348.292 73.130 C 348.089 73.130,347.922 72.798,347.922 72.392 C 347.922 71.981,347.676 71.653,347.368 71.653 C 346.958 71.653,346.814 72.084,346.814 73.315 M245.983 72.576 C 245.983 72.881,246.150 73.130,246.353 73.130 C 246.556 73.130,246.722 72.881,246.722 72.576 C 246.722 72.271,246.556 72.022,246.353 72.022 C 246.150 72.022,245.983 72.271,245.983 72.576 M244.875 75.531 C 244.875 75.836,245.125 76.085,245.429 76.085 C 245.734 76.085,245.983 75.836,245.983 75.531 C 245.983 75.226,245.734 74.977,245.429 74.977 C 245.125 74.977,244.875 75.226,244.875 75.531 M347.922 94.367 C 347.922 94.942,347.713 95.291,347.368 95.291 C 347.061 95.291,346.814 95.619,346.814 96.030 C 346.814 96.436,346.967 96.768,347.154 96.768 C 347.340 96.768,347.756 96.869,348.077 96.992 C 348.563 97.179,348.661 96.899,348.661 95.330 C 348.661 94.293,348.495 93.444,348.292 93.444 C 348.089 93.444,347.922 93.860,347.922 94.367 M244.875 94.737 C 244.875 95.042,245.125 95.291,245.429 95.291 C 245.734 95.291,245.983 95.042,245.983 94.737 C 245.983 94.432,245.734 94.183,245.429 94.183 C 245.125 94.183,244.875 94.432,244.875 94.737 M346.076 100.831 C 346.076 101.440,346.242 101.939,346.445 101.939 C 346.648 101.939,346.814 101.440,346.814 100.831 C 346.814 100.222,346.648 99.723,346.445 99.723 C 346.242 99.723,346.076 100.222,346.076 100.831 M246.722 101.570 C 246.722 102.308,246.907 102.678,247.276 102.678 C 247.581 102.678,247.830 102.844,247.830 103.047 C 247.830 103.250,247.996 103.416,248.199 103.416 C 248.403 103.416,248.569 103.001,248.569 102.493 C 248.569 101.985,248.403 101.570,248.199 101.570 C 247.996 101.570,247.830 101.320,247.830 101.016 C 247.830 100.711,247.581 100.462,247.276 100.462 C 246.907 100.462,246.722 100.831,246.722 101.570 M247.830 105.263 C 247.830 105.669,247.996 106.002,248.199 106.002 C 248.403 106.002,248.569 105.669,248.569 105.263 C 248.569 104.857,248.403 104.524,248.199 104.524 C 247.996 104.524,247.830 104.857,247.830 105.263 M243.029 110.988 C 243.029 111.293,243.278 111.542,243.583 111.542 C 243.887 111.542,244.137 111.293,244.137 110.988 C 244.137 110.683,243.887 110.434,243.583 110.434 C 243.278 110.434,243.029 110.683,243.029 110.988 M341.274 110.988 C 341.274 111.293,341.524 111.542,341.828 111.542 C 342.133 111.542,342.382 111.293,342.382 110.988 C 342.382 110.683,342.133 110.434,341.828 110.434 C 341.524 110.434,341.274 110.683,341.274 110.988 M339.428 114.312 C 339.428 114.887,339.637 115.235,339.982 115.235 C 340.326 115.235,340.536 114.887,340.536 114.312 C 340.536 113.738,340.326 113.389,339.982 113.389 C 339.637 113.389,339.428 113.738,339.428 114.312 M337.950 116.528 C 337.950 116.833,338.116 117.082,338.319 117.082 C 338.523 117.082,338.689 116.833,338.689 116.528 C 338.689 116.223,338.523 115.974,338.319 115.974 C 338.116 115.974,337.950 116.223,337.950 116.528 M234.903 119.114 C 234.903 119.418,235.152 119.668,235.457 119.668 C 235.762 119.668,236.011 119.418,236.011 119.114 C 236.011 118.809,235.762 118.560,235.457 118.560 C 235.152 118.560,234.903 118.809,234.903 119.114 M231.210 122.807 C 231.210 123.112,231.459 123.361,231.764 123.361 C 232.068 123.361,232.318 123.112,232.318 122.807 C 232.318 122.502,232.068 122.253,231.764 122.253 C 231.459 122.253,231.210 122.502,231.210 122.807 M326.870 127.424 C 326.870 127.627,327.119 127.793,327.424 127.793 C 327.729 127.793,327.978 127.627,327.978 127.424 C 327.978 127.221,327.729 127.054,327.424 127.054 C 327.119 127.054,326.870 127.221,326.870 127.424 M322.899 129.454 C 322.365 130.061,322.292 130.748,322.762 130.748 C 322.940 130.748,323.293 130.499,323.546 130.194 C 323.799 129.889,324.318 129.640,324.699 129.640 C 325.080 129.640,325.392 129.474,325.392 129.271 C 325.392 128.711,323.426 128.856,322.899 129.454 M223.084 130.933 C 223.084 131.237,223.333 131.487,223.638 131.487 C 223.943 131.487,224.192 131.237,224.192 130.933 C 224.192 130.628,223.943 130.379,223.638 130.379 C 223.333 130.379,223.084 130.628,223.084 130.933 M318.744 132.041 C 318.744 132.385,319.093 132.595,319.668 132.595 C 320.242 132.595,320.591 132.385,320.591 132.041 C 320.591 131.696,320.242 131.487,319.668 131.487 C 319.093 131.487,318.744 131.696,318.744 132.041 M315.789 177.285 C 315.789 205.848,315.664 220.499,315.420 220.499 C 315.217 220.499,315.051 220.332,315.051 220.129 C 315.051 219.924,314.066 219.760,312.835 219.760 C 311.604 219.760,310.619 219.596,310.619 219.391 C 310.619 219.187,310.203 219.021,309.695 219.021 C 309.121 219.021,308.772 218.812,308.772 218.467 C 308.772 218.067,308.362 217.913,307.295 217.913 C 306.228 217.913,305.817 218.067,305.817 218.467 C 305.817 218.812,305.468 219.021,304.894 219.021 C 304.319 219.021,303.970 218.812,303.970 218.467 C 303.970 217.995,302.986 217.913,297.322 217.913 C 291.659 217.913,290.674 217.995,290.674 218.467 C 290.674 218.886,290.223 219.021,288.827 219.021 C 287.432 219.021,286.981 218.886,286.981 218.467 C 286.981 218.122,286.632 217.913,286.057 217.913 C 285.483 217.913,285.134 218.122,285.134 218.467 C 285.134 218.772,284.885 219.021,284.580 219.021 C 284.275 219.021,284.026 219.187,284.026 219.391 C 284.026 219.602,282.918 219.760,281.440 219.760 C 279.848 219.760,278.855 219.912,278.855 220.156 C 278.855 220.373,278.606 220.302,278.301 219.997 C 277.815 219.511,277.747 214.270,277.747 177.312 C 277.747 140.108,277.682 135.180,277.193 135.180 C 276.704 135.180,276.637 140.244,276.626 178.486 L 276.612 221.791 275.795 222.766 C 275.345 223.302,274.063 224.195,272.946 224.750 C 261.709 230.336,249.423 243.696,247.135 252.816 C 246.931 253.629,246.603 254.875,246.406 255.586 C 243.881 264.696,243.659 266.095,243.630 273.130 C 243.615 276.752,243.784 280.112,244.029 281.071 C 244.263 281.985,244.730 283.980,245.067 285.503 C 245.745 288.576,246.492 291.028,247.259 292.705 C 249.437 297.468,250.046 298.839,250.046 298.977 C 250.046 299.065,250.713 300.099,251.527 301.276 C 252.342 302.453,253.214 303.733,253.466 304.120 C 257.960 311.018,268.186 319.141,276.378 322.321 C 277.232 322.653,278.100 323.051,278.305 323.207 C 278.510 323.362,280.006 323.838,281.629 324.265 C 295.947 328.028,307.372 327.037,320.960 320.852 C 326.372 318.389,334.389 311.886,338.397 306.709 C 338.855 306.117,339.591 305.236,340.032 304.751 C 340.473 304.267,341.054 303.435,341.323 302.904 C 341.593 302.374,342.580 300.693,343.517 299.169 C 345.302 296.267,346.187 294.153,347.927 288.643 C 351.237 278.155,350.885 265.404,346.989 254.654 C 346.080 252.148,345.337 250.020,345.337 249.924 C 345.337 249.406,339.758 240.993,337.937 238.765 C 333.605 233.463,323.674 225.692,320.078 224.789 C 319.496 224.643,318.542 224.046,317.958 223.463 L 316.898 222.402 316.898 178.237 C 316.898 139.225,316.833 134.072,316.343 134.072 C 315.854 134.072,315.789 139.120,315.789 177.285 M211.265 142.752 C 211.265 143.056,211.514 143.306,211.819 143.306 C 212.124 143.306,212.373 143.056,212.373 142.752 C 212.373 142.447,212.124 142.198,211.819 142.198 C 211.514 142.198,211.265 142.447,211.265 142.752 M205.571 148.796 C 205.462 148.972,204.700 149.206,203.877 149.316 C 201.958 149.574,173.861 177.508,173.449 179.568 C 173.107 181.278,173.176 182.456,173.618 182.456 C 174.049 182.456,175.069 183.365,175.069 183.749 C 175.069 184.132,176.090 185.042,176.520 185.042 C 176.738 185.042,176.916 185.457,176.916 185.965 C 176.916 186.704,177.101 186.888,177.839 186.888 C 178.347 186.888,178.763 187.066,178.763 187.284 C 178.763 187.795,179.702 188.735,180.214 188.735 C 180.431 188.735,180.609 188.913,180.609 189.131 C 180.609 189.561,181.519 190.582,181.902 190.582 C 182.286 190.582,183.195 191.602,183.195 192.033 C 183.195 192.250,183.373 192.428,183.591 192.428 C 184.102 192.428,185.042 193.368,185.042 193.879 C 185.042 194.097,185.220 194.275,185.437 194.275 C 185.868 194.275,186.888 195.184,186.888 195.568 C 186.888 195.951,187.909 196.861,188.339 196.861 C 188.557 196.861,188.735 197.039,188.735 197.256 C 188.735 197.768,189.675 198.707,190.186 198.707 C 190.404 198.707,190.582 198.885,190.582 199.103 C 190.582 199.614,191.521 200.554,192.033 200.554 C 192.250 200.554,192.428 200.732,192.428 200.950 C 192.428 201.380,193.338 202.401,193.721 202.401 C 194.105 202.401,195.014 203.421,195.014 203.852 C 195.014 204.069,195.192 204.247,195.410 204.247 C 195.921 204.247,196.861 205.187,196.861 205.698 C 196.861 205.916,197.039 206.094,197.256 206.094 C 197.687 206.094,198.707 207.003,198.707 207.387 C 198.707 208.031,199.906 208.666,201.527 208.881 L 203.330 209.120 216.623 195.840 C 233.784 178.696,233.056 179.502,233.056 177.663 C 233.056 176.846,232.890 176.177,232.687 176.177 C 232.484 176.177,232.318 175.928,232.318 175.623 C 232.318 175.319,232.140 175.069,231.922 175.069 C 231.411 175.069,230.471 174.130,230.471 173.618 C 230.471 173.401,230.293 173.223,230.075 173.223 C 229.645 173.223,228.624 172.313,228.624 171.930 C 228.624 171.622,227.640 170.637,227.331 170.637 C 226.948 170.637,226.039 169.617,226.039 169.186 C 226.039 168.968,225.861 168.790,225.643 168.790 C 225.132 168.790,224.192 167.851,224.192 167.339 C 224.192 167.122,224.014 166.944,223.796 166.944 C 223.285 166.944,222.345 166.004,222.345 165.493 C 222.345 165.275,222.167 165.097,221.950 165.097 C 221.732 165.097,221.316 164.860,221.026 164.569 C 220.736 164.279,220.499 163.864,220.499 163.646 C 220.499 163.428,220.321 163.250,220.103 163.250 C 219.885 163.250,219.470 163.013,219.180 162.723 C 218.889 162.432,218.652 162.017,218.652 161.799 C 218.652 161.582,218.474 161.404,218.256 161.404 C 217.826 161.404,216.805 160.494,216.805 160.111 C 216.805 159.727,215.785 158.818,215.354 158.818 C 215.137 158.818,214.958 158.640,214.958 158.422 C 214.958 157.992,214.049 156.971,213.666 156.971 C 213.282 156.971,212.373 155.951,212.373 155.520 C 212.373 155.303,212.195 155.125,211.977 155.125 C 211.466 155.125,210.526 154.185,210.526 153.674 C 210.526 153.456,210.348 153.278,210.131 153.278 C 209.619 153.278,208.680 152.338,208.680 151.827 C 208.680 151.609,208.502 151.431,208.284 151.431 C 207.579 151.431,206.833 150.400,206.833 149.426 C 206.833 148.506,206.006 148.092,205.571 148.796 M167.682 186.519 C 167.682 186.722,167.932 186.888,168.236 186.888 C 168.541 186.888,168.790 186.722,168.790 186.519 C 168.790 186.316,168.541 186.150,168.236 186.150 C 167.932 186.150,167.682 186.316,167.682 186.519 M155.863 198.338 C 155.863 198.541,156.113 198.707,156.417 198.707 C 156.722 198.707,156.971 198.541,156.971 198.338 C 156.971 198.135,156.722 197.969,156.417 197.969 C 156.113 197.969,155.863 198.135,155.863 198.338 M144.044 210.157 C 144.044 210.360,144.294 210.526,144.598 210.526 C 144.903 210.526,145.152 210.360,145.152 210.157 C 145.152 209.954,144.903 209.788,144.598 209.788 C 144.294 209.788,144.044 209.954,144.044 210.157 M142.074 212.250 C 141.566 212.758,141.855 213.481,142.567 213.481 C 143.059 213.481,143.306 213.235,143.306 212.742 C 143.306 212.031,142.583 211.741,142.074 212.250 M104.709 219.231 C 96.856 220.305,90.549 222.063,87.760 223.956 C 86.970 224.492,86.106 224.931,85.840 224.931 C 85.160 224.931,78.519 229.135,76.085 231.107 C 66.571 238.814,61.201 247.211,57.241 260.572 C 55.337 266.995,55.294 278.181,57.145 285.134 C 58.578 290.514,63.037 301.209,64.229 302.124 C 64.361 302.225,65.376 303.555,66.485 305.078 C 69.091 308.659,76.996 316.528,77.988 316.528 C 78.141 316.528,79.386 317.312,80.756 318.269 C 93.432 327.130,114.416 328.918,129.640 322.435 C 134.278 320.459,134.878 320.143,138.319 317.856 C 147.367 311.844,152.216 306.219,157.933 295.106 C 158.854 293.316,160.687 287.635,161.359 284.488 C 161.587 283.421,161.949 281.738,162.165 280.747 C 163.299 275.534,162.567 265.800,160.523 258.910 C 159.581 255.737,159.387 254.479,159.454 251.985 C 159.501 250.205,159.386 248.938,159.177 248.938 C 158.979 248.938,158.818 248.273,158.818 247.461 C 158.818 246.648,158.640 245.983,158.422 245.983 C 157.771 245.983,156.971 244.981,156.971 244.163 C 156.971 243.742,156.793 243.398,156.576 243.398 C 155.924 243.398,155.125 242.395,155.125 241.578 C 155.125 241.144,154.885 240.813,154.571 240.813 C 154.266 240.813,154.017 240.563,154.017 240.259 C 154.017 239.954,153.850 239.705,153.647 239.705 C 153.444 239.705,153.278 239.289,153.278 238.781 C 153.278 238.042,153.093 237.858,152.355 237.858 C 151.616 237.858,151.431 237.673,151.431 236.934 C 151.431 236.427,151.253 236.011,151.035 236.011 C 150.524 236.011,149.584 235.071,149.584 234.560 C 149.584 234.342,149.335 234.164,149.030 234.164 C 148.686 234.164,148.476 233.816,148.476 233.241 C 148.476 232.564,148.279 232.318,147.738 232.318 C 147.331 232.318,146.999 232.151,146.999 231.948 C 146.999 231.745,146.584 231.579,146.076 231.579 C 145.568 231.579,145.152 231.413,145.152 231.210 C 145.152 231.006,144.903 230.840,144.598 230.840 C 144.294 230.840,144.044 230.662,144.044 230.445 C 144.044 229.933,143.105 228.994,142.593 228.994 C 142.376 228.994,142.198 228.744,142.198 228.440 C 142.198 228.095,141.849 227.886,141.274 227.886 C 140.536 227.886,140.351 227.701,140.351 226.962 C 140.351 226.223,140.166 226.039,139.428 226.039 C 138.920 226.039,138.504 225.873,138.504 225.669 C 138.504 225.466,138.089 225.300,137.581 225.300 C 137.006 225.300,136.657 225.091,136.657 224.746 C 136.657 224.438,136.329 224.192,135.919 224.192 C 135.512 224.192,135.180 224.026,135.180 223.823 C 135.180 223.620,134.515 223.453,133.703 223.453 C 132.584 223.453,132.225 223.307,132.225 222.852 C 132.225 222.348,131.912 222.283,130.286 222.449 C 128.833 222.597,127.685 222.427,125.703 221.771 C 119.872 219.841,109.460 218.581,104.709 219.231 M179.501 229.575 C 179.501 229.919,179.753 230.107,180.117 230.036 C 181.044 229.857,181.171 228.994,180.271 228.994 C 179.817 228.994,179.501 229.232,179.501 229.575 "
          stroke="none"
          fill="#6a6a6a"
          fillRule="evenodd"
        ></path>
        <path
          id="path1"
          d="M292.428 32.024 C 292.886 32.112,293.633 32.112,294.090 32.024 C 294.548 31.936,294.174 31.864,293.259 31.864 C 292.345 31.864,291.971 31.936,292.428 32.024 M299.636 32.029 C 300.197 32.114,301.028 32.111,301.482 32.024 C 301.937 31.936,301.477 31.866,300.462 31.869 C 299.446 31.872,299.074 31.944,299.636 32.029 M101.939 32.510 C 101.431 32.683,99.603 33.103,97.876 33.442 C 96.150 33.782,94.280 34.208,93.721 34.389 C 91.320 35.168,90.511 35.563,90.698 35.865 C 90.807 36.042,90.628 36.084,90.300 35.958 C 89.971 35.832,88.841 36.153,87.787 36.672 C 86.734 37.190,85.208 37.900,84.395 38.249 C 82.971 38.860,76.985 42.895,74.786 44.725 C 72.934 46.268,69.800 49.595,68.034 51.893 C 67.098 53.112,66.240 54.192,66.128 54.294 C 65.332 55.014,63.758 57.661,62.067 61.127 C 59.991 65.379,59.922 65.540,58.921 68.513 C 58.579 69.529,58.156 70.693,57.981 71.099 C 57.807 71.505,57.579 72.419,57.476 73.130 C 57.374 73.841,57.120 75.254,56.912 76.270 C 56.141 80.045,56.021 88.561,56.683 92.521 C 57.023 94.552,57.383 96.713,57.484 97.322 C 57.585 97.932,57.809 98.763,57.981 99.169 C 58.154 99.575,58.378 100.240,58.480 100.646 C 59.422 104.407,63.566 112.901,65.852 115.755 C 66.518 116.586,67.338 117.703,67.674 118.237 C 68.396 119.382,76.059 127.054,76.481 127.054 C 76.640 127.054,77.015 127.298,77.313 127.596 C 78.078 128.362,84.849 132.595,85.308 132.595 C 85.517 132.595,85.688 132.761,85.688 132.964 C 85.688 133.167,86.020 133.333,86.427 133.333 C 88.801 133.333,88.643 130.113,88.643 178.393 C 88.643 202.364,88.742 221.976,88.864 221.976 C 88.986 221.976,89.609 221.735,90.249 221.441 C 91.834 220.712,95.702 219.760,97.077 219.760 C 97.696 219.760,98.305 219.594,98.430 219.391 C 98.556 219.187,99.715 219.021,101.007 219.021 C 102.557 219.021,103.407 218.864,103.509 218.560 C 103.623 218.218,105.071 218.098,109.061 218.098 C 112.888 218.098,114.594 218.232,114.922 218.560 C 115.185 218.823,116.305 219.021,117.530 219.021 C 118.711 219.021,119.966 219.171,120.319 219.353 C 120.672 219.536,122.290 219.941,123.915 220.254 C 125.540 220.567,127.304 220.931,127.834 221.063 C 129.298 221.428,129.257 222.623,129.309 178.209 C 129.336 155.457,129.485 137.341,129.640 137.950 C 129.920 139.053,129.922 139.052,129.966 137.673 C 129.998 136.634,130.166 136.288,130.635 136.288 C 131.506 136.288,172.822 177.641,172.888 178.578 C 172.931 179.175,172.985 179.140,173.174 178.393 C 173.506 177.078,181.231 168.790,182.125 168.790 C 182.307 168.790,182.456 168.620,182.456 168.412 C 182.456 167.914,193.393 156.971,193.891 156.971 C 194.102 156.971,194.275 156.787,194.275 156.561 C 194.275 155.803,201.320 149.216,202.156 149.192 C 202.931 149.169,202.933 149.159,202.216 148.844 C 201.810 148.666,191.861 138.881,180.107 127.100 L 158.736 105.680 158.919 104.271 C 159.020 103.496,159.378 101.948,159.715 100.831 C 161.179 95.979,161.756 93.532,161.764 92.133 C 161.769 91.310,161.949 90.461,162.163 90.247 C 162.935 89.475,162.151 77.545,161.112 74.238 C 160.888 73.527,160.430 71.948,160.094 70.729 C 158.751 65.858,158.501 65.125,157.388 62.789 C 156.030 59.936,154.377 57.159,152.500 54.576 C 151.506 53.208,150.693 52.015,150.693 51.925 C 150.693 51.406,143.127 44.221,141.221 42.930 C 139.973 42.084,138.697 41.137,138.385 40.825 C 138.073 40.514,137.697 40.259,137.550 40.259 C 137.402 40.259,136.736 39.843,136.071 39.335 C 135.405 38.827,134.714 38.412,134.535 38.412 C 134.357 38.412,133.556 38.101,132.756 37.722 C 131.956 37.342,130.637 36.741,129.825 36.385 C 129.012 36.030,127.823 35.509,127.183 35.229 C 126.543 34.948,125.764 34.718,125.451 34.718 C 125.138 34.718,124.779 34.552,124.654 34.349 C 124.528 34.146,123.947 33.980,123.363 33.980 C 122.779 33.980,121.833 33.797,121.261 33.575 C 118.444 32.477,104.319 31.699,101.939 32.510 M258.900 47.553 L 256.510 50.046 259.003 47.656 C 261.318 45.436,261.665 45.060,261.393 45.060 C 261.336 45.060,260.214 46.182,258.900 47.553 M243.533 85.134 C 243.534 87.165,243.596 87.949,243.671 86.876 C 243.746 85.803,243.745 84.141,243.669 83.182 C 243.593 82.224,243.532 83.102,243.533 85.134 M350.270 85.134 C 350.268 86.962,350.331 87.757,350.408 86.899 C 350.486 86.042,350.487 84.546,350.410 83.575 C 350.334 82.604,350.271 83.306,350.270 85.134 M317.815 178.947 C 317.815 203.121,317.859 212.956,317.913 200.802 C 317.967 188.649,317.967 168.871,317.913 156.850 C 317.859 144.830,317.815 154.774,317.815 178.947 M272.012 139.705 L 269.437 142.382 272.114 139.807 C 273.587 138.390,274.792 137.185,274.792 137.129 C 274.792 136.858,274.404 137.217,272.012 139.705 M267.936 143.767 L 266.851 144.968 268.052 143.883 C 268.712 143.286,269.252 142.746,269.252 142.683 C 269.252 142.397,268.947 142.648,267.936 143.767 M264.820 146.814 C 263.923 147.729,263.272 148.476,263.373 148.476 C 263.475 148.476,264.292 147.729,265.189 146.814 C 266.086 145.900,266.737 145.152,266.636 145.152 C 266.534 145.152,265.717 145.900,264.820 146.814 M260.745 150.970 L 258.726 153.093 260.849 151.074 C 262.823 149.199,263.142 148.846,262.868 148.846 C 262.811 148.846,261.855 149.801,260.745 150.970 M256.694 154.940 C 255.797 155.854,255.146 156.602,255.248 156.602 C 255.349 156.602,256.167 155.854,257.064 154.940 C 257.961 154.026,258.612 153.278,258.510 153.278 C 258.409 153.278,257.592 154.026,256.694 154.940 M250.778 160.942 L 246.907 164.912 250.877 161.041 C 253.061 158.911,254.848 157.125,254.848 157.070 C 254.848 156.804,254.374 157.254,250.778 160.942 M242.466 169.252 L 239.520 172.299 242.567 169.353 C 244.243 167.733,245.614 166.362,245.614 166.306 C 245.614 166.037,245.202 166.422,242.466 169.252 M236.173 175.531 L 235.088 176.731 236.288 175.647 C 236.948 175.050,237.488 174.510,237.488 174.446 C 237.488 174.161,237.184 174.412,236.173 175.531 M233.085 180.146 C 233.053 181.056,205.326 209.049,204.457 209.049 C 204.195 209.049,209.110 214.185,215.379 220.461 C 221.648 226.738,226.777 232.057,226.777 232.280 C 226.777 232.504,226.993 232.687,227.257 232.687 C 227.521 232.687,230.197 235.222,233.204 238.319 C 236.211 241.417,238.810 244.087,238.980 244.252 C 239.149 244.418,240.949 246.168,242.979 248.143 L 246.670 251.733 246.902 250.493 C 247.030 249.811,247.707 248.360,248.406 247.267 C 249.105 246.174,249.677 245.106,249.677 244.893 C 249.677 244.680,249.825 244.506,250.006 244.506 C 250.187 244.506,250.440 244.090,250.567 243.583 C 250.695 243.075,250.962 242.659,251.161 242.659 C 251.361 242.659,251.524 242.450,251.524 242.194 C 251.524 241.938,251.939 241.280,252.447 240.733 C 252.955 240.185,253.370 239.644,253.370 239.531 C 253.370 239.295,256.181 236.179,258.367 233.991 C 259.609 232.749,261.230 231.307,264.196 228.808 C 264.794 228.305,267.461 226.601,268.144 226.286 C 268.449 226.145,269.197 225.709,269.806 225.317 C 271.423 224.275,273.009 223.453,273.403 223.453 C 273.845 223.453,276.270 221.176,276.270 220.760 C 276.270 220.587,276.009 220.707,275.690 221.026 C 275.282 221.434,274.927 221.503,274.490 221.258 C 273.562 220.739,233.540 180.514,233.311 179.871 C 233.184 179.513,233.104 179.611,233.085 180.146 M166.185 186.427 L 164.912 187.812 166.297 186.539 C 167.586 185.354,167.852 185.042,167.570 185.042 C 167.508 185.042,166.885 185.665,166.185 186.427 M161.014 191.597 L 159.741 192.982 161.127 191.710 C 162.416 190.525,162.681 190.212,162.399 190.212 C 162.338 190.212,161.714 190.836,161.014 191.597 M141.090 211.450 C 140.192 212.364,139.541 213.112,139.643 213.112 C 139.745 213.112,140.562 212.364,141.459 211.450 C 142.356 210.536,143.007 209.788,142.905 209.788 C 142.804 209.788,141.987 210.536,141.090 211.450 M136.819 215.789 L 135.734 216.990 136.934 215.905 C 138.053 214.894,138.305 214.589,138.019 214.589 C 137.956 214.589,137.416 215.129,136.819 215.789 M134.233 218.375 L 133.149 219.575 134.349 218.490 C 135.468 217.479,135.719 217.175,135.434 217.175 C 135.370 217.175,134.830 217.715,134.233 218.375 M192.590 219.114 L 191.505 220.314 192.705 219.229 C 193.366 218.633,193.906 218.092,193.906 218.029 C 193.906 217.743,193.601 217.995,192.590 219.114 M129.683 220.591 C 129.652 221.330,129.816 221.605,130.286 221.601 C 130.696 221.597,130.780 221.496,130.514 221.324 C 130.283 221.175,130.012 220.720,129.910 220.314 C 129.769 219.748,129.716 219.812,129.683 220.591 M257.248 309.511 C 258.042 310.323,258.774 310.988,258.876 310.988 C 258.977 310.988,258.411 310.323,257.618 309.511 C 256.824 308.698,256.092 308.033,255.990 308.033 C 255.889 308.033,256.455 308.698,257.248 309.511 M334.995 310.803 C 334.098 311.717,333.447 312.465,333.549 312.465 C 333.650 312.465,334.468 311.717,335.365 310.803 C 336.262 309.889,336.913 309.141,336.811 309.141 C 336.710 309.141,335.893 309.889,334.995 310.803 "
          stroke="none"
          fill="#a4a4a4"
          fillRule="evenodd"
        ></path>
        <path
          id="path2"
          d="M295.762 31.665 C 296.631 31.743,297.961 31.742,298.717 31.663 C 299.473 31.583,298.763 31.520,297.138 31.521 C 295.512 31.522,294.894 31.587,295.762 31.665 M106.833 32.038 C 108.204 32.109,110.448 32.109,111.819 32.038 C 113.190 31.966,112.068 31.908,109.326 31.908 C 106.584 31.908,105.462 31.966,106.833 32.038 M289.847 32.025 C 290.307 32.113,290.972 32.110,291.325 32.017 C 291.678 31.925,291.302 31.853,290.489 31.857 C 289.677 31.861,289.388 31.936,289.847 32.025 M302.774 32.025 C 303.234 32.113,303.899 32.110,304.252 32.017 C 304.605 31.925,304.229 31.853,303.416 31.857 C 302.604 31.861,302.315 31.936,302.774 32.025 M97.917 32.904 C 94.914 33.570,93.231 34.255,95.476 33.898 C 97.994 33.498,101.433 32.767,102.124 32.485 C 103.458 31.940,101.297 32.155,97.917 32.904 M116.343 32.502 C 116.648 32.699,117.479 32.846,118.190 32.829 C 119.375 32.801,119.406 32.773,118.560 32.502 C 117.155 32.052,115.647 32.052,116.343 32.502 M120.776 33.426 C 121.487 33.699,122.567 33.925,123.176 33.927 C 124.144 33.930,124.073 33.864,122.622 33.407 C 120.462 32.726,118.998 32.741,120.776 33.426 M283.102 33.241 C 282.637 33.441,282.569 33.558,282.918 33.558 C 283.223 33.558,283.804 33.416,284.211 33.241 C 284.676 33.041,284.744 32.924,284.395 32.924 C 284.090 32.924,283.509 33.066,283.102 33.241 M309.695 33.241 C 310.102 33.416,310.683 33.558,310.988 33.558 C 311.337 33.558,311.269 33.441,310.803 33.241 C 310.397 33.066,309.815 32.924,309.511 32.924 C 309.161 32.924,309.230 33.041,309.695 33.241 M90.859 34.926 C 77.964 39.817,67.277 49.357,61.536 61.100 C 59.438 65.394,57.403 70.823,57.760 71.180 C 57.875 71.295,58.043 71.158,58.132 70.875 C 58.403 70.018,59.525 66.716,59.813 65.928 C 60.924 62.889,65.070 55.251,66.128 54.294 C 66.240 54.192,67.098 53.112,68.034 51.893 C 69.800 49.595,72.934 46.268,74.786 44.725 C 76.985 42.895,82.971 38.860,84.395 38.249 C 85.208 37.900,86.704 37.232,87.719 36.764 C 88.735 36.297,90.231 35.664,91.043 35.358 C 93.686 34.363,94.377 34.030,93.813 34.023 C 93.509 34.019,92.179 34.426,90.859 34.926 M124.654 34.349 C 124.779 34.552,125.138 34.718,125.451 34.718 C 125.764 34.718,126.585 34.968,127.276 35.272 C 127.967 35.577,129.155 36.098,129.917 36.429 C 130.679 36.760,131.956 37.342,132.756 37.722 C 133.556 38.101,134.357 38.412,134.535 38.412 C 134.714 38.412,135.435 38.851,136.138 39.387 C 136.841 39.923,137.498 40.280,137.598 40.180 C 137.860 39.918,135.247 38.180,133.518 37.467 C 132.705 37.132,131.376 36.558,130.563 36.191 C 126.704 34.448,124.240 33.680,124.654 34.349 M275.162 36.011 C 274.654 36.301,274.404 36.539,274.608 36.539 C 274.811 36.539,275.392 36.301,275.900 36.011 C 276.408 35.721,276.657 35.483,276.454 35.483 C 276.251 35.483,275.669 35.721,275.162 36.011 M318.006 36.011 C 318.513 36.301,319.095 36.539,319.298 36.539 C 319.501 36.539,319.252 36.301,318.744 36.011 C 318.236 35.721,317.655 35.483,317.452 35.483 C 317.248 35.483,317.498 35.721,318.006 36.011 M138.135 40.538 C 138.135 40.692,139.253 41.565,140.620 42.478 C 141.987 43.390,144.735 45.779,146.727 47.787 C 148.719 49.794,150.423 51.362,150.515 51.271 C 150.813 50.973,144.649 44.923,142.191 43.100 C 140.874 42.124,139.504 41.085,139.146 40.792 C 138.419 40.195,138.135 40.124,138.135 40.538 M265.374 41.618 C 263.256 43.157,261.005 45.060,261.304 45.060 C 261.415 45.060,262.389 44.354,263.467 43.490 C 264.546 42.627,265.915 41.556,266.509 41.110 C 267.104 40.664,267.507 40.294,267.405 40.288 C 267.304 40.282,266.390 40.880,265.374 41.618 M326.500 40.391 C 326.500 40.483,327.349 41.168,328.386 41.913 C 329.423 42.658,330.162 43.091,330.029 42.876 C 329.751 42.426,326.500 40.137,326.500 40.391 M258.910 47.091 C 258.013 48.006,257.362 48.753,257.464 48.753 C 257.565 48.753,258.383 48.006,259.280 47.091 C 260.177 46.177,260.828 45.429,260.726 45.429 C 260.625 45.429,259.808 46.177,258.910 47.091 M334.275 46.777 C 335.339 48.057,336.473 49.015,336.473 48.634 C 336.473 48.581,335.691 47.797,334.737 46.891 L 333.000 45.245 334.275 46.777 M255.545 50.877 C 254.369 52.178,253.607 53.186,253.801 53.186 C 253.884 53.186,254.578 52.438,255.342 51.524 C 256.867 49.699,257.004 49.264,255.545 50.877 M338.681 51.697 C 339.110 52.300,339.651 52.910,339.881 53.053 C 340.112 53.195,339.835 52.702,339.266 51.956 C 338.031 50.337,337.566 50.131,338.681 51.697 M150.693 51.899 C 150.693 52.003,151.506 53.208,152.500 54.576 C 154.377 57.159,156.030 59.936,157.388 62.789 C 158.575 65.280,158.584 65.308,160.310 71.468 C 161.830 76.890,162.331 77.320,161.027 72.083 C 159.344 65.321,156.806 59.837,152.666 54.017 C 151.156 51.892,150.693 51.396,150.693 51.899 M252.262 55.217 C 251.633 56.131,251.202 56.879,251.303 56.879 C 251.405 56.879,252.003 56.131,252.632 55.217 C 253.261 54.303,253.692 53.555,253.590 53.555 C 253.489 53.555,252.891 54.303,252.262 55.217 M248.450 61.882 C 247.583 63.702,247.705 64.011,248.612 62.292 C 249.024 61.511,249.296 60.807,249.216 60.727 C 249.136 60.647,248.791 61.167,248.450 61.882 M346.103 63.897 C 346.102 64.429,347.144 66.543,347.171 66.063 C 347.178 65.934,346.941 65.269,346.644 64.585 C 346.347 63.902,346.104 63.592,346.103 63.897 M245.086 70.756 C 244.951 71.297,244.911 71.811,244.998 71.898 C 245.085 71.985,245.267 71.614,245.403 71.072 C 245.539 70.531,245.579 70.017,245.492 69.930 C 245.405 69.843,245.222 70.215,245.086 70.756 M56.948 73.869 C 56.681 75.189,56.307 76.966,56.117 77.818 C 55.238 81.751,55.913 93.764,57.234 97.692 L 57.606 98.800 57.458 97.507 C 57.376 96.796,57.047 94.635,56.727 92.705 C 55.843 87.373,56.151 77.448,57.290 74.555 C 57.502 74.018,57.620 73.104,57.554 72.524 C 57.465 71.749,57.304 72.107,56.948 73.869 M349.855 77.562 C 349.855 78.273,349.931 78.564,350.024 78.209 C 350.117 77.853,350.117 77.271,350.024 76.916 C 349.931 76.560,349.855 76.851,349.855 77.562 M161.815 78.116 C 161.798 78.929,161.945 79.843,162.142 80.148 C 162.591 80.842,162.591 78.962,162.142 77.562 C 161.886 76.761,161.842 76.835,161.815 78.116 M243.504 79.963 C 243.506 80.979,243.578 81.350,243.663 80.789 C 243.748 80.228,243.746 79.397,243.658 78.942 C 243.570 78.488,243.501 78.947,243.504 79.963 M350.239 80.517 C 350.239 81.431,350.311 81.805,350.399 81.348 C 350.487 80.891,350.487 80.143,350.399 79.686 C 350.311 79.229,350.239 79.603,350.239 80.517 M243.155 85.134 C 243.157 86.759,243.222 87.378,243.300 86.509 C 243.378 85.640,243.376 84.311,243.297 83.554 C 243.218 82.798,243.154 83.509,243.155 85.134 M350.239 89.751 C 350.239 90.665,350.311 91.039,350.399 90.582 C 350.487 90.125,350.487 89.377,350.399 88.920 C 350.311 88.463,350.239 88.837,350.239 89.751 M243.504 90.305 C 243.506 91.320,243.578 91.692,243.663 91.131 C 243.748 90.569,243.746 89.738,243.658 89.284 C 243.570 88.830,243.501 89.289,243.504 90.305 M162.050 90.333 C 161.898 90.487,161.788 91.291,161.806 92.121 L 161.839 93.629 162.196 92.392 C 162.581 91.054,162.498 89.882,162.050 90.333 M349.862 92.890 C 349.866 93.703,349.942 93.992,350.030 93.532 C 350.119 93.073,350.115 92.408,350.023 92.055 C 349.930 91.702,349.858 92.078,349.862 92.890 M243.841 93.629 C 243.841 94.035,243.974 94.783,244.137 95.291 C 244.371 96.022,244.432 96.060,244.432 95.476 C 244.432 95.069,244.299 94.321,244.137 93.813 C 243.903 93.082,243.841 93.044,243.841 93.629 M160.958 96.399 C 160.619 97.719,160.063 99.714,159.722 100.831 C 159.381 101.948,159.020 103.496,158.919 104.271 L 158.736 105.680 180.291 127.256 C 204.014 151.002,202.549 149.817,205.093 147.317 L 206.648 145.789 205.077 147.133 C 204.213 147.872,203.214 148.476,202.857 148.476 C 202.042 148.476,159.187 105.655,159.187 104.841 C 159.187 104.515,159.443 103.523,159.756 102.637 C 160.663 100.067,161.821 95.260,161.693 94.602 C 161.628 94.270,161.298 95.078,160.958 96.399 M244.927 98.615 C 244.927 98.920,245.070 99.501,245.245 99.908 C 245.445 100.373,245.562 100.442,245.562 100.092 C 245.562 99.788,245.419 99.206,245.245 98.800 C 245.045 98.334,244.927 98.266,244.927 98.615 M57.623 99.424 C 57.634 100.352,58.344 101.115,58.351 100.206 C 58.354 99.761,58.190 99.295,57.987 99.169 C 57.784 99.043,57.620 99.158,57.623 99.424 M58.368 101.387 C 58.361 101.591,58.748 102.837,59.228 104.157 C 63.619 116.251,73.100 126.654,85.994 133.527 L 88.089 134.643 88.276 178.587 L 88.463 222.530 88.553 178.670 C 88.652 130.061,88.806 133.333,86.427 133.333 C 86.020 133.333,85.688 133.167,85.688 132.964 C 85.688 132.761,85.517 132.595,85.308 132.595 C 84.849 132.595,78.078 128.362,77.313 127.596 C 77.015 127.298,76.640 127.054,76.481 127.054 C 76.059 127.054,68.396 119.382,67.674 118.237 C 67.338 117.703,66.518 116.586,65.852 115.755 C 64.108 113.577,60.768 107.219,59.677 103.999 C 59.013 102.039,58.386 100.788,58.368 101.387 M246.496 104.412 C 246.521 105.127,246.671 105.459,246.876 105.255 C 247.082 105.051,247.066 104.586,246.835 104.075 C 246.482 103.290,246.458 103.313,246.496 104.412 M244.124 108.126 L 242.105 110.249 244.229 108.231 C 245.397 107.120,246.353 106.165,246.353 106.107 C 246.353 105.833,246.000 106.153,244.124 108.126 M240.074 112.096 C 239.177 113.010,238.526 113.758,238.627 113.758 C 238.729 113.758,239.546 113.010,240.443 112.096 C 241.340 111.182,241.991 110.434,241.890 110.434 C 241.788 110.434,240.971 111.182,240.074 112.096 M342.172 113.666 C 341.612 114.631,340.400 116.406,339.479 117.611 C 338.557 118.816,337.979 119.693,338.193 119.561 C 339.156 118.966,343.936 111.911,343.376 111.911 C 343.274 111.911,342.733 112.701,342.172 113.666 M232.313 119.945 L 226.593 125.762 232.410 120.041 C 237.814 114.727,238.394 114.127,238.130 114.127 C 238.077 114.127,235.459 116.745,232.313 119.945 M334.626 123.176 C 333.113 124.700,331.958 125.946,332.059 125.946 C 332.161 125.946,333.482 124.700,334.995 123.176 C 336.509 121.653,337.664 120.406,337.562 120.406 C 337.461 120.406,336.139 121.653,334.626 123.176 M220.494 131.764 L 214.774 137.581 220.591 131.860 C 223.790 128.714,226.408 126.096,226.408 126.043 C 226.408 125.779,225.808 126.359,220.494 131.764 M325.848 130.168 C 324.778 130.832,323.781 131.514,323.632 131.682 C 323.224 132.143,326.972 129.992,327.595 129.408 C 328.396 128.657,328.010 128.825,325.848 130.168 M130.038 137.119 C 130.054 137.576,130.151 137.742,130.254 137.488 C 130.356 137.235,130.635 137.027,130.872 137.027 C 131.658 137.027,172.484 178.155,172.484 178.946 C 172.484 179.415,168.632 183.568,161.865 190.395 L 151.247 201.108 162.050 190.399 C 170.543 181.981,172.851 179.493,172.845 178.765 C 172.835 177.672,131.711 136.288,130.635 136.288 C 130.224 136.288,130.019 136.573,130.038 137.119 M254.292 157.802 L 233.610 178.578 254.343 157.939 C 266.611 145.726,275.244 137.404,275.488 137.554 C 276.136 137.955,276.070 220.268,275.421 220.806 C 274.868 221.265,233.988 180.627,233.683 179.317 C 233.543 178.714,233.503 178.748,233.469 179.502 C 233.430 180.340,274.006 221.607,274.869 221.607 C 276.293 221.607,276.270 222.303,276.270 179.321 C 276.270 138.741,276.234 137.027,275.398 137.027 C 275.165 137.027,265.668 146.376,254.292 157.802 M210.520 141.736 L 206.648 145.706 210.619 141.835 C 214.306 138.239,214.757 137.765,214.490 137.765 C 214.436 137.765,212.649 139.552,210.520 141.736 M129.818 179.317 C 129.818 201.662,129.863 210.749,129.917 199.510 C 129.971 188.271,129.971 169.988,129.917 158.882 C 129.863 147.776,129.818 156.971,129.818 179.317 M141.106 211.064 C 135.734 216.439,130.998 220.904,130.582 220.986 C 129.842 221.133,129.842 221.138,130.566 221.187 C 131.077 221.222,134.399 218.144,141.274 211.265 C 146.756 205.780,151.158 201.293,151.057 201.293 C 150.955 201.293,146.477 205.690,141.106 211.064 M181.078 230.928 C 169.242 242.759,159.557 252.527,159.557 252.635 C 159.557 252.743,169.155 243.224,180.886 231.482 C 192.634 219.723,202.605 210.033,203.082 209.911 C 203.834 209.719,205.456 211.198,215.363 221.107 C 221.641 227.387,226.777 232.380,226.777 232.204 C 226.777 231.368,204.339 209.418,203.484 209.418 C 202.808 209.418,197.536 214.480,181.078 230.928 M318.006 223.045 C 318.006 223.512,319.462 224.336,319.761 224.037 C 319.879 223.919,319.793 223.823,319.571 223.823 C 319.348 223.823,318.905 223.562,318.586 223.242 C 318.267 222.923,318.006 222.834,318.006 223.045 M334.811 234.903 C 336.222 236.325,337.459 237.488,337.561 237.488 C 337.663 237.488,336.591 236.325,335.180 234.903 C 333.769 233.481,332.531 232.318,332.430 232.318 C 332.328 232.318,333.400 233.481,334.811 234.903 M232.691 238.491 C 235.838 241.683,238.453 244.370,238.504 244.462 C 238.555 244.554,238.596 244.418,238.596 244.160 C 238.596 243.598,227.904 232.687,227.354 232.687 C 227.143 232.687,229.545 235.299,232.691 238.491 M242.540 248.237 C 244.732 250.477,246.366 252.462,246.460 253.001 C 246.617 253.900,246.623 253.898,246.672 252.905 C 246.725 251.832,242.343 246.818,239.903 245.159 C 239.286 244.740,240.473 246.125,242.540 248.237 M350.656 273.130 C 350.656 276.177,350.713 277.375,350.783 275.791 C 350.852 274.207,350.852 271.714,350.782 270.251 C 350.712 268.787,350.655 270.083,350.656 273.130 M163.010 272.576 C 163.010 274.303,163.074 275.009,163.151 274.146 C 163.229 273.283,163.229 271.870,163.151 271.006 C 163.074 270.143,163.010 270.849,163.010 272.576 M55.125 273.130 C 55.130 273.943,55.205 274.232,55.294 273.772 C 55.382 273.313,55.379 272.648,55.286 272.295 C 55.194 271.942,55.121 272.318,55.125 273.130 M70.360 310.619 C 71.771 312.041,73.009 313.204,73.110 313.204 C 73.212 313.204,72.141 312.041,70.729 310.619 C 69.318 309.197,68.081 308.033,67.979 308.033 C 67.878 308.033,68.949 309.197,70.360 310.619 M258.172 310.734 C 258.172 310.798,258.712 311.338,259.372 311.935 L 260.572 313.019 259.488 311.819 C 258.477 310.700,258.172 310.449,258.172 310.734 M144.206 314.035 L 143.121 315.235 144.321 314.151 C 145.440 313.139,145.691 312.835,145.406 312.835 C 145.343 312.835,144.802 313.375,144.206 314.035 "
          stroke="none"
          fill="#b5b5b5"
          fillRule="evenodd"
        ></path>
        <path
          id="path3"
          d="M295.759 32.031 C 296.423 32.113,297.420 32.112,297.975 32.028 C 298.530 31.943,297.987 31.876,296.768 31.878 C 295.549 31.880,295.095 31.949,295.759 32.031 M129.266 178.301 C 129.260 221.691,129.268 221.422,128.018 221.107 C 122.653 219.754,120.561 219.455,122.572 220.328 C 123.256 220.625,124.170 220.870,124.604 220.873 C 125.038 220.876,126.093 221.123,126.949 221.421 C 129.897 222.448,129.640 226.473,129.640 179.277 C 129.640 156.039,129.557 137.027,129.455 137.027 C 129.354 137.027,129.268 155.600,129.266 178.301 M197.817 152.683 C 195.869 154.590,194.275 156.335,194.275 156.561 C 194.275 156.787,194.102 156.971,193.891 156.971 C 193.429 156.971,182.316 168.035,182.546 168.265 C 182.635 168.353,187.033 164.103,192.321 158.820 C 197.608 153.538,201.805 149.215,201.646 149.215 C 201.488 149.215,199.764 150.775,197.817 152.683 M178.533 172.035 C 175.241 175.292,174.095 176.547,174.409 176.547 C 174.503 176.547,176.328 174.801,178.466 172.669 C 180.604 170.536,182.232 168.790,182.083 168.790 C 181.934 168.790,180.336 170.250,178.533 172.035 M218.613 194.737 C 210.771 202.608,204.485 209.049,204.644 209.049 C 205.072 209.049,233.121 180.972,232.987 180.677 C 232.923 180.538,226.455 186.865,218.613 194.737 M104.432 218.157 C 101.987 218.577,103.846 218.837,109.308 218.837 C 113.049 218.837,115.070 218.708,114.846 218.484 C 114.477 218.115,106.190 217.855,104.432 218.157 M98.430 219.391 C 98.140 219.861,98.995 219.861,99.723 219.391 C 100.173 219.100,100.126 219.031,99.468 219.027 C 99.023 219.024,98.556 219.187,98.430 219.391 M118.929 219.391 C 119.657 219.861,120.512 219.861,120.222 219.391 C 120.096 219.187,119.629 219.024,119.184 219.027 C 118.526 219.031,118.478 219.100,118.929 219.391 M93.259 220.467 C 90.553 221.243,88.556 222.012,88.748 222.204 C 88.827 222.283,89.874 222.019,91.075 221.617 C 92.277 221.215,93.592 220.875,93.998 220.860 C 94.404 220.846,95.235 220.606,95.845 220.327 C 97.443 219.596,96.033 219.672,93.259 220.467 M271.653 224.214 C 271.043 224.602,270.212 225.096,269.806 225.310 C 268.249 226.134,264.767 228.297,264.196 228.795 C 263.955 229.006,262.874 229.925,261.795 230.839 C 259.658 232.647,255.167 237.192,255.342 237.368 C 255.402 237.428,256.927 236.044,258.730 234.293 C 261.586 231.519,266.991 227.147,267.563 227.147 C 267.672 227.147,268.670 226.565,269.781 225.854 C 270.893 225.143,271.935 224.556,272.097 224.550 C 272.259 224.543,272.714 224.294,273.108 223.996 C 274.188 223.179,272.996 223.358,271.653 224.214 M254.006 238.601 C 253.657 239.009,253.370 239.432,253.370 239.540 C 253.370 239.648,252.955 240.185,252.447 240.733 C 251.939 241.280,251.524 241.938,251.524 242.194 C 251.524 242.450,251.361 242.659,251.161 242.659 C 250.962 242.659,250.695 243.075,250.567 243.583 C 250.440 244.090,250.187 244.506,250.006 244.506 C 249.825 244.506,249.677 244.680,249.677 244.893 C 249.677 245.106,249.087 246.203,248.365 247.330 C 247.644 248.458,247.126 249.572,247.214 249.806 C 247.304 250.043,247.506 249.904,247.672 249.492 C 248.010 248.653,252.617 241.095,252.964 240.813 C 253.088 240.711,253.654 240.005,254.222 239.243 C 255.294 237.805,255.123 237.296,254.006 238.601 M55.487 268.883 C 55.487 269.594,55.563 269.885,55.656 269.529 C 55.749 269.174,55.749 268.592,55.656 268.236 C 55.563 267.881,55.487 268.172,55.487 268.883 M243.155 273.500 C 243.157 275.125,243.222 275.744,243.300 274.875 C 243.378 274.006,243.376 272.676,243.297 271.920 C 243.218 271.164,243.154 271.874,243.155 273.500 M55.487 277.008 C 55.487 277.719,55.563 278.010,55.656 277.655 C 55.749 277.299,55.749 276.717,55.656 276.362 C 55.563 276.006,55.487 276.297,55.487 277.008 "
          stroke="none"
          fill="#9c9c9e"
          fillRule="evenodd"
        ></path>
        <path
          id="path4"
          d="M289.197 32.502 C 288.892 32.699,288.212 32.863,287.686 32.866 C 285.057 32.882,278.300 35.081,272.784 37.717 C 271.984 38.099,271.140 38.412,270.909 38.412 C 270.678 38.412,270.099 38.827,269.621 39.335 C 269.144 39.843,268.547 40.259,268.295 40.259 C 268.043 40.259,267.781 40.393,267.713 40.557 C 267.645 40.721,266.626 41.491,265.447 42.268 C 263.475 43.567,257.499 49.164,255.761 51.339 C 254.445 52.986,250.416 58.650,250.416 58.854 C 250.416 59.088,247.614 65.280,247.100 66.182 C 246.669 66.938,245.221 72.108,244.973 73.777 C 244.835 74.708,244.928 74.977,245.389 74.977 C 245.716 74.977,245.983 75.226,245.983 75.531 C 245.983 76.196,244.892 76.284,244.837 75.623 C 244.817 75.369,244.575 76.159,244.300 77.378 C 243.300 81.807,243.777 92.424,245.220 97.876 C 245.632 99.435,247.074 104.151,247.340 104.815 C 247.453 105.095,238.510 114.316,225.581 127.253 C 208.926 143.917,203.834 149.215,204.471 149.215 C 204.934 149.215,205.415 149.049,205.540 148.846 C 206.001 148.101,206.833 148.474,206.833 149.426 C 206.833 150.400,207.579 151.431,208.284 151.431 C 208.502 151.431,208.680 151.609,208.680 151.827 C 208.680 152.338,209.619 153.278,210.131 153.278 C 210.348 153.278,210.526 153.456,210.526 153.674 C 210.526 154.185,211.466 155.125,211.977 155.125 C 212.195 155.125,212.373 155.303,212.373 155.520 C 212.373 155.951,213.282 156.971,213.666 156.971 C 214.049 156.971,214.958 157.992,214.958 158.422 C 214.958 158.640,215.137 158.818,215.354 158.818 C 215.785 158.818,216.805 159.727,216.805 160.111 C 216.805 160.494,217.826 161.404,218.256 161.404 C 218.474 161.404,218.652 161.582,218.652 161.799 C 218.652 162.311,219.592 163.250,220.103 163.250 C 220.321 163.250,220.499 163.428,220.499 163.646 C 220.499 164.157,221.438 165.097,221.950 165.097 C 222.167 165.097,222.345 165.275,222.345 165.493 C 222.345 166.004,223.285 166.944,223.796 166.944 C 224.014 166.944,224.192 167.122,224.192 167.339 C 224.192 167.851,225.132 168.790,225.643 168.790 C 225.861 168.790,226.039 168.968,226.039 169.186 C 226.039 169.617,226.948 170.637,227.331 170.637 C 227.640 170.637,228.624 171.622,228.624 171.930 C 228.624 172.313,229.645 173.223,230.075 173.223 C 230.293 173.223,230.471 173.401,230.471 173.618 C 230.471 174.130,231.411 175.069,231.922 175.069 C 232.140 175.069,232.318 175.319,232.318 175.623 C 232.318 175.928,232.484 176.177,232.687 176.177 C 232.890 176.177,233.056 176.846,233.056 177.663 C 233.056 179.501,233.780 178.700,216.659 195.804 C 209.367 203.089,203.616 209.049,203.878 209.049 C 204.779 209.049,232.911 180.523,233.200 179.317 C 233.525 177.961,274.599 136.657,275.622 136.657 C 276.236 136.657,276.269 138.887,276.259 179.040 L 276.249 221.422 275.244 222.388 C 274.691 222.919,273.241 223.898,272.022 224.564 C 270.803 225.229,269.365 226.083,268.826 226.460 C 268.287 226.838,267.737 227.147,267.606 227.147 C 266.393 227.147,256.526 236.022,254.260 239.151 C 253.671 239.963,253.088 240.711,252.964 240.813 C 251.286 242.181,245.709 253.301,247.145 252.414 C 247.319 252.307,247.461 252.040,247.461 251.822 C 247.461 251.060,250.110 246.235,252.532 242.586 C 257.071 235.745,265.313 228.544,272.946 224.750 C 274.063 224.195,275.345 223.302,275.795 222.766 L 276.612 221.791 276.626 178.486 C 276.637 140.244,276.704 135.180,277.193 135.180 C 277.682 135.180,277.747 140.108,277.747 177.312 C 277.747 214.270,277.815 219.511,278.301 219.997 C 278.606 220.302,278.855 220.373,278.855 220.156 C 278.855 219.912,279.848 219.760,281.440 219.760 C 282.918 219.760,284.026 219.602,284.026 219.391 C 284.026 219.187,284.275 219.021,284.580 219.021 C 284.885 219.021,285.134 218.772,285.134 218.467 C 285.134 218.122,285.483 217.913,286.057 217.913 C 286.632 217.913,286.981 218.122,286.981 218.467 C 286.981 218.886,287.432 219.021,288.827 219.021 C 290.223 219.021,290.674 218.886,290.674 218.467 C 290.674 217.995,291.659 217.913,297.322 217.913 C 302.986 217.913,303.970 217.995,303.970 218.467 C 303.970 218.812,304.319 219.021,304.894 219.021 C 305.468 219.021,305.817 218.812,305.817 218.467 C 305.817 218.067,306.228 217.913,307.295 217.913 C 308.362 217.913,308.772 218.067,308.772 218.467 C 308.772 218.812,309.121 219.021,309.695 219.021 C 310.203 219.021,310.619 219.187,310.619 219.391 C 310.619 219.596,311.604 219.760,312.835 219.760 C 314.066 219.760,315.051 219.924,315.051 220.129 C 315.051 220.332,315.217 220.499,315.420 220.499 C 315.664 220.499,315.789 205.848,315.789 177.285 C 315.789 139.120,315.854 134.072,316.343 134.072 C 316.833 134.072,316.898 139.220,316.898 178.188 L 316.898 222.304 317.852 223.340 C 318.689 224.248,318.734 224.264,318.222 223.464 C 317.594 222.485,317.298 135.535,317.919 134.576 C 318.068 134.346,319.021 133.770,320.037 133.297 C 326.500 130.287,334.824 123.602,338.617 118.375 C 339.354 117.359,340.059 116.445,340.183 116.343 C 341.166 115.538,345.364 107.778,346.368 104.908 C 348.529 98.736,348.727 98.097,349.073 96.214 C 350.914 86.179,350.355 77.848,347.187 68.117 C 345.600 63.240,344.731 61.361,341.906 56.694 C 338.791 51.548,331.348 43.737,327.699 41.784 C 327.275 41.557,326.707 41.162,326.437 40.907 C 325.850 40.350,322.900 38.412,322.640 38.412 C 322.539 38.412,321.310 37.853,319.908 37.171 C 316.753 35.636,312.778 34.256,309.141 33.433 C 307.618 33.088,305.770 32.655,305.036 32.469 C 303.250 32.020,289.901 32.047,289.197 32.502 M294.522 33.096 C 295.926 33.635,294.865 33.980,291.804 33.980 C 288.385 33.980,286.873 33.392,289.650 33.143 C 292.540 32.883,293.932 32.870,294.522 33.096 M305.524 33.241 C 306.393 33.241,306.878 33.388,306.741 33.610 C 306.453 34.075,298.800 34.105,298.800 33.641 C 298.800 33.043,299.671 32.881,301.901 33.063 C 303.099 33.161,304.729 33.241,305.524 33.241 M285.134 34.534 C 285.134 34.841,284.806 35.088,284.395 35.088 C 283.985 35.088,283.657 34.841,283.657 34.534 C 283.657 34.226,283.985 33.980,284.395 33.980 C 284.806 33.980,285.134 34.226,285.134 34.534 M309.880 34.534 C 309.880 34.838,309.631 35.088,309.326 35.088 C 309.021 35.088,308.772 34.838,308.772 34.534 C 308.772 34.229,309.021 33.980,309.326 33.980 C 309.631 33.980,309.880 34.229,309.880 34.534 M281.440 35.457 C 281.440 35.660,281.108 35.826,280.702 35.826 C 280.295 35.826,279.963 35.660,279.963 35.457 C 279.963 35.254,280.295 35.088,280.702 35.088 C 281.108 35.088,281.440 35.254,281.440 35.457 M279.594 36.380 C 279.594 36.725,279.245 36.934,278.670 36.934 C 278.096 36.934,277.747 36.725,277.747 36.380 C 277.747 36.036,278.096 35.826,278.670 35.826 C 279.245 35.826,279.594 36.036,279.594 36.380 M316.159 36.380 C 316.159 36.725,315.810 36.934,315.235 36.934 C 314.661 36.934,314.312 36.725,314.312 36.380 C 314.312 36.036,314.661 35.826,315.235 35.826 C 315.810 35.826,316.159 36.036,316.159 36.380 M275.900 38.227 C 275.900 38.572,275.551 38.781,274.977 38.781 C 274.402 38.781,274.054 38.572,274.054 38.227 C 274.054 37.882,274.402 37.673,274.977 37.673 C 275.551 37.673,275.900 37.882,275.900 38.227 M319.483 38.227 C 319.483 38.572,319.134 38.781,318.560 38.781 C 317.985 38.781,317.636 38.572,317.636 38.227 C 317.636 37.882,317.985 37.673,318.560 37.673 C 319.134 37.673,319.483 37.882,319.483 38.227 M272.207 40.074 C 272.207 40.419,271.858 40.628,271.283 40.628 C 270.709 40.628,270.360 40.419,270.360 40.074 C 270.360 39.729,270.709 39.520,271.283 39.520 C 271.858 39.520,272.207 39.729,272.207 40.074 M323.752 40.086 C 322.839 40.777,322.438 40.773,322.438 40.074 C 322.438 39.713,322.792 39.524,323.453 39.532 C 324.426 39.543,324.439 39.566,323.752 40.086 M267.690 42.775 C 267.770 43.016,267.573 43.213,267.251 43.213 C 266.930 43.213,266.667 42.950,266.667 42.629 C 266.667 41.976,267.462 42.090,267.690 42.775 M327.024 42.329 C 327.850 42.646,327.750 43.213,326.870 43.213 C 326.459 43.213,326.131 42.967,326.131 42.659 C 326.131 42.038,326.199 42.013,327.024 42.329 M329.825 44.506 C 329.825 44.811,329.575 45.060,329.271 45.060 C 328.966 45.060,328.717 44.811,328.717 44.506 C 328.717 44.201,328.966 43.952,329.271 43.952 C 329.575 43.952,329.825 44.201,329.825 44.506 M334.257 48.938 C 334.257 49.243,334.007 49.492,333.703 49.492 C 333.398 49.492,333.149 49.243,333.149 48.938 C 333.149 48.633,333.398 48.384,333.703 48.384 C 334.007 48.384,334.257 48.633,334.257 48.938 M255.956 54.109 C 255.956 54.683,255.746 55.032,255.402 55.032 C 255.057 55.032,254.848 54.683,254.848 54.109 C 254.848 53.534,255.057 53.186,255.402 53.186 C 255.746 53.186,255.956 53.534,255.956 54.109 M340.536 55.956 C 340.536 56.530,340.326 56.879,339.982 56.879 C 339.637 56.879,339.428 56.530,339.428 55.956 C 339.428 55.381,339.637 55.032,339.982 55.032 C 340.326 55.032,340.536 55.381,340.536 55.956 M342.382 58.910 C 342.382 59.215,342.548 59.464,342.752 59.464 C 342.955 59.464,343.121 59.714,343.121 60.018 C 343.121 60.323,342.955 60.572,342.752 60.572 C 342.548 60.572,342.382 60.323,342.382 60.018 C 342.382 59.714,342.133 59.464,341.828 59.464 C 341.524 59.464,341.274 59.215,341.274 58.910 C 341.274 58.606,341.524 58.356,341.828 58.356 C 342.133 58.356,342.382 58.606,342.382 58.910 M249.677 65.005 C 249.677 65.743,249.492 66.113,249.123 66.113 C 248.753 66.113,248.569 65.743,248.569 65.005 C 248.569 64.266,248.753 63.897,249.123 63.897 C 249.492 63.897,249.677 64.266,249.677 65.005 M248.569 67.616 C 248.569 68.434,247.770 69.437,247.118 69.437 C 246.478 69.437,246.664 67.900,247.368 67.365 C 248.278 66.675,248.569 66.735,248.569 67.616 M346.814 69.437 C 346.814 70.046,346.648 70.545,346.445 70.545 C 346.242 70.545,346.076 70.046,346.076 69.437 C 346.076 68.827,346.242 68.329,346.445 68.329 C 346.648 68.329,346.814 68.827,346.814 69.437 M347.922 72.392 C 347.922 72.798,348.089 73.130,348.292 73.130 C 348.495 73.130,348.661 73.961,348.661 74.977 C 348.661 75.993,348.495 76.824,348.292 76.824 C 348.089 76.824,347.922 76.408,347.922 75.900 C 347.922 75.326,347.713 74.977,347.368 74.977 C 346.958 74.977,346.814 74.546,346.814 73.315 C 346.814 72.084,346.958 71.653,347.368 71.653 C 347.676 71.653,347.922 71.981,347.922 72.392 M246.722 72.576 C 246.722 72.881,246.556 73.130,246.353 73.130 C 246.150 73.130,245.983 72.881,245.983 72.576 C 245.983 72.271,246.150 72.022,246.353 72.022 C 246.556 72.022,246.722 72.271,246.722 72.576 M348.661 95.330 C 348.661 96.899,348.563 97.179,348.077 96.992 C 347.756 96.869,347.340 96.768,347.154 96.768 C 346.967 96.768,346.814 96.436,346.814 96.030 C 346.814 95.619,347.061 95.291,347.368 95.291 C 347.713 95.291,347.922 94.942,347.922 94.367 C 347.922 93.860,348.089 93.444,348.292 93.444 C 348.495 93.444,348.661 94.293,348.661 95.330 M245.983 94.737 C 245.983 95.042,245.734 95.291,245.429 95.291 C 245.125 95.291,244.875 95.042,244.875 94.737 C 244.875 94.432,245.125 94.183,245.429 94.183 C 245.734 94.183,245.983 94.432,245.983 94.737 M346.814 100.831 C 346.814 101.440,346.648 101.939,346.445 101.939 C 346.242 101.939,346.076 101.440,346.076 100.831 C 346.076 100.222,346.242 99.723,346.445 99.723 C 346.648 99.723,346.814 100.222,346.814 100.831 M247.830 101.016 C 247.830 101.320,247.996 101.570,248.199 101.570 C 248.403 101.570,248.569 101.985,248.569 102.493 C 248.569 103.001,248.403 103.416,248.199 103.416 C 247.996 103.416,247.830 103.250,247.830 103.047 C 247.830 102.844,247.581 102.678,247.276 102.678 C 246.907 102.678,246.722 102.308,246.722 101.570 C 246.722 100.831,246.907 100.462,247.276 100.462 C 247.581 100.462,247.830 100.711,247.830 101.016 M248.569 105.263 C 248.569 105.669,248.403 106.002,248.199 106.002 C 247.996 106.002,247.830 105.669,247.830 105.263 C 247.830 104.857,247.996 104.524,248.199 104.524 C 248.403 104.524,248.569 104.857,248.569 105.263 M244.137 110.988 C 244.137 111.293,243.887 111.542,243.583 111.542 C 243.278 111.542,243.029 111.293,243.029 110.988 C 243.029 110.683,243.278 110.434,243.583 110.434 C 243.887 110.434,244.137 110.683,244.137 110.988 M342.382 110.988 C 342.382 111.293,342.133 111.542,341.828 111.542 C 341.524 111.542,341.274 111.293,341.274 110.988 C 341.274 110.683,341.524 110.434,341.828 110.434 C 342.133 110.434,342.382 110.683,342.382 110.988 M340.536 114.312 C 340.536 114.887,340.326 115.235,339.982 115.235 C 339.637 115.235,339.428 114.887,339.428 114.312 C 339.428 113.738,339.637 113.389,339.982 113.389 C 340.326 113.389,340.536 113.738,340.536 114.312 M338.689 116.528 C 338.689 116.833,338.523 117.082,338.319 117.082 C 338.116 117.082,337.950 116.833,337.950 116.528 C 337.950 116.223,338.116 115.974,338.319 115.974 C 338.523 115.974,338.689 116.223,338.689 116.528 M236.011 119.114 C 236.011 119.418,235.762 119.668,235.457 119.668 C 235.152 119.668,234.903 119.418,234.903 119.114 C 234.903 118.809,235.152 118.560,235.457 118.560 C 235.762 118.560,236.011 118.809,236.011 119.114 M232.318 122.807 C 232.318 123.112,232.068 123.361,231.764 123.361 C 231.459 123.361,231.210 123.112,231.210 122.807 C 231.210 122.502,231.459 122.253,231.764 122.253 C 232.068 122.253,232.318 122.502,232.318 122.807 M327.978 127.424 C 327.978 127.627,327.729 127.793,327.424 127.793 C 327.119 127.793,326.870 127.627,326.870 127.424 C 326.870 127.221,327.119 127.054,327.424 127.054 C 327.729 127.054,327.978 127.221,327.978 127.424 M325.392 129.271 C 325.392 129.474,325.080 129.640,324.699 129.640 C 324.318 129.640,323.799 129.889,323.546 130.194 C 323.293 130.499,322.940 130.748,322.762 130.748 C 322.292 130.748,322.365 130.061,322.899 129.454 C 323.426 128.856,325.392 128.711,325.392 129.271 M224.192 130.933 C 224.192 131.237,223.943 131.487,223.638 131.487 C 223.333 131.487,223.084 131.237,223.084 130.933 C 223.084 130.628,223.333 130.379,223.638 130.379 C 223.943 130.379,224.192 130.628,224.192 130.933 M320.591 132.041 C 320.591 132.385,320.242 132.595,319.668 132.595 C 319.093 132.595,318.744 132.385,318.744 132.041 C 318.744 131.696,319.093 131.487,319.668 131.487 C 320.242 131.487,320.591 131.696,320.591 132.041 M212.373 142.752 C 212.373 143.056,212.124 143.306,211.819 143.306 C 211.514 143.306,211.265 143.056,211.265 142.752 C 211.265 142.447,211.514 142.198,211.819 142.198 C 212.124 142.198,212.373 142.447,212.373 142.752 M187.741 163.399 C 177.118 174.018,173.465 177.893,173.205 178.819 C 172.941 179.758,167.810 185.095,151.895 200.988 L 130.933 221.920 128.992 221.775 C 127.925 221.696,126.731 221.459,126.339 221.250 C 125.946 221.040,125.263 220.868,124.820 220.868 C 124.377 220.868,123.161 220.601,122.118 220.274 C 121.075 219.948,119.723 219.541,119.114 219.370 C 117.273 218.855,106.781 218.595,103.232 218.977 C 99.552 219.373,98.553 219.554,95.845 220.313 C 90.166 221.907,88.691 222.426,88.510 222.896 C 88.400 223.182,87.679 223.750,86.907 224.157 C 86.135 224.565,85.688 224.905,85.913 224.914 C 86.139 224.923,86.970 224.492,87.760 223.955 C 89.888 222.509,94.128 221.149,101.016 219.702 C 107.087 218.427,118.486 219.382,125.703 221.771 C 127.685 222.427,128.833 222.597,130.286 222.449 C 131.912 222.283,132.225 222.348,132.225 222.852 C 132.225 223.307,132.584 223.453,133.703 223.453 C 134.515 223.453,135.180 223.620,135.180 223.823 C 135.180 224.026,135.512 224.192,135.919 224.192 C 136.329 224.192,136.657 224.438,136.657 224.746 C 136.657 225.091,137.006 225.300,137.581 225.300 C 138.089 225.300,138.504 225.466,138.504 225.669 C 138.504 225.873,138.920 226.039,139.428 226.039 C 140.166 226.039,140.351 226.223,140.351 226.962 C 140.351 227.701,140.536 227.886,141.274 227.886 C 141.849 227.886,142.198 228.095,142.198 228.440 C 142.198 228.744,142.376 228.994,142.593 228.994 C 143.105 228.994,144.044 229.933,144.044 230.445 C 144.044 230.662,144.294 230.840,144.598 230.840 C 144.903 230.840,145.152 231.006,145.152 231.210 C 145.152 231.413,145.568 231.579,146.076 231.579 C 146.584 231.579,146.999 231.745,146.999 231.948 C 146.999 232.151,147.331 232.318,147.738 232.318 C 148.279 232.318,148.476 232.564,148.476 233.241 C 148.476 233.816,148.686 234.164,149.030 234.164 C 149.335 234.164,149.584 234.342,149.584 234.560 C 149.584 235.071,150.524 236.011,151.035 236.011 C 151.253 236.011,151.431 236.427,151.431 236.934 C 151.431 237.673,151.616 237.858,152.355 237.858 C 153.093 237.858,153.278 238.042,153.278 238.781 C 153.278 239.289,153.444 239.705,153.647 239.705 C 153.850 239.705,154.017 239.954,154.017 240.259 C 154.017 240.563,154.266 240.813,154.571 240.813 C 154.885 240.813,155.125 241.144,155.125 241.578 C 155.125 242.395,155.924 243.398,156.576 243.398 C 156.793 243.398,156.971 243.742,156.971 244.163 C 156.971 244.981,157.771 245.983,158.422 245.983 C 158.640 245.983,158.818 246.648,158.818 247.461 C 158.818 248.319,158.994 248.938,159.238 248.938 C 159.529 248.938,159.591 249.592,159.439 251.062 C 159.300 252.410,159.338 252.916,159.543 252.447 C 159.951 251.516,202.018 209.558,202.770 209.332 C 203.075 209.241,202.509 209.043,201.512 208.892 C 199.874 208.643,198.707 208.018,198.707 207.387 C 198.707 207.003,197.687 206.094,197.256 206.094 C 197.039 206.094,196.861 205.916,196.861 205.698 C 196.861 205.187,195.921 204.247,195.410 204.247 C 195.192 204.247,195.014 204.069,195.014 203.852 C 195.014 203.421,194.105 202.401,193.721 202.401 C 193.338 202.401,192.428 201.380,192.428 200.950 C 192.428 200.732,192.250 200.554,192.033 200.554 C 191.521 200.554,190.582 199.614,190.582 199.103 C 190.582 198.885,190.404 198.707,190.186 198.707 C 189.675 198.707,188.735 197.768,188.735 197.256 C 188.735 197.039,188.557 196.861,188.339 196.861 C 187.909 196.861,186.888 195.951,186.888 195.568 C 186.888 195.184,185.868 194.275,185.437 194.275 C 185.220 194.275,185.042 194.097,185.042 193.879 C 185.042 193.368,184.102 192.428,183.591 192.428 C 183.373 192.428,183.195 192.250,183.195 192.033 C 183.195 191.602,182.286 190.582,181.902 190.582 C 181.519 190.582,180.609 189.561,180.609 189.131 C 180.609 188.913,180.431 188.735,180.214 188.735 C 179.702 188.735,178.763 187.795,178.763 187.284 C 178.763 187.066,178.347 186.888,177.839 186.888 C 177.101 186.888,176.916 186.704,176.916 185.965 C 176.916 185.457,176.738 185.042,176.520 185.042 C 176.090 185.042,175.069 184.132,175.069 183.749 C 175.069 183.365,174.049 182.456,173.618 182.456 C 173.176 182.456,173.107 181.278,173.449 179.568 C 173.673 178.452,201.388 150.016,202.770 149.486 C 203.189 149.325,203.154 149.266,202.627 149.244 C 202.180 149.226,196.816 154.326,187.741 163.399 M168.790 186.519 C 168.790 186.722,168.541 186.888,168.236 186.888 C 167.932 186.888,167.682 186.722,167.682 186.519 C 167.682 186.316,167.932 186.150,168.236 186.150 C 168.541 186.150,168.790 186.316,168.790 186.519 M156.971 198.338 C 156.971 198.541,156.722 198.707,156.417 198.707 C 156.113 198.707,155.863 198.541,155.863 198.338 C 155.863 198.135,156.113 197.969,156.417 197.969 C 156.722 197.969,156.971 198.135,156.971 198.338 M145.152 210.157 C 145.152 210.360,144.903 210.526,144.598 210.526 C 144.294 210.526,144.044 210.360,144.044 210.157 C 144.044 209.954,144.294 209.788,144.598 209.788 C 144.903 209.788,145.152 209.954,145.152 210.157 M143.306 212.742 C 143.306 213.235,143.059 213.481,142.567 213.481 C 141.855 213.481,141.566 212.758,142.074 212.250 C 142.583 211.741,143.306 212.031,143.306 212.742 M180.887 229.455 C 180.654 230.154,179.501 230.253,179.501 229.575 C 179.501 229.232,179.817 228.994,180.271 228.994 C 180.722 228.994,180.977 229.184,180.887 229.455 M71.826 234.626 L 69.621 236.934 71.930 234.730 C 74.074 232.682,74.407 232.318,74.134 232.318 C 74.077 232.318,73.038 233.356,71.826 234.626 M334.626 235.088 C 335.935 236.408,337.089 237.488,337.190 237.488 C 337.292 237.488,336.304 236.408,334.995 235.088 C 333.687 233.767,332.533 232.687,332.431 232.687 C 332.330 232.687,333.317 233.767,334.626 235.088 M159.239 254.109 C 159.239 254.414,159.382 254.995,159.557 255.402 C 159.757 255.867,159.874 255.936,159.874 255.586 C 159.874 255.282,159.731 254.700,159.557 254.294 C 159.357 253.828,159.239 253.760,159.239 254.109 M243.491 269.067 C 243.495 269.880,243.571 270.169,243.659 269.709 C 243.748 269.250,243.744 268.585,243.652 268.232 C 243.559 267.879,243.487 268.255,243.491 269.067 M162.626 270.175 C 162.628 271.394,162.697 271.848,162.779 271.185 C 162.861 270.521,162.860 269.523,162.775 268.968 C 162.691 268.413,162.624 268.957,162.626 270.175 M350.284 273.130 C 350.285 275.974,350.343 277.089,350.413 275.607 C 350.483 274.125,350.483 271.799,350.412 270.436 C 350.341 269.074,350.284 270.286,350.284 273.130 M55.531 272.946 C 55.531 274.672,55.594 275.379,55.672 274.515 C 55.750 273.652,55.750 272.239,55.672 271.376 C 55.594 270.512,55.531 271.219,55.531 272.946 M162.630 275.900 C 162.630 277.221,162.697 277.761,162.779 277.101 C 162.861 276.440,162.861 275.360,162.779 274.700 C 162.697 274.040,162.630 274.580,162.630 275.900 M243.484 277.378 C 243.484 278.089,243.560 278.380,243.653 278.024 C 243.745 277.669,243.745 277.087,243.653 276.731 C 243.560 276.376,243.484 276.667,243.484 277.378 M349.215 283.657 C 349.075 284.295,349.037 284.894,349.131 284.988 C 349.225 285.083,349.409 284.629,349.538 283.980 C 349.668 283.331,349.706 282.731,349.622 282.648 C 349.539 282.564,349.355 283.018,349.215 283.657 M346.505 292.721 C 346.269 293.240,346.082 293.864,346.090 294.108 C 346.098 294.352,346.350 293.987,346.650 293.296 C 347.281 291.842,347.147 291.311,346.505 292.721 M247.487 293.813 C 247.487 294.017,247.724 294.598,248.015 295.106 C 248.305 295.614,248.543 295.863,248.543 295.660 C 248.543 295.457,248.305 294.875,248.015 294.367 C 247.724 293.860,247.487 293.610,247.487 293.813 M59.834 294.134 C 59.834 294.534,61.669 298.061,61.878 298.061 C 61.979 298.061,61.624 297.188,61.088 296.122 C 60.058 294.071,59.834 293.715,59.834 294.134 M250.785 300.646 C 251.219 301.256,251.657 301.754,251.759 301.754 C 251.860 301.754,251.588 301.256,251.154 300.646 C 250.720 300.037,250.282 299.538,250.181 299.538 C 250.079 299.538,250.351 300.037,250.785 300.646 M342.404 300.878 C 341.969 301.614,341.674 302.277,341.748 302.351 C 341.821 302.425,342.254 301.822,342.710 301.012 C 343.744 299.171,343.479 299.055,342.404 300.878 M152.331 304.588 C 151.763 305.333,151.486 305.827,151.716 305.685 C 152.189 305.392,153.788 303.232,153.532 303.232 C 153.440 303.232,152.900 303.842,152.331 304.588 M67.221 306.556 C 67.655 307.165,68.093 307.664,68.194 307.664 C 68.296 307.664,68.024 307.165,67.590 306.556 C 67.156 305.946,66.718 305.448,66.616 305.448 C 66.515 305.448,66.787 305.946,67.221 306.556 M339.058 305.711 C 339.058 305.923,337.946 307.322,336.586 308.819 C 335.226 310.317,334.825 310.877,335.694 310.065 C 337.744 308.148,339.579 305.845,339.287 305.554 C 339.161 305.428,339.058 305.498,339.058 305.711 M259.095 310.988 C 261.119 313.019,262.858 314.681,262.959 314.681 C 263.061 314.681,261.488 313.019,259.464 310.988 C 257.441 308.957,255.702 307.295,255.600 307.295 C 255.499 307.295,257.071 308.957,259.095 310.988 M148.274 309.603 L 146.814 311.173 148.384 309.713 C 149.247 308.910,149.954 308.203,149.954 308.143 C 149.954 307.864,149.632 308.143,148.274 309.603 M71.734 311.554 C 72.286 312.135,72.805 312.537,72.886 312.446 C 72.967 312.355,72.515 311.879,71.881 311.389 L 70.729 310.497 71.734 311.554 M74.608 314.127 C 75.297 314.838,75.944 315.420,76.045 315.420 C 76.147 315.420,75.666 314.838,74.977 314.127 C 74.288 313.416,73.641 312.835,73.539 312.835 C 73.438 312.835,73.918 313.416,74.608 314.127 M142.728 314.774 L 141.644 315.974 142.844 314.889 C 143.963 313.878,144.214 313.573,143.929 313.573 C 143.865 313.573,143.325 314.114,142.728 314.774 M329.542 315.431 C 328.878 316.034,328.473 316.528,328.642 316.528 C 328.810 316.528,329.425 316.030,330.009 315.420 C 331.367 314.003,331.105 314.009,329.542 315.431 M86.427 321.699 C 87.138 322.088,87.886 322.407,88.089 322.407 C 88.292 322.407,87.876 322.088,87.165 321.699 C 86.454 321.310,85.706 320.991,85.503 320.991 C 85.300 320.991,85.716 321.310,86.427 321.699 M130.009 322.253 C 129.501 322.543,129.252 322.781,129.455 322.781 C 129.658 322.781,130.240 322.543,130.748 322.253 C 131.256 321.963,131.505 321.725,131.302 321.725 C 131.099 321.725,130.517 321.963,130.009 322.253 M315.051 323.361 C 314.543 323.651,314.294 323.889,314.497 323.889 C 314.700 323.889,315.282 323.651,315.789 323.361 C 316.297 323.071,316.547 322.833,316.343 322.833 C 316.140 322.833,315.559 323.071,315.051 323.361 M124.284 324.284 C 123.819 324.484,123.751 324.602,124.100 324.602 C 124.404 324.602,124.986 324.459,125.392 324.284 C 125.858 324.084,125.926 323.967,125.577 323.967 C 125.272 323.967,124.691 324.110,124.284 324.284 M121.330 325.023 C 120.864 325.223,120.796 325.341,121.145 325.341 C 121.450 325.341,122.031 325.198,122.438 325.023 C 122.903 324.823,122.972 324.706,122.622 324.706 C 122.318 324.706,121.736 324.849,121.330 325.023 M107.748 326.767 C 108.404 326.849,109.567 326.850,110.333 326.770 C 111.100 326.690,110.563 326.623,109.141 326.622 C 107.719 326.620,107.092 326.685,107.748 326.767 M295.375 326.767 C 296.031 326.849,297.194 326.850,297.960 326.770 C 298.727 326.690,298.190 326.623,296.768 326.622 C 295.346 326.620,294.719 326.685,295.375 326.767 "
          stroke="none"
          fill="#949c9c"
          fillRule="evenodd"
        ></path>
        <path
          id="path5"
          d="M295.759 31.293 C 296.423 31.375,297.420 31.373,297.975 31.289 C 298.530 31.205,297.987 31.137,296.768 31.139 C 295.549 31.141,295.095 31.210,295.759 31.293 M107.766 31.665 C 108.635 31.743,109.964 31.742,110.721 31.663 C 111.477 31.583,110.766 31.520,109.141 31.521 C 107.516 31.522,106.897 31.587,107.766 31.665 M292.059 31.655 C 292.516 31.743,293.264 31.743,293.721 31.655 C 294.178 31.567,293.804 31.495,292.890 31.495 C 291.976 31.495,291.602 31.567,292.059 31.655 M300.369 31.649 C 300.725 31.742,301.307 31.742,301.662 31.649 C 302.018 31.556,301.727 31.480,301.016 31.480 C 300.305 31.480,300.014 31.556,300.369 31.649 M102.216 32.024 C 102.673 32.112,103.421 32.112,103.878 32.024 C 104.335 31.936,103.961 31.864,103.047 31.864 C 102.133 31.864,101.759 31.936,102.216 32.024 M114.778 32.025 C 115.238 32.113,115.902 32.110,116.255 32.017 C 116.609 31.925,116.233 31.853,115.420 31.857 C 114.608 31.861,114.319 31.936,114.778 32.025 M98.615 32.502 C 97.884 32.736,97.845 32.798,98.430 32.798 C 98.837 32.798,99.584 32.665,100.092 32.502 C 100.823 32.268,100.862 32.207,100.277 32.207 C 99.871 32.207,99.123 32.340,98.615 32.502 M125.946 34.287 C 126.251 34.475,126.916 34.740,127.424 34.876 C 128.066 35.048,128.178 35.019,127.793 34.781 C 127.488 34.592,126.824 34.327,126.316 34.191 C 125.674 34.020,125.561 34.049,125.946 34.287 M84.857 37.146 C 83.425 37.923,83.587 38.191,85.042 37.451 C 86.434 36.743,86.680 36.559,86.211 36.580 C 86.025 36.588,85.416 36.843,84.857 37.146 M136.842 39.303 C 137.452 39.826,138.102 40.256,138.289 40.257 C 138.689 40.259,138.685 40.255,137.027 39.185 L 135.734 38.351 136.842 39.303 M77.562 41.710 C 76.445 42.488,75.201 43.519,74.798 44.000 C 74.137 44.790,74.173 44.781,75.167 43.914 C 75.774 43.385,77.059 42.422,78.024 41.773 C 78.989 41.123,79.778 40.517,79.778 40.425 C 79.778 40.172,79.739 40.195,77.562 41.710 M138.873 40.549 C 138.873 40.708,139.401 41.150,140.046 41.531 C 140.691 41.912,142.312 43.122,143.647 44.221 C 145.670 45.884,145.785 45.944,144.334 44.575 C 142.301 42.657,138.873 40.130,138.873 40.549 M70.894 47.564 L 68.144 50.415 70.904 47.830 C 72.422 46.408,73.738 45.203,73.828 45.152 C 73.918 45.102,73.914 44.982,73.818 44.886 C 73.723 44.791,72.407 45.995,70.894 47.564 M147.012 47.080 C 147.323 47.493,148.321 48.662,149.228 49.680 C 150.135 50.697,151.345 52.110,151.917 52.819 C 152.796 53.910,152.778 53.852,151.806 52.447 C 151.173 51.533,149.708 49.783,148.550 48.558 C 147.392 47.333,146.700 46.668,147.012 47.080 M65.905 53.433 C 65.336 54.179,65.059 54.673,65.290 54.530 C 65.763 54.238,67.362 52.078,67.105 52.078 C 67.014 52.078,66.474 52.688,65.905 53.433 M153.818 55.679 C 154.388 56.542,154.924 57.248,155.010 57.248 C 155.276 57.248,153.862 55.000,153.307 54.542 C 153.019 54.304,153.249 54.815,153.818 55.679 M155.863 59.095 C 156.278 59.908,156.700 60.572,156.802 60.572 C 156.903 60.572,156.647 59.908,156.233 59.095 C 155.818 58.283,155.396 57.618,155.294 57.618 C 155.193 57.618,155.449 58.283,155.863 59.095 M159.246 65.928 C 159.244 66.131,159.468 66.879,159.741 67.590 C 160.015 68.301,160.244 68.633,160.251 68.329 C 160.257 68.024,160.034 67.276,159.755 66.667 C 159.476 66.057,159.247 65.725,159.246 65.928 M161.097 72.207 C 161.091 72.613,161.229 73.278,161.404 73.684 C 161.808 74.625,161.808 73.654,161.404 72.392 C 161.166 71.649,161.106 71.613,161.097 72.207 M56.721 73.341 C 56.585 73.883,56.545 74.397,56.632 74.484 C 56.719 74.571,56.901 74.199,57.037 73.658 C 57.173 73.117,57.213 72.602,57.126 72.515 C 57.039 72.428,56.857 72.800,56.721 73.341 M162.633 82.179 C 162.634 83.601,162.701 84.138,162.781 83.371 C 162.861 82.605,162.860 81.442,162.778 80.786 C 162.697 80.130,162.631 80.757,162.633 82.179 M55.546 85.319 C 55.546 88.061,55.604 89.183,55.676 87.812 C 55.747 86.440,55.747 84.197,55.676 82.825 C 55.604 81.454,55.546 82.576,55.546 85.319 M350.653 85.319 C 350.653 88.061,350.711 89.183,350.782 87.812 C 350.853 86.440,350.853 84.197,350.782 82.825 C 350.711 81.454,350.653 82.576,350.653 85.319 M162.633 88.089 C 162.634 89.511,162.701 90.047,162.781 89.281 C 162.861 88.514,162.860 87.351,162.778 86.695 C 162.697 86.040,162.631 86.667,162.633 88.089 M161.265 97.184 C 160.957 98.723,161.255 99.022,161.588 97.507 C 161.728 96.868,161.766 96.269,161.672 96.175 C 161.578 96.081,161.395 96.535,161.265 97.184 M159.616 102.995 C 159.380 103.782,159.187 104.652,159.187 104.929 C 159.187 105.388,201.948 148.476,202.404 148.476 C 202.512 148.476,192.997 138.878,181.259 127.147 C 158.710 104.610,159.265 105.234,159.936 103.201 C 160.174 102.480,160.296 101.817,160.207 101.727 C 160.118 101.638,159.852 102.209,159.616 102.995 M238.778 113.112 L 231.394 120.591 238.873 113.208 C 245.823 106.347,246.519 105.633,246.257 105.633 C 246.204 105.633,242.839 108.998,238.778 113.112 M60.203 107.248 C 60.203 107.647,61.670 110.434,61.880 110.434 C 61.982 110.434,61.709 109.728,61.273 108.864 C 60.417 107.166,60.203 106.843,60.203 107.248 M65.005 115.789 C 65.634 116.704,66.231 117.452,66.333 117.452 C 66.434 117.452,66.003 116.704,65.374 115.789 C 64.745 114.875,64.147 114.127,64.046 114.127 C 63.944 114.127,64.376 114.875,65.005 115.789 M70.545 122.386 C 72.068 123.968,74.146 125.945,75.162 126.779 C 77.367 128.590,77.102 128.316,71.837 123.345 C 68.542 120.234,68.298 120.052,70.545 122.386 M225.296 126.593 L 219.575 132.410 225.392 126.690 C 230.797 121.375,231.377 120.776,231.113 120.776 C 231.060 120.776,228.442 123.393,225.296 126.593 M334.799 123.453 L 332.595 125.762 334.903 123.557 C 336.173 122.345,337.211 121.306,337.211 121.249 C 337.211 120.976,336.847 121.309,334.799 123.453 M81.256 131.084 C 81.764 131.500,82.345 131.841,82.548 131.842 C 82.944 131.845,82.276 131.333,81.071 130.711 C 80.580 130.457,80.642 130.583,81.256 131.084 M323.823 131.698 C 322.442 132.447,322.526 132.759,323.915 132.041 C 324.524 131.725,325.023 131.389,325.023 131.292 C 325.023 131.055,324.983 131.068,323.823 131.698 M213.477 138.412 L 207.756 144.229 213.573 138.509 C 216.773 135.362,219.391 132.745,219.391 132.691 C 219.391 132.428,218.791 133.008,213.477 138.412 M87.441 134.477 C 87.801 134.939,87.922 144.608,87.996 178.983 L 88.092 222.899 88.183 178.900 C 88.268 137.373,88.237 134.873,87.627 134.394 C 87.055 133.945,87.033 133.955,87.441 134.477 M318.184 178.947 C 318.184 203.121,318.228 212.956,318.283 200.802 C 318.337 188.649,318.337 168.871,318.282 156.850 C 318.228 144.830,318.184 154.774,318.184 178.947 M130.192 137.858 C 130.082 138.315,130.038 157.221,130.094 179.871 L 130.197 221.053 130.288 179.431 C 130.353 149.375,130.493 137.739,130.789 137.555 C 131.029 137.407,134.149 140.210,138.269 144.274 L 145.337 151.247 138.323 144.137 C 131.169 136.885,130.544 136.402,130.192 137.858 M274.404 138.030 C 273.978 138.592,273.980 138.621,274.422 138.227 C 274.707 137.973,275.073 137.765,275.235 137.765 C 275.598 137.765,275.634 220.272,275.271 220.635 C 275.128 220.778,272.095 218.022,268.531 214.510 L 262.050 208.126 268.494 214.666 C 273.472 219.719,275.048 221.115,275.421 220.806 C 276.067 220.270,275.956 137.722,275.309 137.507 C 275.086 137.432,274.678 137.668,274.404 138.030 M271.448 140.997 L 270.175 142.382 271.560 141.109 C 272.850 139.925,273.115 139.612,272.833 139.612 C 272.772 139.612,272.148 140.235,271.448 140.997 M205.526 146.353 L 203.693 148.292 205.633 146.459 C 207.434 144.756,207.741 144.414,207.465 144.414 C 207.407 144.414,206.534 145.286,205.526 146.353 M158.818 164.912 C 166.231 172.327,172.378 178.393,172.480 178.393 C 172.582 178.393,166.600 172.327,159.187 164.912 C 151.775 157.498,145.627 151.431,145.525 151.431 C 145.424 151.431,151.406 157.498,158.818 164.912 M259.629 152.816 L 258.356 154.201 259.741 152.928 C 261.031 151.744,261.296 151.431,261.014 151.431 C 260.953 151.431,260.329 152.054,259.629 152.816 M246.353 166.020 C 245.456 166.934,244.805 167.682,244.906 167.682 C 245.008 167.682,245.825 166.934,246.722 166.020 C 247.619 165.106,248.270 164.358,248.169 164.358 C 248.067 164.358,247.250 165.106,246.353 166.020 M240.616 171.837 L 238.412 174.146 240.720 171.941 C 241.990 170.729,243.029 169.690,243.029 169.633 C 243.029 169.360,242.664 169.693,240.616 171.837 M234.883 177.562 L 233.610 178.947 234.995 177.675 C 236.285 176.490,236.550 176.177,236.268 176.177 C 236.206 176.177,235.583 176.801,234.883 177.562 M241.736 187.996 C 246.202 192.465,249.938 196.122,250.040 196.122 C 250.141 196.122,246.571 192.465,242.105 187.996 C 237.640 183.527,233.903 179.871,233.801 179.871 C 233.700 179.871,237.270 183.527,241.736 187.996 M166.197 185.688 L 163.066 188.920 166.297 185.788 C 169.299 182.880,169.697 182.456,169.429 182.456 C 169.373 182.456,167.919 183.910,166.197 185.688 M160.295 191.505 C 159.398 192.419,158.747 193.167,158.849 193.167 C 158.951 193.167,159.768 192.419,160.665 191.505 C 161.562 190.591,162.213 189.843,162.111 189.843 C 162.010 189.843,161.193 190.591,160.295 191.505 M153.454 198.430 L 150.508 201.477 153.555 198.531 C 155.231 196.911,156.602 195.540,156.602 195.484 C 156.602 195.215,156.190 195.600,153.454 198.430 M255.956 202.216 C 259.099 205.365,261.755 207.941,261.856 207.941 C 261.958 207.941,259.469 205.365,256.325 202.216 C 253.181 199.067,250.526 196.491,250.424 196.491 C 250.323 196.491,252.812 199.067,255.956 202.216 M144.409 207.479 L 138.689 213.296 144.506 207.576 C 147.705 204.430,150.323 201.812,150.323 201.759 C 150.323 201.495,149.723 202.075,144.409 207.479 M203.544 209.880 C 203.631 209.931,204.365 210.554,205.175 211.265 L 206.648 212.558 205.375 211.173 C 204.675 210.411,203.941 209.788,203.744 209.788 C 203.547 209.788,203.457 209.829,203.544 209.880 M180.882 231.494 C 169.153 243.229,159.562 253.077,159.568 253.378 C 159.576 253.749,159.708 253.687,159.980 253.186 C 160.201 252.779,169.876 242.932,181.482 231.302 C 193.088 219.672,202.498 210.157,202.395 210.157 C 202.292 210.157,192.611 219.759,180.882 231.494 M210.520 216.528 C 212.649 218.712,214.436 220.499,214.490 220.499 C 214.757 220.499,214.306 220.025,210.619 216.429 L 206.648 212.558 210.520 216.528 M134.811 216.990 C 133.914 217.904,133.263 218.652,133.364 218.652 C 133.466 218.652,134.283 217.904,135.180 216.990 C 136.077 216.076,136.728 215.328,136.627 215.328 C 136.525 215.328,135.708 216.076,134.811 216.990 M220.499 226.593 C 223.642 229.741,226.298 232.318,226.399 232.318 C 226.501 232.318,224.012 229.741,220.868 226.593 C 217.724 223.444,215.069 220.868,214.967 220.868 C 214.866 220.868,217.355 223.444,220.499 226.593 M232.318 238.412 C 235.461 241.560,238.117 244.137,238.218 244.137 C 238.320 244.137,235.831 241.560,232.687 238.412 C 229.543 235.263,226.888 232.687,226.786 232.687 C 226.685 232.687,229.174 235.263,232.318 238.412 M334.257 233.911 C 334.257 233.974,334.797 234.514,335.457 235.111 L 336.657 236.196 335.573 234.995 C 334.561 233.876,334.257 233.625,334.257 233.911 M69.437 236.196 C 68.540 237.110,67.889 237.858,67.990 237.858 C 68.092 237.858,68.909 237.110,69.806 236.196 C 70.703 235.282,71.354 234.534,71.253 234.534 C 71.151 234.534,70.334 235.282,69.437 236.196 M242.283 248.292 C 244.413 250.476,246.199 252.262,246.254 252.262 C 246.521 252.262,246.070 251.789,242.382 248.193 L 238.412 244.321 242.283 248.292 M242.788 272.207 C 242.788 273.934,242.852 274.640,242.930 273.777 C 243.007 272.913,243.007 271.500,242.930 270.637 C 242.852 269.774,242.788 270.480,242.788 272.207 M55.118 270.729 C 55.118 271.440,55.194 271.731,55.287 271.376 C 55.380 271.020,55.380 270.439,55.287 270.083 C 55.194 269.728,55.118 270.018,55.118 270.729 M162.981 277.008 C 162.981 277.922,163.054 278.296,163.142 277.839 C 163.230 277.382,163.230 276.634,163.142 276.177 C 163.054 275.720,162.981 276.094,162.981 277.008 M255.217 307.779 C 255.217 307.843,255.757 308.383,256.417 308.980 L 257.618 310.065 256.533 308.864 C 255.522 307.745,255.217 307.494,255.217 307.779 "
          stroke="none"
          fill="#cccccd"
          fillRule="evenodd"
        ></path>
        <path
          id="path6"
          d="M112.373 31.649 C 112.729 31.742,113.310 31.742,113.666 31.649 C 114.021 31.556,113.730 31.480,113.019 31.480 C 112.308 31.480,112.018 31.556,112.373 31.649 M242.790 85.134 C 242.789 86.962,242.852 87.757,242.929 86.899 C 243.007 86.042,243.008 84.546,242.931 83.575 C 242.855 82.604,242.792 83.306,242.790 85.134 M165.820 111.634 C 166.726 112.599,167.515 113.389,167.575 113.389 C 167.852 113.389,167.559 113.057,165.928 111.527 L 164.174 109.880 165.820 111.634 M172.484 118.375 C 173.173 119.086,173.820 119.668,173.921 119.668 C 174.023 119.668,173.542 119.086,172.853 118.375 C 172.164 117.664,171.517 117.082,171.416 117.082 C 171.314 117.082,171.795 117.664,172.484 118.375 M70.914 123.176 C 72.223 124.497,73.377 125.577,73.478 125.577 C 73.580 125.577,72.592 124.497,71.283 123.176 C 69.975 121.856,68.821 120.776,68.719 120.776 C 68.618 120.776,69.605 121.856,70.914 123.176 M176.916 122.738 C 176.916 122.801,177.456 123.342,178.116 123.938 L 179.317 125.023 178.232 123.823 C 177.221 122.704,176.916 122.453,176.916 122.738 M183.564 129.386 C 183.564 129.450,184.104 129.990,184.765 130.586 L 185.965 131.671 184.880 130.471 C 183.869 129.352,183.564 129.101,183.564 129.386 M190.197 136.011 C 191.103 136.976,191.892 137.765,191.951 137.765 C 192.229 137.765,191.935 137.434,190.305 135.903 L 188.550 134.257 190.197 136.011 M196.122 141.944 C 196.122 142.007,196.662 142.548,197.322 143.144 L 198.523 144.229 197.438 143.029 C 196.427 141.910,196.122 141.658,196.122 141.944 M351.012 273.130 C 351.013 275.162,351.075 275.945,351.150 274.872 C 351.225 273.799,351.224 272.137,351.148 271.179 C 351.072 270.221,351.011 271.099,351.012 273.130 M107.572 327.139 C 108.333 327.219,109.580 327.219,110.342 327.139 C 111.103 327.059,110.480 326.994,108.957 326.994 C 107.433 326.994,106.810 327.059,107.572 327.139 M295.393 327.141 C 296.262 327.219,297.591 327.218,298.348 327.138 C 299.104 327.059,298.393 326.995,296.768 326.996 C 295.143 326.998,294.524 327.063,295.393 327.141 "
          stroke="none"
          fill="#d2d4d4"
          fillRule="evenodd"
        ></path>
        <path
          id="path7"
          d="M106.710 30.801 C 106.625 30.880,104.852 31.129,102.769 31.353 C 99.284 31.728,93.531 33.004,93.081 33.501 C 92.976 33.617,93.306 33.615,93.813 33.496 C 94.321 33.378,96.316 32.912,98.246 32.461 C 105.344 30.802,116.341 31.264,124.469 33.564 C 127.200 34.337,127.634 34.416,127.054 34.039 C 124.776 32.555,107.727 29.841,106.710 30.801 M292.151 30.986 C 291.440 31.114,293.593 31.217,296.935 31.215 C 300.277 31.213,302.521 31.105,301.921 30.977 C 300.519 30.676,293.835 30.682,292.151 30.986 M288.370 31.655 C 288.829 31.744,289.494 31.740,289.847 31.648 C 290.200 31.556,289.825 31.483,289.012 31.487 C 288.199 31.492,287.911 31.567,288.370 31.655 M304.252 31.655 C 304.711 31.744,305.376 31.740,305.729 31.648 C 306.082 31.556,305.706 31.483,304.894 31.487 C 304.081 31.492,303.792 31.567,304.252 31.655 M285.134 32.133 C 284.428 32.589,285.188 32.589,286.611 32.133 L 287.535 31.837 286.611 31.806 C 286.103 31.789,285.439 31.936,285.134 32.133 M307.295 32.133 C 308.718 32.589,309.477 32.589,308.772 32.133 C 308.467 31.936,307.802 31.789,307.295 31.806 L 306.371 31.837 307.295 32.133 M281.440 33.080 C 280.729 33.349,280.397 33.576,280.702 33.584 C 281.006 33.592,281.921 33.360,282.733 33.067 C 283.546 32.774,283.878 32.547,283.472 32.563 C 283.066 32.578,282.151 32.811,281.440 33.080 M311.173 33.067 C 311.985 33.360,312.899 33.594,313.204 33.589 C 313.509 33.583,313.093 33.338,312.281 33.046 C 311.468 32.753,310.554 32.518,310.249 32.524 C 309.945 32.530,310.360 32.774,311.173 33.067 M89.566 34.517 C 84.126 36.572,76.730 41.297,71.959 45.766 C 68.925 48.608,63.208 55.575,63.594 55.960 C 63.692 56.059,64.627 54.959,65.670 53.516 C 71.709 45.159,80.457 38.471,90.120 34.823 C 91.440 34.325,92.590 33.848,92.675 33.764 C 93.043 33.397,91.614 33.743,89.566 34.517 M128.532 34.815 C 129.040 35.044,130.826 35.853,132.502 36.613 C 134.178 37.373,135.549 37.912,135.549 37.811 C 135.549 37.520,128.689 34.346,128.120 34.374 C 127.839 34.388,128.024 34.586,128.532 34.815 M273.130 36.235 C 271.911 36.850,270.748 37.525,270.545 37.736 C 270.224 38.070,275.463 35.603,275.869 35.229 C 276.350 34.788,275.061 35.261,273.130 36.235 M320.026 36.225 C 321.238 36.826,322.393 37.481,322.593 37.680 C 322.792 37.880,323.121 38.042,323.324 38.042 C 323.557 38.042,323.564 37.915,323.343 37.697 C 322.890 37.251,318.509 35.081,318.119 35.109 C 317.955 35.121,318.813 35.623,320.026 36.225 M136.122 38.349 C 136.315 38.518,137.802 39.540,139.428 40.621 C 151.566 48.697,160.332 62.461,162.364 76.639 C 162.510 77.655,162.702 78.268,162.793 78.003 C 162.992 77.415,162.290 73.436,161.410 70.175 C 159.812 64.249,156.312 57.370,152.204 52.084 C 148.339 47.110,144.353 43.393,139.179 39.936 C 136.702 38.281,135.081 37.440,136.122 38.349 M324.469 38.635 C 325.801 39.661,326.712 39.951,325.577 38.987 C 324.968 38.470,324.303 38.051,324.100 38.056 C 323.897 38.062,324.063 38.322,324.469 38.635 M265.772 40.550 C 263.412 42.156,255.959 48.906,255.953 49.443 C 255.952 49.571,257.452 48.228,259.288 46.456 C 261.123 44.685,264.062 42.233,265.817 41.008 C 267.573 39.783,268.856 38.787,268.669 38.795 C 268.482 38.803,267.178 39.592,265.772 40.550 M327.978 40.767 C 327.978 40.866,328.476 41.302,329.086 41.736 C 329.695 42.170,330.194 42.383,330.194 42.210 C 330.194 42.037,329.695 41.601,329.086 41.241 C 328.476 40.881,327.978 40.667,327.978 40.767 M332.779 44.633 C 334.100 45.872,336.094 47.854,337.211 49.038 C 338.329 50.222,338.830 50.684,338.325 50.064 C 336.510 47.838,334.773 46.073,332.595 44.242 L 330.379 42.380 332.779 44.633 M255.027 50.360 C 253.904 51.632,250.930 56.079,251.779 55.217 C 252.577 54.407,255.656 50.178,255.533 50.061 C 255.461 49.992,255.233 50.127,255.027 50.360 M340.688 53.463 C 342.769 56.281,343.307 56.897,342.545 55.586 C 341.433 53.674,339.994 51.724,339.688 51.716 C 339.526 51.712,339.976 52.498,340.688 53.463 M62.501 57.525 C 60.437 60.491,55.961 72.251,56.217 74.037 C 56.276 74.452,56.630 73.546,57.002 72.022 C 57.879 68.440,59.793 63.501,61.816 59.605 C 63.504 56.352,63.672 55.844,62.501 57.525 M343.675 57.987 C 343.990 58.596,344.331 59.095,344.433 59.095 C 344.534 59.095,344.359 58.596,344.044 57.987 C 343.729 57.378,343.388 56.879,343.287 56.879 C 343.185 56.879,343.360 57.378,343.675 57.987 M248.181 60.979 C 247.555 62.219,247.104 63.294,247.178 63.368 C 247.253 63.443,247.844 62.429,248.492 61.115 C 249.140 59.801,249.591 58.726,249.494 58.726 C 249.397 58.726,248.806 59.740,248.181 60.979 M346.471 63.343 C 346.471 63.546,346.709 64.127,346.999 64.635 C 347.289 65.143,347.527 65.392,347.527 65.189 C 347.527 64.986,347.289 64.404,346.999 63.897 C 346.709 63.389,346.471 63.139,346.471 63.343 M246.431 64.795 C 245.786 66.212,245.883 66.867,246.550 65.589 C 246.859 64.997,247.059 64.354,246.995 64.162 C 246.931 63.970,246.677 64.255,246.431 64.795 M347.563 65.959 C 347.580 66.592,349.368 71.471,349.379 70.914 C 349.392 70.203,348.152 66.219,347.812 65.879 C 347.670 65.737,347.557 65.773,347.563 65.959 M245.429 67.590 C 245.291 68.027,245.260 68.467,245.362 68.569 C 245.463 68.671,245.660 68.396,245.799 67.959 C 245.937 67.522,245.968 67.082,245.866 66.980 C 245.765 66.879,245.568 67.153,245.429 67.590 M244.549 70.581 C 244.322 71.231,244.148 72.029,244.161 72.354 C 244.175 72.679,244.417 72.204,244.699 71.298 C 245.290 69.402,245.166 68.810,244.549 70.581 M349.463 72.392 C 349.457 72.899,349.595 73.647,349.769 74.054 L 350.087 74.792 350.076 74.054 C 350.070 73.647,349.932 72.899,349.769 72.392 L 349.473 71.468 349.463 72.392 M243.562 74.402 C 243.423 75.144,243.392 75.833,243.494 75.935 C 243.596 76.036,243.792 75.513,243.931 74.772 C 244.071 74.031,244.101 73.341,244.000 73.239 C 243.898 73.138,243.701 73.661,243.562 74.402 M350.224 76.085 C 350.224 76.796,350.300 77.087,350.393 76.731 C 350.486 76.376,350.486 75.794,350.393 75.439 C 350.300 75.083,350.224 75.374,350.224 76.085 M55.654 75.857 C 55.515 76.219,55.418 77.041,55.439 77.685 C 55.475 78.825,55.485 78.817,55.816 77.402 C 56.182 75.842,56.070 74.773,55.654 75.857 M242.854 79.106 C 242.704 80.260,242.659 81.424,242.755 81.692 C 242.851 81.960,243.053 81.235,243.203 80.081 C 243.354 78.927,243.398 77.764,243.302 77.496 C 243.206 77.228,243.004 77.952,242.854 79.106 M350.693 84.278 C 350.693 87.999,350.572 92.041,350.425 93.259 L 350.157 95.476 350.679 93.075 C 351.216 90.606,351.398 80.028,350.933 78.368 C 350.801 77.898,350.693 80.557,350.693 84.278 M162.901 84.711 C 162.906 92.152,162.366 95.744,160.211 102.612 L 159.479 104.948 160.349 105.891 C 165.391 111.359,202.566 148.107,203.055 148.107 C 204.190 148.107,246.362 105.601,246.302 104.517 C 246.254 103.634,246.246 103.631,246.091 104.444 C 245.905 105.410,203.824 147.738,203.049 147.738 C 202.280 147.738,160.499 105.757,160.355 104.839 C 160.286 104.400,160.575 102.944,160.997 101.604 C 162.791 95.918,164.252 79.919,163.084 78.751 C 162.982 78.648,162.899 81.330,162.901 84.711 M55.175 85.319 C 55.175 87.858,55.234 88.897,55.306 87.627 C 55.378 86.357,55.378 84.280,55.306 83.010 C 55.234 81.741,55.175 82.779,55.175 85.319 M242.745 89.566 C 242.746 90.379,242.874 91.542,243.029 92.151 L 243.311 93.259 243.333 92.151 C 243.345 91.542,243.218 90.379,243.050 89.566 L 242.744 88.089 242.745 89.566 M55.407 92.921 C 55.410 93.513,55.583 94.247,55.790 94.552 C 56.061 94.949,56.098 94.687,55.920 93.629 C 55.614 91.797,55.400 91.502,55.407 92.921 M243.429 94.922 C 243.420 95.226,243.654 96.307,243.950 97.322 L 244.488 99.169 244.265 97.507 C 244.027 95.726,243.457 93.965,243.429 94.922 M56.174 96.157 C 56.112 97.428,58.128 103.909,59.639 107.295 C 60.092 108.310,60.529 109.317,60.610 109.532 C 61.011 110.600,63.722 114.866,63.998 114.866 C 64.173 114.866,63.980 114.395,63.570 113.818 C 61.391 110.759,58.385 103.632,56.854 97.900 C 56.498 96.567,56.192 95.782,56.174 96.157 M349.605 96.973 C 349.466 97.715,349.435 98.404,349.537 98.506 C 349.638 98.607,349.835 98.084,349.974 97.343 C 350.113 96.602,350.144 95.912,350.043 95.810 C 349.941 95.709,349.744 96.232,349.605 96.973 M348.505 101.308 C 348.132 102.569,347.740 103.850,347.635 104.155 C 347.509 104.520,347.568 104.583,347.806 104.340 C 348.244 103.891,349.586 99.416,349.352 99.182 C 349.260 99.091,348.879 100.047,348.505 101.308 M244.517 99.723 C 244.517 100.028,244.678 100.526,244.875 100.831 C 245.194 101.323,245.233 101.323,245.233 100.831 C 245.233 100.526,245.072 100.028,244.875 99.723 C 244.557 99.231,244.517 99.231,244.517 99.723 M245.256 101.939 C 245.256 102.244,245.417 102.742,245.614 103.047 C 245.932 103.540,245.972 103.540,245.972 103.047 C 245.972 102.742,245.811 102.244,245.614 101.939 C 245.296 101.447,245.256 101.447,245.256 101.939 M346.518 106.732 C 346.094 107.752,345.820 108.587,345.910 108.587 C 346.184 108.587,347.659 105.246,347.469 105.056 C 347.370 104.957,346.942 105.711,346.518 106.732 M343.649 112.339 C 343.300 113.018,342.367 114.529,341.576 115.697 C 340.786 116.865,340.271 117.821,340.432 117.821 C 340.887 117.821,344.731 111.552,344.450 111.270 C 344.358 111.179,343.998 111.660,343.649 112.339 M64.285 115.387 C 64.268 115.691,66.817 119.269,67.757 120.260 C 67.970 120.484,68.987 121.565,70.018 122.661 C 71.048 123.757,72.876 125.501,74.080 126.537 C 77.584 129.552,79.623 130.904,85.319 133.987 C 86.233 134.481,87.103 135.077,87.252 135.310 C 87.401 135.543,87.526 155.190,87.529 178.969 C 87.535 225.695,87.664 222.824,85.503 223.953 C 84.894 224.271,84.578 224.538,84.802 224.547 C 85.026 224.555,85.774 224.181,86.464 223.716 L 87.719 222.870 87.813 179.157 C 87.884 146.074,87.801 135.317,87.473 134.921 C 87.234 134.633,86.444 134.100,85.717 133.737 C 77.343 129.550,69.983 123.255,64.932 115.957 C 64.587 115.458,64.296 115.202,64.285 115.387 M336.040 122.351 C 333.872 124.631,332.137 126.535,332.184 126.582 C 332.355 126.754,337.105 122.012,338.647 120.129 C 341.012 117.241,340.411 117.754,336.040 122.351 M329.576 128.280 C 327.210 130.192,326.712 130.739,328.163 129.831 C 329.242 129.155,332.040 126.670,331.671 126.714 C 331.570 126.726,330.627 127.431,329.576 128.280 M324.706 131.494 C 323.821 132.075,322.990 132.664,322.860 132.803 C 322.484 133.202,325.496 131.607,326.316 130.973 C 327.575 130.000,326.403 130.379,324.706 131.494 M319.196 134.647 L 318.375 135.222 318.381 178.876 C 318.384 202.886,318.508 222.722,318.658 222.957 C 318.807 223.191,318.885 203.581,318.832 179.379 L 318.735 135.375 319.571 134.732 C 320.610 133.932,320.313 133.865,319.196 134.647 M130.603 138.350 C 130.216 139.356,130.356 219.522,130.745 220.129 C 131.084 220.658,171.102 181.294,172.159 179.393 C 172.517 178.749,163.687 169.162,162.734 169.160 C 162.551 169.160,164.504 171.268,167.074 173.845 C 169.643 176.422,171.745 178.769,171.745 179.061 C 171.745 179.352,162.604 188.740,151.431 199.922 L 131.117 220.254 131.117 179.172 C 131.117 156.578,131.251 138.174,131.415 138.275 C 131.578 138.376,138.517 145.281,146.835 153.619 C 155.152 161.958,162.123 168.782,162.325 168.785 C 162.527 168.788,155.714 161.810,147.184 153.278 C 131.836 137.927,131.040 137.210,130.603 138.350 M254.557 158.186 C 241.796 170.948,234.164 178.845,234.164 179.289 C 234.164 180.269,274.858 220.986,275.239 220.386 C 275.609 219.804,275.604 138.822,275.234 138.240 C 275.044 137.941,268.125 144.616,254.557 158.186 M275.072 199.608 L 274.977 220.141 254.848 200.021 C 243.777 188.954,234.660 179.621,234.589 179.280 C 234.502 178.865,241.157 171.992,254.718 158.490 L 274.977 138.319 275.072 158.697 C 275.125 169.905,275.125 188.315,275.072 199.608 M197.230 215.512 C 194.290 218.458,191.998 220.868,192.137 220.868 C 192.276 220.868,194.711 218.541,197.547 215.697 C 203.060 210.170,203.287 210.034,204.617 211.450 C 205.094 211.958,205.663 212.372,205.882 212.371 C 206.100 212.370,205.748 211.872,205.099 211.263 C 203.302 209.579,202.978 209.754,197.230 215.512 M206.833 213.339 C 206.833 213.728,237.973 244.883,238.167 244.689 C 238.250 244.607,231.233 237.453,222.575 228.791 C 213.917 220.129,206.833 213.176,206.833 213.339 M181.721 231.026 C 176.339 236.409,172.036 240.813,172.158 240.813 C 172.280 240.813,176.808 236.408,182.220 231.025 C 187.632 225.642,191.935 221.238,191.782 221.239 C 191.630 221.239,187.102 225.644,181.721 231.026 M320.222 224.007 C 320.729 224.298,321.311 224.535,321.514 224.535 C 321.717 224.535,321.468 224.298,320.960 224.007 C 320.452 223.717,319.871 223.480,319.668 223.480 C 319.464 223.480,319.714 223.717,320.222 224.007 M81.331 226.114 C 80.661 226.527,80.191 226.944,80.286 227.039 C 80.382 227.134,81.093 226.782,81.867 226.256 C 83.521 225.132,83.101 225.020,81.331 226.114 M79.040 227.491 C 79.040 227.681,78.749 227.931,78.393 228.048 C 78.038 228.165,77.082 228.857,76.270 229.585 L 74.792 230.909 76.824 229.520 C 79.388 227.767,80.084 227.147,79.488 227.147 C 79.242 227.147,79.040 227.302,79.040 227.491 M328.569 228.940 C 329.974 229.927,331.350 231.007,331.627 231.341 C 331.904 231.675,332.293 231.948,332.490 231.948 C 332.688 231.948,332.134 231.351,331.259 230.620 C 329.358 229.032,326.658 227.147,326.284 227.147 C 326.136 227.147,327.165 227.954,328.569 228.940 M70.721 234.626 L 67.775 237.673 70.822 234.727 C 72.498 233.107,73.869 231.735,73.869 231.680 C 73.869 231.411,73.457 231.796,70.721 234.626 M335.719 234.995 C 337.249 236.626,337.581 236.919,337.581 236.642 C 337.581 236.583,336.791 235.793,335.826 234.888 L 334.072 233.241 335.719 234.995 M338.319 238.042 C 338.797 238.550,339.249 238.966,339.324 238.966 C 339.631 238.966,338.109 237.141,337.793 237.131 C 337.606 237.124,337.842 237.535,338.319 238.042 M66.701 238.781 C 66.368 239.289,66.153 239.705,66.222 239.705 C 66.292 239.705,66.710 239.289,67.152 238.781 C 67.593 238.273,67.808 237.858,67.630 237.858 C 67.452 237.858,67.033 238.273,66.701 238.781 M340.580 240.813 C 341.233 241.625,341.833 242.290,341.914 242.290 C 342.199 242.290,339.978 239.351,339.687 239.343 C 339.525 239.339,339.927 240.000,340.580 240.813 M64.549 241.736 C 63.997 242.650,63.613 243.398,63.695 243.398 C 63.777 243.398,64.349 242.650,64.966 241.736 C 65.583 240.822,65.967 240.074,65.820 240.074 C 65.673 240.074,65.101 240.822,64.549 241.736 M165.728 247.025 C 162.537 250.239,159.926 253.087,159.926 253.354 C 159.926 253.621,160.294 253.360,160.745 252.774 C 161.195 252.188,163.929 249.340,166.819 246.445 C 169.710 243.550,171.953 241.182,171.803 241.182 C 171.653 241.182,168.919 243.811,165.728 247.025 M343.902 245.979 C 344.357 246.790,344.790 247.392,344.864 247.319 C 345.022 247.160,343.496 244.506,343.246 244.506 C 343.151 244.506,343.446 245.169,343.902 245.979 M242.347 249.215 C 244.301 251.196,245.988 253.066,246.097 253.370 C 246.252 253.806,246.301 253.787,246.324 253.278 C 246.352 252.658,239.707 245.614,239.093 245.614 C 238.929 245.614,240.394 247.235,242.347 249.215 M60.554 248.235 C 60.130 249.067,59.846 249.812,59.923 249.889 C 60.000 249.967,60.425 249.286,60.867 248.376 C 61.874 246.304,61.602 246.182,60.554 248.235 M345.733 249.123 C 345.733 249.326,345.970 249.908,346.260 250.416 C 346.551 250.923,346.788 251.173,346.788 250.970 C 346.788 250.766,346.551 250.185,346.260 249.677 C 345.970 249.169,345.733 248.920,345.733 249.123 M59.125 251.098 C 58.905 251.509,58.727 252.063,58.728 252.330 C 58.729 252.598,58.982 252.334,59.289 251.746 C 59.596 251.157,59.774 250.602,59.686 250.514 C 59.597 250.425,59.345 250.688,59.125 251.098 M347.564 253.370 C 347.564 253.675,347.726 254.174,347.922 254.478 C 348.241 254.971,348.280 254.971,348.280 254.478 C 348.280 254.174,348.119 253.675,347.922 253.370 C 347.604 252.878,347.564 252.878,347.564 253.370 M160.430 255.032 C 161.096 257.295,162.108 260.072,161.978 259.280 C 161.691 257.528,160.931 255.031,160.572 254.663 C 160.337 254.421,160.288 254.549,160.430 255.032 M57.291 256.361 C 57.064 257.011,56.891 257.726,56.905 257.950 C 56.919 258.173,57.169 257.706,57.461 256.911 C 57.752 256.116,57.925 255.402,57.847 255.323 C 57.768 255.244,57.518 255.711,57.291 256.361 M348.306 255.452 C 348.298 255.682,348.535 256.430,348.831 257.114 C 349.128 257.797,349.377 258.168,349.385 257.937 C 349.393 257.707,349.157 256.959,348.860 256.275 C 348.563 255.592,348.314 255.221,348.306 255.452 M244.482 258.050 C 244.276 258.593,244.155 259.286,244.214 259.590 C 244.273 259.894,244.506 259.450,244.732 258.603 C 245.194 256.870,245.051 256.554,244.482 258.050 M56.351 259.491 C 56.216 260.032,56.188 260.558,56.289 260.660 C 56.391 260.761,56.585 260.401,56.721 259.860 C 56.857 259.319,56.885 258.793,56.783 258.691 C 56.682 258.590,56.487 258.950,56.351 259.491 M349.463 259.280 C 349.481 260.239,350.063 261.816,350.076 260.942 C 350.082 260.536,349.944 259.871,349.769 259.464 C 349.575 259.012,349.456 258.940,349.463 259.280 M243.583 261.496 C 243.442 262.134,243.405 262.734,243.499 262.828 C 243.593 262.922,243.776 262.468,243.906 261.819 C 244.036 261.170,244.073 260.571,243.990 260.487 C 243.906 260.403,243.723 260.857,243.583 261.496 M162.212 261.311 C 162.222 261.717,162.356 262.548,162.512 263.158 L 162.793 264.266 162.811 263.158 C 162.821 262.548,162.686 261.717,162.512 261.311 L 162.194 260.572 162.212 261.311 M350.224 262.973 C 350.224 263.684,350.300 263.975,350.393 263.620 C 350.486 263.264,350.486 262.682,350.393 262.327 C 350.300 261.971,350.224 262.262,350.224 262.973 M242.936 265.143 C 242.784 265.829,242.670 266.826,242.683 267.359 L 242.706 268.329 243.070 267.418 C 243.270 266.917,243.384 265.920,243.323 265.202 L 243.213 263.897 242.936 265.143 M162.967 265.559 C 162.967 266.270,163.043 266.560,163.135 266.205 C 163.228 265.849,163.228 265.268,163.135 264.912 C 163.043 264.557,162.967 264.848,162.967 265.559 M350.773 266.851 C 350.887 268.273,351.040 269.506,351.113 269.591 C 351.393 269.914,351.179 265.707,350.880 265.005 C 350.690 264.558,350.648 265.289,350.773 266.851 M55.133 267.036 C 55.133 267.950,55.205 268.324,55.293 267.867 C 55.381 267.410,55.381 266.662,55.293 266.205 C 55.205 265.748,55.133 266.122,55.133 267.036 M163.378 273.130 C 163.379 277.282,163.430 277.792,163.634 275.716 C 163.774 274.294,163.772 271.967,163.632 270.545 C 163.426 268.468,163.376 268.976,163.378 273.130 M54.572 271.376 C 54.465 272.341,54.504 273.878,54.659 274.792 C 54.895 276.188,54.947 275.906,54.986 273.038 C 55.037 269.297,54.874 268.645,54.572 271.376 M242.425 273.130 C 242.426 275.162,242.488 275.945,242.563 274.872 C 242.638 273.799,242.637 272.137,242.561 271.179 C 242.485 270.221,242.424 271.099,242.425 273.130 M350.940 278.116 C 350.900 279.030,350.775 280.194,350.662 280.702 C 350.487 281.491,350.517 281.531,350.871 280.977 C 351.099 280.621,351.224 279.457,351.149 278.392 L 351.014 276.454 350.940 278.116 M55.133 279.224 C 55.133 280.139,55.205 280.512,55.293 280.055 C 55.381 279.598,55.381 278.850,55.293 278.393 C 55.205 277.936,55.133 278.310,55.133 279.224 M242.722 279.224 C 242.728 279.935,242.866 280.933,243.029 281.440 C 243.283 282.234,243.326 282.156,243.335 280.886 C 243.341 280.074,243.203 279.077,243.029 278.670 C 242.773 278.075,242.713 278.182,242.722 279.224 M162.967 280.702 C 162.967 281.413,163.043 281.704,163.135 281.348 C 163.228 280.993,163.228 280.411,163.135 280.055 C 163.043 279.700,162.967 279.991,162.967 280.702 M162.562 282.733 C 162.529 283.139,162.409 283.887,162.296 284.395 C 162.119 285.192,162.149 285.229,162.510 284.663 C 162.740 284.302,162.859 283.554,162.775 283.001 C 162.675 282.345,162.601 282.252,162.562 282.733 M350.224 283.287 C 350.224 283.998,350.300 284.289,350.393 283.934 C 350.486 283.578,350.486 282.996,350.393 282.641 C 350.300 282.285,350.224 282.576,350.224 283.287 M243.461 283.657 C 243.455 284.164,243.593 284.912,243.767 285.319 L 244.085 286.057 244.074 285.319 C 244.068 284.912,243.930 284.164,243.767 283.657 L 243.472 282.733 243.461 283.657 M349.584 285.873 C 349.444 286.511,349.413 287.117,349.514 287.218 C 349.616 287.320,349.814 286.880,349.954 286.242 C 350.094 285.603,350.126 284.998,350.024 284.896 C 349.923 284.795,349.725 285.234,349.584 285.873 M56.172 285.503 C 56.183 285.808,56.335 286.390,56.510 286.796 L 56.827 287.535 56.847 286.796 C 56.859 286.390,56.707 285.808,56.510 285.503 C 56.191 285.011,56.154 285.011,56.172 285.503 M161.437 287.753 C 161.187 288.587,161.051 289.337,161.134 289.420 C 161.217 289.503,161.490 288.889,161.739 288.055 C 161.989 287.221,162.125 286.471,162.042 286.388 C 161.959 286.305,161.687 286.919,161.437 287.753 M244.166 286.796 C 244.164 287.202,244.400 287.950,244.691 288.458 C 245.365 289.638,245.368 289.385,244.701 287.535 C 244.409 286.722,244.168 286.390,244.166 286.796 M160.480 290.674 C 160.341 291.111,160.311 291.552,160.413 291.653 C 160.514 291.755,160.711 291.480,160.849 291.043 C 160.988 290.607,161.019 290.166,160.917 290.064 C 160.815 289.963,160.619 290.237,160.480 290.674 M245.264 290.199 C 245.239 290.772,246.751 294.831,246.925 294.657 C 246.997 294.585,246.657 293.452,246.170 292.138 C 245.682 290.825,245.275 289.952,245.264 290.199 M57.987 291.671 C 57.987 292.192,59.539 295.893,59.693 295.739 C 59.820 295.613,58.411 291.719,58.139 291.444 C 58.056 291.359,57.987 291.461,57.987 291.671 M346.524 295.001 C 346.087 295.951,345.803 296.803,345.893 296.893 C 345.983 296.984,346.398 296.262,346.814 295.291 C 347.800 292.993,347.559 292.752,346.524 295.001 M247.096 295.213 C 247.088 295.706,248.610 298.513,248.788 298.334 C 248.880 298.242,248.538 297.437,248.028 296.544 C 247.518 295.652,247.098 295.053,247.096 295.213 M60.654 297.906 C 60.844 298.640,63.708 303.219,63.981 303.225 C 64.129 303.229,63.630 302.255,62.873 301.061 C 60.981 298.078,60.533 297.441,60.654 297.906 M157.024 298.483 C 156.764 298.900,156.632 299.322,156.731 299.421 C 156.830 299.520,157.105 299.241,157.341 298.800 C 157.899 297.757,157.640 297.497,157.024 298.483 M342.782 301.970 C 342.343 302.715,342.052 303.394,342.137 303.479 C 342.221 303.563,342.650 303.023,343.090 302.278 C 343.530 301.532,343.820 300.853,343.736 300.769 C 343.651 300.684,343.222 301.225,342.782 301.970 M154.017 303.573 C 154.017 303.760,153.586 304.425,153.060 305.050 C 152.535 305.675,152.244 306.183,152.414 306.179 C 152.878 306.167,154.866 303.232,154.410 303.232 C 154.194 303.232,154.017 303.385,154.017 303.573 M252.262 304.340 C 252.696 304.949,253.134 305.448,253.236 305.448 C 253.337 305.448,253.066 304.949,252.632 304.340 C 252.198 303.730,251.759 303.232,251.658 303.232 C 251.556 303.232,251.828 303.730,252.262 304.340 M64.266 303.773 C 64.266 304.195,66.743 307.490,67.493 308.065 C 67.930 308.401,67.887 308.265,67.361 307.653 C 66.931 307.151,66.058 306.009,65.422 305.115 C 64.786 304.222,64.266 303.618,64.266 303.773 M340.093 305.910 C 338.366 307.950,337.344 309.477,338.548 308.218 C 339.712 307.000,342.116 303.970,341.918 303.970 C 341.816 303.970,340.995 304.843,340.093 305.910 M253.370 305.881 C 253.370 306.247,254.853 307.782,255.033 307.601 C 255.133 307.502,254.799 307.031,254.292 306.554 C 253.785 306.078,253.370 305.775,253.370 305.881 M149.829 308.957 C 149.065 309.871,148.542 310.619,148.667 310.619 C 148.910 310.619,150.686 308.618,151.173 307.794 C 151.729 306.853,151.218 307.295,149.829 308.957 M255.621 308.586 C 256.442 309.753,259.254 312.617,259.405 312.440 C 259.480 312.353,258.543 311.283,257.322 310.065 C 256.101 308.846,255.336 308.181,255.621 308.586 M68.340 308.967 C 68.328 309.364,72.777 313.807,74.054 314.673 C 74.460 314.949,73.506 313.971,71.933 312.500 C 70.361 311.030,68.911 309.547,68.713 309.207 C 68.514 308.866,68.346 308.758,68.340 308.967 M336.539 310.067 C 336.099 310.574,335.878 310.988,336.049 310.988 C 336.471 310.988,337.744 309.550,337.520 309.326 C 337.421 309.228,336.980 309.561,336.539 310.067 M333.703 312.900 L 332.225 314.406 333.980 312.988 C 334.945 312.208,335.734 311.522,335.734 311.464 C 335.734 311.067,334.972 311.606,333.703 312.900 M146.196 312.740 C 144.456 314.175,143.936 314.697,144.093 314.851 C 144.168 314.925,145.050 314.252,146.053 313.356 C 148.053 311.569,148.157 311.123,146.196 312.740 M74.977 315.380 C 74.977 315.559,75.392 315.977,75.900 316.310 C 76.408 316.642,76.824 316.858,76.824 316.788 C 76.824 316.718,76.408 316.300,75.900 315.859 C 75.392 315.417,74.977 315.202,74.977 315.380 M142.961 315.576 C 142.713 315.874,141.686 316.647,140.678 317.294 C 139.670 317.941,138.922 318.546,139.015 318.640 C 139.143 318.768,142.237 316.700,143.644 315.546 C 143.729 315.477,143.711 315.333,143.604 315.227 C 143.498 315.120,143.208 315.277,142.961 315.576 M262.615 315.328 C 262.622 315.480,263.079 315.924,263.631 316.314 L 264.635 317.023 263.740 316.037 C 262.799 315.001,262.596 314.873,262.615 315.328 M330.166 316.037 L 329.271 317.023 330.275 316.314 C 330.827 315.924,331.284 315.480,331.290 315.328 C 331.309 314.873,331.107 315.001,330.166 316.037 M77.532 317.401 C 78.024 318.007,79.409 318.922,79.409 318.642 C 79.409 318.571,78.869 318.118,78.209 317.635 C 77.466 317.091,77.208 317.002,77.532 317.401 M264.820 317.080 C 264.820 317.355,268.192 319.558,268.359 319.391 C 268.448 319.302,267.688 318.711,266.671 318.078 C 265.653 317.446,264.820 316.996,264.820 317.080 M327.619 317.839 C 326.914 318.337,326.498 318.743,326.696 318.742 C 326.893 318.741,327.553 318.332,328.163 317.832 C 329.585 316.666,329.275 316.670,327.619 317.839 M324.928 319.451 C 323.410 320.424,323.200 320.767,324.538 320.087 C 325.185 319.757,325.818 319.321,325.945 319.116 C 326.241 318.637,326.152 318.666,324.928 319.451 M270.729 320.761 C 270.729 320.862,271.394 321.284,272.207 321.699 C 273.019 322.114,273.684 322.370,273.684 322.268 C 273.684 322.166,273.019 321.744,272.207 321.330 C 271.394 320.915,270.729 320.659,270.729 320.761 M321.572 321.373 C 320.791 321.785,320.230 322.200,320.325 322.295 C 320.501 322.470,323.176 321.011,323.176 320.739 C 323.176 320.530,323.149 320.540,321.572 321.373 M132.225 322.253 C 131.311 322.742,130.695 323.150,130.855 323.160 C 131.247 323.182,134.072 321.731,134.072 321.507 C 134.072 321.262,134.087 321.256,132.225 322.253 M89.012 323.730 C 89.520 324.021,90.102 324.258,90.305 324.258 C 90.508 324.258,90.259 324.021,89.751 323.730 C 89.243 323.440,88.661 323.203,88.458 323.203 C 88.255 323.203,88.504 323.440,89.012 323.730 M129.067 323.510 C 128.874 323.694,127.969 324.101,127.054 324.416 C 126.140 324.730,125.725 324.986,126.131 324.983 C 127.038 324.977,130.791 323.250,129.991 323.207 C 129.676 323.190,129.260 323.327,129.067 323.510 M276.639 323.730 C 277.147 324.021,277.729 324.258,277.932 324.258 C 278.135 324.258,277.886 324.021,277.378 323.730 C 276.870 323.440,276.288 323.203,276.085 323.203 C 275.882 323.203,276.131 323.440,276.639 323.730 M316.528 323.730 C 316.020 324.021,315.771 324.258,315.974 324.258 C 316.177 324.258,316.759 324.021,317.267 323.730 C 317.775 323.440,318.024 323.203,317.821 323.203 C 317.618 323.203,317.036 323.440,316.528 323.730 M94.367 325.556 C 94.977 325.854,95.891 326.088,96.399 326.077 C 97.249 326.057,97.234 326.031,96.214 325.752 C 93.533 325.018,93.190 324.981,94.367 325.556 M122.622 325.596 C 121.532 325.908,121.278 326.072,121.884 326.073 C 122.392 326.074,123.389 325.851,124.100 325.577 C 125.722 324.953,124.828 324.964,122.622 325.596 M282.169 325.608 C 282.874 325.914,283.871 326.099,284.385 326.018 C 285.171 325.895,285.133 325.864,284.140 325.817 C 283.492 325.787,282.859 325.596,282.733 325.392 C 282.608 325.189,282.141 325.030,281.696 325.038 C 281.060 325.049,281.162 325.172,282.169 325.608 M310.249 325.596 C 309.159 325.908,308.905 326.072,309.511 326.073 C 310.018 326.074,311.016 325.851,311.727 325.577 C 313.348 324.953,312.455 324.964,310.249 325.596 M98.246 326.490 C 98.550 326.692,99.367 326.861,100.062 326.864 C 101.717 326.872,101.422 326.662,99.354 326.362 C 98.192 326.193,97.858 326.232,98.246 326.490 M118.375 326.500 L 117.267 326.782 118.375 326.820 C 118.984 326.841,119.732 326.697,120.037 326.500 C 120.723 326.057,120.117 326.057,118.375 326.500 M285.873 326.490 C 286.177 326.692,286.994 326.861,287.689 326.864 C 289.344 326.872,289.049 326.662,286.981 326.362 C 285.819 326.193,285.485 326.232,285.873 326.490 M306.002 326.500 L 304.894 326.782 306.187 326.820 C 306.898 326.841,307.729 326.697,308.033 326.500 C 308.715 326.060,307.734 326.060,306.002 326.500 M103.056 327.280 C 104.268 327.618,114.426 327.608,115.605 327.269 C 116.113 327.122,113.291 327.007,109.335 327.014 C 105.378 327.020,102.553 327.140,103.056 327.280 M290.682 327.280 C 291.885 327.615,302.044 327.610,303.232 327.273 C 303.740 327.130,300.918 327.015,296.961 327.018 C 293.003 327.022,290.178 327.140,290.682 327.280 "
          stroke="none"
          fill="#dbdcdc"
          fillRule="evenodd"
        ></path>
      </g>
    </svg>
  );
});
