package org.jboss.as.ee.utils;

import java.security.AccessController;
import java.security.PrivilegedAction;

import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.modules.Module;

/**
 * @author Stuart Douglas
 */
public class ClassLoadingUtils {

    public static Class<?> loadClass(final String className, final DeploymentUnit du) throws ClassNotFoundException {
        return loadClass(className, du.getAttachment(Attachments.MODULE));
    }

    public static Class<?> loadClass(final String className, final Module module) throws ClassNotFoundException {
        final ClassLoader oldTccl = getCurrentClassLoader();
        try {
            setCurrentClassLoader(module.getClassLoader());
            return Class.forName(className, false, module.getClassLoader());
        } finally {
            setCurrentClassLoader(oldTccl);
        }
    }

    private static ClassLoader getCurrentClassLoader(){
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        } else {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>() {
                public ClassLoader run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
    }

    private static void setCurrentClassLoader(final ClassLoader classLoader){
        if (System.getSecurityManager() == null) {
            Thread.currentThread().setContextClassLoader(classLoader);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>() {
                public Object run() {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    return null;
                }
            });
        }
    }
    private ClassLoadingUtils() {

    }
}
