/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2016, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.as.connector.subsystems.datasources;

import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;

import javax.sql.DataSource;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

/**
 * @author Tomas Hofman (thofman@redhat.com)
 */
public class WildFlyDataSourceTestCase {

    @Test
    public void testGetParentLogger() throws SQLFeatureNotSupportedException {
        WildFlyDataSource delegated = Mockito.mock(WildFlyDataSource.class);
        Logger logger = Logger.getAnonymousLogger();
        Mockito.when(delegated.getParentLogger()).thenReturn(logger);

        WildFlyDataSource ds = new WildFlyDataSource(delegated, "jndi");
        Logger returnedLogger = ds.getParentLogger();
        Assert.assertEquals(logger, returnedLogger);
    }

    @Test
    public void testGetParentLoggerJdk6() throws SQLFeatureNotSupportedException {
        DataSource delegated = Mockito.mock(DataSource.class);
        WildFlyDataSource ds = new WildFlyDataSource(delegated, "jndi");
        Logger returnedLogger = null;
        try {
            returnedLogger = ds.getParentLogger();
            if (System.getProperty("java.version").startsWith("1.6")) {
                Assert.fail("SQLFeatureNotSupportedException expected on JDK 6");
            }
        } catch (SQLFeatureNotSupportedException e) {
            // expected for 1.6
            if (!System.getProperty("java.version").startsWith("1.6")) {
                throw e;
            }
        }
        Assert.assertEquals(null, returnedLogger);
    }

}
