/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.diagram.print;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.print.PrintGraphicalViewerOperation;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.widgets.Display;

public class PrintDiagramViewerOperation
extends PrintGraphicalViewerOperation {
    private double zoom = 1.0;

    public PrintDiagramViewerOperation(Printer p, GraphicalViewer g) {
        super(p, g);
    }

    protected void setupPrinterGraphicsFor(Graphics graphics, IFigure figure) {
        double dpiScale = (double)this.getPrinter().getDPI().x / (double)Display.getCurrent().getDPI().x;
        Rectangle printRegion = this.getPrintRegion();
        printRegion.width = (int)((double)printRegion.width / dpiScale);
        printRegion.height = (int)((double)printRegion.height / dpiScale);
        Rectangle bounds = figure.getBounds();
        double xScale = (double)printRegion.width / (double)bounds.width;
        double yScale = (double)printRegion.height / (double)bounds.height;
        switch (this.getPrintMode()) {
            case 2: {
                graphics.scale(Math.min(xScale, yScale) * dpiScale);
                break;
            }
            case 3: {
                graphics.scale(xScale * dpiScale);
                break;
            }
            case 4: {
                graphics.scale(yScale * dpiScale);
                break;
            }
            default: {
                graphics.scale(this.getZoom() * dpiScale);
            }
        }
        graphics.setForegroundColor(figure.getForegroundColor());
        graphics.setBackgroundColor(figure.getBackgroundColor());
        graphics.setFont(figure.getFont());
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setZoom(double zoom) {
        this.zoom = zoom;
    }
}

