/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.jboss.ide.eclipse.freemarker.model.AbstractItem;
import org.jboss.ide.eclipse.freemarker.model.CompletionInterpolation;

public abstract class AbstractDirective
extends AbstractItem {
    String contents;
    public static String[] directives = new String[]{"if", "else", "elseif", "switch", "case", "default", "break", "list", "break", "include", "import", "noparse", "compress", "escape", "noescape", "assign", "global", "local", "setting", "macro", "nested", "return", "flush", "function", "stop", "ftl", "t", "lt", "rt", "nt", "attempt", "recover", "visit", "recurse", "fallback"};

    public String getContents() {
        if (this.contents == null) {
            this.contents = super.getContents();
            if (this.contents != null) {
                try {
                    this.contents = this.contents.substring(2, this.contents.length() - 1);
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
            }
        }
        return this.contents;
    }

    public ICompletionProposal[] getCompletionProposals(int offset, Map context) {
        if (offset < 2) {
            return null;
        }
        AbstractItem.ContentWithOffset contentWithOffset = this.splitContents(offset);
        int index = contentWithOffset.getIndex();
        if (index == 0) {
            int subOffset = contentWithOffset.getOffsetInIndex();
            contentWithOffset.getOffset();
            String[] contents = contentWithOffset.getContents();
            if (contentWithOffset.wasLastCharSpace()) {
                if (contents.length == 1) {
                    CompletionInterpolation completionInterpolation = new CompletionInterpolation("${", offset - contentWithOffset.getOffsetInIndex() - 2, this.getItemSet(), this.getResource());
                    return completionInterpolation.getCompletionProposals(offset, context);
                }
                return null;
            }
            String prefix = contents[index].substring(0, subOffset);
            ArrayList<ICompletionProposal> l = new ArrayList<ICompletionProposal>();
            int i = 0;
            while (i < directives.length) {
                String name = directives[i];
                if (name.startsWith(prefix)) {
                    l.add(this.getCompletionProposal(offset, subOffset, name, contents[0]));
                }
                ++i;
            }
            return this.completionProposals(l);
        }
        if (index == 1 && !contentWithOffset.wasLastCharSpace()) {
            String value = "";
            try {
                value = contentWithOffset.getContents()[index].substring(0, contentWithOffset.getOffsetInIndex());
            }
            catch (Exception exception) {}
            CompletionInterpolation completionInterpolation = new CompletionInterpolation("${" + value, offset - contentWithOffset.getOffsetInIndex() - 2, this.getItemSet(), this.getResource());
            return completionInterpolation.getCompletionProposals(offset, context);
        }
        return null;
    }

    public ICompletionProposal[] completionProposals(List l) {
        Collections.sort(l, new CompletionProposalComparator());
        return l.toArray(new ICompletionProposal[l.size()]);
    }

    public ICompletionProposal getCompletionProposal(int offset, int subOffset, String replacementString, String replacingString) {
        return new CompletionProposal(replacementString, offset - subOffset, replacingString.length(), replacementString.length());
    }

    public class CompletionProposalComparator
    implements Comparator {
        public int compare(Object arg0, Object arg1) {
            return ((ICompletionProposal)arg0).getDisplayString().compareTo(((ICompletionProposal)arg1).getDisplayString());
        }
    }
}

