/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.markers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.PositionHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceMarkers {
    public static String TEXT_PROBLEM = "org.jboss.tools.common.model.textproblemmarker";
    public static String CONSTRAINT_PROBLEM = "org.jboss.tools.jst.web.constraintsmarker";
    public static String JST_WEB_PROBLEM = "org.jboss.tools.jst.web.strutsmarker";
    public static String OLD_CONSTRAINT_PROBLEM = "org.jboss.tools.jst.web.ui.constraintsmarker";
    public static String OLD_JST_WEB_PROBLEM = "org.jboss.tools.jst.web.ui.strutsmarker";
    private XModelObject object;
    String type = null;
    String oldType = null;

    public ResourceMarkers(String type) {
        this.type = type;
    }

    public ResourceMarkers(String type, String oldType) {
        this.type = type;
        this.oldType = oldType;
    }

    public void setModelObject(XModelObject object) {
        this.object = object;
    }

    public void update() {
        if (this.object == null || !this.object.isActive()) {
            return;
        }
        IWorkspaceRunnable r = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ResourceMarkers.this.update0();
            }
        };
        try {
            ModelPlugin.getWorkspace().run(r, null, 1, null);
        }
        catch (CoreException coreException) {}
    }

    private void update0() {
        HashSet<IMarker> dms = null;
        try {
            IResource r = EclipseResourceUtil.getResource(this.object);
            if (r == null || !r.exists()) {
                return;
            }
            IMarker[] ms = this.getOwnedMarkers(r);
            if (ms != null) {
                dms = new HashSet<IMarker>();
                int i = 0;
                while (i < ms.length) {
                    dms.add(ms[i]);
                    ++i;
                }
            }
            String[] errorList = this.getErrors();
            int i = 0;
            while (i < errorList.length) {
                String error = errorList[i];
                if (error != null && error.length() != 0) {
                    String attr;
                    IMarker marker;
                    String message = this.getTrueMessage(error);
                    String path = this.getObjectPathForError(i);
                    int location = this.getLocation(i);
                    if (location < 0) {
                        location = this.getLocation(error);
                    }
                    if ((marker = this.findMarker(path, message, attr = this.getObjectAttributeForError(i), dms)) != null) {
                        dms.remove(marker);
                        ResourceMarkers.updateLocation(marker, location, this.getStart(i), this.getEnd(i));
                    } else {
                        marker = r.createMarker(this.type);
                        marker.setAttribute("message", (Object)message);
                        marker.setAttribute("severity", 2);
                        marker.setAttribute("path", (Object)path);
                        if (attr != null && attr.length() > 0) {
                            marker.setAttribute("attribute", (Object)attr);
                        }
                        ResourceMarkers.updateLocation(marker, location, this.getStart(i), this.getEnd(i));
                    }
                }
                ++i;
            }
            if (dms == null) {
                return;
            }
            ms = dms.toArray(new IMarker[0]);
            i = 0;
            while (i < ms.length) {
                ms[i].delete();
                ++i;
            }
        }
        catch (CoreException e) {
            ModelPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    public static void updateLocation(IMarker marker, int location, int start, int end) throws CoreException {
        if (location >= 0 && marker.getAttribute("lineNumber", -1) != location) {
            marker.setAttribute("lineNumber", location);
        }
        if (start >= 0 && marker.getAttribute("charStart", -1) != start) {
            marker.setAttribute("charStart", start);
        }
        if (end >= 0 && marker.getAttribute("charEnd", -1) != end) {
            marker.setAttribute("charEnd", end);
        }
    }

    private IMarker findMarker(String path, String message, String attr, Set<IMarker> dms) {
        if (dms == null) {
            return null;
        }
        for (IMarker m : dms) {
            try {
                if (!message.equals(m.getAttribute("message")) || attr != null && !attr.equals(m.getAttribute("attribute")) || this.oldType != null && this.oldType.equals(m.getType())) continue;
                if (!path.equals(m.getAttribute("path"))) {
                    m.setAttribute("path", (Object)path);
                }
                return m;
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    protected String getObjectPathForError(int i) {
        return this.object == null ? null : this.object.getPath();
    }

    protected String getObjectAttributeForError(int i) {
        return null;
    }

    protected String getTrueMessage(String message) {
        StringBuffer sb = new StringBuffer();
        int c = 0;
        while (c < message.length()) {
            int i3;
            int i2;
            int i1 = message.indexOf(64, c);
            if (i1 < 0 || (i2 = message.indexOf(64, i1 + 1)) < 0 || (i3 = message.indexOf(64, i2 + 1)) < 0) break;
            if (c > 0) {
                sb.append(message.substring(0, i1));
            }
            sb.append(message.substring(i2 + 1, i3));
            c = i3 + 1;
        }
        sb.append(message.substring(c));
        return sb.toString();
    }

    public void clear() {
        IResource r = EclipseResourceUtil.getResource(this.object);
        if (!(r instanceof IFile)) {
            return;
        }
        final IMarker[] ms = this.getOwnedMarkers(r);
        if (ms == null) {
            return;
        }
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    int i = 0;
                    while (i < ms.length) {
                        ms[i].delete();
                        ++i;
                    }
                }
                catch (CoreException coreException) {}
            }
        };
        try {
            ModelPlugin.getWorkspace().run(runnable, null, 1, null);
        }
        catch (CoreException e) {
            ModelPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    private IMarker[] getOwnedMarkers(IResource r) {
        ArrayList<IMarker> l = null;
        try {
            IMarker[] ms = r.findMarkers(null, false, 1);
            if (ms != null) {
                int i = 0;
                while (i < ms.length) {
                    if (this.isOwnedMarker(ms[i])) {
                        if (l == null) {
                            l = new ArrayList<IMarker>();
                        }
                        l.add(ms[i]);
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
        return l == null ? null : l.toArray(new IMarker[0]);
    }

    protected boolean isOwnedMarker(IMarker m) throws CoreException {
        if (m == null) {
            return false;
        }
        String _type = m.getType();
        if (_type == null) {
            return true;
        }
        if (_type.startsWith("org.jboss.tools.")) {
            return _type.equals(this.type) || this.oldType != null && _type.equals(this.oldType);
        }
        return false;
    }

    protected String[] getErrors() {
        return new String[0];
    }

    protected int getLocation(int i) {
        return -1;
    }

    protected int getLocation(String error) {
        return -1;
    }

    protected int getStart(int i) {
        return -1;
    }

    protected int getEnd(int i) {
        return -1;
    }

    public static void refreshProblemMarkersAsync(final XModelObject file) {
        if (!file.isActive()) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ResourceMarkers.refreshProblemMarkers(file);
            }
        });
    }

    public static void refreshProblemMarkers(XModelObject file) {
        IResource r = (IResource)file.getAdapter(IResource.class);
        if (r == null) {
            return;
        }
        try {
            IMarker[] ms = r.findMarkers(JST_WEB_PROBLEM, true, 1);
            if (ms != null) {
                int i = 0;
                while (i < ms.length) {
                    String path = ms[i].getAttribute("path", null);
                    if (path != null) {
                        XModelObject o = file.getModel().getByPath(path);
                        if (o == null) {
                            ms[i].delete();
                        } else {
                            String attr = ms[i].getAttribute("attribute", null);
                            PositionHolder h = PositionHolder.getPosition(o, attr);
                            h.update();
                            ResourceMarkers.updateLocation(ms[i], h.getLine(), h.getStart(), h.getEnd());
                        }
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
    }
}

