/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.impl;

import java.util.Comparator;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.impl.RegularChildren;

public class GroupOrderedChildren
extends RegularChildren {
    protected XModelObject[] list = EMPTY;
    int[] limits = new int[this.getGroupCount()];

    public boolean areChildrenOrdered() {
        return true;
    }

    protected int getGroupCount() {
        return 2;
    }

    protected int getGroup(XModelObject o) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        super.clear();
        if (this.list != EMPTY) {
            GroupOrderedChildren groupOrderedChildren = this;
            synchronized (groupOrderedChildren) {
                this.list = EMPTY;
                int i = 0;
                while (i < this.limits.length) {
                    this.limits[i] = 0;
                    ++i;
                }
            }
        }
    }

    public XModelObject[] getObjects() {
        return this.list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addObject(XModelObject o) {
        if (!super.addObject(o)) {
            return false;
        }
        int g = this.getGroup(o);
        int i = this.limits[g];
        GroupOrderedChildren groupOrderedChildren = this;
        synchronized (groupOrderedChildren) {
            XModelObject[] ls = new XModelObject[this.list.length + 1];
            System.arraycopy(this.list, 0, ls, 0, i);
            ls[i] = o;
            System.arraycopy(this.list, i, ls, i + 1, this.list.length - i);
            int k = g;
            while (k < this.limits.length) {
                int n = k++;
                this.limits[n] = this.limits[n] + 1;
            }
            this.list = ls;
        }
        return true;
    }

    public boolean removeObject(XModelObject o) {
        if (!super.removeObject(o)) {
            return false;
        }
        int i = this.getIndex(o);
        if (i >= 0) {
            if (this.list.length == 1) {
                this.list = EMPTY;
            } else {
                XModelObject[] ls = new XModelObject[this.list.length - 1];
                if (i > 0) {
                    System.arraycopy(this.list, 0, ls, 0, i);
                }
                System.arraycopy(this.list, i + 1, ls, i, this.list.length - i - 1);
                this.list = ls;
            }
            int g = 0;
            while (g < this.limits.length) {
                if (this.limits[g] > i) {
                    int n = g;
                    this.limits[n] = this.limits[n] - 1;
                }
                ++g;
            }
        }
        return true;
    }

    private int getGroup(int i) {
        int g = 0;
        while (g < this.limits.length) {
            if (this.limits[g] > i) {
                return g;
            }
            ++g;
        }
        return -1;
    }

    public int getIndex(XModelObject o) {
        int i = 0;
        while (i < this.list.length) {
            if (o == this.list[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean move(int from, int to) {
        int g;
        int c = this.list.length;
        if (c == 0) {
            return false;
        }
        if (to >= c) {
            to = c - 1;
        }
        if ((g = this.getGroup(from)) < 0) {
            return false;
        }
        int goff = g == 0 ? 0 : this.limits[g - 1];
        int gend = this.limits[g];
        if (to < goff) {
            to = goff;
        } else if (to >= gend) {
            to = gend - 1;
        }
        if (from < 0 || from >= c || from == to) {
            return false;
        }
        XModelObject o = this.list[from];
        int delta = to > from ? 1 : -1;
        int k = from;
        while (k != to) {
            this.list[k] = this.list[k + delta];
            k += delta;
        }
        this.list[to] = o;
        return true;
    }

    public void sort(Comparator c) {
    }
}

