/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.filesystems.impl;

import java.io.File;
import java.util.Hashtable;
import org.jboss.tools.common.model.filesystems.FilePathHelper;

public class FileSystemPeer {
    private Hashtable<String, Long> p = new Hashtable();

    public void clear() {
        this.p.clear();
    }

    public void register(File f) {
        this.p.put(this.toKey(f), this.toLastModified(f));
    }

    public void unregister(File f) {
        this.p.remove(this.toKey(f));
    }

    public void unregisterDir(File f) {
        this.p.remove(this.toKey(f, true));
    }

    public boolean contains(File f) {
        return this.p.get(this.toKey(f)) != null;
    }

    public boolean containsDir(File f) {
        return this.p.get(this.toKey(f, true)) != null;
    }

    public boolean isUpdated(File f) {
        Long o = this.p.get(this.toKey(f));
        if (o == null) {
            return f.exists();
        }
        return f.lastModified() != o.longValue();
    }

    private String toKey(File f) {
        return this.toKey(f, f.isDirectory());
    }

    private String toKey(File f, boolean asDir) {
        String s = f.getAbsolutePath().replace('\\', '/');
        s = FilePathHelper.toPathPath(s);
        return asDir ? String.valueOf(s) + "/" : s;
    }

    private Long toLastModified(File f) {
        return !f.exists() ? Long.valueOf(0L) : Long.valueOf(f.lastModified());
    }
}

