/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.filesystems.impl;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.engines.impl.EnginesLoader;
import org.jboss.tools.common.model.filesystems.BodySource;
import org.jboss.tools.common.model.filesystems.impl.AbstractXMLFileImpl;
import org.jboss.tools.common.model.filesystems.impl.SFBodySource;
import org.jboss.tools.common.model.filesystems.impl.ThreadSafeCopyFactory;
import org.jboss.tools.common.model.impl.XModelImpl;
import org.jboss.tools.common.model.impl.XModelObjectImpl;
import org.jboss.tools.common.model.loaders.EntityRecognizerContext;
import org.jboss.tools.common.model.loaders.XObjectLoader;
import org.jboss.tools.common.model.markers.ConstraintChecker;
import org.jboss.tools.common.model.util.EntityXMLRegistration;
import org.jboss.tools.common.model.util.XMLUtil;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractExtendedXMLFileImpl
extends AbstractXMLFileImpl {
    private static final long serialVersionUID = 7942041044569562286L;
    ConstraintChecker constraintChecker = new ConstraintChecker(this);
    ThreadSafeCopyFactory threadSafeCopyFactory = null;
    private static String ns = ".NAME.EXTENSION.overlapped.expanded._body_.actualBodyTimeStamp.correctBody.forceLoad.";
    static CheckerJob checkerOnLoad = new CheckerJob();
    static String NO_MERGE_ATTRIBUTES = ".name.extension._lateload.isIncorrect.incorrectBody.expand.";

    XModelObject getThreadSafeCopy() {
        return this.threadSafeCopyFactory == null ? null : this.threadSafeCopyFactory.getThreadSafeCopy();
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public String get(String name) {
        if (name.equals("_hasErrors_")) {
            return super.get("isIncorrect");
        }
        if (this.getParent() != null && ns.indexOf("." + name + ".") < 0) {
            if (this.loadAttributeSeparately(name)) {
                return super.get(name);
            }
            this.loadChildren();
            XModelObject copy = this.getThreadSafeCopy();
            if (copy != null) {
                return copy.get(name);
            }
        }
        return super.get(name);
    }

    protected boolean shouldLoadAttributeSeparately(String xmlname) {
        return false;
    }

    private boolean loadAttributeSeparately(String xmlname) {
        BodySource source = this.getBodySource();
        if (source == null) {
            return this.threadSafeCopyFactory == null;
        }
        if (!this.shouldLoadAttributeSeparately(xmlname)) {
            return false;
        }
        if (xmlname == null || xmlname.length() == 0) {
            return false;
        }
        String oldvalue = super.get(xmlname);
        if (oldvalue != null && oldvalue.length() > 0) {
            return true;
        }
        String body = source.get();
        Document doc = XMLUtil.getDocument(new StringReader(body));
        if (doc == null) {
            return false;
        }
        Element element = doc.getDocumentElement();
        if (element == null) {
            return false;
        }
        XModelObjectLoaderUtil util = new XModelObjectLoaderUtil();
        util.setSaveEntity(false);
        String value = util.getAttribute(element, xmlname);
        if (value == null || value.length() == 0) {
            return false;
        }
        super.set(xmlname, value);
        return true;
    }

    @Override
    public boolean isObjectEditable() {
        return super.isObjectEditable() && !"yes".equals(this.get("_hasErrors_"));
    }

    @Override
    public XModelObject[] getChildren() {
        XModelObject copy = this.getThreadSafeCopy();
        return copy != null ? copy.getChildren() : super.getChildren();
    }

    @Override
    protected void loadChildren() {
        this.getThreadSafeCopy();
        BodySource source = this.getBodySource();
        if (source == null) {
            return;
        }
        this.threadSafeCopyFactory = new ThreadSafeCopyFactory(this);
        super.setBodySource(null);
        XObjectLoader loader = XModelObjectLoaderUtil.getObjectLoader(this);
        String body = source.get();
        XModelObjectLoaderUtil.setTempBody(this, body);
        loader.load(this);
        if (this.threadSafeCopyFactory != null) {
            this.threadSafeCopyFactory.destroy();
            this.threadSafeCopyFactory = null;
        }
        if (!this.isIncorrect() && !this.isOverlapped()) {
            this.runCheckerOnLoad();
        }
    }

    void runCheckerOnLoad() {
        if (!this.isActive()) {
            return;
        }
        XModelObject s = this.getParent();
        while (s != null && s.getFileType() != 3) {
            s = s.getParent();
        }
        if (s == null || !s.getModelEntity().getName().equals("FileSystemFolder")) {
            return;
        }
        checkerOnLoad.add(this);
    }

    @Override
    public void set(String name, String value) {
        super.set(name, value);
        if ("incorrectBody".equals(name) && value.length() > 0) {
            this.set("isIncorrect", "yes");
            int resolution = EntityXMLRegistration.getInstance().resolve(this.getModelEntity());
            if (EntityXMLRegistration.isSystemId(value)) {
                resolution = EntityXMLRegistration.UNRESOLVED;
            }
            this.setErrors(value, resolution == EntityXMLRegistration.DTD, resolution == EntityXMLRegistration.SCHEMA);
        }
    }

    @Override
    public String getAsText() {
        return this.get("body");
    }

    @Override
    public void edit(String body) throws XModelException {
        this.edit(body, false);
    }

    protected boolean isForceLoadOn() {
        return "true".equals(this.get("forceLoad"));
    }

    public void edit(String body, boolean update) throws XModelException {
        if (body == null) {
            return;
        }
        if (!this.isForceLoadOn() && body.equals(this.getAsText())) {
            return;
        }
        String entity = this.getModel().getEntityRecognizer().getEntityName(new EntityRecognizerContext(AbstractExtendedXMLFileImpl.toFileName(this), this.getAttributeValue("extension"), body));
        if (entity == null || !entity.equals(this.getModelEntity().getName())) {
            String[] errors;
            String[] stringArray = errors = body.length() == 0 ? null : XMLUtil.getXMLErrors(new StringReader(body), false);
            if (errors == null || errors.length == 0) {
                errors = new String[]{"Doctype has been changed. Please save file for the change to take effect in object model.    :0:0"};
            }
            this.setErrors(body, errors);
            XModelImpl m = (XModelImpl)this.getModel();
            m.fireStructureChanged(this);
            if (!this.isOverlapped()) {
                this.getResourceMarkers().update();
            }
            return;
        }
        boolean errors1 = "yes".equals(this.get("_hasErrors_"));
        AbstractExtendedXMLFileImpl f = this.getUpdatedFile(body, true);
        if (f == null) {
            return;
        }
        f.getChildren();
        XModelObjectImpl p = (XModelObjectImpl)this.getParent();
        XModelImpl m = (XModelImpl)this.getModel();
        boolean isOverlapped = this.isOverlapped();
        if (!isOverlapped) {
            this.getResourceMarkers().clear();
        }
        if (f.isIncorrect()) {
            this.getChildren();
            boolean fire = this.loaderError == null && f.loaderError != null;
            this.loaderError = f.loaderError;
            super.set("incorrectBody", f.get("incorrectBody"));
            super.set("isIncorrect", "yes");
            if (f.get("errors") != null) {
                super.set("errors", f.get("errors"));
            }
            if (fire) {
                this.changeTimeStamp();
            }
            if (f.get("actualBodyTimeStamp") != null && !"-1".equals(f.get("actualBodyTimeStamp"))) {
                this.mergeAll(f, update);
            }
            m.fireStructureChanged(this);
            if (!isOverlapped) {
                this.getResourceMarkers().update();
            }
        } else if (this.isMergingChanges()) {
            String oldBody = this.get("correctBody");
            boolean changed = body != null && !body.equals(oldBody);
            this.set("correctBody", body);
            this.set("actualBodyTimeStamp", "0");
            long ots = this.getTimeStamp();
            this.mergeAll(f, update);
            if (changed && ots == this.getTimeStamp()) {
                this.changeTimeStamp();
            }
            this.set("actualBodyTimeStamp", "" + this.getTimeStamp());
            if (errors1) {
                m.fireStructureChanged(this);
            }
            if (!isOverlapped) {
                this.constraintChecker.check();
            }
        } else {
            p.removeChild_0(this);
            p.addChild_0(f);
            m.fireStructureChanged(p);
            f.setModified(true);
            if (!isOverlapped) {
                f.getResourceMarkers().update();
            }
        }
    }

    @Override
    protected void safeChangeTimeStamp() {
        boolean b = ("" + this.getTimeStamp()).equals(this.get("actualBodyTimeStamp"));
        this.changeTimeStamp();
        if (b) {
            this.set("actualBodyTimeStamp", "" + this.getTimeStamp());
        }
    }

    protected void mergeAll(XModelObject f, boolean update) throws XModelException {
        this.merge(f, !update);
    }

    protected boolean isMergingChanges() {
        return true;
    }

    protected String getProcessEntity() {
        return null;
    }

    protected boolean hasDTD() {
        return true;
    }

    private AbstractExtendedXMLFileImpl getUpdatedFile(String body, boolean fire) {
        boolean errors2;
        boolean errors1 = "yes".equals(this.get("_hasErrors_"));
        this.loaderError = null;
        int resolution = EntityXMLRegistration.getInstance().resolve(this.getModelEntity());
        if (EntityXMLRegistration.isSystemId(body)) {
            resolution = EntityXMLRegistration.UNRESOLVED;
        }
        this.setErrors(body, resolution == EntityXMLRegistration.DTD, resolution == EntityXMLRegistration.SCHEMA);
        boolean bl = errors2 = this.get("errors") != null && this.get("errors").length() > 0;
        if (errors1 && errors2) {
            super.set("incorrectBody".intern(), body);
            if (fire) {
                this.changeTimeStamp();
                if (this.isActive()) {
                    ((XModelImpl)this.getModel()).fireNodeChanged(this, this.getPath());
                }
                this.setModified(true);
            }
        }
        AbstractExtendedXMLFileImpl f = (AbstractExtendedXMLFileImpl)this.getModel().createModelObject(this.getModelEntity().getName(), null);
        f.setAttributeValue("name", this.getAttributeValue("name"));
        f.setAttributeValue("extension", this.getAttributeValue("extension"));
        if (errors2) {
            f.set("incorrectBody", body);
            f.set("errors", super.get("errors"));
        }
        f.setBodySource(new SFBodySource(body));
        return f;
    }

    protected final void merge(XModelObject update, boolean fire) throws XModelException {
        if (fire) {
            this.fireObjectChanged("beforeMerge");
        }
        if (!"yes".equals(update.get("isIncorrect"))) {
            super.set("incorrectBody", "");
            super.set("isIncorrect", "no");
            super.set("errors", "");
            this.loaderError = null;
        }
        if (update instanceof AbstractExtendedXMLFileImpl) {
            this.loaderError = ((AbstractExtendedXMLFileImpl)update).loaderError;
        }
        Map<String, XModelObject> map = this.getChildrenForSaveAsMap();
        Set<String> set = null;
        XModelObject[] cs = update.getChildren();
        String entity = this.getProcessEntity();
        int i = 0;
        while (i < cs.length) {
            if (entity == null || !entity.equals(cs[i].getModelEntity().getName())) {
                XModelObject c = this.getChildByPath(cs[i].getPathPart());
                if (c == null) {
                    if (set == null) {
                        set = EnginesLoader.getChildrenToRemove(map, update);
                    }
                    if ((c = EnginesLoader.findAppropriateChild(set, cs[i], map)) == null) {
                        c = cs[i].copy();
                        this.addChild(c);
                    } else {
                        boolean has_id;
                        boolean bl = has_id = c.getModelEntity().getAttribute(XModelObjectLoaderUtil.ATTR_ID_NAME) != null;
                        if (has_id) {
                            c.removeFromParent();
                            EnginesLoader.merge(c, cs[i], false);
                            this.addChild(c);
                        } else {
                            EnginesLoader.merge(c, cs[i], fire);
                        }
                    }
                } else if (c.getModelEntity().getName().equals(cs[i].getModelEntity().getName())) {
                    EnginesLoader.merge(c, cs[i], fire);
                } else {
                    this.removeChild(c);
                    this.addChild(cs[i].copy());
                }
                map.remove(c.getPathPart());
            }
            ++i;
        }
        Iterator<XModelObject> it = map.values().iterator();
        while (it.hasNext()) {
            it.next().removeFromParent();
        }
        boolean doFire = false;
        int i2 = 0;
        while (i2 < cs.length) {
            int ci;
            XModelObject c = this.getChildByPath(cs[i2].getPathPart());
            if (c != null && (ci = this.getIndexOfChild(c)) != i2) {
                doFire = true;
                this.move(ci, i2, false);
            }
            ++i2;
        }
        if (fire && doFire) {
            ((XModelImpl)this.getModel()).fireStructureChanged(this);
        }
        this.mergeAttributes(update, fire);
        if (fire) {
            this.fireObjectChanged("afterMerge");
        }
    }

    void mergeAttributes(XModelObject update, boolean fire) throws XModelException {
        XAttribute[] as = update.getModelEntity().getAttributes();
        int i = 0;
        while (i < as.length) {
            String n = as[i].getName();
            if (NO_MERGE_ATTRIBUTES.indexOf("." + n + ".") < 0) {
                XModelObjectLoaderUtil.mergeAttributeComment(this, update, as[i], fire);
                String ov = this.getAttributeValue(n);
                String nv = update.getAttributeValue(n);
                if (ov != null && !ov.equals(nv)) {
                    if (fire) {
                        this.getModel().changeObjectAttribute(this, n, nv);
                    } else {
                        this.setAttributeValue(n, nv);
                    }
                }
            }
            ++i;
        }
        XModelObjectLoaderUtil.mergeFinalComment(this, update, fire);
    }

    private Map<String, XModelObject> getChildrenForSaveAsMap() {
        String entity = this.getProcessEntity();
        XModelObject[] cs = this.getChildrenForSave();
        HashMap<String, XModelObject> map = new HashMap<String, XModelObject>();
        int i = 0;
        while (i < cs.length) {
            if (entity == null || !entity.equals(cs[i].getModelEntity().getName())) {
                map.put(cs[i].getPathPart(), cs[i]);
            }
            ++i;
        }
        return map;
    }

    static class CheckerJob
    extends WorkspaceJob {
        List<AbstractExtendedXMLFileImpl> files = new ArrayList<AbstractExtendedXMLFileImpl>();

        public CheckerJob() {
            super("Checking constraints on load...");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(AbstractExtendedXMLFileImpl file) {
            List<AbstractExtendedXMLFileImpl> list = this.files;
            synchronized (list) {
                this.files.add(file);
            }
            this.schedule();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            while (true) {
                AbstractExtendedXMLFileImpl file = null;
                List<AbstractExtendedXMLFileImpl> list = this.files;
                synchronized (list) {
                    if (this.files.isEmpty()) {
                        break;
                    }
                    file = this.files.remove(0);
                }
                file.getResourceMarkers().clear();
                file.constraintChecker.check();
            }
            return Status.OK_STATUS;
        }
    }
}

