/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.engines.impl;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Properties;
import org.jboss.tools.common.model.engines.impl.ProcessOut;
import org.jboss.tools.common.model.plugin.ModelPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XProcess {
    protected Process process = null;
    ProcessOut err = null;
    ProcessOut out = null;
    Writer w = new XPWriter();
    int exit = -1;

    private String[] getCommandLine() {
        ArrayList<String> l = new ArrayList<String>();
        this.buildCommandLine(l);
        return l.toArray(new String[l.size()]);
    }

    protected abstract void buildCommandLine(ArrayList<String> var1);

    protected abstract String getRoot();

    public void start() {
        if (this.isRunning()) {
            return;
        }
        this.exit = -1;
        try {
            String[] command_line = this.getCommandLine();
            this.process = Runtime.getRuntime().exec(command_line, null, new File(this.getRoot()));
            this.err = new ProcessOut(this.process, true, this.w);
            this.out = new ProcessOut(this.process, false, this.w);
        }
        catch (IOException e) {
            ModelPlugin.getPluginLog().logError((Throwable)e);
        }
        new HookMonitor();
    }

    public final void stop() {
        if (!this.isRunning()) {
            return;
        }
        this.process.destroy();
        this.waitFor();
        this.clear();
    }

    public final boolean isRunning() {
        if (this.process == null) {
            return false;
        }
        try {
            this.exit = this.process.exitValue();
            this.clear();
            return false;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return true;
        }
    }

    private void clear() {
        this.process = null;
        this.err = null;
        this.out = null;
    }

    public final int waitFor() {
        if (this.process == null) {
            return this.exit;
        }
        ProcessOut errc = this.err;
        ProcessOut outc = this.out;
        try {
            this.exit = this.process.waitFor();
            if (errc != null) {
                errc.waitFor();
            }
            if (outc != null) {
                outc.waitFor();
            }
            return this.exit;
        }
        catch (InterruptedException interruptedException) {
            return this.exit;
        }
    }

    protected void write(String s) {
    }

    protected void appendJava(ArrayList<String> l, Properties p) {
        l.add(String.valueOf(this.getJavaHome(p)) + "/bin/java");
    }

    protected String getJavaHome(Properties p) {
        File f = new File(p.getProperty("java.home"));
        return f.getAbsolutePath().replace('\\', '/');
    }

    private class HookMonitor
    implements Runnable {
        Thread sdhook = null;

        public HookMonitor() {
            if (!XProcess.this.isRunning()) {
                return;
            }
            this.sdhook = new Thread(new SD());
            Runtime.getRuntime().addShutdownHook(this.sdhook);
            new Thread(this).start();
        }

        public void run() {
            try {
                XProcess.this.process.waitFor();
            }
            catch (InterruptedException interruptedException) {}
            XProcess.this.stop();
            Runtime.getRuntime().removeShutdownHook(this.sdhook);
        }
    }

    private class SD
    implements Runnable {
        private SD() {
        }

        public void run() {
            XProcess.this.stop();
        }
    }

    class XPWriter
    extends Writer {
        XPWriter() {
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            XProcess.this.write(new String(cbuf, off, len));
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }
    }
}

