/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.meta.action.impl;

import java.io.File;
import java.text.MessageFormat;
import java.util.Properties;
import org.jboss.tools.common.meta.XChild;
import org.jboss.tools.common.meta.action.XAttributeData;
import org.jboss.tools.common.meta.action.XEntityData;
import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.meta.action.impl.WizardDataValidator;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.CreateFileHandler;
import org.jboss.tools.common.model.loaders.EntityRecognizerContext;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;

public class DefaultWizardDataValidator
implements WizardDataValidator {
    protected SpecialWizardSupport support;
    protected int step;
    protected String message = null;
    protected String warning = null;

    public void setSupport(SpecialWizardSupport support, int step) {
        this.support = support;
        this.step = step;
    }

    public int getId() {
        return this.step;
    }

    public void validate(Properties data) {
        String value;
        String resourceAttr;
        this.message = null;
        this.warning = null;
        XEntityData[] ds = this.support.getEntityData();
        if (ds.length <= this.step) {
            return;
        }
        if (this.support.action != null) {
            String entity;
            if ("true".equals(this.support.action.getProperty("validator.add")) && this.step == 0) {
                int max;
                entity = this.support.action.getProperty("entity");
                if (entity == null) {
                    entity = ds[this.step].getModelEntity().getName();
                }
                if (!this.checkChild(this.support.getTarget(), entity, data)) {
                    return;
                }
                XModelObject parent = this.support.getTarget();
                int childCount = parent.getChildren(entity).length;
                XChild c = this.support.getTarget().getModelEntity().getChild(entity);
                int n = max = c == null ? 0 : c.getMaxCount();
                if (c != null && max <= childCount) {
                    String parentTitle = DefaultCreateHandler.title(parent, true);
                    this.message = max == 1 ? MessageFormat.format("{0} can contain only {1} child with entity {2}.", parentTitle, max, entity) : MessageFormat.format("{0} can contain only {1} children with entity {2}.", parentTitle, max, entity);
                }
            } else if ("true".equals(this.support.action.getProperty("validator.edit"))) {
                entity = this.support.action.getProperty("entity");
                if (entity == null) {
                    entity = ds[this.step].getModelEntity().getName();
                }
                if (!this.checkChild(this.support.getTarget().getParent(), entity, data)) {
                    return;
                }
            }
        }
        if (this.message != null) {
            return;
        }
        XAttributeData[] as = ds[this.step].getAttributeData();
        int i = 0;
        while (i < as.length) {
            String n = as[i].getAttribute().getName();
            String value2 = data.getProperty(n);
            if (value2 == null) {
                value2 = "";
            }
            if (this.support.isFieldEditorEnabled(this.step, n, data)) {
                this.message = DefaultCreateHandler.validateAttribute(as[i], value2);
                if (this.message != null) {
                    return;
                }
            }
            ++i;
        }
        if (this.message != null || this.support.action == null) {
            return;
        }
        if ("true".equals(this.support.action.getProperty("validator.addfile")) && this.step == 0) {
            this.validateAddFile(ds, data);
        }
        if ((resourceAttr = this.support.action.getProperty("validator.resource")) != null && (value = data.getProperty(resourceAttr)) != null && !new File(value).exists()) {
            this.message = MessageFormat.format("Resource {0} does not exist.", value);
        }
    }

    protected void validateAddFile(XEntityData[] ds, Properties data) {
        XModelObject o;
        CreateFileHandler.validateNameAndExtension(this.support.action, data, null);
        String entity = this.support.action.getProperty("entity");
        if (entity == null) {
            String ext = null;
            String string = entity = ext != null ? this.support.getTarget().getModel().getEntityRecognizer().getEntityName(new EntityRecognizerContext(ext)) : ds[this.step].getModelEntity().getName();
            if (entity == null || this.support.getTarget().getModel().getMetaData().getEntity(entity) == null) {
                entity = ds[this.step].getModelEntity().getName();
            }
        }
        if ((o = this.support.getTarget().getModel().createModelObject(entity, data)) != null) {
            this.message = DefaultCreateHandler.getContainsMessage(this.support.getTarget(), o);
        }
    }

    public String getErrorMessage() {
        return this.message;
    }

    public String getWarningMessage() {
        return this.warning;
    }

    public boolean isCommandEnabled(String command) {
        if (this.message != null && (SpecialWizardSupport.OK.equals(command) || SpecialWizardSupport.NEXT.equals(command) || SpecialWizardSupport.FINISH.equals(command))) {
            return false;
        }
        return this.support.isActionEnabled(command);
    }

    protected boolean checkChild(XModelObject parent, String entity, Properties data) {
        XModelObject o = this.support.getTarget().getModel().createModelObject(entity, data);
        if (o.getModelEntity().getAttribute(XModelObjectLoaderUtil.ATTR_ID_NAME) != null && !"true".equals(o.getModelEntity().getProperty("unique"))) {
            return true;
        }
        if (o != null && parent == this.support.getTarget().getParent() && o.getPathPart().equals(this.support.getTarget().getPathPart())) {
            return true;
        }
        this.message = DefaultCreateHandler.getContainsMessage(parent, o);
        return this.message == null;
    }
}

