/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.console;

import bsh.EvalError;
import bsh.Interpreter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.console.AbstractQueryPage;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.ConsoleMessages;
import org.hibernate.console.QueryInputModel;
import org.hibernate.engine.SessionImplementor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaPage
extends AbstractQueryPage {
    private String criteriaCode;
    Criteria criteria = null;
    private Interpreter ip;

    public JavaPage(ConsoleConfiguration cfg, String criteriaCode, QueryInputModel model) {
        super(cfg, model);
        this.criteriaCode = criteriaCode;
        this.setTabName(this.getQueryString().replace('\n', ' ').replace('\r', ' '));
    }

    @Override
    public void setSession(Session s) {
        super.setSession(s);
        try {
            if (this.criteriaCode.indexOf("System.exit") >= 0) {
                this.list = Collections.emptyList();
                this.addException(new IllegalArgumentException(ConsoleMessages.JavaPage_not_allowed));
                return;
            }
            this.ip = this.setupInterpreter(this.getSession());
            Object o = this.ip.eval(this.criteriaCode);
            if (o instanceof Criteria) {
                this.criteria = (Criteria)o;
                if (this.model.getMaxResults() != null) {
                    this.criteria.setMaxResults(this.model.getMaxResults().intValue());
                }
            } else if (o instanceof List) {
                this.list = (List)o;
                if (this.model.getMaxResults() != null) {
                    this.list = this.list.subList(0, Math.min(this.list.size(), this.model.getMaxResults()));
                }
            } else {
                this.list = new ArrayList();
                this.list.add(o);
            }
        }
        catch (EvalError e) {
            this.addException(e);
        }
        catch (HibernateException e) {
            this.addException(e);
        }
    }

    private Interpreter setupInterpreter(Session session) throws EvalError, HibernateException {
        Interpreter interpreter = new Interpreter();
        interpreter.set("session", (Object)session);
        interpreter.setClassLoader(Thread.currentThread().getContextClassLoader());
        SessionImplementor si = (SessionImplementor)session;
        Map map = si.getFactory().getAllClassMetadata();
        Iterator iterator = map.keySet().iterator();
        String imports = "";
        while (iterator.hasNext()) {
            String element = (String)iterator.next();
            imports = String.valueOf(imports) + "import " + element + ";\n";
        }
        imports = String.valueOf(imports) + "import org.hibernate.criterion.*;\n";
        imports = String.valueOf(imports) + "import org.hibernate.*;\n";
        interpreter.eval(imports);
        return interpreter;
    }

    @Override
    public List<Object> getList() {
        if (this.list != null) {
            return this.list;
        }
        try {
            if (this.criteria == null) {
                return Collections.emptyList();
            }
            long startTime = System.currentTimeMillis();
            this.list = this.criteria.list();
            this.queryTime = System.currentTimeMillis() - startTime;
        }
        catch (HibernateException e) {
            this.list = Collections.emptyList();
            this.addException(e);
        }
        return this.list;
    }

    @Override
    public List<String> getPathNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(ConsoleMessages.JavaPage_no_info);
        return l;
    }

    @Override
    public String getQueryString() {
        return this.criteriaCode;
    }

    @Override
    public void setQueryString(String queryString) {
        this.criteriaCode = queryString;
        this.list = null;
        this.ip = null;
    }

    @Override
    public void release() {
        super.release();
    }
}

