/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.mapper.editors.reveng;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.hibernate.eclipse.console.model.IRevEngTable;
import org.hibernate.eclipse.mapper.MapperMessages;
import org.hibernate.eclipse.mapper.editors.reveng.FormTextEntryListenerAdapter;
import org.hibernate.eclipse.mapper.editors.reveng.RevEngDetailsPage;
import org.hibernate.eclipse.mapper.editors.reveng.xpl.FormTextEntry;

public class TableDetailsPage
extends RevEngDetailsPage
implements IDetailsPage,
PropertyChangeListener {
    private FormTextEntry nameEntry;
    private FormTextEntry schemaEntry;
    private FormTextEntry catalogEntry;
    private FormTextEntry classEntry;
    private IRevEngTable table;

    protected void buildContents(FormToolkit toolkit, Section section, Composite client) {
        section.setText(MapperMessages.TableDetailsPage_table_details);
        section.setDescription(MapperMessages.TableDetailsPage_set_properties_of_selected_table);
        this.catalogEntry = new FormTextEntry(client, toolkit, MapperMessages.TableDetailsPage_catalog, 0);
        this.catalogEntry.setFormEntryListener(new FormTextEntryListenerAdapter(){

            public void textValueChanged(FormTextEntry entry) {
                TableDetailsPage.this.table.setCatalog(entry.getValue());
            }
        });
        this.schemaEntry = new FormTextEntry(client, toolkit, MapperMessages.TableDetailsPage_schema, 0);
        this.schemaEntry.setFormEntryListener(new FormTextEntryListenerAdapter(){

            public void textValueChanged(FormTextEntry entry) {
                TableDetailsPage.this.table.setSchema(entry.getValue());
            }
        });
        this.nameEntry = new FormTextEntry(client, toolkit, MapperMessages.TableDetailsPage_name, 0);
        this.nameEntry.setFormEntryListener(new FormTextEntryListenerAdapter(){

            public void textValueChanged(FormTextEntry entry) {
                TableDetailsPage.this.table.setName(entry.getValue());
            }
        });
        this.classEntry = new FormTextEntry(client, toolkit, MapperMessages.TableDetailsPage_class_name, 0);
        this.classEntry.setFormEntryListener(new FormTextEntryListenerAdapter(){

            public void textValueChanged(FormTextEntry entry) {
                TableDetailsPage.this.table.setClassname(entry.getValue());
            }
        });
        Button button = toolkit.createButton(client, MapperMessages.TableDetailsPage_add_primary_key, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableDetailsPage.this.handleAddPrimaryKey();
            }
        });
    }

    protected void handleAddPrimaryKey() {
        if (this.table.getPrimaryKey() == null) {
            this.table.addPrimaryKey();
        }
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        IRevEngTable newTable = (IRevEngTable)((IStructuredSelection)selection).getFirstElement();
        if (this.table != null) {
            this.table.removePropertyChangeListener((PropertyChangeListener)this);
        }
        if (newTable != null) {
            newTable.addPropertyChangeListener((PropertyChangeListener)this);
        }
        this.table = newTable;
        this.update();
    }

    private void update() {
        this.catalogEntry.setValue(this.table.getCatalog());
        this.schemaEntry.setValue(this.table.getSchema());
        this.nameEntry.setValue(this.table.getName());
        this.classEntry.setValue(this.table.getClassname());
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.update();
    }
}

