/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views;

import java.util.StringTokenizer;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.eclipse.ui.views.CPDView;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class CPDViewTooltipListener
implements Listener {
    private final CPDView view;
    private Listener labelListener;
    private Shell tip;
    private TreeItem shownItem;

    public CPDViewTooltipListener(CPDView cPDView) {
        this.view = cPDView;
    }

    public void initialize() {
        this.labelListener = new Listener(){

            public void handleEvent(Event event) {
                Label label = (Label)event.widget;
                Shell shell = label.getShell();
                Tree tree = CPDViewTooltipListener.this.view.getTreeViewer().getTree();
                switch (event.type) {
                    case 3: {
                        Event event2 = new Event();
                        event2.item = (TreeItem)label.getData("_TREEITEM");
                        tree.setSelection(new TreeItem[]{(TreeItem)event2.item});
                        tree.notifyListeners(13, event2);
                        shell.dispose();
                        CPDViewTooltipListener.this.view.setFocus();
                        break;
                    }
                    case 7: {
                        shell.dispose();
                        break;
                    }
                }
            }
        };
    }

    public void handleEvent(Event event) {
        Tree tree = this.view.getTreeViewer().getTree();
        TreeItem treeItem = tree.getItem(new Point(event.x, event.y));
        switch (event.type) {
            case 1: 
            case 12: {
                this.disposeTooltip();
                break;
            }
            case 5: {
                if (this.shownItem == null || this.shownItem.equals(treeItem)) break;
                this.disposeTooltip();
                break;
            }
            case 32: {
                TreeNode treeNode;
                if (treeItem == null || !((treeNode = (TreeNode)treeItem.getData()).getValue() instanceof Match)) break;
                Match match = (Match)treeNode.getValue();
                String string = this.createText(match);
                this.showTooltip(treeItem, string);
                break;
            }
        }
    }

    private String createText(Match match) {
        String string = match.getSourceCodeSlice().replaceAll("\t", "    ");
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            if (n >= 6) {
                stringBuffer.append("\n...\n");
                break;
            }
            stringBuffer.append(stringTokenizer.nextToken()).append('\n');
            ++n;
        }
        return stringBuffer.toString();
    }

    private void disposeTooltip() {
        if (this.tip != null && !this.tip.isDisposed()) {
            this.tip.dispose();
        }
    }

    private void showTooltip(TreeItem treeItem, String string) {
        Tree tree = this.view.getTreeViewer().getTree();
        Display display = tree.getDisplay();
        if (this.tip != null && !this.tip.isDisposed()) {
            this.tip.dispose();
        }
        this.tip = new Shell(540676);
        this.tip.setBackground(display.getSystemColor(29));
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginWidth = 5;
        fillLayout.marginHeight = 5;
        this.tip.setLayout((Layout)fillLayout);
        Label label = new Label((Composite)this.tip, 0);
        label.setForeground(display.getSystemColor(28));
        label.setBackground(display.getSystemColor(29));
        label.setData("_TREEITEM", (Object)treeItem);
        label.setText(string);
        label.addListener(7, this.labelListener);
        label.addListener(3, this.labelListener);
        Point point = this.tip.computeSize(-1, -1);
        Rectangle rectangle = treeItem.getBounds(2);
        Point point2 = tree.toDisplay(rectangle.x, rectangle.y);
        Rectangle rectangle2 = tree.getClientArea();
        Point point3 = tree.toDisplay(rectangle2.width, rectangle2.height);
        if (point2.x + point.x + 50 > point3.x) {
            point.x = point3.x - point2.x - 50;
        }
        if (point2.y + point.y + 3 > point3.y) {
            point.y = point3.y - point2.y - 3;
        }
        this.tip.setBounds(point2.x + 50, point2.y + 3, point.x, point.y);
        this.tip.setVisible(true);
        this.shownItem = treeItem;
    }
}

