/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.properties.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.builder.PMDNature;
import net.sourceforge.pmd.eclipse.runtime.properties.IProjectProperties;
import net.sourceforge.pmd.eclipse.runtime.properties.IProjectPropertiesManager;
import net.sourceforge.pmd.eclipse.runtime.properties.PropertiesException;
import net.sourceforge.pmd.eclipse.runtime.properties.impl.ProjectPropertiesTO;
import net.sourceforge.pmd.eclipse.runtime.properties.impl.PropertiesFactoryImpl;
import net.sourceforge.pmd.eclipse.runtime.properties.impl.RuleSpecTO;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.util.LocalConfiguration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;

public class ProjectPropertiesManagerImpl
implements IProjectPropertiesManager {
    private static final Logger log;
    private static final String PROPERTIES_FILE = ".pmd";
    private static final String PROPERTIES_MAPPING = "/net/sourceforge/pmd/eclipse/runtime/properties/impl/mapping.xml";
    private final Map projectsProperties = new HashMap();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.pmd.eclipse.runtime.properties.impl.ProjectPropertiesManagerImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public IProjectProperties loadProjectProperties(IProject iProject) throws PropertiesException {
        log.debug((Object)("Loading project properties for project " + iProject.getName()));
        try {
            IProjectProperties iProjectProperties = (IProjectProperties)this.projectsProperties.get(iProject);
            if (iProjectProperties == null) {
                iProjectProperties = new PropertiesFactoryImpl().newProjectProperties(iProject, this);
                ProjectPropertiesTO projectPropertiesTO = this.readProjectProperties(iProject);
                this.fillProjectProperties(iProjectProperties, projectPropertiesTO);
                this.projectsProperties.put(iProject, iProjectProperties);
            }
            if (iProjectProperties.isRuleSetStoredInProject()) {
                this.loadRuleSetFromProject(iProjectProperties);
            } else {
                boolean bl = this.synchronizeRuleSet(iProjectProperties);
                iProjectProperties.setNeedRebuild(iProjectProperties.isNeedRebuild() || bl);
            }
            return iProjectProperties;
        }
        catch (CoreException coreException) {
            throw new PropertiesException("Core Exception when loading project properties for project " + iProject.getName(), coreException);
        }
    }

    public void storeProjectProperties(IProjectProperties iProjectProperties) throws PropertiesException {
        log.debug((Object)("Storing project properties for project " + iProjectProperties.getProject().getName()));
        try {
            if (iProjectProperties.isPmdEnabled()) {
                PMDNature.addPMDNature(iProjectProperties.getProject(), null);
            } else {
                PMDNature.removePMDNature(iProjectProperties.getProject(), null);
            }
            this.writeProjectProperties(iProjectProperties.getProject(), this.fillTransferObject(iProjectProperties));
            this.projectsProperties.put(iProjectProperties.getProject(), iProjectProperties);
        }
        catch (CoreException coreException) {
            throw new PropertiesException("Core Exception when storing project properties for project " + iProjectProperties.getProject().getName(), coreException);
        }
    }

    private void loadRuleSetFromProject(IProjectProperties iProjectProperties) throws PropertiesException {
        if (iProjectProperties.isRuleSetFileExist()) {
            log.debug((Object)("Loading ruleset from project ruleset file: " + iProjectProperties.getRuleSetFile()));
            try {
                RuleSetFactory ruleSetFactory = new RuleSetFactory();
                File file = iProjectProperties.getResolvedRuleSetFile();
                iProjectProperties.setProjectRuleSet(ruleSetFactory.createRuleSets(file.getPath()).getAllRuleSets()[0]);
            }
            catch (RuleSetNotFoundException ruleSetNotFoundException) {
                PMDPlugin.getDefault().logError("Project RuleSet cannot be loaded for project " + iProjectProperties.getProject().getName() + " using RuleSet file name " + iProjectProperties.getRuleSetFile() + ". Using the rules from properties.", ruleSetNotFoundException);
            }
        }
    }

    private ProjectPropertiesTO readProjectProperties(IProject iProject) throws PropertiesException {
        ProjectPropertiesTO projectPropertiesTO = null;
        try {
            Mapping mapping = new Mapping(this.getClass().getClassLoader());
            URL uRL = this.getClass().getResource(PROPERTIES_MAPPING);
            mapping.loadMapping(uRL);
            IFile iFile = iProject.getFile(PROPERTIES_FILE);
            if (iFile.exists() && iFile.isAccessible()) {
                InputStreamReader inputStreamReader = new InputStreamReader(iFile.getContents());
                Unmarshaller unmarshaller = new Unmarshaller(mapping);
                projectPropertiesTO = (ProjectPropertiesTO)unmarshaller.unmarshal((Reader)inputStreamReader);
                ((Reader)inputStreamReader).close();
            }
        }
        catch (MarshalException marshalException) {
            throw new PropertiesException(marshalException);
        }
        catch (ValidationException validationException) {
            throw new PropertiesException(validationException);
        }
        catch (IOException iOException) {
            throw new PropertiesException(iOException);
        }
        catch (MappingException mappingException) {
            throw new PropertiesException(mappingException);
        }
        catch (CoreException coreException) {
            throw new PropertiesException(coreException);
        }
        return projectPropertiesTO;
    }

    private void fillProjectProperties(IProjectProperties iProjectProperties, ProjectPropertiesTO projectPropertiesTO) throws PropertiesException, CoreException {
        if (projectPropertiesTO == null) {
            log.info((Object)"Project properties not found. Use default.");
        } else {
            IWorkingSetManager iWorkingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            iProjectProperties.setProjectWorkingSet(iWorkingSetManager.getWorkingSet(projectPropertiesTO.getWorkingSetName()));
            iProjectProperties.setRuleSetFile(projectPropertiesTO.getRuleSetFile());
            iProjectProperties.setRuleSetStoredInProject(projectPropertiesTO.isRuleSetStoredInProject());
            iProjectProperties.setPmdEnabled(iProjectProperties.getProject().hasNature("net.sourceforge.pmd.eclipse.plugin.pmdNature"));
            iProjectProperties.setIncludeDerivedFiles(projectPropertiesTO.isIncludeDerivedFiles());
            iProjectProperties.setViolationsAsErrors(projectPropertiesTO.isViolationsAsErrors());
            if (projectPropertiesTO.isRuleSetStoredInProject()) {
                this.loadRuleSetFromProject(iProjectProperties);
            } else {
                this.setRuleSetFromProperties(iProjectProperties, projectPropertiesTO.getRules());
            }
            log.debug((Object)"Project properties loaded");
        }
    }

    private void setRuleSetFromProperties(IProjectProperties iProjectProperties, RuleSpecTO[] ruleSpecTOArray) throws PropertiesException {
        RuleSet ruleSet = new RuleSet();
        RuleSet ruleSet2 = PMDPlugin.getDefault().getPreferencesManager().getRuleSet();
        int n = ruleSpecTOArray == null ? 0 : ruleSpecTOArray.length;
        int n2 = 0;
        while (n2 < n) {
            try {
                Rule rule = ruleSet2.getRuleByName(ruleSpecTOArray[n2].getName());
                ruleSet.addRule(rule);
            }
            catch (RuntimeException runtimeException) {
                log.debug((Object)("The rule " + ruleSpecTOArray[n2].getName() + " cannot be found. ignore."));
            }
            ++n2;
        }
        ruleSet.addExcludePatterns(ruleSet2.getExcludePatterns());
        ruleSet.addIncludePatterns(ruleSet2.getIncludePatterns());
        iProjectProperties.setProjectRuleSet(ruleSet);
    }

    private void writeProjectProperties(IProject iProject, ProjectPropertiesTO projectPropertiesTO) throws PropertiesException {
        try {
            LocalConfiguration.getInstance().getProperties().setProperty("org.exolab.castor.indent", "true");
            Mapping mapping = new Mapping(this.getClass().getClassLoader());
            URL uRL = this.getClass().getResource(PROPERTIES_MAPPING);
            mapping.loadMapping(uRL);
            StringWriter stringWriter = new StringWriter();
            Marshaller marshaller = new Marshaller((Writer)stringWriter);
            marshaller.setMapping(mapping);
            marshaller.marshal((Object)projectPropertiesTO);
            stringWriter.flush();
            stringWriter.close();
            IFile iFile = iProject.getFile(PROPERTIES_FILE);
            if (iFile.exists() && iFile.isAccessible()) {
                iFile.setContents((InputStream)new ByteArrayInputStream(stringWriter.toString().getBytes()), false, false, null);
            } else {
                iFile.create((InputStream)new ByteArrayInputStream(stringWriter.toString().getBytes()), false, null);
            }
        }
        catch (MarshalException marshalException) {
            throw new PropertiesException(marshalException);
        }
        catch (ValidationException validationException) {
            throw new PropertiesException(validationException);
        }
        catch (IOException iOException) {
            throw new PropertiesException(iOException);
        }
        catch (MappingException mappingException) {
            throw new PropertiesException(mappingException);
        }
        catch (CoreException coreException) {
            throw new PropertiesException(coreException);
        }
    }

    private ProjectPropertiesTO fillTransferObject(IProjectProperties iProjectProperties) throws PropertiesException {
        ProjectPropertiesTO projectPropertiesTO = new ProjectPropertiesTO();
        projectPropertiesTO.setRuleSetStoredInProject(iProjectProperties.isRuleSetStoredInProject());
        projectPropertiesTO.setRuleSetFile(iProjectProperties.getRuleSetFile());
        projectPropertiesTO.setWorkingSetName(iProjectProperties.getProjectWorkingSet() == null ? null : iProjectProperties.getProjectWorkingSet().getName());
        projectPropertiesTO.setIncludeDerivedFiles(iProjectProperties.isIncludeDerivedFiles());
        projectPropertiesTO.setViolationsAsErrors(iProjectProperties.violationsAsErrors());
        if (!iProjectProperties.isRuleSetStoredInProject()) {
            RuleSet ruleSet = iProjectProperties.getProjectRuleSet();
            ArrayList<RuleSpecTO> arrayList = new ArrayList<RuleSpecTO>();
            Iterator iterator = ruleSet.getRules().iterator();
            while (iterator.hasNext()) {
                Rule rule = (Rule)iterator.next();
                arrayList.add(new RuleSpecTO(rule.getName(), rule.getRuleSetName()));
            }
            projectPropertiesTO.setRules(arrayList.toArray(new RuleSpecTO[arrayList.size()]));
            projectPropertiesTO.setExcludePatterns(ruleSet.getExcludePatterns().toArray(new String[ruleSet.getExcludePatterns().size()]));
            projectPropertiesTO.setIncludePatterns(ruleSet.getIncludePatterns().toArray(new String[ruleSet.getIncludePatterns().size()]));
        }
        return projectPropertiesTO;
    }

    private boolean synchronizeRuleSet(IProjectProperties iProjectProperties) throws PropertiesException {
        log.debug((Object)"Synchronizing the project ruleset with the plugin ruleset");
        RuleSet ruleSet = PMDPlugin.getDefault().getPreferencesManager().getRuleSet();
        RuleSet ruleSet2 = iProjectProperties.getProjectRuleSet();
        boolean bl = false;
        if (!ruleSet2.getRules().equals(ruleSet.getRules())) {
            RuleSet ruleSet3;
            Rule rule;
            log.debug((Object)"The project ruleset is different from the plugin ruleset ; synchronizing.");
            Iterator iterator = ruleSet2.getRules().iterator();
            while (iterator.hasNext()) {
                rule = (Rule)iterator.next();
                ruleSet3 = ruleSet.getRuleByName(rule.getName());
                if (ruleSet3 != null) continue;
                log.debug((Object)("The rule " + rule.getName() + " is no more defined in the plugin ruleset. Remove it."));
                iterator.remove();
            }
            rule = ruleSet2.getRules().iterator();
            ruleSet3 = new RuleSet();
            ruleSet3.setDescription(ruleSet2.getDescription());
            ruleSet3.setName(ruleSet2.getName());
            while (rule.hasNext()) {
                Rule rule2 = (Rule)rule.next();
                Rule rule3 = ruleSet.getRuleByName(rule2.getName());
                if (rule3 == null) continue;
                ruleSet3.addRule(rule3);
            }
            if (!ruleSet3.getRules().equals(ruleSet2.getRules())) {
                log.info((Object)"Set the projet ruleset according to preferences.");
                iProjectProperties.setProjectRuleSet(ruleSet3);
                bl = true;
            }
            log.debug((Object)("Ruleset for project " + iProjectProperties.getProject().getName() + " is now synchronized. " + (bl ? "Ruleset has changed" : "Ruleset has not changed")));
        }
        return bl;
    }
}

