/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.core.ext;

import net.sourceforge.pmd.eclipse.core.IRuleSetManager;
import net.sourceforge.pmd.eclipse.core.IRuleSetsExtension;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class RuleSetsExtensionProcessor {
    private static final String EXTENTION_POINT = "net.sourceforge.pmd.eclipse.plugin.rulesets";
    private static final String CLASS_ATTRIBUTE = "class";
    private final IRuleSetManager ruleSetManager;

    public RuleSetsExtensionProcessor(IRuleSetManager iRuleSetManager) {
        this.ruleSetManager = iRuleSetManager;
    }

    public void process() throws CoreException {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(EXTENTION_POINT);
        IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            this.processExecutableExtension(iConfigurationElementArray[n]);
            ++n;
        }
    }

    private void processExecutableExtension(IConfigurationElement iConfigurationElement) throws CoreException {
        Object object = iConfigurationElement.createExecutableExtension(CLASS_ATTRIBUTE);
        if (object instanceof IRuleSetsExtension) {
            IRuleSetsExtension iRuleSetsExtension = (IRuleSetsExtension)object;
            iRuleSetsExtension.registerRuleSets(this.ruleSetManager.getRegisteredRuleSets());
            iRuleSetsExtension.registerDefaultRuleSets(this.ruleSetManager.getDefaultRuleSets());
        } else {
            PMDPlugin.getDefault().log(4, "Extension " + iConfigurationElement.getName() + " is not an instance of IRuleSetsExtension", null);
        }
    }
}

