/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.view.explorer;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.marker.FindBugsMarker;
import de.tobject.findbugs.reporter.MarkerUtil;
import de.tobject.findbugs.view.explorer.BugGroup;
import de.tobject.findbugs.view.explorer.MarkerMapper;
import edu.umd.cs.findbugs.BugCategory;
import edu.umd.cs.findbugs.BugCode;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.I18N;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.ui.IWorkingSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum GroupType {
    Workspace(false, MarkerMapper.NO_MAPPING),
    WorkingSet(false, MarkerMapper.NO_MAPPING),
    Project(true, new MarkerMapper<IProject>(){

        @Override
        IProject getIdentifier(IMarker marker) {
            return marker.getResource().getProject();
        }

        @Override
        String getShortDescription(Object id) {
            return ((IProject)id).getName();
        }
    }),
    Package(true, new MarkerMapper<IPackageFragment>(){

        @Override
        IPackageFragment getIdentifier(IMarker marker) {
            IJavaElement javaElement = MarkerUtil.findJavaElementForMarker(marker);
            if (javaElement == null) {
                javaElement = JavaCore.create((IResource)marker.getResource());
            }
            if (javaElement != null) {
                return (IPackageFragment)javaElement.getAncestor(4);
            }
            return null;
        }

        @Override
        String getShortDescription(Object id) {
            String name = ((IPackageFragment)id).getElementName();
            if (name == null || name.length() == 0) {
                name = "default package";
            }
            return name;
        }
    }),
    Class(true, new MarkerMapper<IJavaElement>(){

        @Override
        IJavaElement getIdentifier(IMarker marker) {
            IJavaElement javaElement = MarkerUtil.findJavaElementForMarker(marker);
            if (javaElement != null) {
                return javaElement;
            }
            return JavaCore.create((IResource)marker.getResource());
        }

        @Override
        String getShortDescription(Object id) {
            return ((IJavaElement)id).getElementName();
        }
    }),
    Priority(true, new MarkerMapper<Integer>(){

        @Override
        Integer getIdentifier(IMarker marker) {
            try {
                Object attribute = marker.getAttribute("priority");
                if (attribute instanceof Integer) {
                    Integer prio = (Integer)attribute;
                    switch (prio) {
                        case 2: {
                            return 1;
                        }
                        case 1: {
                            return 2;
                        }
                    }
                    return 3;
                }
            }
            catch (CoreException e) {
                FindbugsPlugin.getDefault().logException(e, "Missing priority attribute in marker");
            }
            BugInstance bug = MarkerUtil.findBugInstanceForMarker(marker);
            return bug == null ? null : Integer.valueOf(bug.getPriority());
        }

        @Override
        String getShortDescription(Object id) {
            return FindBugsMarker.Priority.label((Integer)id).name() + " priority";
        }
    }),
    Category(true, new MarkerMapper<BugCategory>(){

        @Override
        BugCategory getIdentifier(IMarker marker) {
            BugInstance bug = MarkerUtil.findBugInstanceForMarker(marker);
            if (bug == null) {
                return null;
            }
            return I18N.instance().getBugCategory(bug.getBugPattern().getCategory());
        }

        @Override
        String getShortDescription(Object id) {
            return ((BugCategory)id).getShortDescription();
        }
    }),
    PatternType(true, new MarkerMapper<BugCode>(){

        @Override
        BugCode getIdentifier(IMarker marker) {
            BugCode code = MarkerUtil.findBugCodeForMarker(marker);
            if (code == null) {
                BugInstance bug = MarkerUtil.findBugInstanceForMarker(marker);
                if (bug == null) {
                    return null;
                }
                return I18N.instance().getBugCode(bug.getAbbrev());
            }
            return code;
        }

        @Override
        String getShortDescription(Object id) {
            return ((BugCode)id).getDescription();
        }
    }),
    Pattern(true, new MarkerMapper<BugPattern>(){

        @Override
        BugPattern getIdentifier(IMarker marker) {
            BugPattern bug = MarkerUtil.findBugPatternForMarker(marker);
            return bug;
        }

        @Override
        String getShortDescription(Object id) {
            return ((BugPattern)id).getShortDescription();
        }
    }),
    Marker(false, MarkerMapper.NO_MAPPING),
    Undefined(false, MarkerMapper.NO_MAPPING);

    private final boolean visible;
    private final MarkerMapper<?> mapper;

    private GroupType(boolean visible, MarkerMapper<?> mapper) {
        this.visible = visible;
        this.mapper = mapper;
        if (mapper != MarkerMapper.NO_MAPPING) {
            mapper.setType(this);
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    MarkerMapper<?> getMapper() {
        return this.mapper;
    }

    public static List<GroupType> getVisible() {
        GroupType[] values;
        ArrayList<GroupType> visible = new ArrayList<GroupType>();
        for (GroupType type : values = GroupType.values()) {
            if (!type.isVisible()) continue;
            visible.add(type);
        }
        return visible;
    }

    public static GroupType getType(Object element) {
        if (element instanceof BugGroup) {
            return ((BugGroup)element).getType();
        }
        if (element instanceof IMarker) {
            return Marker;
        }
        if (element instanceof IProject) {
            return Project;
        }
        if (element instanceof IWorkingSet) {
            return WorkingSet;
        }
        if (element instanceof IWorkspaceRoot) {
            return Workspace;
        }
        if (element instanceof IPackageFragment) {
            return Package;
        }
        if (element instanceof IJavaElement) {
            return Class;
        }
        if (element instanceof BugCode) {
            return PatternType;
        }
        if (element instanceof BugPattern) {
            return Pattern;
        }
        if (element instanceof BugCategory) {
            return Category;
        }
        if (element instanceof Integer) {
            return Priority;
        }
        return Undefined;
    }
}

