/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.propertieseditor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.attribute.adapter.DefaultValueAdapter;
import org.jboss.tools.common.model.ui.messages.UIMessages;
import org.jboss.tools.common.model.util.AbstractTableHelper;
import org.jboss.tools.common.propertieseditor.PropertiesEditor;

class FPTableHelper
extends AbstractTableHelper
implements PropertyChangeListener {
    PropertiesEditor pe;
    String nameFilter = "";
    String valueFilter = "";
    String compileError = "";
    XModelObject[] filteredChildren = new XModelObject[0];
    long ts = -1L;
    static String ESCAPE = "()[]{}+.!@#$%^&";

    public void setModelObject(XModelObject object) {
        super.setModelObject(object);
    }

    void applyFilters() {
        this.ts = this.object == null ? -1L : this.object.getTimeStamp();
        this.compileError = "";
        if (this.object == null) {
            this.filteredChildren = new XModelObject[0];
        } else if (this.nameFilter.length() == 0 && this.valueFilter.length() == 0) {
            this.filteredChildren = this.object.getChildren();
        } else {
            boolean isCaseSensitive = this.pe.caseSensitive.getSelection();
            this.filteredChildren = this.object.getChildren();
            Pattern pn = null;
            Pattern pv = null;
            if (this.nameFilter.length() > 0) {
                try {
                    pn = Pattern.compile(FPTableHelper.convertToRegExp(this.nameFilter, this.pe.fake.getSelection(), isCaseSensitive));
                }
                catch (Exception e) {
                    this.compileError = NLS.bind((String)UIMessages.PROPERTIES_EDITOR_ILLEGAL_NAME_EXPRESSION, (Object)e.getMessage());
                    return;
                }
            }
            if (this.valueFilter.length() > 0) {
                try {
                    pv = Pattern.compile(FPTableHelper.convertToRegExp(this.valueFilter, this.pe.fake.getSelection(), isCaseSensitive));
                }
                catch (Exception e) {
                    this.compileError = NLS.bind((String)UIMessages.PROPERTIES_EDITOR_ILLEGAL_VALUE_EXPRESSION, (Object)e.getMessage());
                    return;
                }
            }
            XModelObject[] children = this.object.getChildren();
            ArrayList<XModelObject> list = new ArrayList<XModelObject>();
            XModelObject[] xModelObjectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                XModelObject c = xModelObjectArray[n2];
                String n3 = FPTableHelper.checkCase(c.getAttributeValue("name"), isCaseSensitive);
                String v = FPTableHelper.checkCase(c.getAttributeValue("value"), isCaseSensitive);
                if ((pn == null || pn.matcher(n3).find()) && (pv == null || pv.matcher(v).find())) {
                    list.add(c);
                }
                ++n2;
            }
            this.filteredChildren = list.toArray(new XModelObject[0]);
        }
    }

    public FPTableHelper(PropertiesEditor pe) {
        this.pe = pe;
    }

    public int size() {
        if (this.object == null) {
            return 0;
        }
        if (this.ts != this.object.getTimeStamp()) {
            this.applyFilters();
        }
        return this.filteredChildren.length;
    }

    public XModelObject getModelObject(int r) {
        if (this.object == null) {
            return null;
        }
        if (this.ts != this.object.getTimeStamp()) {
            this.applyFilters();
        }
        XModelObject[] cs = this.filteredChildren;
        return r < 0 || r >= cs.length ? null : cs[r];
    }

    public String[] getHeader() {
        return new String[]{"name", "value"};
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof DefaultValueAdapter) {
            DefaultValueAdapter a = (DefaultValueAdapter)evt.getSource();
            String name = a.getAttribute().getName();
            if ("name".equals(name)) {
                this.nameFilter = "" + evt.getNewValue();
            } else if ("value".equals(name)) {
                this.valueFilter = "" + evt.getNewValue();
            }
            this.applyFilters();
            this.pe.refresh();
        }
    }

    static String checkCase(String s, boolean isCaseSensitive) {
        return isCaseSensitive ? s : s.toLowerCase();
    }

    static String convertToRegExp(String filter, boolean isRegExp, boolean isCaseSensitive) {
        if (filter == null || filter.length() == 0) {
            return "";
        }
        filter = FPTableHelper.checkCase(filter, isCaseSensitive);
        if (isRegExp) {
            return filter;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < filter.length()) {
            char ch = filter.charAt(i);
            if (ch == '?') {
                sb.append(".");
            } else if (ch == '*') {
                sb.append(".*");
            } else if (ESCAPE.indexOf(ch) >= 0) {
                sb.append('\\').append(ch);
            } else if (ch == '\\') {
                if (i >= filter.length() - 1) {
                    sb.append("\\\\");
                } else {
                    char c = filter.charAt(i + 1);
                    if (c == '*' || c == '?' || c == '\\') {
                        sb.append('\\').append(c);
                        ++i;
                    } else {
                        sb.append("\\\\");
                    }
                }
            } else {
                sb.append(ch);
            }
            ++i;
        }
        return sb.toString();
    }
}

