/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.editors.dnd;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Properties;
import org.eclipse.compare.Splitter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.jboss.tools.common.model.ui.editors.dnd.DefaultDropWizardPage;
import org.jboss.tools.common.model.ui.editors.dnd.DropWizardMessages;
import org.jboss.tools.common.model.ui.editors.dnd.IDropWizardModel;
import org.jboss.tools.common.model.ui.editors.dnd.ITagProposal;
import org.jboss.tools.common.model.ui.editors.dnd.ValidationException;
import org.jboss.tools.common.model.ui.editors.dnd.composite.TagAttributesComposite;

public class TagAttributesWizardPage
extends DefaultDropWizardPage
implements PropertyChangeListener {
    protected Properties context = new Properties();
    private TabItem general = null;
    private TabFolder tabs = null;
    private TagAttributesComposite advancedTabContentOnly = null;
    private Splitter composite = null;

    public TagAttributesWizardPage() {
        super("Edit required and preferred attributes", "");
    }

    protected TagAttributesWizardPage(String pageName) {
        super(pageName, "");
    }

    public void createControl(Composite parent) {
        this.showAttributes(parent);
    }

    protected void showAttributes(Composite parent) {
        this.composite = new Splitter(parent, 256);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        this.composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        this.composite.setLayoutData((Object)data);
        this.tabs = new TabFolder((Composite)this.composite, 128);
        this.tabs.setLayoutData((Object)data);
        this.general = new TabItem(this.tabs, 0);
        this.general.setText(DropWizardMessages.General_Tab_Title);
        final TagAttributesComposite generalTabContent = new TagAttributesComposite((Composite)this.tabs, 0, this.getSpecificWizard().getWizardModel(), true, this.context);
        this.general.setControl((Control)generalTabContent);
        TabItem advanced = new TabItem(this.tabs, 0);
        advanced.setText(DropWizardMessages.Advanced_Tab_Title);
        final TagAttributesComposite advancedTabContent = new TagAttributesComposite((Composite)this.tabs, 0, this.getSpecificWizard().getWizardModel(), this.context);
        advanced.setControl((Control)advancedTabContent);
        this.advancedTabContentOnly = new TagAttributesComposite((Composite)this.composite, 0, this.getSpecificWizard().getWizardModel(), this.context);
        this.composite.setVisible((Control)this.tabs, this.showAdvansedTab());
        this.composite.setVisible((Control)this.advancedTabContentOnly, !this.showAdvansedTab());
        this.tabs.addSelectionListener((SelectionListener)generalTabContent);
        this.tabs.addSelectionListener((SelectionListener)advancedTabContent);
        this.tabs.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TagAttributesWizardPage.this.tabs.removeSelectionListener((SelectionListener)generalTabContent);
                TagAttributesWizardPage.this.tabs.removeSelectionListener((SelectionListener)advancedTabContent);
                TagAttributesWizardPage.this.tabs.removeDisposeListener((DisposeListener)this);
            }
        });
        this.setControl((Control)this.composite);
        this.getSpecificWizard().getWizardModel().addPropertyChangeListener("tagProposal", this);
        this.updateTitle();
        this.runValidation();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getNewValue() != IDropWizardModel.UNDEFINED_TAG_PROPOSAL) {
            this.updateTitle();
            this.composite.setVisible((Control)this.tabs, this.showAdvansedTab());
            this.composite.setVisible((Control)this.advancedTabContentOnly, !this.showAdvansedTab());
            this.composite.layout();
        }
        this.getControl().redraw();
    }

    protected void updateTitle() {
        ITagProposal tagProposal = this.getDropWizardModel().getTagProposal();
        StringBuffer titleText = new StringBuffer();
        titleText.append("<");
        if (!"".equals(tagProposal.getPrefix())) {
            titleText.append(tagProposal.getPrefix()).append(":");
        }
        titleText.append(tagProposal.getName()).append("> attributes");
        this.setTitle(titleText.toString());
    }

    protected boolean showAdvansedTab() {
        TagAttributesComposite.AttributeDescriptorValue[] values = this.getDropWizardModel().getAttributeValueDescriptors();
        int i = 0;
        while (i < values.length) {
            if (values[i].isPreferable() || values[i].isRequired()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void validate() throws ValidationException {
    }

    public void dispose() {
        this.getSpecificWizard().getWizardModel().removePropertyChangeListener("tagProposal", this);
        super.dispose();
    }
}

