/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.editors.dnd;

import java.util.HashMap;
import java.util.Map;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.editors.dnd.DefaultElementGenerator;
import org.jboss.tools.common.model.ui.editors.dnd.HtmlElementDropGenerator;
import org.jboss.tools.common.model.ui.editors.dnd.IElementGenerator;

public class ElementGeneratorFactory {
    private static final ElementGeneratorFactory INSTANCE = new ElementGeneratorFactory();
    public static final IElementGenerator DEFAULT_ELEMENT_GENERATOR = new DefaultElementGenerator();
    public static Map<String, Class> generatorMap = new HashMap<String, Class>();

    static {
        generatorMap.put("-//w3c//dtd html 4.0 transitional//en", HtmlElementDropGenerator.class);
        generatorMap.put("http://java.sun.com/jsf/core", DefaultElementGenerator.class);
        generatorMap.put("http://java.sun.com/jsf/html", DefaultElementGenerator.class);
        generatorMap.put("http://java.sun.com/JSP/Page", DefaultElementGenerator.class);
        generatorMap.put("http://struts.apache.org/tags-html", DefaultElementGenerator.class);
    }

    public static ElementGeneratorFactory getInstance() {
        return INSTANCE;
    }

    private ElementGeneratorFactory() {
    }

    public IElementGenerator getElementGenerator(String uri) {
        IElementGenerator fInstance = DEFAULT_ELEMENT_GENERATOR;
        try {
            Class fClass = generatorMap.get(uri);
            if (fClass == null) {
                return fInstance;
            }
            fInstance = (IElementGenerator)fClass.newInstance();
        }
        catch (InstantiationException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        catch (IllegalAccessException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        return fInstance;
    }
}

